package org.eclipse.hyades.logging.events.cbe.impl.tests;

import java.io.Serializable;

import javax.naming.CompositeName;
import javax.naming.Reference;

import junit.framework.TestCase;

import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.events.cbe.CompletionException;
import org.eclipse.hyades.logging.events.cbe.ContentHandler;
import org.eclipse.hyades.logging.events.cbe.EventFactory;
import org.eclipse.hyades.logging.events.cbe.impl.EventFactoryImpl;
import org.eclipse.hyades.logging.events.cbe.impl.EventFactoryObjectFactory;

/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 *
 * @author Denilson Nastacio
 * @version 1.0.1
 * @since 1.0.1
 */
public class EventFactoryObjectFactoryTest extends TestCase implements Serializable {

    /**
     * Constructor for EventFactoryObjectFactoryTest.
     * @param arg0
     */
    public EventFactoryObjectFactoryTest(String testcase) {
        super(testcase);
    }

    /*
     * @see TestCase#setUp()
     */
    protected void setUp() throws Exception {
        super.setUp();
    }

    /*
     * @see TestCase#tearDown()
     */
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * Tests whether an <code>EventFactory</code> can be bound to JNDI and 
     * rebuilt back.
     */
    public void testGetObjectInstance() throws Exception {
        final String EXTENSION_NAME = "Example";
        ContentHandler mockHandler = new MockHandler(EXTENSION_NAME);
        EventFactoryImpl efi = new EventFactoryImpl();
        efi.setContentHandler(mockHandler);

        Reference ref = efi.getReference();

        EventFactoryObjectFactory efof = new EventFactoryObjectFactory();
        EventFactory ef = (EventFactory) efof.getObjectInstance(ref, new CompositeName("AA"), null, null);
        assertNotNull("Returned factory cannot be null", ef);

        CommonBaseEvent event = ef.createCommonBaseEvent("someExtension");
        event.complete();

        assertEquals("Mediation must change extension name", event.getExtensionName(), EXTENSION_NAME);
    }

    /*
     * Private methods. 
     */

    /**
     * 
     */
    public class MockHandler implements ContentHandler, Serializable {
        private String extensionName;

        public MockHandler(String name) {
            extensionName = name;
        }
        public void completeEvent(CommonBaseEvent event) throws CompletionException {
            event.setExtensionName(extensionName);
        }
    }
}
