package org.eclipse.hyades.logging.events.cbe.tests;

import junit.framework.TestCase;

import org.eclipse.hyades.logging.events.cbe.CompletionException;
import org.eclipse.hyades.logging.events.cbe.util.EventHelpers;

/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 *
 * @author Denilson Nastacio
 * @version 1.0.1
 * @since 1.0.1
 */
public class CompletionExceptionTest extends TestCase {
    /**
     * Constructor for CompletionExceptionTest.
     * @param arg0
     */
    public CompletionExceptionTest(String arg0) {
        super(arg0);
    }

    /*
     * Test for void CompletionException()
     */
    public void testCompletionException() {
        new CompletionException();
    }

    /*
     * Test for void CompletionException(String)
     */
    public void testCompletionExceptionString() {
        String msg = "test";
        CompletionException e = new CompletionException(msg);
        assertEquals(msg, e.getMessage());
    }

    /*
     * Test for void CompletionException(String, String)
     */
    public void testCompletionExceptionStringString() {
        CompletionException e = new CompletionException(EventHelpers.getString("LOG_INVALID_JNDI_REFERENCE_EXC_"));

        EventExceptionTest.assertExceptionMsg(e, "LOG_INVALID_JNDI_REFERENCE_EXC_", null);
    }

    /*
     * Test for void CompletionException(String, String, Object[])
     */
    public void testCompletionExceptionStringStringObjectArray() {
        CompletionException e = new CompletionException(EventHelpers.getString("LOG_INVALID_JNDI_REFERENCE_EXC_", "a"));
        EventExceptionTest.assertExceptionMsg(e, "LOG_INVALID_JNDI_REFERENCE_EXC_", new Object[] {"a"});
    }

    /*
     * Test for void CompletionException(String, String, Object[], Throwable)
     */
    public void testCompletionExceptionStringStringObjectArrayThrowable() {

        Exception linkedException = new Exception();
        
        CompletionException e = new CompletionException(EventHelpers.getString("LOG_INVALID_JNDI_REFERENCE_EXC_", "a"), linkedException);
        
        EventExceptionTest.assertExceptionMsg(e, "LOG_INVALID_JNDI_REFERENCE_EXC_", new Object[] { "a" });
        
        assertEquals(linkedException, e.getCause());
    }

}
