package org.eclipse.hyades.logging.events.cbe.tests;

import junit.framework.TestCase;

import org.eclipse.hyades.logging.events.cbe.MissingPropertyException;
import org.eclipse.hyades.logging.events.cbe.util.EventHelpers;

/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 *
 * @author Denilson Nastacio
 * @version 1.0.1
 * @since 1.0.1
 */
public class MissingPropertyExceptionTest extends TestCase {
    /**
     * Constructor for MissingPropertyExceptionTest.
     * @param arg0
     */
    public MissingPropertyExceptionTest(String arg0) {
        super(arg0);
    }

    /*
     * Test for void MissingPropertyException()
     */
    public void testMissingPropertyException() {
        new MissingPropertyException();
    }

    /*
     * Test for void MissingPropertyException(String)
     */
    public void testMissingPropertyExceptionString() {
        String msg = "test";
        MissingPropertyException e = new MissingPropertyException(msg);
        assertEquals(msg, e.getMessage());
    }

    /*
     * Test for void MissingPropertyException(String, String)
     */
    public void testMissingPropertyExceptionStringString() {
       
        MissingPropertyException e = new MissingPropertyException(EventHelpers.getString("LOG_INVALID_JNDI_REFERENCE_EXC_"));

        EventExceptionTest.assertExceptionMsg(e, "LOG_INVALID_JNDI_REFERENCE_EXC_", null);
    }

    /*
     * Test for void MissingPropertyException(String, String, Object[])
     */
    public void testMissingPropertyExceptionStringStringObjectArray() {

        MissingPropertyException e = new MissingPropertyException(EventHelpers.getString("LOG_INVALID_JNDI_REFERENCE_EXC_", "a"));

        EventExceptionTest.assertExceptionMsg(e, "LOG_INVALID_JNDI_REFERENCE_EXC_", new Object[] { "a" });
    }

    /*
     * Test for void MissingPropertyException(String, String, Object[], Throwable)
     */
    public void testMissingPropertyExceptionStringStringObjectArrayThrowable() {

        Exception linkedException = new Exception();

        MissingPropertyException e = new MissingPropertyException(EventHelpers.getString("LOG_INVALID_JNDI_REFERENCE_EXC_", "a"), linkedException);
        
        EventExceptionTest.assertExceptionMsg(e, "LOG_INVALID_JNDI_REFERENCE_EXC_", new Object[] { "a" });
        
        assertEquals(linkedException, e.getCause());
    }

}
