package org.eclipse.hyades.logging.events.cbe.tests;

import junit.framework.TestCase;

import org.eclipse.hyades.logging.events.cbe.ValidationException;
import org.eclipse.hyades.logging.events.cbe.util.EventHelpers;

/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 *
 * @author Denilson Nastacio
 * @version 1.0.1
 * @since 1.0.1
 */
public class ValidationExceptionTest extends TestCase {
    /**
     * Constructor for ValidationExceptionTest.
     * @param arg0
     */
    public ValidationExceptionTest(String arg0) {
        super(arg0);
    }

    /*
     * Test for void ValidationException()
     */
    public void testValidationException() {
        new ValidationException();
    }

    /*
     * Test for void ValidationException(String)
     */
    public void testValidationExceptionString() {
        String msg = "test";
        ValidationException e = new ValidationException(msg);
        assertEquals(msg, e.getMessage());
    }

    /*
     * Test for void ValidationException(String, String)
     */
    public void testValidationExceptionStringString() {
        
        ValidationException e = new ValidationException(EventHelpers.getString("LOG_INVALID_JNDI_REFERENCE_EXC_"));

        EventExceptionTest.assertExceptionMsg(e, "LOG_INVALID_JNDI_REFERENCE_EXC_", null);
    }

    /*
     * Test for void ValidationException(String, String, Object[])
     */
    public void testValidationExceptionStringStringObjectArray() {

        ValidationException e = new ValidationException(EventHelpers.getString("LOG_INVALID_JNDI_REFERENCE_EXC_", "a"));

        EventExceptionTest.assertExceptionMsg(e, "LOG_INVALID_JNDI_REFERENCE_EXC_", new Object[] { "a" });
    }

    /*
     * Test for void ValidationException(String, String, Object[], Throwable)
     */
    public void testValidationExceptionStringStringObjectArrayThrowable() {

        Exception linkedException = new Exception();

        ValidationException e = new ValidationException(EventHelpers.getString("LOG_INVALID_JNDI_REFERENCE_EXC_", "a"),linkedException);

        EventExceptionTest.assertExceptionMsg(e, "LOG_INVALID_JNDI_REFERENCE_EXC_",  new Object[] { "a" });
       
        assertEquals(linkedException, e.getCause());
    }

}
