package org.eclipse.hyades.logging.events.cbe.util;

import java.util.ListResourceBundle;

/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * English resource bundle.
 * 
 * @author Denilson Nastacio
 * @author Paul E. Slauenwhite
 * @version 1.0.1
 * @since 1.0
 * @deprecated As of 3.1, replaced by the <code>plugin[<language code>[_<country code>]].properties</code> property resource bundle.
 */
public class EventMessages extends ListResourceBundle {

    public static final String CLASS_NAME ="org.eclipse.hyades.logging.events.cbe.util.EventMessages";

    /**************************************************************************
    * Implements java.util.ListResourceBundle.getContents().
    * @see java.util.ListResourceBundle
    **************************************************************************/

    public Object[][] getContents() {
        return contents;
    }

    /**************************************************************************
    * Keys for translatable text
    **************************************************************************/

    public static final String LOG_INVALID_JNDI_REFERENCE_EXC_ ="LOG_INVALID_JNDI_REFERENCE_EXC_";
    public static final String LOG_FAILED_TO_SERIALIZE_CONTENT_HANDLER_EXC_ ="LOG_FAILED_TO_SERIALIZE_CONTENT_HANDLER_EXC_";
    public static final String LOG_FAILED_TO_DESERIALIZE_CONTENT_HANDLER_EXC_ ="LOG_FAILED_TO_DESERIALIZE_CONTENT_HANDLER_EXC_";
    public static final String LOG_INVALID_GLOBAL_INSTANCE_ID_EXC_ ="LOG_INVALID_GLOBAL_INSTANCE_ID_EXC_";
    public static final String LOG_VALUE_ARRAY_SIZE_MISMATCH_EXC_ ="LOG_VALUE_ARRAY_SIZE_MISMATCH_EXC_";
    public static final String LOG_INVALID_TYPE_CONVERSION_EXC_ ="LOG_INVALID_TYPE_CONVERSION_EXC_";
    public static final String LOG_EXTENDED_DATA_INVALID_TYPE_EXC_ ="LOG_EXTENDED_DATA_INVALID_TYPE_EXC_";
    public static final String LOG_EXTENDED_DATA_VALUE_NULL_EXC_ ="LOG_EXTENDED_DATA_VALUE_NULL_EXC_";
    public static final String LOG_EXTENDED_DATA_INVALID_BOOLEAN_EXC_ ="LOG_EXTENDED_DATA_INVALID_BOOLEAN_EXC_";
    public static final String LOG_EXTENDED_DATA_INVALID_DATE_EXC_ ="LOG_EXTENDED_DATA_INVALID_DATE_EXC_";
    public static final String LOG_EXTENDED_DATA_INVALID_HEX_BINARY_1_EXC_ ="LOG_EXTENDED_DATA_INVALID_HEX_BINARY_1_EXC_";
    public static final String LOG_EXTENDED_DATA_INVALID_HEX_BINARY_2_EXC_ ="LOG_EXTENDED_DATA_INVALID_HEX_BINARY_2_EXC_";
    public static final String LOG_INVALID_SITUATION_TYPE_EXC_ ="LOG_INVALID_SITUATION_TYPE_EXC_";
    public static final String LOG_INVALID_CREATION_TIME_EXC_ ="LOG_INVALID_CREATION_TIME_EXC_";
    public static final String LOG_INVALID_LIST_ELEMENT_LENGTH_EXC_ ="LOG_INVALID_LIST_ELEMENT_LENGTH_EXC_";
    public static final String LOG_VALUE_OUT_OF_RANGE_EXC_ ="LOG_VALUE_OUT_OF_RANGE_EXC_";
    public static final String LOG_MISSING_REQUIRED_ATTRIBUTE_EXC_ ="LOG_MISSING_REQUIRED_ATTRIBUTE_EXC_";
    public static final String LOG_MUTUALLY_EXCLUSIVE_ATTRIBUTES_EXC_ ="LOG_MUTUALLY_EXCLUSIVE_ATTRIBUTES_EXC_";
    public static final String LOG_INVALID_VERSION_EXC_ ="LOG_INVALID_VERSION_EXC_";
    public static final String LOG_INVALID_GLOBAL_INSTANCE_ID_LENGTH_EXC_ ="LOG_INVALID_GLOBAL_INSTANCE_ID_LENGTH_EXC_";
    public static final String LOG_INVALID_LENGTH_EXC_ ="LOG_INVALID_LENGTH_EXC_";
    public static final String LOG_INVALID_LENGTH_RANGE_EXC_ ="LOG_INVALID_LENGTH_RANGE_EXC_";
    public static final String LOG_MISSING_ATTRIBUTES_EXC_ ="LOG_MISSING_ATTRIBUTES_EXC_";
    public static final String LOG_INCONSISTENT_ATTRIBUTES_EXC_ ="LOG_INCONSISTENT_ATTRIBUTES_EXC_";
    public static final String LOG_CATEGORY_MISMATCH_EXC_ ="LOG_CATEGORY_MISMATCH_EXC_";
    public static final String LOG_COMPONENT_IDENTIFICATION_INVALID_LOCATION_TYPE_EXC_ ="LOG_COMPONENT_IDENTIFICATION_INVALID_LOCATION_TYPE_EXC_";
    public static final String LOG_EVENT_SAX_PARSER_UNEXPECTED_XML_ELEMENT_EXC_ ="LOG_EVENT_SAX_PARSER_UNEXPECTED_XML_ELEMENT_EXC_";
    public static final String LOG_EVENT_SAX_PARSER_INCORRECT_XML_ELEMENT_EXC_ ="LOG_EVENT_SAX_PARSER_INCORRECT_XML_ELEMENT_EXC_";
    
    /**************************************************************************
    * Resource table
    **************************************************************************/
    private final static Object[][] contents = { { LOG_INVALID_JNDI_REFERENCE_EXC_, resolveResourceString(LOG_INVALID_JNDI_REFERENCE_EXC_) }, {
        LOG_FAILED_TO_SERIALIZE_CONTENT_HANDLER_EXC_, resolveResourceString(LOG_FAILED_TO_SERIALIZE_CONTENT_HANDLER_EXC_) }, {
        LOG_FAILED_TO_DESERIALIZE_CONTENT_HANDLER_EXC_, resolveResourceString(LOG_FAILED_TO_DESERIALIZE_CONTENT_HANDLER_EXC_) }, {
        LOG_INVALID_GLOBAL_INSTANCE_ID_EXC_, resolveResourceString(LOG_INVALID_GLOBAL_INSTANCE_ID_EXC_) }, {
        LOG_VALUE_ARRAY_SIZE_MISMATCH_EXC_, resolveResourceString(LOG_VALUE_ARRAY_SIZE_MISMATCH_EXC_) }, {
        LOG_INVALID_TYPE_CONVERSION_EXC_, resolveResourceString(LOG_INVALID_TYPE_CONVERSION_EXC_) }, {
        LOG_EXTENDED_DATA_INVALID_TYPE_EXC_, resolveResourceString(LOG_EXTENDED_DATA_INVALID_TYPE_EXC_) }, {
        LOG_EXTENDED_DATA_VALUE_NULL_EXC_, resolveResourceString(LOG_EXTENDED_DATA_VALUE_NULL_EXC_) }, {
        LOG_EXTENDED_DATA_INVALID_BOOLEAN_EXC_, resolveResourceString(LOG_EXTENDED_DATA_INVALID_BOOLEAN_EXC_) }, {
        LOG_EXTENDED_DATA_INVALID_DATE_EXC_, resolveResourceString(LOG_EXTENDED_DATA_INVALID_DATE_EXC_) }, {
        LOG_EXTENDED_DATA_INVALID_HEX_BINARY_1_EXC_, resolveResourceString(LOG_EXTENDED_DATA_INVALID_HEX_BINARY_1_EXC_) }, {
        LOG_EXTENDED_DATA_INVALID_HEX_BINARY_2_EXC_, resolveResourceString(LOG_EXTENDED_DATA_INVALID_HEX_BINARY_2_EXC_) }, {
        LOG_INVALID_SITUATION_TYPE_EXC_, resolveResourceString(LOG_INVALID_SITUATION_TYPE_EXC_) }, {
        LOG_INVALID_CREATION_TIME_EXC_, resolveResourceString(LOG_INVALID_CREATION_TIME_EXC_) }, {
        LOG_INVALID_LIST_ELEMENT_LENGTH_EXC_, resolveResourceString(LOG_INVALID_LIST_ELEMENT_LENGTH_EXC_) }, {
        LOG_VALUE_OUT_OF_RANGE_EXC_, resolveResourceString(LOG_VALUE_OUT_OF_RANGE_EXC_) }, {
        LOG_MISSING_REQUIRED_ATTRIBUTE_EXC_, resolveResourceString(LOG_MISSING_REQUIRED_ATTRIBUTE_EXC_) }, {
        LOG_MUTUALLY_EXCLUSIVE_ATTRIBUTES_EXC_, resolveResourceString(LOG_MUTUALLY_EXCLUSIVE_ATTRIBUTES_EXC_) }, {
        LOG_INVALID_VERSION_EXC_, resolveResourceString(LOG_INVALID_VERSION_EXC_) }, {
        LOG_INVALID_GLOBAL_INSTANCE_ID_LENGTH_EXC_, resolveResourceString(LOG_INVALID_GLOBAL_INSTANCE_ID_LENGTH_EXC_) }, {
        LOG_INVALID_LENGTH_EXC_, resolveResourceString(LOG_INVALID_LENGTH_EXC_) }, {
        LOG_INVALID_LENGTH_RANGE_EXC_, resolveResourceString(LOG_INVALID_LENGTH_RANGE_EXC_) }, {
        LOG_MISSING_ATTRIBUTES_EXC_, resolveResourceString(LOG_MISSING_ATTRIBUTES_EXC_) }, {
        LOG_INCONSISTENT_ATTRIBUTES_EXC_, resolveResourceString(LOG_INCONSISTENT_ATTRIBUTES_EXC_) }, {
        LOG_CATEGORY_MISMATCH_EXC_, resolveResourceString(LOG_CATEGORY_MISMATCH_EXC_) }, {
        LOG_COMPONENT_IDENTIFICATION_INVALID_LOCATION_TYPE_EXC_, resolveResourceString(LOG_COMPONENT_IDENTIFICATION_INVALID_LOCATION_TYPE_EXC_) }, {
        LOG_EVENT_SAX_PARSER_UNEXPECTED_XML_ELEMENT_EXC_, resolveResourceString(LOG_EVENT_SAX_PARSER_UNEXPECTED_XML_ELEMENT_EXC_) }, {
        LOG_EVENT_SAX_PARSER_INCORRECT_XML_ELEMENT_EXC_ , resolveResourceString(LOG_EVENT_SAX_PARSER_INCORRECT_XML_ELEMENT_EXC_)}
    };    
    
    private static String resolveResourceString(String key){
        
        StringBuffer buffer = new StringBuffer();
        String resourceString = EventHelpers.getString(key);
        char character = 0;
        
        for (int counter = 0; counter < resourceString.length(); counter++) {
            
            character = resourceString.charAt(counter);
            
            if(character == '\''){
                buffer.append("''");
            }
            else{
                buffer.append(character);
            }
            
        }
        
        return (buffer.toString());
    }
}
