/*******************************************************************************
 * Copyright (c) 2003 Hyades project. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Common
 * Public License v1.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: IBM - Initial API and implementation
 ******************************************************************************/

package org.eclipse.hyades.internal.execution.local.control;

import java.net.InetAddress;
import java.util.Enumeration;

import org.eclipse.hyades.execution.security.ISecureClientParameters;
import org.eclipse.hyades.internal.execution.local.common.SetNVPairCommand;
import org.eclipse.hyades.internal.execution.security.LoginFailedException;
import org.eclipse.hyades.internal.execution.security.SecureConnectionRequiredException;
import org.eclipse.hyades.internal.execution.security.UntrustedAgentControllerException;
import org.eclipse.hyades.internal.execution.security.User;

public interface Node {

    /**
     * Terminates the specified process on this node.
     */
    void killProcess(Process process) throws InactiveProcessException,
            NotConnectedException;

    /**
     * Causes this node to shutdown after the specified number of seconds.
     */
    void shutdown(long delay) throws NotConnectedException;

    /**
     * Causes this node to reboot after the specified number of seconds.
     */
    void reboot(long delay) throws NotConnectedException;

    /**
     * Enumerate all the monitors on this node.
     */
    Enumeration listMonitors() throws NotConnectedException;

    /**
     * Enumerate all the active processes on this node.
     */
    Enumeration listProcesses() throws NotConnectedException;

    /**
     * Enumerate all the properties on this node.
     */
    SetNVPairCommand[] getPropertyValues(String name, String type)
            throws NotConnectedException;

    /**
     * Retrieve a specific Process on this Node
     */
    Process getProcess(String processId);

    /**
     * Retrieve the InetAddress for this Node.
     */
    InetAddress getInetAddress();

    /**
     * Retrives all the InetAddresses for this Node.
     */
    InetAddress[] getAllInetAddresses();

    /**
     * Retrieve the host name for this Node.
     */
    String getName();

    /**
     * Is this controller connected to this node
     */
    boolean isConnected();

    /**
     * Attempt to connect to this node.
     */
    Connection connect(int port) throws AgentControllerUnavailableException,
            SecureConnectionRequiredException,
            UntrustedAgentControllerException, LoginFailedException;

    /**
     * Retrieve the connection associated with this node object
     */
    Connection getConnection();

    /**
     * Retrieve the user for this node.
     */
    User getUser();

    /**
     * Update the user for this node.
     */
    void setUser(User user);

    /**
     * Blocks calling thread until the process is retrieved, if the process
     * cannot be retrieved within the timeout period, null is returned for the
     * process return value.
     * 
     * @param processIdentity
     *            the identity of the process to wait for
     * @param timeout
     *            the maximum time to wait for the process to be retrieved
     * @return the process retrieved or null if the timeout is reached before
     *         the process is found
     * @throws NotConnectedException
     */
    Process waitForProcess(String processIdentity, int timeout) throws NotConnectedException;

    void setApplication(Application app);

    Application getApplication();

    void setSecurityParameters(ISecureClientParameters manager);

    ISecureClientParameters getSecurityParameters();

}

