/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.hierarchy;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Correlation Container Proxy</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * A UI proxy class, to avoid loading the whole correlation instance resource.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.CorrelationContainerProxy#getName <em>Name</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.CorrelationContainerProxy#getCreationTime <em>Creation Time</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.CorrelationContainerProxy#getCorrelationContainer <em>Correlation Container</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.CorrelationContainerProxy#getCorrelatedAgents <em>Correlated Agents</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.CorrelationContainerProxy#getCorrelationEngine <em>Correlation Engine</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.CorrelationContainerProxy#getMonitor <em>Monitor</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.hyades.models.hierarchy.HierarchyPackage#getCorrelationContainerProxy()
 * @model 
 * @generated
 */
public interface CorrelationContainerProxy extends EObject{
	/**
	 * Returns the value of the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Name</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Name</em>' attribute.
	 * @see #setName(String)
	 * @see org.eclipse.hyades.models.hierarchy.HierarchyPackage#getCorrelationContainerProxy_Name()
	 * @model 
	 * @generated
	 */
	String getName();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.hierarchy.CorrelationContainerProxy#getName <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Name</em>' attribute.
	 * @see #getName()
	 * @generated
	 */
	void setName(String value);

	/**
	 * Returns the value of the '<em><b>Creation Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Creation Time</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Creation Time</em>' attribute.
	 * @see #setCreationTime(long)
	 * @see org.eclipse.hyades.models.hierarchy.HierarchyPackage#getCorrelationContainerProxy_CreationTime()
	 * @model 
	 * @generated
	 */
	long getCreationTime();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.hierarchy.CorrelationContainerProxy#getCreationTime <em>Creation Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Creation Time</em>' attribute.
	 * @see #getCreationTime()
	 * @generated
	 */
	void setCreationTime(long value);

	/**
	 * Returns the value of the '<em><b>Correlation Container</b></em>' reference.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.hierarchy.CorrelationContainer#getCorrelationContainerProxy <em>Correlation Container Proxy</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Correlation Container</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Correlation Container</em>' reference.
	 * @see #setCorrelationContainer(CorrelationContainer)
	 * @see org.eclipse.hyades.models.hierarchy.HierarchyPackage#getCorrelationContainerProxy_CorrelationContainer()
	 * @see org.eclipse.hyades.models.hierarchy.CorrelationContainer#getCorrelationContainerProxy
	 * @model opposite="correlationContainerProxy"
	 * @generated
	 */
	CorrelationContainer getCorrelationContainer();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.hierarchy.CorrelationContainerProxy#getCorrelationContainer <em>Correlation Container</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Correlation Container</em>' reference.
	 * @see #getCorrelationContainer()
	 * @generated
	 */
	void setCorrelationContainer(CorrelationContainer value);

	/**
	 * Returns the value of the '<em><b>Correlated Agents</b></em>' reference list.
	 * The list contents are of type {@link org.eclipse.hyades.models.hierarchy.TRCAgentProxy}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Correlated Agents</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Correlated Agents</em>' reference list.
	 * @see org.eclipse.hyades.models.hierarchy.HierarchyPackage#getCorrelationContainerProxy_CorrelatedAgents()
	 * @model type="org.eclipse.hyades.models.hierarchy.TRCAgentProxy"
	 * @generated
	 */
	EList getCorrelatedAgents();

	/**
	 * Returns the value of the '<em><b>Correlation Engine</b></em>' containment reference.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.hierarchy.CorrelationEngine#getCorrelationContainerProxy <em>Correlation Container Proxy</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Correlation Engine</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Correlation Engine</em>' containment reference.
	 * @see #setCorrelationEngine(CorrelationEngine)
	 * @see org.eclipse.hyades.models.hierarchy.HierarchyPackage#getCorrelationContainerProxy_CorrelationEngine()
	 * @see org.eclipse.hyades.models.hierarchy.CorrelationEngine#getCorrelationContainerProxy
	 * @model opposite="CorrelationContainerProxy" containment="true"
	 * @generated
	 */
	CorrelationEngine getCorrelationEngine();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.hierarchy.CorrelationContainerProxy#getCorrelationEngine <em>Correlation Engine</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Correlation Engine</em>' containment reference.
	 * @see #getCorrelationEngine()
	 * @generated
	 */
	void setCorrelationEngine(CorrelationEngine value);

	/**
	 * Returns the value of the '<em><b>Monitor</b></em>' container reference.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.hierarchy.TRCMonitor#getCorrelationContainerProxies <em>Correlation Container Proxies</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Monitor</em>' container reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Monitor</em>' container reference.
	 * @see #setMonitor(TRCMonitor)
	 * @see org.eclipse.hyades.models.hierarchy.HierarchyPackage#getCorrelationContainerProxy_Monitor()
	 * @see org.eclipse.hyades.models.hierarchy.TRCMonitor#getCorrelationContainerProxies
	 * @model opposite="correlationContainerProxies" required="true"
	 * @generated
	 */
	TRCMonitor getMonitor();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.hierarchy.CorrelationContainerProxy#getMonitor <em>Monitor</em>}' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Monitor</em>' container reference.
	 * @see #getMonitor()
	 * @generated
	 */
	void setMonitor(TRCMonitor value);

} // CorrelationContainerProxy
