/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.hierarchy;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>TRC Agent Proxy</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * A TRCAgent proxy, to enable support for loading and unloading the agent resource. This class shadows most of the properties of the TRCAgent: please check the documentation on TRCAgent for duplicated fields.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.TRCAgentProxy#getName <em>Name</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.TRCAgentProxy#getType <em>Type</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.TRCAgentProxy#getRuntimeId <em>Runtime Id</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.TRCAgentProxy#getStartTime <em>Start Time</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.TRCAgentProxy#getStopTime <em>Stop Time</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.TRCAgentProxy#getCollectionMode <em>Collection Mode</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.TRCAgentProxy#isActive <em>Active</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.TRCAgentProxy#isAttached <em>Attached</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.TRCAgentProxy#isCollectionData <em>Collection Data</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.TRCAgentProxy#isMonitored <em>Monitored</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.TRCAgentProxy#getProfileFile <em>Profile File</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.TRCAgentProxy#getProcessProxy <em>Process Proxy</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.TRCAgentProxy#getConfigurations <em>Configurations</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.TRCAgentProxy#getAgent <em>Agent</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.TRCAgentProxy#getInternalCorrelations <em>Internal Correlations</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.hyades.models.hierarchy.HierarchyPackage#getTRCAgentProxy()
 * @model 
 * @generated
 */
public interface TRCAgentProxy extends EObject{
	/**
	 * Returns the value of the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Name</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Name</em>' attribute.
	 * @see #setName(String)
	 * @see org.eclipse.hyades.models.hierarchy.HierarchyPackage#getTRCAgentProxy_Name()
	 * @model 
	 * @generated
	 */
	String getName();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.hierarchy.TRCAgentProxy#getName <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Name</em>' attribute.
	 * @see #getName()
	 * @generated
	 */
	void setName(String value);

	/**
	 * Returns the value of the '<em><b>Type</b></em>' attribute.
	 * The default value is <code>"_unknown"</code>.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Type</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Type</em>' attribute.
	 * @see #setType(String)
	 * @see org.eclipse.hyades.models.hierarchy.HierarchyPackage#getTRCAgentProxy_Type()
	 * @model default="_unknown"
	 * @generated
	 */
	String getType();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.hierarchy.TRCAgentProxy#getType <em>Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Type</em>' attribute.
	 * @see #getType()
	 * @generated
	 */
	void setType(String value);

	/**
	 * Returns the value of the '<em><b>Runtime Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Runtime Id</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Runtime Id</em>' attribute.
	 * @see #setRuntimeId(String)
	 * @see org.eclipse.hyades.models.hierarchy.HierarchyPackage#getTRCAgentProxy_RuntimeId()
	 * @model 
	 * @generated
	 */
	String getRuntimeId();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.hierarchy.TRCAgentProxy#getRuntimeId <em>Runtime Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Runtime Id</em>' attribute.
	 * @see #getRuntimeId()
	 * @generated
	 */
	void setRuntimeId(String value);

	/**
	 * Returns the value of the '<em><b>Start Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Start Time</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Start Time</em>' attribute.
	 * @see #setStartTime(double)
	 * @see org.eclipse.hyades.models.hierarchy.HierarchyPackage#getTRCAgentProxy_StartTime()
	 * @model 
	 * @generated
	 */
	double getStartTime();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.hierarchy.TRCAgentProxy#getStartTime <em>Start Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Start Time</em>' attribute.
	 * @see #getStartTime()
	 * @generated
	 */
	void setStartTime(double value);

	/**
	 * Returns the value of the '<em><b>Stop Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Stop Time</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Stop Time</em>' attribute.
	 * @see #setStopTime(double)
	 * @see org.eclipse.hyades.models.hierarchy.HierarchyPackage#getTRCAgentProxy_StopTime()
	 * @model 
	 * @generated
	 */
	double getStopTime();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.hierarchy.TRCAgentProxy#getStopTime <em>Stop Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Stop Time</em>' attribute.
	 * @see #getStopTime()
	 * @generated
	 */
	void setStopTime(double value);

	/**
	 * Returns the value of the '<em><b>Collection Mode</b></em>' attribute.
	 * The default value is <code>"0"</code>.
	 * The literals are from the enumeration {@link org.eclipse.hyades.models.hierarchy.TRCCollectionMode}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Collection Mode</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Defines different collection modes (some include filtering of data on agent side some on loader side and some are combined). This is used by loaders and UI to decide the model building algorithms and the presentation mode.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Collection Mode</em>' attribute.
	 * @see org.eclipse.hyades.models.hierarchy.TRCCollectionMode
	 * @see #setCollectionMode(TRCCollectionMode)
	 * @see org.eclipse.hyades.models.hierarchy.HierarchyPackage#getTRCAgentProxy_CollectionMode()
	 * @model default="0"
	 * @generated
	 */
	TRCCollectionMode getCollectionMode();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.hierarchy.TRCAgentProxy#getCollectionMode <em>Collection Mode</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Collection Mode</em>' attribute.
	 * @see org.eclipse.hyades.models.hierarchy.TRCCollectionMode
	 * @see #getCollectionMode()
	 * @generated
	 */
	void setCollectionMode(TRCCollectionMode value);

	/**
	 * Returns the value of the '<em><b>Active</b></em>' attribute.
	 * The default value is <code>"false"</code>.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Active</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Active</em>' attribute.
	 * @see #setActive(boolean)
	 * @see org.eclipse.hyades.models.hierarchy.HierarchyPackage#getTRCAgentProxy_Active()
	 * @model default="false" transient="true"
	 * @generated
	 */
	boolean isActive();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.hierarchy.TRCAgentProxy#isActive <em>Active</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Active</em>' attribute.
	 * @see #isActive()
	 * @generated
	 */
	void setActive(boolean value);

	/**
	 * Returns the value of the '<em><b>Attached</b></em>' attribute.
	 * The default value is <code>"false"</code>.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Attached</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Attached</em>' attribute.
	 * @see #setAttached(boolean)
	 * @see org.eclipse.hyades.models.hierarchy.HierarchyPackage#getTRCAgentProxy_Attached()
	 * @model default="false" transient="true"
	 * @generated
	 */
	boolean isAttached();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.hierarchy.TRCAgentProxy#isAttached <em>Attached</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Attached</em>' attribute.
	 * @see #isAttached()
	 * @generated
	 */
	void setAttached(boolean value);

	/**
	 * Returns the value of the '<em><b>Collection Data</b></em>' attribute.
	 * The default value is <code>"false"</code>.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Collection Data</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Collection Data</em>' attribute.
	 * @see #setCollectionData(boolean)
	 * @see org.eclipse.hyades.models.hierarchy.HierarchyPackage#getTRCAgentProxy_CollectionData()
	 * @model default="false" transient="true"
	 * @generated
	 */
	boolean isCollectionData();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.hierarchy.TRCAgentProxy#isCollectionData <em>Collection Data</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Collection Data</em>' attribute.
	 * @see #isCollectionData()
	 * @generated
	 */
	void setCollectionData(boolean value);

	/**
	 * Returns the value of the '<em><b>Monitored</b></em>' attribute.
	 * The default value is <code>"false"</code>.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Monitored</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Monitored</em>' attribute.
	 * @see #setMonitored(boolean)
	 * @see org.eclipse.hyades.models.hierarchy.HierarchyPackage#getTRCAgentProxy_Monitored()
	 * @model default="false" transient="true"
	 * @generated
	 */
	boolean isMonitored();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.hierarchy.TRCAgentProxy#isMonitored <em>Monitored</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Monitored</em>' attribute.
	 * @see #isMonitored()
	 * @generated
	 */
	void setMonitored(boolean value);

	/**
	 * Returns the value of the '<em><b>Profile File</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Profile File</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Profile File</em>' attribute.
	 * @see #setProfileFile(String)
	 * @see org.eclipse.hyades.models.hierarchy.HierarchyPackage#getTRCAgentProxy_ProfileFile()
	 * @model transient="true"
	 * @generated
	 */
	String getProfileFile();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.hierarchy.TRCAgentProxy#getProfileFile <em>Profile File</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Profile File</em>' attribute.
	 * @see #getProfileFile()
	 * @generated
	 */
	void setProfileFile(String value);

	/**
	 * Returns the value of the '<em><b>Agent</b></em>' reference.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.hierarchy.TRCAgent#getAgentProxy <em>Agent Proxy</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Agent</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Agent</em>' reference.
	 * @see #setAgent(TRCAgent)
	 * @see org.eclipse.hyades.models.hierarchy.HierarchyPackage#getTRCAgentProxy_Agent()
	 * @see org.eclipse.hyades.models.hierarchy.TRCAgent#getAgentProxy
	 * @model opposite="agentProxy"
	 * @generated
	 */
	TRCAgent getAgent();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.hierarchy.TRCAgentProxy#getAgent <em>Agent</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Agent</em>' reference.
	 * @see #getAgent()
	 * @generated
	 */
	void setAgent(TRCAgent value);

	/**
	 * Returns the value of the '<em><b>Internal Correlations</b></em>' reference list.
	 * The list contents are of type {@link org.eclipse.hyades.models.hierarchy.CorrelationContainerProxy}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Internal Correlations</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Internal Correlations</em>' reference list.
	 * @see org.eclipse.hyades.models.hierarchy.HierarchyPackage#getTRCAgentProxy_InternalCorrelations()
	 * @model type="org.eclipse.hyades.models.hierarchy.CorrelationContainerProxy"
	 * @generated
	 */
	EList getInternalCorrelations();

	/**
	 * Returns the value of the '<em><b>Process Proxy</b></em>' container reference.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.hierarchy.TRCProcessProxy#getAgentProxies <em>Agent Proxies</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Process Proxy</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Process Proxy</em>' container reference.
	 * @see #setProcessProxy(TRCProcessProxy)
	 * @see org.eclipse.hyades.models.hierarchy.HierarchyPackage#getTRCAgentProxy_ProcessProxy()
	 * @see org.eclipse.hyades.models.hierarchy.TRCProcessProxy#getAgentProxies
	 * @model opposite="agentProxies"
	 * @generated
	 */
	TRCProcessProxy getProcessProxy();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.hierarchy.TRCAgentProxy#getProcessProxy <em>Process Proxy</em>}' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Process Proxy</em>' container reference.
	 * @see #getProcessProxy()
	 * @generated
	 */
	void setProcessProxy(TRCProcessProxy value);

	/**
	 * Returns the value of the '<em><b>Configurations</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.hyades.models.hierarchy.TRCConfiguration}.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.hierarchy.TRCConfiguration#getAgentProxy <em>Agent Proxy</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Configurations</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Configurations</em>' containment reference list.
	 * @see org.eclipse.hyades.models.hierarchy.HierarchyPackage#getTRCAgentProxy_Configurations()
	 * @see org.eclipse.hyades.models.hierarchy.TRCConfiguration#getAgentProxy
	 * @model type="org.eclipse.hyades.models.hierarchy.TRCConfiguration" opposite="agentProxy" containment="true"
	 * @generated
	 */
	EList getConfigurations();

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @model 
	 * @generated
	 */
	boolean isToProfileFile();

} // TRCAgentProxy
