/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.hierarchy;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>TRC Configuration</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * A configuration is used to hold a set of options and filters. This would normally be used to capture a set of options and filters that are active for a given agent.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.TRCConfiguration#getName <em>Name</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.TRCConfiguration#isActive <em>Active</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.TRCConfiguration#getOptions <em>Options</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.TRCConfiguration#getFilters <em>Filters</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.TRCConfiguration#getAgentProxy <em>Agent Proxy</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.hyades.models.hierarchy.HierarchyPackage#getTRCConfiguration()
 * @model 
 * @generated
 */
public interface TRCConfiguration extends EObject{
	/**
	 * Returns the value of the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Name</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Name</em>' attribute.
	 * @see #setName(String)
	 * @see org.eclipse.hyades.models.hierarchy.HierarchyPackage#getTRCConfiguration_Name()
	 * @model 
	 * @generated
	 */
	String getName();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.hierarchy.TRCConfiguration#getName <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Name</em>' attribute.
	 * @see #getName()
	 * @generated
	 */
	void setName(String value);

	/**
	 * Returns the value of the '<em><b>Active</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Active</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Active</em>' attribute.
	 * @see #setActive(boolean)
	 * @see org.eclipse.hyades.models.hierarchy.HierarchyPackage#getTRCConfiguration_Active()
	 * @model 
	 * @generated
	 */
	boolean isActive();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.hierarchy.TRCConfiguration#isActive <em>Active</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Active</em>' attribute.
	 * @see #isActive()
	 * @generated
	 */
	void setActive(boolean value);

	/**
	 * Returns the value of the '<em><b>Options</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.hyades.models.hierarchy.TRCOption}.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.hierarchy.TRCOption#getConfiguration <em>Configuration</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Options</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Options</em>' containment reference list.
	 * @see org.eclipse.hyades.models.hierarchy.HierarchyPackage#getTRCConfiguration_Options()
	 * @see org.eclipse.hyades.models.hierarchy.TRCOption#getConfiguration
	 * @model type="org.eclipse.hyades.models.hierarchy.TRCOption" opposite="configuration" containment="true"
	 * @generated
	 */
	EList getOptions();

	/**
	 * Returns the value of the '<em><b>Filters</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.hyades.models.hierarchy.TRCFilter}.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.hierarchy.TRCFilter#getConfiguration <em>Configuration</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Filters</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Filters</em>' containment reference list.
	 * @see org.eclipse.hyades.models.hierarchy.HierarchyPackage#getTRCConfiguration_Filters()
	 * @see org.eclipse.hyades.models.hierarchy.TRCFilter#getConfiguration
	 * @model type="org.eclipse.hyades.models.hierarchy.TRCFilter" opposite="configuration" containment="true"
	 * @generated
	 */
	EList getFilters();

	/**
	 * Returns the value of the '<em><b>Agent Proxy</b></em>' container reference.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.hierarchy.TRCAgentProxy#getConfigurations <em>Configurations</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Agent Proxy</em>' container reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Agent Proxy</em>' container reference.
	 * @see #setAgentProxy(TRCAgentProxy)
	 * @see org.eclipse.hyades.models.hierarchy.HierarchyPackage#getTRCConfiguration_AgentProxy()
	 * @see org.eclipse.hyades.models.hierarchy.TRCAgentProxy#getConfigurations
	 * @model opposite="configurations" required="true"
	 * @generated
	 */
	TRCAgentProxy getAgentProxy();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.hierarchy.TRCConfiguration#getAgentProxy <em>Agent Proxy</em>}' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Agent Proxy</em>' container reference.
	 * @see #getAgentProxy()
	 * @generated
	 */
	void setAgentProxy(TRCAgentProxy value);

} // TRCConfiguration
