/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.hierarchy;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>TRC Node</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * A Node is a machine, or at least a machine execution partition. It owns process proxies for processes with agents attached and data collected.
 * There is one server/service installed for each Node. An analogy is a service running on NT that hooks to the process being monitored.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.TRCNode#getRuntimeId <em>Runtime Id</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.TRCNode#getTimezone <em>Timezone</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.TRCNode#getPort <em>Port</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.TRCNode#getDeltaTime <em>Delta Time</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.TRCNode#getName <em>Name</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.TRCNode#getDescription <em>Description</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.TRCNode#getIpAddress <em>Ip Address</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.TRCNode#getMonitor <em>Monitor</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.TRCNode#getProcessProxies <em>Process Proxies</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.hyades.models.hierarchy.HierarchyPackage#getTRCNode()
 * @model 
 * @generated
 */
public interface TRCNode extends EObject{
	/**
	 * Returns the value of the '<em><b>Runtime Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Runtime Id</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Runtime Id</em>' attribute.
	 * @see #setRuntimeId(String)
	 * @see org.eclipse.hyades.models.hierarchy.HierarchyPackage#getTRCNode_RuntimeId()
	 * @model 
	 * @generated
	 */
	String getRuntimeId();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.hierarchy.TRCNode#getRuntimeId <em>Runtime Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Runtime Id</em>' attribute.
	 * @see #getRuntimeId()
	 * @generated
	 */
	void setRuntimeId(String value);

	/**
	 * Returns the value of the '<em><b>Timezone</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Timezone</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Timezone</em>' attribute.
	 * @see #setTimezone(double)
	 * @see org.eclipse.hyades.models.hierarchy.HierarchyPackage#getTRCNode_Timezone()
	 * @model 
	 * @generated
	 */
	double getTimezone();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.hierarchy.TRCNode#getTimezone <em>Timezone</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Timezone</em>' attribute.
	 * @see #getTimezone()
	 * @generated
	 */
	void setTimezone(double value);

	/**
	 * Returns the value of the '<em><b>Port</b></em>' attribute.
	 * The default value is <code>"10002"</code>.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Port</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Port</em>' attribute.
	 * @see #setPort(int)
	 * @see org.eclipse.hyades.models.hierarchy.HierarchyPackage#getTRCNode_Port()
	 * @model default="10002"
	 * @generated
	 */
	int getPort();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.hierarchy.TRCNode#getPort <em>Port</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Port</em>' attribute.
	 * @see #getPort()
	 * @generated
	 */
	void setPort(int value);

	/**
	 * Returns the value of the '<em><b>Delta Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Delta Time</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Used to synchronize entry, exit events between different nodes, on a distributed application. It is in microseconds.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Delta Time</em>' attribute.
	 * @see #setDeltaTime(double)
	 * @see org.eclipse.hyades.models.hierarchy.HierarchyPackage#getTRCNode_DeltaTime()
	 * @model 
	 * @generated
	 */
	double getDeltaTime();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.hierarchy.TRCNode#getDeltaTime <em>Delta Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Delta Time</em>' attribute.
	 * @see #getDeltaTime()
	 * @generated
	 */
	void setDeltaTime(double value);

	/**
	 * Returns the value of the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Name</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * The machine/host name 
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Name</em>' attribute.
	 * @see #setName(String)
	 * @see org.eclipse.hyades.models.hierarchy.HierarchyPackage#getTRCNode_Name()
	 * @model 
	 * @generated
	 */
	String getName();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.hierarchy.TRCNode#getName <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Name</em>' attribute.
	 * @see #getName()
	 * @generated
	 */
	void setName(String value);

	/**
	 * Returns the value of the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Description</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Description</em>' attribute.
	 * @see #setDescription(String)
	 * @see org.eclipse.hyades.models.hierarchy.HierarchyPackage#getTRCNode_Description()
	 * @model 
	 * @generated
	 */
	String getDescription();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.hierarchy.TRCNode#getDescription <em>Description</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Description</em>' attribute.
	 * @see #getDescription()
	 * @generated
	 */
	void setDescription(String value);

	/**
	 * Returns the value of the '<em><b>Ip Address</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Ip Address</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * The IP address of the node
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Ip Address</em>' attribute.
	 * @see #setIpAddress(String)
	 * @see org.eclipse.hyades.models.hierarchy.HierarchyPackage#getTRCNode_IpAddress()
	 * @model 
	 * @generated
	 */
	String getIpAddress();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.hierarchy.TRCNode#getIpAddress <em>Ip Address</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Ip Address</em>' attribute.
	 * @see #getIpAddress()
	 * @generated
	 */
	void setIpAddress(String value);

	/**
	 * Returns the value of the '<em><b>Process Proxies</b></em>' reference list.
	 * The list contents are of type {@link org.eclipse.hyades.models.hierarchy.TRCProcessProxy}.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.hierarchy.TRCProcessProxy#getNode <em>Node</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Process Proxies</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Process Proxies</em>' reference list.
	 * @see org.eclipse.hyades.models.hierarchy.HierarchyPackage#getTRCNode_ProcessProxies()
	 * @see org.eclipse.hyades.models.hierarchy.TRCProcessProxy#getNode
	 * @model type="org.eclipse.hyades.models.hierarchy.TRCProcessProxy" opposite="node"
	 * @generated
	 */
	EList getProcessProxies();

	/**
	 * Returns the value of the '<em><b>Monitor</b></em>' reference.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.hierarchy.TRCMonitor#getNodes <em>Nodes</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Monitor</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Monitor</em>' reference.
	 * @see #setMonitor(TRCMonitor)
	 * @see org.eclipse.hyades.models.hierarchy.HierarchyPackage#getTRCNode_Monitor()
	 * @see org.eclipse.hyades.models.hierarchy.TRCMonitor#getNodes
	 * @model opposite="nodes"
	 * @generated
	 */
	TRCMonitor getMonitor();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.hierarchy.TRCNode#getMonitor <em>Monitor</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Monitor</em>' reference.
	 * @see #getMonitor()
	 * @generated
	 */
	void setMonitor(TRCMonitor value);

} // TRCNode
