/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.hierarchy.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.hyades.models.hierarchy.HierarchyPackage;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCConfiguration;
import org.eclipse.hyades.models.hierarchy.TRCFilter;
import org.eclipse.hyades.models.hierarchy.TRCOption;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>TRC Configuration</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.impl.TRCConfigurationImpl#getName <em>Name</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.impl.TRCConfigurationImpl#isActive <em>Active</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.impl.TRCConfigurationImpl#getOptions <em>Options</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.impl.TRCConfigurationImpl#getFilters <em>Filters</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.impl.TRCConfigurationImpl#getAgentProxy <em>Agent Proxy</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class TRCConfigurationImpl extends EObjectImpl  implements TRCConfiguration {
	/**
	 * The default value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected static final String NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected String name = NAME_EDEFAULT;

	/**
	 * The default value of the '{@link #isActive() <em>Active</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isActive()
	 * @generated
	 * @ordered
	 */
	protected static final boolean ACTIVE_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isActive() <em>Active</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isActive()
	 * @generated
	 * @ordered
	 */
	protected boolean active = ACTIVE_EDEFAULT;

	/**
	 * The cached value of the '{@link #getOptions() <em>Options</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOptions()
	 * @generated
	 * @ordered
	 */
	protected EList options = null;

	/**
	 * The cached value of the '{@link #getFilters() <em>Filters</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getFilters()
	 * @generated
	 * @ordered
	 */
	protected EList filters = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TRCConfigurationImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return HierarchyPackage.eINSTANCE.getTRCConfiguration();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getName() {
		return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setName(String newName) {
		String oldName = name;
		name = newName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, HierarchyPackage.TRC_CONFIGURATION__NAME, oldName, name));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isActive() {
		return active;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setActive(boolean newActive) {
		boolean oldActive = active;
		active = newActive;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, HierarchyPackage.TRC_CONFIGURATION__ACTIVE, oldActive, active));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getOptions() {
		if (options == null) {
			options = new EObjectContainmentWithInverseEList(TRCOption.class, this, HierarchyPackage.TRC_CONFIGURATION__OPTIONS, HierarchyPackage.TRC_OPTION__CONFIGURATION);
		}
		return options;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getFilters() {
		if (filters == null) {
			filters = new EObjectContainmentWithInverseEList(TRCFilter.class, this, HierarchyPackage.TRC_CONFIGURATION__FILTERS, HierarchyPackage.TRC_FILTER__CONFIGURATION);
		}
		return filters;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCAgentProxy getAgentProxy() {
		if (eContainerFeatureID != HierarchyPackage.TRC_CONFIGURATION__AGENT_PROXY) return null;
		return (TRCAgentProxy)eContainer;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setAgentProxy(TRCAgentProxy newAgentProxy) {
		if (newAgentProxy != eContainer || (eContainerFeatureID != HierarchyPackage.TRC_CONFIGURATION__AGENT_PROXY && newAgentProxy != null)) {
			if (EcoreUtil.isAncestor(this, newAgentProxy))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eContainer != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newAgentProxy != null)
				msgs = ((InternalEObject)newAgentProxy).eInverseAdd(this, HierarchyPackage.TRC_AGENT_PROXY__CONFIGURATIONS, TRCAgentProxy.class, msgs);
			msgs = eBasicSetContainer((InternalEObject)newAgentProxy, HierarchyPackage.TRC_CONFIGURATION__AGENT_PROXY, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, HierarchyPackage.TRC_CONFIGURATION__AGENT_PROXY, newAgentProxy, newAgentProxy));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case HierarchyPackage.TRC_CONFIGURATION__OPTIONS:
					return ((InternalEList)getOptions()).basicAdd(otherEnd, msgs);
				case HierarchyPackage.TRC_CONFIGURATION__FILTERS:
					return ((InternalEList)getFilters()).basicAdd(otherEnd, msgs);
				case HierarchyPackage.TRC_CONFIGURATION__AGENT_PROXY:
					if (eContainer != null)
						msgs = eBasicRemoveFromContainer(msgs);
					return eBasicSetContainer(otherEnd, HierarchyPackage.TRC_CONFIGURATION__AGENT_PROXY, msgs);
				default:
					return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
			}
		}
		if (eContainer != null)
			msgs = eBasicRemoveFromContainer(msgs);
		return eBasicSetContainer(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case HierarchyPackage.TRC_CONFIGURATION__OPTIONS:
					return ((InternalEList)getOptions()).basicRemove(otherEnd, msgs);
				case HierarchyPackage.TRC_CONFIGURATION__FILTERS:
					return ((InternalEList)getFilters()).basicRemove(otherEnd, msgs);
				case HierarchyPackage.TRC_CONFIGURATION__AGENT_PROXY:
					return eBasicSetContainer(null, HierarchyPackage.TRC_CONFIGURATION__AGENT_PROXY, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs) {
		if (eContainerFeatureID >= 0) {
			switch (eContainerFeatureID) {
				case HierarchyPackage.TRC_CONFIGURATION__AGENT_PROXY:
					return ((InternalEObject)eContainer).eInverseRemove(this, HierarchyPackage.TRC_AGENT_PROXY__CONFIGURATIONS, TRCAgentProxy.class, msgs);
				default:
					return eDynamicBasicRemoveFromContainer(msgs);
			}
		}
		return ((InternalEObject)eContainer).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - eContainerFeatureID, null, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case HierarchyPackage.TRC_CONFIGURATION__NAME:
				return getName();
			case HierarchyPackage.TRC_CONFIGURATION__ACTIVE:
				return isActive() ? Boolean.TRUE : Boolean.FALSE;
			case HierarchyPackage.TRC_CONFIGURATION__OPTIONS:
				return getOptions();
			case HierarchyPackage.TRC_CONFIGURATION__FILTERS:
				return getFilters();
			case HierarchyPackage.TRC_CONFIGURATION__AGENT_PROXY:
				return getAgentProxy();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case HierarchyPackage.TRC_CONFIGURATION__NAME:
				setName((String)newValue);
				return;
			case HierarchyPackage.TRC_CONFIGURATION__ACTIVE:
				setActive(((Boolean)newValue).booleanValue());
				return;
			case HierarchyPackage.TRC_CONFIGURATION__OPTIONS:
				getOptions().clear();
				getOptions().addAll((Collection)newValue);
				return;
			case HierarchyPackage.TRC_CONFIGURATION__FILTERS:
				getFilters().clear();
				getFilters().addAll((Collection)newValue);
				return;
			case HierarchyPackage.TRC_CONFIGURATION__AGENT_PROXY:
				setAgentProxy((TRCAgentProxy)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case HierarchyPackage.TRC_CONFIGURATION__NAME:
				setName(NAME_EDEFAULT);
				return;
			case HierarchyPackage.TRC_CONFIGURATION__ACTIVE:
				setActive(ACTIVE_EDEFAULT);
				return;
			case HierarchyPackage.TRC_CONFIGURATION__OPTIONS:
				getOptions().clear();
				return;
			case HierarchyPackage.TRC_CONFIGURATION__FILTERS:
				getFilters().clear();
				return;
			case HierarchyPackage.TRC_CONFIGURATION__AGENT_PROXY:
				setAgentProxy((TRCAgentProxy)null);
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case HierarchyPackage.TRC_CONFIGURATION__NAME:
				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
			case HierarchyPackage.TRC_CONFIGURATION__ACTIVE:
				return active != ACTIVE_EDEFAULT;
			case HierarchyPackage.TRC_CONFIGURATION__OPTIONS:
				return options != null && !options.isEmpty();
			case HierarchyPackage.TRC_CONFIGURATION__FILTERS:
				return filters != null && !filters.isEmpty();
			case HierarchyPackage.TRC_CONFIGURATION__AGENT_PROXY:
				return getAgentProxy() != null;
		}
		return eDynamicIsSet(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (name: ");
		result.append(name);
		result.append(", active: ");
		result.append(active);
		result.append(')');
		return result.toString();
	}

} //TRCConfigurationImpl
