/**********************************************************************
 * Copyright (c) 2003,2004 Scapa Technologies Limited and others
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.statistical.ui.monitoractions.internal.donothing;

import org.eclipse.hyades.statistical.ui.widgets.alert.internal.*;
import org.eclipse.hyades.statistical.ui.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.hyades.model.statistical.*;


public class DoNothingAlertAction implements AlertAction {

boolean trigger;
String name;
double value;
double time;
	public AlertActionControl getControl(Composite c) {
		return new DoNothingControl(c,this);
	}
	
	public String getDescription() {
		return EditorPlugin.getString("ALERT_ACTION_NAME_DONOTHING");
	}
	
	public String getProviderName() {
		return EditorPlugin.getString("ALERT_ACTION_NAME_DONOTHING");
	}
	public void setInformation(String name, SDSnapshotObservation obs, double value, double time, boolean trigger) {
		this.name = name;
		this.value = value;
		this.time = time;
		this.trigger = trigger;
	}
	public void run() {
		if (trigger) {
			System.out.println("TRIGGER "+name+" @ "+value);
		} else {
			System.out.println("RESET "+name+" @ "+value);
		}
	}
	public Object clone() {
		return new DoNothingAlertAction();
	}
}

