/**********************************************************************
 * Copyright (c) 2003,2004 Scapa Technologies Limited and others
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.statistical.ui.monitoractions.internal.email;

import org.eclipse.hyades.statistical.ui.widgets.alert.internal.*;
import org.eclipse.hyades.statistical.ui.widgets.internal.GData;
import org.eclipse.hyades.statistical.ui.editor.internal.*;
import org.eclipse.hyades.statistical.ui.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.*;
import org.eclipse.swt.events.*;

public class EmailControl extends AlertActionControl implements SelectionListener {
EmailAlertAction action;

String host = "mail";
int port = 25;
String sender;
String recipients;
String localhostDomain;

Group sender_panel;
	Label sender_label;
	Text sender_address;

Group recipient_panel;
	Label recipient_label;
	Text recipient_address;
	
Group smtp_panel;
	Label smtp_host_label;
	Text smtp_host;
	Label smtp_port_label;
	Text smtp_port;

Group domain_panel;
	Label domain_label;
	Text domain_address;

Button defaults;
	
	public EmailControl(Composite c, EmailAlertAction action) {
		super(c,0);
		this.action = action;
		
		initGraphics();
		initEventHandling();
		
		readFromAction(action);
	}
	
	private void initGraphics() {
		setLayout(new GridLayout(1,true));
		
		sender_panel = new Group(this,0);
		sender_panel.setLayout(new GridLayout(2,false));
		sender_panel.setLayoutData(GData.getGridData(true,false,-1,-1,1,1,GridData.FILL,GridData.FILL));
		sender_panel.setText(EditorPlugin.getString("ALERT_ACTION_EMAIL_SENDER_TITLE"));
		sender_label = new Label(sender_panel,0);
		sender_label.setLayoutData(GData.getGridData(false,false,-1,-1,1,1,GridData.BEGINNING,GridData.BEGINNING));
		sender_label.setText(EditorPlugin.getString("ALERT_ACTION_EMAIL_SENDER"));
		sender_address = new Text(sender_panel,SWT.BORDER);
		sender_address.setLayoutData(GData.getGridData(true,false,-1,-1,1,1,GridData.FILL,GridData.FILL));

		recipient_panel = new Group(this,0);
		recipient_panel.setLayout(new GridLayout(2,false));
		recipient_panel.setLayoutData(GData.getGridData(true,false,-1,-1,1,1,GridData.FILL,GridData.FILL));
		recipient_panel.setText(EditorPlugin.getString("ALERT_ACTION_EMAIL_RECIPIENT_TITLE"));
		recipient_label = new Label(recipient_panel,0);
		recipient_label.setLayoutData(GData.getGridData(false,false,-1,-1,1,1,GridData.BEGINNING,GridData.BEGINNING));
		recipient_label.setText(EditorPlugin.getString("ALERT_ACTION_EMAIL_RECIPIENT"));
		recipient_address = new Text(recipient_panel,SWT.BORDER);
		recipient_address.setLayoutData(GData.getGridData(true,false,-1,-1,1,1,GridData.FILL,GridData.FILL));
		
		smtp_panel = new Group(this,0);
		smtp_panel.setLayout(new GridLayout(2,false));
		smtp_panel.setLayoutData(GData.getGridData(true,false,-1,-1,1,1,GridData.FILL,GridData.FILL));
		smtp_panel.setText(EditorPlugin.getString("ALERT_ACTION_EMAIL_SMTP_TITLE"));

		smtp_host_label = new Label(smtp_panel,0);
		smtp_host_label.setLayoutData(GData.getGridData(false,false,-1,-1,1,1,GridData.BEGINNING,GridData.BEGINNING));
		smtp_host_label.setText(EditorPlugin.getString("ALERT_ACTION_EMAIL_SMTPHOST"));
		smtp_host = new Text(smtp_panel,SWT.BORDER);
		smtp_host.setLayoutData(GData.getGridData(true,false,-1,-1,1,1,GridData.FILL,GridData.FILL));

		smtp_port_label = new Label(smtp_panel,0);
		smtp_port_label.setLayoutData(GData.getGridData(false,false,-1,-1,1,1,GridData.BEGINNING,GridData.BEGINNING));
		smtp_port_label.setText(EditorPlugin.getString("ALERT_ACTION_EMAIL_SMTPPORT"));
		smtp_port = new Text(smtp_panel,SWT.BORDER);
		smtp_port.setLayoutData(GData.getGridData(true,false,-1,-1,1,1,GridData.FILL,GridData.FILL));
		
		domain_panel = new Group(this,0);
		domain_panel.setLayout(new GridLayout(2,false));
		domain_panel.setLayoutData(GData.getGridData(true,false,-1,-1,1,1,GridData.FILL,GridData.FILL));
		domain_panel.setText(EditorPlugin.getString("ALERT_ACTION_EMAIL_DOMAIN_TITLE"));
		domain_label = new Label(domain_panel,0);
		domain_label.setLayoutData(GData.getGridData(false,false,-1,-1,1,1,GridData.BEGINNING,GridData.BEGINNING));
		domain_label.setText(EditorPlugin.getString("ALERT_ACTION_EMAIL_DOMAIN"));
		domain_address = new Text(domain_panel,SWT.BORDER);
		domain_address.setLayoutData(GData.getGridData(true,false,-1,-1,1,1,GridData.FILL,GridData.FILL));
		
		defaults = new Button(this,SWT.NONE);
		defaults.setText(EditorPlugin.getString("RESTORE_DEFAULTS"));
	}
	
	void setDefaultsButtonOn(boolean on) {
		if (!on) {
			try {
				defaults.dispose();
			} catch (Exception e) {}
			layout(true);
			redraw();
		}
	}
	
	public void restoreDefaults() {
		EmailActionProvider provider = new EmailActionProvider();
		readFromAction(provider.fromPreferenceStore(EditorPlugin.getDefault().getPreferenceStore()));
	}
	
	public void widgetDefaultSelected(SelectionEvent e) {
		widgetSelected(e);
	}
	public void widgetSelected(SelectionEvent e) {
		Object o = e.getSource();
		if (o == defaults) {
			restoreDefaults();
		}
	}
	
	private void initEventHandling() {
		defaults.addSelectionListener(this);
	}
	
	public void readFromAction(AlertAction tmp) {
		EmailAlertAction eaction = (EmailAlertAction)tmp;
		sender_address.setText(eaction.sender);
		recipient_address.setText(eaction.recipients);
		smtp_host.setText(eaction.host);
		smtp_port.setText(""+eaction.port);
		domain_address.setText(eaction.localhostDomain);
	}
	
	public void writeToAction(AlertAction tmp) throws InvalidDataException {
		String sender = sender_address.getText();
		if (sender.length() == 0) throw new InvalidDataException(EditorPlugin.getString("ERROR_ALERT_EMAIL_SENDER"));
		if (sender.indexOf('@') == -1) throw new InvalidDataException(EditorPlugin.getString("ERROR_ALERT_EMAIL_SENDER"));

		String recipient = recipient_address.getText();
		if (recipient.length() == 0) throw new InvalidDataException(EditorPlugin.getString("ERROR_ALERT_EMAIL_RECIPIENT"));
		if (recipient.indexOf('@') == -1) throw new InvalidDataException(EditorPlugin.getString("ERROR_ALERT_EMAIL_RECIPIENT"));

		String host = smtp_host.getText();
		if (host.length() == 0) throw new InvalidDataException(EditorPlugin.getString("ERROR_ALERT_EMAIL_HOST"));
		
		String portstr = smtp_port.getText();
		if (portstr.length() == 0) throw new InvalidDataException(EditorPlugin.getString("ERROR_ALERT_EMAIL_PORT"));
		int port = 0;
		try {
			port = Integer.parseInt(portstr);
		} catch (Exception e) {
			throw new InvalidDataException(EditorPlugin.getString("ERROR_ALERT_EMAIL_PORT"));
		}
		if (port < 1 || port > 65535) {
			throw new InvalidDataException(EditorPlugin.getString("ERROR_ALERT_EMAIL_PORT"));
		}

		String domain = domain_address.getText();
		
		EmailAlertAction eaction = (EmailAlertAction)tmp;
		eaction.sender = sender;
		eaction.recipients = recipient;
		eaction.host = host;
		eaction.port = port;
		eaction.localhostDomain = domain;
	}
	public AlertAction writeToClonedAction() throws InvalidDataException {
		EmailAlertAction clone = (EmailAlertAction)action.clone();
		writeToAction(clone);
		return clone;
	}
	public AlertAction writeToOriginalAction() throws InvalidDataException {
		writeToAction(action);
		return action;
	}

	public String getDescription() {
		return EditorPlugin.getString("ALERT_ACTION_NAME_EMAIL");
	}
}

