/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.test.extension;

import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.hyades.ui.HyadesUI;
import org.eclipse.hyades.ui.extension.IAssociationDescriptor;
import org.eclipse.hyades.ui.extension.IAssociationMapping;
import org.eclipse.hyades.ui.extension.IAssociationMappingRegistry;

public class ExtensionTestCase
extends TestCase {
    private static final String PLUGIN_ID = "org.eclipse.hyades.ui.test";
    private static final String EP_ONE_TYPE_ASSOCIATION = "oneTypeAssociations";
    private static final String EP_MULTI_TYPE_ASSOCIATION = "multiTypeAssociations";
    private static final String EP_UNTYPE_ASSOCIATION = "untypedAssociations";

    public ExtensionTestCase(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite("Hyades UI Extension Framework");
        testSuite.addTest((Test)new ExtensionTestCase("testBasicAttributes"));
        testSuite.addTest((Test)new ExtensionTestCase("testOneTypeAssociation_Load"));
        testSuite.addTest((Test)new ExtensionTestCase("testOneTypeAssociation_Manipulation"));
        testSuite.addTest((Test)new ExtensionTestCase("testOneTypeAssociation_Default"));
        testSuite.addTest((Test)new ExtensionTestCase("testMultiTypeAssociation_Load"));
        testSuite.addTest((Test)new ExtensionTestCase("testMultiTypeAssociation_Manipulation"));
        testSuite.addTest((Test)new ExtensionTestCase("testMultiTypeAssociation_Default"));
        testSuite.addTest((Test)new ExtensionTestCase("testUntypeAssociation_Load"));
        testSuite.addTest((Test)new ExtensionTestCase("testUntypeAssociation_Manipulation"));
        testSuite.addTest((Test)new ExtensionTestCase("testUntypeAssociation_Default"));
        return testSuite;
    }

    protected void setUp() throws Exception {
        Assert.assertNotNull((String)"This test is supposed to run inside an Eclipse context", (Object)ResourcesPlugin.getWorkspace());
    }

    public void testBasicAttributes() {
        IAssociationMappingRegistry iAssociationMappingRegistry = HyadesUI.createAssociationMappingRegistry();
        iAssociationMappingRegistry.initialize("category1", null, null);
        Assert.assertEquals((String)"category1", (String)iAssociationMappingRegistry.getObjectCategory());
        IAssociationMapping iAssociationMapping = iAssociationMappingRegistry.retrieveAssociationMapping("mapping1", PLUGIN_ID);
        Assert.assertEquals((String)PLUGIN_ID, (String)iAssociationMapping.getPluginId());
        Assert.assertEquals((Object)iAssociationMappingRegistry, (Object)iAssociationMapping.getAssociationMappingRegistry());
        Assert.assertEquals((String)"mapping1", (String)iAssociationMapping.getExtensionPoint());
        Assert.assertEquals((Object)iAssociationMapping, (Object)iAssociationMappingRegistry.retrieveAssociationMapping("mapping1", PLUGIN_ID));
        Assert.assertEquals((Object)iAssociationMapping, (Object)iAssociationMappingRegistry.getAssociationMapping("mapping1"));
        iAssociationMappingRegistry.retrieveAssociationMapping("mapping2", PLUGIN_ID);
        Assert.assertEquals((int)2, (int)iAssociationMappingRegistry.getAssociationMappings().length);
        IAssociationDescriptor iAssociationDescriptor = iAssociationMapping.createAssociationDescriptor();
        iAssociationDescriptor.setName("name");
        iAssociationDescriptor.setDescription("description");
        iAssociationDescriptor.setExtension("fileExtension");
        iAssociationDescriptor.setId("id");
        Assert.assertEquals((Object)iAssociationMapping, (Object)iAssociationDescriptor.getAssociationMapping());
        Assert.assertEquals((int)1, (int)iAssociationMapping.associationDescriptors().length);
        Assert.assertEquals((Object)iAssociationDescriptor, (Object)iAssociationMapping.associationDescriptors()[0]);
        Assert.assertEquals((int)1, (int)iAssociationMapping.getAssociationDescriptors("type1").length);
        Assert.assertEquals((Object)iAssociationDescriptor, (Object)iAssociationMapping.getAssociationDescriptors("type1")[0]);
        Assert.assertTrue((boolean)iAssociationDescriptor.applyToAllTypes());
        Assert.assertTrue((boolean)iAssociationDescriptor.applyTo("type2"));
        Assert.assertEquals((String)"name", (String)iAssociationDescriptor.getName());
        Assert.assertEquals((String)"description", (String)iAssociationDescriptor.getDescription());
        Assert.assertEquals((String)"fileExtension", (String)iAssociationDescriptor.getExtension());
        Assert.assertEquals((String)"id", (String)iAssociationDescriptor.getId());
        Assert.assertNull((Object)iAssociationDescriptor.getImplementationClass());
        Assert.assertNull((Object)iAssociationDescriptor.getImage());
        Assert.assertNull((Object)iAssociationDescriptor.getImageDescriptor());
        IllegalArgumentException illegalArgumentException = null;
        try {
            iAssociationMapping.setDefaultAssociationDescriptor(null, iAssociationDescriptor);
        }
        catch (IllegalArgumentException illegalArgumentException2) {
            illegalArgumentException = illegalArgumentException2;
        }
        Assert.assertNotNull((Object)illegalArgumentException);
        Assert.assertTrue((boolean)(illegalArgumentException instanceof IllegalArgumentException));
        illegalArgumentException = null;
        try {
            iAssociationMapping.getAssociationDescriptors(null);
        }
        catch (IllegalArgumentException illegalArgumentException3) {
            illegalArgumentException = illegalArgumentException3;
        }
        Assert.assertNotNull((Object)illegalArgumentException);
        Assert.assertTrue((boolean)(illegalArgumentException instanceof IllegalArgumentException));
        illegalArgumentException = null;
        try {
            iAssociationMapping.getDefaultAssociationDescriptor(null);
        }
        catch (IllegalArgumentException illegalArgumentException4) {
            illegalArgumentException = illegalArgumentException4;
        }
        Assert.assertNotNull((Object)illegalArgumentException);
        Assert.assertTrue((boolean)(illegalArgumentException instanceof IllegalArgumentException));
        Assert.assertEquals((Object)iAssociationDescriptor, (Object)iAssociationMapping.getAssociationDescriptor("type2", "id"));
        Assert.assertNull((Object)iAssociationMapping.getAssociationDescriptor("type2", "fakeId"));
        Assert.assertNull((Object)iAssociationMapping.getAssociationDescriptor("fakeId"));
        IAssociationDescriptor iAssociationDescriptor2 = iAssociationMapping.createAssociationDescriptor();
        iAssociationDescriptor2.setId("aNewId");
        Assert.assertEquals((Object)iAssociationDescriptor2, (Object)iAssociationMapping.getAssociationDescriptor("aNewId"));
        Assert.assertEquals((Object)iAssociationDescriptor2, (Object)iAssociationMapping.getAssociationDescriptor("type2", "aNewId"));
        Assert.assertEquals((Object)iAssociationDescriptor2, (Object)iAssociationMapping.getAssociationDescriptor("type3", "aNewId"));
    }

    public void testOneTypeAssociation_Load() {
        IAssociationMappingRegistry iAssociationMappingRegistry = HyadesUI.createAssociationMappingRegistry();
        iAssociationMappingRegistry.initialize("category1", null, null);
        IAssociationMapping iAssociationMapping = iAssociationMappingRegistry.retrieveAssociationMapping(EP_ONE_TYPE_ASSOCIATION, PLUGIN_ID);
        Assert.assertEquals((Object)iAssociationMappingRegistry, (Object)iAssociationMapping.getAssociationMappingRegistry());
        Assert.assertEquals((String)EP_ONE_TYPE_ASSOCIATION, (String)iAssociationMapping.getExtensionPoint());
        Assert.assertEquals((int)2, (int)iAssociationMapping.getAssociationDescriptors("type1").length);
        Assert.assertEquals((int)1, (int)iAssociationMapping.getAssociationDescriptors("type2").length);
        Assert.assertEquals((int)4, (int)iAssociationMapping.associationDescriptors().length);
        Assert.assertEquals((int)1, (int)iAssociationMapping.getAssociationDescriptors("type").length);
        Assert.assertEquals((int)0, (int)iAssociationMapping.getAssociationDescriptors().length);
        Assert.assertNotNull((Object)iAssociationMapping.getDefaultAssociationDescriptor("type1"));
        Assert.assertNotNull((Object)iAssociationMapping.getDefaultAssociationDescriptor("type2"));
        Assert.assertNotNull((Object)iAssociationMapping.getDefaultAssociationDescriptor("type"));
        Assert.assertNull((Object)iAssociationMapping.getDefaultAssociationDescriptor("type3"));
        Assert.assertNull((Object)iAssociationMapping.getDefaultAssociationDescriptor());
        IAssociationDescriptor[] iAssociationDescriptorArray = iAssociationMapping.getAssociationDescriptors("type1");
        Assert.assertTrue((boolean)iAssociationDescriptorArray[0].applyTo("type1"));
        Assert.assertFalse((boolean)iAssociationDescriptorArray[0].applyToAllTypes());
        Assert.assertNull((Object)iAssociationDescriptorArray[0].getImage());
        Assert.assertNull((Object)iAssociationDescriptorArray[0].getImageDescriptor());
        Assert.assertNull((Object)iAssociationDescriptorArray[0].getExtension());
        Assert.assertNull((Object)iAssociationDescriptorArray[0].getImplementationClass());
        Assert.assertTrue((boolean)iAssociationDescriptorArray[1].applyTo("type1"));
        Assert.assertFalse((boolean)iAssociationDescriptorArray[1].applyToAllTypes());
        Assert.assertNull((Object)iAssociationDescriptorArray[1].getImage());
        Assert.assertNull((Object)iAssociationDescriptorArray[1].getImageDescriptor());
        Assert.assertNull((Object)iAssociationDescriptorArray[1].getExtension());
        Assert.assertNull((Object)iAssociationDescriptorArray[1].getImplementationClass());
        if (iAssociationDescriptorArray[0].getName().indexOf("First") >= 0) {
            Assert.assertNull((Object)iAssociationDescriptorArray[0].getId());
            Assert.assertEquals((String)"Description for: First One type association - Type1", (String)iAssociationDescriptorArray[0].getDescription());
            Assert.assertEquals((String)"First One type association - Type1", (String)iAssociationDescriptorArray[0].getName());
            Assert.assertEquals((String)"SOTA-Type1", (String)iAssociationDescriptorArray[1].getId());
            Assert.assertEquals((String)"Description for: Second One type association - Type1", (String)iAssociationDescriptorArray[1].getDescription());
            Assert.assertEquals((String)"Second One type association - Type1", (String)iAssociationDescriptorArray[1].getName());
        } else {
            Assert.assertNull((Object)iAssociationDescriptorArray[1].getId());
            Assert.assertEquals((String)"Description for: First One type association - Type1", (String)iAssociationDescriptorArray[1].getDescription());
            Assert.assertEquals((String)"First One type association - Type1", (String)iAssociationDescriptorArray[1].getName());
            Assert.assertEquals((String)"SOTA-Type1", (String)iAssociationDescriptorArray[0].getId());
            Assert.assertEquals((String)"Description for: Second One type association - Type1", (String)iAssociationDescriptorArray[0].getDescription());
            Assert.assertEquals((String)"Second One type association - Type1", (String)iAssociationDescriptorArray[0].getName());
        }
        iAssociationDescriptorArray = iAssociationMapping.getAssociationDescriptors("type2");
        Assert.assertTrue((boolean)iAssociationDescriptorArray[0].applyTo("type2"));
        Assert.assertFalse((boolean)iAssociationDescriptorArray[0].applyToAllTypes());
        Assert.assertNull((Object)iAssociationDescriptorArray[0].getImage());
        Assert.assertNull((Object)iAssociationDescriptorArray[0].getImageDescriptor());
        Assert.assertNull((Object)iAssociationDescriptorArray[0].getExtension());
        Assert.assertNull((Object)iAssociationDescriptorArray[0].getId());
        Assert.assertNull((Object)iAssociationDescriptorArray[0].getImplementationClass());
        Assert.assertEquals((String)"Description for: Third One type association - Type2", (String)iAssociationDescriptorArray[0].getDescription());
        Assert.assertEquals((String)"Third One type association - Type2", (String)iAssociationDescriptorArray[0].getName());
        iAssociationDescriptorArray = iAssociationMapping.getAssociationDescriptors("type");
        Assert.assertTrue((boolean)iAssociationDescriptorArray[0].applyTo("type"));
        Assert.assertFalse((boolean)iAssociationDescriptorArray[0].applyToAllTypes());
        Assert.assertNull((Object)iAssociationDescriptorArray[0].getImage());
        Assert.assertNull((Object)iAssociationDescriptorArray[0].getImageDescriptor());
        Assert.assertNull((Object)iAssociationDescriptorArray[0].getImplementationClass());
        Assert.assertEquals((String)"extension", (String)iAssociationDescriptorArray[0].getExtension());
        Assert.assertEquals((String)"id", (String)iAssociationDescriptorArray[0].getId());
        Assert.assertEquals((String)"description", (String)iAssociationDescriptorArray[0].getDescription());
        Assert.assertEquals((String)"name", (String)iAssociationDescriptorArray[0].getName());
    }

    public void testOneTypeAssociation_Manipulation() {
        IAssociationMappingRegistry iAssociationMappingRegistry = HyadesUI.createAssociationMappingRegistry();
        iAssociationMappingRegistry.initialize("category1", null, null);
        IAssociationMapping iAssociationMapping = iAssociationMappingRegistry.retrieveAssociationMapping(EP_ONE_TYPE_ASSOCIATION, PLUGIN_ID);
        Assert.assertEquals((int)0, (int)iAssociationMapping.getAssociationDescriptors().length);
        IAssociationDescriptor iAssociationDescriptor = iAssociationMapping.createAssociationDescriptor();
        Assert.assertEquals((int)5, (int)iAssociationMapping.associationDescriptors().length);
        Assert.assertEquals((int)3, (int)iAssociationMapping.getAssociationDescriptors("type1").length);
        Assert.assertEquals((int)2, (int)iAssociationMapping.getAssociationDescriptors("type2").length);
        Assert.assertEquals((int)2, (int)iAssociationMapping.getAssociationDescriptors("type").length);
        Assert.assertEquals((int)1, (int)iAssociationMapping.getAssociationDescriptors().length);
        IAssociationDescriptor[] iAssociationDescriptorArray = iAssociationMapping.getAssociationDescriptors("type1");
        IAssociationDescriptor iAssociationDescriptor2 = null;
        iAssociationDescriptor2 = iAssociationDescriptorArray[0].applyToAllTypes() ? iAssociationDescriptorArray[1] : iAssociationDescriptorArray[0];
        iAssociationDescriptor2.removeType("type1");
        Assert.assertEquals((int)5, (int)iAssociationMapping.associationDescriptors().length);
        Assert.assertEquals((int)3, (int)iAssociationMapping.getAssociationDescriptors("type1").length);
        Assert.assertEquals((int)3, (int)iAssociationMapping.getAssociationDescriptors("type2").length);
        Assert.assertEquals((int)3, (int)iAssociationMapping.getAssociationDescriptors("type").length);
        Assert.assertEquals((int)2, (int)iAssociationMapping.getAssociationDescriptors().length);
        iAssociationDescriptor.addType("type");
        Assert.assertEquals((int)5, (int)iAssociationMapping.associationDescriptors().length);
        Assert.assertEquals((int)2, (int)iAssociationMapping.getAssociationDescriptors("type1").length);
        Assert.assertEquals((int)2, (int)iAssociationMapping.getAssociationDescriptors("type2").length);
        Assert.assertEquals((int)3, (int)iAssociationMapping.getAssociationDescriptors("type").length);
        Assert.assertEquals((int)1, (int)iAssociationMapping.getAssociationDescriptors().length);
        iAssociationDescriptor.addType("type2");
        Assert.assertEquals((int)5, (int)iAssociationMapping.associationDescriptors().length);
        Assert.assertEquals((int)2, (int)iAssociationMapping.getAssociationDescriptors("type1").length);
        Assert.assertEquals((int)3, (int)iAssociationMapping.getAssociationDescriptors("type2").length);
        Assert.assertEquals((int)3, (int)iAssociationMapping.getAssociationDescriptors("type").length);
        Assert.assertEquals((int)1, (int)iAssociationMapping.getAssociationDescriptors().length);
        iAssociationDescriptor.removeType("type1");
        Assert.assertEquals((int)5, (int)iAssociationMapping.associationDescriptors().length);
        Assert.assertEquals((int)2, (int)iAssociationMapping.getAssociationDescriptors("type1").length);
        Assert.assertEquals((int)3, (int)iAssociationMapping.getAssociationDescriptors("type2").length);
        Assert.assertEquals((int)3, (int)iAssociationMapping.getAssociationDescriptors("type").length);
        Assert.assertEquals((int)1, (int)iAssociationMapping.getAssociationDescriptors().length);
    }

    public void testOneTypeAssociation_Default() {
        IAssociationMappingRegistry iAssociationMappingRegistry = HyadesUI.createAssociationMappingRegistry();
        iAssociationMappingRegistry.initialize("category1", null, null);
        IAssociationMapping iAssociationMapping = iAssociationMappingRegistry.retrieveAssociationMapping("fake", PLUGIN_ID);
        IAssociationMapping iAssociationMapping2 = iAssociationMappingRegistry.retrieveAssociationMapping(EP_ONE_TYPE_ASSOCIATION, PLUGIN_ID);
        Assert.assertEquals((int)0, (int)iAssociationMapping2.getAssociationDescriptors().length);
        IAssociationDescriptor iAssociationDescriptor = iAssociationMapping.createAssociationDescriptor();
        iAssociationDescriptor.setId("fake1");
        IllegalArgumentException illegalArgumentException = null;
        try {
            iAssociationMapping2.setDefaultAssociationDescriptor("category1", iAssociationDescriptor);
        }
        catch (IllegalArgumentException illegalArgumentException2) {
            illegalArgumentException = illegalArgumentException2;
        }
        Assert.assertNotNull((Object)illegalArgumentException);
        Assert.assertTrue((boolean)(illegalArgumentException instanceof IllegalArgumentException));
        IAssociationDescriptor iAssociationDescriptor2 = iAssociationMapping2.getDefaultAssociationDescriptor("type1");
        Assert.assertNotNull((Object)iAssociationDescriptor2);
        Assert.assertTrue((boolean)iAssociationDescriptor2.applyTo("type1"));
        Assert.assertEquals((Object)iAssociationDescriptor2, (Object)iAssociationMapping2.getAssociationDescriptors("type1")[0]);
        Assert.assertEquals((int)0, (int)iAssociationMapping2.getAssociationDescriptors().length);
        IAssociationDescriptor iAssociationDescriptor3 = iAssociationMapping2.createAssociationDescriptor();
        Assert.assertEquals((int)1, (int)iAssociationMapping2.getAssociationDescriptors().length);
        Assert.assertEquals((Object)iAssociationDescriptor2, (Object)iAssociationMapping2.getAssociationDescriptors("type1")[0]);
        iAssociationMapping2.setDefaultAssociationDescriptor("type1", iAssociationDescriptor3);
        Assert.assertEquals((Object)iAssociationDescriptor3, (Object)iAssociationMapping2.getAssociationDescriptors("type1")[0]);
        Assert.assertEquals((Object)iAssociationDescriptor3, (Object)iAssociationMapping2.getDefaultAssociationDescriptor("type1"));
        iAssociationDescriptor3.addType("type5");
        Assert.assertEquals((int)0, (int)iAssociationMapping2.getAssociationDescriptors().length);
        Assert.assertTrue((boolean)iAssociationDescriptor3.applyTo("type5"));
        Assert.assertEquals((int)1, (int)iAssociationMapping2.getAssociationDescriptors("type5").length);
        Assert.assertEquals((Object)iAssociationDescriptor2, (Object)iAssociationMapping2.getAssociationDescriptors("type1")[0]);
        Assert.assertEquals((Object)iAssociationDescriptor3, (Object)iAssociationMapping2.getAssociationDescriptors("type5")[0]);
        Assert.assertEquals((Object)iAssociationDescriptor3, (Object)iAssociationMapping2.getDefaultAssociationDescriptor("type5"));
        Assert.assertEquals((int)1, (int)iAssociationMapping.associationDescriptors().length);
        Assert.assertEquals((int)1, (int)iAssociationMapping.getAssociationDescriptors("fakeType1").length);
        Assert.assertEquals((Object)iAssociationDescriptor, (Object)iAssociationMapping.associationDescriptors()[0]);
        Assert.assertEquals((Object)iAssociationDescriptor, (Object)iAssociationMapping.getAssociationDescriptors("fakeType1")[0]);
        Assert.assertEquals((Object)iAssociationDescriptor, (Object)iAssociationMapping.getDefaultAssociationDescriptor("fakeType1"));
        Assert.assertEquals((Object)iAssociationDescriptor, (Object)iAssociationMapping.getDefaultAssociationDescriptor("fakeType2"));
        IAssociationDescriptor iAssociationDescriptor4 = iAssociationMapping.createAssociationDescriptor();
        iAssociationDescriptor4.setId("fake2");
        Assert.assertEquals((int)2, (int)iAssociationMapping.associationDescriptors().length);
        Assert.assertEquals((int)2, (int)iAssociationMapping.getAssociationDescriptors("fakeType1").length);
        Assert.assertEquals((Object)iAssociationDescriptor, (Object)iAssociationMapping.getAssociationDescriptors("fakeType1")[0]);
        Assert.assertEquals((Object)iAssociationDescriptor, (Object)iAssociationMapping.getDefaultAssociationDescriptor("fakeType1"));
        iAssociationMapping.setDefaultAssociationDescriptor("fakeType1", iAssociationDescriptor4);
        Assert.assertEquals((Object)iAssociationDescriptor4, (Object)iAssociationMapping.getAssociationDescriptors("fakeType1")[0]);
        Assert.assertEquals((Object)iAssociationDescriptor4, (Object)iAssociationMapping.getDefaultAssociationDescriptor("fakeType1"));
    }

    public void testMultiTypeAssociation_Load() {
        IAssociationMappingRegistry iAssociationMappingRegistry = HyadesUI.createAssociationMappingRegistry();
        iAssociationMappingRegistry.initialize("category1", null, null);
        IAssociationMapping iAssociationMapping = iAssociationMappingRegistry.retrieveAssociationMapping(EP_MULTI_TYPE_ASSOCIATION, PLUGIN_ID);
        Assert.assertEquals((Object)iAssociationMappingRegistry, (Object)iAssociationMapping.getAssociationMappingRegistry());
        Assert.assertEquals((String)EP_MULTI_TYPE_ASSOCIATION, (String)iAssociationMapping.getExtensionPoint());
        Assert.assertEquals((int)2, (int)iAssociationMapping.getAssociationDescriptors("type1").length);
        Assert.assertEquals((int)3, (int)iAssociationMapping.getAssociationDescriptors("type2").length);
        Assert.assertEquals((int)1, (int)iAssociationMapping.getAssociationDescriptors("type3").length);
        Assert.assertEquals((int)4, (int)iAssociationMapping.associationDescriptors().length);
        Assert.assertEquals((int)1, (int)iAssociationMapping.getAssociationDescriptors("type").length);
        Assert.assertEquals((int)0, (int)iAssociationMapping.getAssociationDescriptors().length);
        Assert.assertNotNull((Object)iAssociationMapping.getDefaultAssociationDescriptor("type1"));
        Assert.assertNotNull((Object)iAssociationMapping.getDefaultAssociationDescriptor("type2"));
        Assert.assertNotNull((Object)iAssociationMapping.getDefaultAssociationDescriptor("type3"));
        Assert.assertNotNull((Object)iAssociationMapping.getDefaultAssociationDescriptor("type"));
        Assert.assertNull((Object)iAssociationMapping.getDefaultAssociationDescriptor());
        Assert.assertNull((Object)iAssociationMapping.getDefaultAssociationDescriptor("type4"));
        IAssociationDescriptor[] iAssociationDescriptorArray = iAssociationMapping.getAssociationDescriptors("type2");
        Assert.assertEquals((Object)iAssociationDescriptorArray[0], (Object)iAssociationMapping.getDefaultAssociationDescriptor("type2"));
        int n = 0;
        int n2 = iAssociationDescriptorArray.length;
        while (n < n2) {
            if (iAssociationDescriptorArray[n].getName().indexOf("First") >= 0) {
                Assert.assertTrue((boolean)iAssociationDescriptorArray[n].applyTo("type1"));
                Assert.assertTrue((boolean)iAssociationDescriptorArray[n].applyTo("type2"));
                Assert.assertEquals((String)"Description for: First One type association - Type1, Type2", (String)iAssociationDescriptorArray[n].getDescription());
            } else if (iAssociationDescriptorArray[n].getName().indexOf("Second") >= 0) {
                Assert.assertTrue((boolean)iAssociationDescriptorArray[n].applyTo("type1"));
                Assert.assertTrue((boolean)iAssociationDescriptorArray[n].applyTo("type2"));
                Assert.assertEquals((String)"SMTA-Type1,Type2", (String)iAssociationDescriptorArray[n].getId());
            } else if (iAssociationDescriptorArray[n].getName().indexOf("Third") >= 0) {
                Assert.assertTrue((boolean)iAssociationDescriptorArray[n].applyTo("type2"));
                Assert.assertTrue((boolean)iAssociationDescriptorArray[n].applyTo("type3"));
                Assert.assertEquals((String)"Description for: Third Multi type association - Type2,Type3", (String)iAssociationDescriptorArray[n].getDescription());
            }
            ++n;
        }
    }

    public void testMultiTypeAssociation_Manipulation() {
        IAssociationMappingRegistry iAssociationMappingRegistry = HyadesUI.createAssociationMappingRegistry();
        iAssociationMappingRegistry.initialize("category1", null, null);
        IAssociationMapping iAssociationMapping = iAssociationMappingRegistry.retrieveAssociationMapping(EP_MULTI_TYPE_ASSOCIATION, PLUGIN_ID);
        Assert.assertEquals((int)0, (int)iAssociationMapping.getAssociationDescriptors().length);
        IAssociationDescriptor iAssociationDescriptor = iAssociationMapping.createAssociationDescriptor();
        iAssociationDescriptor.setId("newDescriptor");
        Assert.assertEquals((int)5, (int)iAssociationMapping.associationDescriptors().length);
        Assert.assertEquals((int)3, (int)iAssociationMapping.getAssociationDescriptors("type1").length);
        Assert.assertEquals((int)4, (int)iAssociationMapping.getAssociationDescriptors("type2").length);
        Assert.assertEquals((int)2, (int)iAssociationMapping.getAssociationDescriptors("type3").length);
        Assert.assertEquals((int)2, (int)iAssociationMapping.getAssociationDescriptors("type").length);
        Assert.assertEquals((int)1, (int)iAssociationMapping.getAssociationDescriptors().length);
        IAssociationDescriptor iAssociationDescriptor2 = null;
        IAssociationDescriptor[] iAssociationDescriptorArray = iAssociationMapping.getAssociationDescriptors("type2");
        int n = 0;
        int n2 = iAssociationDescriptorArray.length;
        while (n < n2) {
            if (iAssociationDescriptorArray[n].getName().indexOf("Third") >= 0) {
                iAssociationDescriptor2 = iAssociationDescriptorArray[n];
                break;
            }
            ++n;
        }
        Assert.assertNotNull(iAssociationDescriptor2);
        Assert.assertFalse((boolean)iAssociationDescriptor2.applyToAllTypes());
        Assert.assertTrue((boolean)iAssociationDescriptor2.applyTo("type2"));
        Assert.assertTrue((boolean)iAssociationDescriptor2.applyTo("type3"));
        Assert.assertFalse((boolean)iAssociationDescriptor2.applyTo("type"));
        iAssociationDescriptor2.removeType("type2");
        Assert.assertFalse((boolean)iAssociationDescriptor2.applyToAllTypes());
        Assert.assertTrue((boolean)iAssociationDescriptor2.applyTo("type3"));
        Assert.assertFalse((boolean)iAssociationDescriptor2.applyTo("type2"));
        Assert.assertFalse((boolean)iAssociationDescriptor2.applyTo("type"));
        Assert.assertEquals((int)5, (int)iAssociationMapping.associationDescriptors().length);
        Assert.assertEquals((int)3, (int)iAssociationMapping.getAssociationDescriptors("type1").length);
        Assert.assertEquals((int)3, (int)iAssociationMapping.getAssociationDescriptors("type2").length);
        Assert.assertEquals((int)2, (int)iAssociationMapping.getAssociationDescriptors("type3").length);
        Assert.assertEquals((int)2, (int)iAssociationMapping.getAssociationDescriptors("type").length);
        Assert.assertEquals((int)1, (int)iAssociationMapping.getAssociationDescriptors().length);
        iAssociationDescriptor2.removeType("type3");
        Assert.assertTrue((boolean)iAssociationDescriptor2.applyToAllTypes());
        Assert.assertTrue((boolean)iAssociationDescriptor2.applyTo("type3"));
        Assert.assertTrue((boolean)iAssociationDescriptor2.applyTo("type2"));
        Assert.assertTrue((boolean)iAssociationDescriptor2.applyTo("type"));
        Assert.assertEquals((int)5, (int)iAssociationMapping.associationDescriptors().length);
        Assert.assertEquals((int)4, (int)iAssociationMapping.getAssociationDescriptors("type1").length);
        Assert.assertEquals((int)4, (int)iAssociationMapping.getAssociationDescriptors("type2").length);
        Assert.assertEquals((int)2, (int)iAssociationMapping.getAssociationDescriptors("type3").length);
        Assert.assertEquals((int)3, (int)iAssociationMapping.getAssociationDescriptors("type").length);
        Assert.assertEquals((int)2, (int)iAssociationMapping.getAssociationDescriptors().length);
        iAssociationDescriptor2.addType("type");
        Assert.assertFalse((boolean)iAssociationDescriptor2.applyToAllTypes());
        Assert.assertFalse((boolean)iAssociationDescriptor2.applyTo("type3"));
        Assert.assertFalse((boolean)iAssociationDescriptor2.applyTo("type2"));
        Assert.assertTrue((boolean)iAssociationDescriptor2.applyTo("type"));
        Assert.assertEquals((int)5, (int)iAssociationMapping.associationDescriptors().length);
        Assert.assertEquals((int)3, (int)iAssociationMapping.getAssociationDescriptors("type1").length);
        Assert.assertEquals((int)3, (int)iAssociationMapping.getAssociationDescriptors("type2").length);
        Assert.assertEquals((int)1, (int)iAssociationMapping.getAssociationDescriptors("type3").length);
        Assert.assertEquals((int)3, (int)iAssociationMapping.getAssociationDescriptors("type").length);
        Assert.assertEquals((int)1, (int)iAssociationMapping.getAssociationDescriptors().length);
    }

    public void testMultiTypeAssociation_Default() {
        IAssociationMappingRegistry iAssociationMappingRegistry = HyadesUI.createAssociationMappingRegistry();
        iAssociationMappingRegistry.initialize("category1", null, null);
        IAssociationMapping iAssociationMapping = iAssociationMappingRegistry.retrieveAssociationMapping(EP_MULTI_TYPE_ASSOCIATION, PLUGIN_ID);
        IAssociationDescriptor[] iAssociationDescriptorArray = iAssociationMapping.getAssociationDescriptors("type2");
        Assert.assertEquals((Object)iAssociationDescriptorArray[0], (Object)iAssociationMapping.getDefaultAssociationDescriptor("type2"));
        IAssociationDescriptor iAssociationDescriptor = iAssociationMapping.createAssociationDescriptor();
        Assert.assertTrue((boolean)iAssociationDescriptor.applyToAllTypes());
        Assert.assertTrue((boolean)iAssociationDescriptor.applyTo("type2"));
        Assert.assertEquals((Object)iAssociationDescriptorArray[0], (Object)iAssociationMapping.getDefaultAssociationDescriptor("type2"));
        Assert.assertEquals((Object)iAssociationDescriptorArray[0], (Object)iAssociationMapping.getAssociationDescriptors("type2")[0]);
        Assert.assertTrue((boolean)iAssociationMapping.setDefaultAssociationDescriptor("type2", iAssociationDescriptor));
        Assert.assertTrue((boolean)iAssociationDescriptor.applyToAllTypes());
        Assert.assertTrue((boolean)iAssociationDescriptor.applyTo("type2"));
        Assert.assertEquals((Object)iAssociationDescriptor, (Object)iAssociationMapping.getDefaultAssociationDescriptor("type2"));
        Assert.assertEquals((Object)iAssociationDescriptor, (Object)iAssociationMapping.getAssociationDescriptors("type2")[0]);
        iAssociationDescriptor.addType("type2");
        Assert.assertFalse((boolean)iAssociationDescriptor.applyToAllTypes());
        Assert.assertTrue((boolean)iAssociationDescriptor.applyTo("type2"));
        Assert.assertEquals((Object)iAssociationDescriptor, (Object)iAssociationMapping.getDefaultAssociationDescriptor("type2"));
        Assert.assertEquals((Object)iAssociationDescriptor, (Object)iAssociationMapping.getAssociationDescriptors("type2")[0]);
        iAssociationDescriptor.removeType("type2");
        Assert.assertTrue((boolean)iAssociationDescriptor.applyToAllTypes());
        Assert.assertTrue((boolean)iAssociationDescriptor.applyTo("type2"));
        Assert.assertEquals((Object)iAssociationMapping.getDefaultAssociationDescriptor("type2"), (Object)iAssociationMapping.getAssociationDescriptors("type2")[0]);
        iAssociationDescriptor.addType("type3");
        Assert.assertFalse((boolean)iAssociationDescriptor.applyToAllTypes());
        Assert.assertFalse((boolean)iAssociationDescriptor.applyTo("type2"));
        Assert.assertFalse((iAssociationDescriptor == iAssociationMapping.getDefaultAssociationDescriptor("type2") ? 1 : 0) != 0);
        Assert.assertFalse((iAssociationDescriptor == iAssociationMapping.getAssociationDescriptors("type2")[0] ? 1 : 0) != 0);
    }

    public void testUntypeAssociation_Load() {
        IAssociationMappingRegistry iAssociationMappingRegistry = HyadesUI.createAssociationMappingRegistry();
        iAssociationMappingRegistry.initialize("category1", null, null);
        IAssociationMapping iAssociationMapping = iAssociationMappingRegistry.retrieveAssociationMapping(EP_UNTYPE_ASSOCIATION, PLUGIN_ID);
        Assert.assertEquals((Object)iAssociationMappingRegistry, (Object)iAssociationMapping.getAssociationMappingRegistry());
        Assert.assertEquals((String)EP_UNTYPE_ASSOCIATION, (String)iAssociationMapping.getExtensionPoint());
        Assert.assertEquals((int)4, (int)iAssociationMapping.getAssociationDescriptors().length);
        Assert.assertEquals((int)4, (int)iAssociationMapping.getAssociationDescriptors("type1").length);
        Assert.assertEquals((int)4, (int)iAssociationMapping.associationDescriptors().length);
        Assert.assertNotNull((Object)iAssociationMapping.getDefaultAssociationDescriptor());
        Assert.assertNotNull((Object)iAssociationMapping.getDefaultAssociationDescriptor("type1"));
        IAssociationDescriptor[] iAssociationDescriptorArray = iAssociationMapping.getAssociationDescriptors();
        int n = 0;
        int n2 = iAssociationDescriptorArray.length;
        while (n < n2) {
            Assert.assertTrue((boolean)iAssociationDescriptorArray[n].applyToAllTypes());
            ++n;
        }
    }

    public void testUntypeAssociation_Manipulation() {
        IAssociationMappingRegistry iAssociationMappingRegistry = HyadesUI.createAssociationMappingRegistry();
        iAssociationMappingRegistry.initialize("category1", null, null);
        IAssociationMapping iAssociationMapping = iAssociationMappingRegistry.retrieveAssociationMapping(EP_UNTYPE_ASSOCIATION, PLUGIN_ID);
        Assert.assertEquals((int)4, (int)iAssociationMapping.associationDescriptors().length);
        Assert.assertEquals((int)4, (int)iAssociationMapping.getAssociationDescriptors().length);
        Assert.assertEquals((int)4, (int)iAssociationMapping.getAssociationDescriptors("type1").length);
        IAssociationDescriptor iAssociationDescriptor = iAssociationMapping.getAssociationDescriptors()[0];
        IAssociationDescriptor iAssociationDescriptor2 = iAssociationMapping.createAssociationDescriptor();
        iAssociationDescriptor2.setId("newDescriptor");
        Assert.assertEquals((int)5, (int)iAssociationMapping.associationDescriptors().length);
        Assert.assertEquals((int)5, (int)iAssociationMapping.getAssociationDescriptors().length);
        Assert.assertEquals((int)5, (int)iAssociationMapping.getAssociationDescriptors("type1").length);
        iAssociationDescriptor.removeType("type2");
        Assert.assertEquals((int)5, (int)iAssociationMapping.associationDescriptors().length);
        Assert.assertEquals((int)5, (int)iAssociationMapping.getAssociationDescriptors().length);
        Assert.assertEquals((int)5, (int)iAssociationMapping.getAssociationDescriptors("type1").length);
        iAssociationDescriptor.addType("type2");
        Assert.assertEquals((int)5, (int)iAssociationMapping.associationDescriptors().length);
        Assert.assertEquals((int)4, (int)iAssociationMapping.getAssociationDescriptors().length);
        Assert.assertEquals((int)4, (int)iAssociationMapping.getAssociationDescriptors("type1").length);
        Assert.assertEquals((int)5, (int)iAssociationMapping.getAssociationDescriptors("type2").length);
        iAssociationDescriptor.removeType("type2");
        iAssociationDescriptor.addType("type1");
        Assert.assertEquals((int)5, (int)iAssociationMapping.associationDescriptors().length);
        Assert.assertEquals((int)4, (int)iAssociationMapping.getAssociationDescriptors().length);
        Assert.assertEquals((int)5, (int)iAssociationMapping.getAssociationDescriptors("type1").length);
        Assert.assertEquals((int)4, (int)iAssociationMapping.getAssociationDescriptors("type2").length);
        iAssociationDescriptor.removeType("type1");
        Assert.assertEquals((int)5, (int)iAssociationMapping.associationDescriptors().length);
        Assert.assertEquals((int)5, (int)iAssociationMapping.getAssociationDescriptors().length);
        Assert.assertEquals((int)5, (int)iAssociationMapping.getAssociationDescriptors("type1").length);
        Assert.assertEquals((int)5, (int)iAssociationMapping.getAssociationDescriptors("type2").length);
    }

    public void testUntypeAssociation_Default() {
        IAssociationMappingRegistry iAssociationMappingRegistry = HyadesUI.createAssociationMappingRegistry();
        iAssociationMappingRegistry.initialize("category1", null, null);
        IAssociationMapping iAssociationMapping = iAssociationMappingRegistry.retrieveAssociationMapping(EP_UNTYPE_ASSOCIATION, PLUGIN_ID);
        IAssociationDescriptor[] iAssociationDescriptorArray = iAssociationMapping.getAssociationDescriptors();
        Assert.assertEquals((int)4, (int)iAssociationDescriptorArray.length);
        Assert.assertEquals((Object)iAssociationDescriptorArray[0], (Object)iAssociationMapping.getDefaultAssociationDescriptor());
        iAssociationMapping.setDefaultAssociationDescriptor(iAssociationDescriptorArray[2]);
        Assert.assertEquals((Object)iAssociationDescriptorArray[2], (Object)iAssociationMapping.getDefaultAssociationDescriptor());
        Assert.assertEquals((Object)iAssociationDescriptorArray[2], (Object)iAssociationMapping.getAssociationDescriptors()[0]);
        iAssociationMapping.getAssociationDescriptors()[0].addType("type");
        Assert.assertEquals((int)3, (int)iAssociationMapping.getAssociationDescriptors().length);
        Assert.assertEquals((int)4, (int)iAssociationMapping.associationDescriptors().length);
        Assert.assertEquals((Object)iAssociationDescriptorArray[0], (Object)iAssociationMapping.getDefaultAssociationDescriptor());
    }
}

