/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.editor.form.base;

import org.eclipse.hyades.test.ui.internal.editor.form.base.SelectableControl;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;

public class ToggleControl
extends SelectableControl {
    protected boolean selection;
    private Color decorationColor;
    private Color activeColor;
    protected Cursor activeCursor;
    protected boolean hover = false;
    private static final int marginWidth = 2;
    private static final int marginHeight = 2;
    private static final int WIDTH = 9;
    private static final int HEIGHT = 9;
    private static final int[] offPoints = new int[]{0, 2, 8, 2, 4, 6};
    private static final int[] onPoints = new int[]{2, -1, 2, 8, 6, 4};

    public ToggleControl(Composite composite, int n) {
        super(composite, n);
        this.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ToggleControl.this.selection = !ToggleControl.this.selection;
                ToggleControl.this.redraw();
            }
        });
        this.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseEnter(MouseEvent mouseEvent) {
                ToggleControl.this.hover = true;
                if (ToggleControl.this.activeCursor != null) {
                    ToggleControl.this.setCursor(ToggleControl.this.activeCursor);
                }
                ToggleControl.this.redraw();
            }

            public void mouseExit(MouseEvent mouseEvent) {
                ToggleControl.this.hover = false;
                if (ToggleControl.this.activeCursor != null) {
                    ToggleControl.this.setCursor(null);
                }
                ToggleControl.this.redraw();
            }
        });
        this.initAccessible();
    }

    void initAccessible() {
        this.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getHelp(AccessibleEvent accessibleEvent) {
                accessibleEvent.result = ToggleControl.this.getToolTipText();
            }
        });
        this.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getChildAtPoint(AccessibleControlEvent accessibleControlEvent) {
                Point point = ToggleControl.this.toControl(new Point(accessibleControlEvent.x, accessibleControlEvent.y));
                if (ToggleControl.this.getBounds().contains(point)) {
                    accessibleControlEvent.childID = -1;
                }
            }

            public void getLocation(AccessibleControlEvent accessibleControlEvent) {
                Rectangle rectangle = ToggleControl.this.getBounds();
                Point point = ToggleControl.this.toDisplay(new Point(rectangle.x, rectangle.y));
                accessibleControlEvent.x = point.x;
                accessibleControlEvent.y = point.y;
                accessibleControlEvent.width = rectangle.width;
                accessibleControlEvent.height = rectangle.height;
            }

            public void getChildCount(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.detail = 0;
            }

            public void getRole(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.detail = 35;
            }

            public void getState(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.detail = ToggleControl.this.getSelection() ? 512 : 1024;
            }

            public void getValue(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.result = ToggleControl.this.getSelection() ? "1" : "0";
            }
        });
    }

    public void setDecorationColor(Color color) {
        this.decorationColor = color;
    }

    public Color getDecorationColor() {
        return this.decorationColor;
    }

    public void setActiveDecorationColor(Color color) {
        this.activeColor = color;
    }

    public void setActiveCursor(Cursor cursor) {
        this.activeCursor = cursor;
    }

    public Color getActiveDecorationColor() {
        return this.activeColor;
    }

    public Point computeSize(int n, int n2, boolean bl) {
        int n3 = n != -1 ? n : 13;
        int n4 = n2 != -1 ? n2 : 13;
        return new Point(n3, n4);
    }

    protected void paint(GC gC) {
        if (this.hover && this.activeColor != null) {
            gC.setBackground(this.activeColor);
        } else if (this.decorationColor != null) {
            gC.setBackground(this.decorationColor);
        } else {
            gC.setBackground(this.getForeground());
        }
        Point point = this.getSize();
        int n = (point.x - 9) / 2;
        int n2 = (point.y - 9) / 2;
        int[] nArray = this.selection ? this.translate(onPoints, n, n2) : this.translate(offPoints, n, n2);
        gC.fillPolygon(nArray);
        gC.setBackground(this.getBackground());
    }

    private int[] translate(int[] nArray, int n, int n2) {
        int[] nArray2 = new int[nArray.length];
        int n3 = 0;
        while (n3 < nArray.length) {
            nArray2[n3] = nArray[n3] + n;
            n3 += 2;
        }
        int n4 = 1;
        while (n4 < nArray.length) {
            nArray2[n4] = nArray[n4] + n2;
            n4 += 2;
        }
        return nArray2;
    }

    public boolean getSelection() {
        return this.selection;
    }

    public void setSelection(boolean bl) {
        this.selection = bl;
    }
}

