/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.sample.svg.generator;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import org.eclipse.hyades.ui.sample.svg.generator.DataInputProcessingException;
import org.eclipse.hyades.ui.sample.svg.generator.GraphicDocumentProperties;
import org.eclipse.hyades.ui.sample.svg.generator.IGraphicDocumentDefaults;
import org.eclipse.hyades.ui.sample.svg.generator.IGraphicDocumentStyle;
import org.eclipse.hyades.ui.sample.svg.generator.IUserPreferencesConstants;
import org.w3c.dom.Document;

public class GraphicAttributes
implements IGraphicDocumentStyle,
IUserPreferencesConstants,
IGraphicDocumentDefaults,
Serializable {
    private String browserCookieName;
    private Document configDocument;
    private Document dataDocument;
    private String graphicType;
    private String resourcesFolder;
    private String graphicTitle;
    private String graphicTimestampPrefix;
    private boolean legendSuppressed = false;
    private String graphicLegendTitle;
    private String graphicFont = "Arial, sans-serif";
    private String graphicColorPaletteName = "ZZ1";
    private HashMap graphicColorPalette;
    private short graphicWidth = 0;
    private short graphicHeight = 0;
    Locale locale = Locale.getDefault();
    private boolean outlineSuppressed = false;
    private String preferencesPage;
    private String preferencesPageWidth;
    private String preferencesPageHeight;
    private String preferencesIconText;
    private boolean svgFormatOnly = true;
    private boolean timestampSuppressed = false;
    private boolean titlebarSuppressed = false;
    private String userPreferences;
    private boolean userPreferencesSuppressed = false;
    private String userPreferencesUpdateVariableName;
    private DecimalFormat numberFormatter = null;
    private DecimalFormat bigNumberFormatter = null;
    private NumberFormat percentFormatter = null;
    private DateFormat dateFormatter = null;

    public GraphicAttributes() {
        this.setGraphicWidth("365");
        this.setGraphicHeight("320");
        this.setFormatter();
    }

    public void setAttributesFrom(GraphicDocumentProperties graphicDocumentProperties) {
        this.configDocument = graphicDocumentProperties.getConfigDocument();
        this.dataDocument = graphicDocumentProperties.getDataDocument();
        this.setBrowserCookieName(graphicDocumentProperties.getBrowserCookieName());
        this.setResourcesFolder(graphicDocumentProperties.getResourcesFolder());
        this.setGraphicTitle(graphicDocumentProperties.getGraphicTitle());
        this.setGraphicTimestampPrefix(graphicDocumentProperties.getGraphicTimestampPrefix());
        this.setLegendSuppressed(graphicDocumentProperties.getLegendSuppressed());
        this.setGraphicLegendTitle(graphicDocumentProperties.getGraphicLegendTitle());
        this.setGraphicFont(graphicDocumentProperties.getGraphicFont());
        this.setPreferencesPage(graphicDocumentProperties.getPreferencesPage());
        this.setPreferencesPageWidth(graphicDocumentProperties.getPreferencesPageWidth());
        this.setPreferencesPageHeight(graphicDocumentProperties.getPreferencesPageHeight());
        this.setPreferencesIconText(graphicDocumentProperties.getPreferencesIconText());
        this.setSvgFormatOnly(graphicDocumentProperties.getSvgFormatOnly());
        this.setUserPreferences(graphicDocumentProperties.getUserPreferences());
        this.setUserPreferencesSuppressed(graphicDocumentProperties.getUserPreferencesSuppressed());
        this.setUserPreferencesUpdateVariableName(graphicDocumentProperties.getUserPreferencesUpdateVariableName());
        this.setTitlebarSuppressed(graphicDocumentProperties.getTitlebarSuppressed());
        this.setTimestampSuppressed(graphicDocumentProperties.getTimestampSuppressed());
        this.setOutlineSuppressed(graphicDocumentProperties.getOutlineSuppressed());
        this.setGraphicHeight(graphicDocumentProperties.getGraphicHeight());
        this.setGraphicWidth(graphicDocumentProperties.getGraphicWidth());
        this.setLocale(graphicDocumentProperties.getLocale());
        this.createGraphicColorPalettes(graphicDocumentProperties.getGraphicColorPalettes());
        this.setGraphicColorPaletteName(graphicDocumentProperties.getGraphicColorPaletteName());
    }

    public String getBrowserCookieName() {
        return this.browserCookieName;
    }

    public Document getConfigDocument() {
        return this.configDocument;
    }

    public Document getDataDocument() {
        return this.dataDocument;
    }

    public String getGraphicType() {
        return this.graphicType;
    }

    public short getGraphicHeight() {
        return this.graphicHeight;
    }

    public short getGraphicWidth() {
        return this.graphicWidth;
    }

    public String getGraphicFont() {
        return this.graphicFont;
    }

    public String getGraphicColorPaletteName() {
        return this.graphicColorPaletteName;
    }

    public HashMap getGraphicColorPalette() {
        return this.graphicColorPalette;
    }

    public String getGraphicTitle() {
        return this.graphicTitle;
    }

    public boolean isLegendSuppressed() {
        return this.legendSuppressed;
    }

    public String getGraphicTimestampPrefix() {
        return this.graphicTimestampPrefix;
    }

    public String getGraphicLegendTitle() {
        return this.graphicLegendTitle;
    }

    public boolean isOutlineSuppressed() {
        return this.outlineSuppressed;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getPreferencesPage() {
        return this.preferencesPage;
    }

    public String getPreferencesPageWidth() {
        return this.preferencesPageWidth;
    }

    public String getPreferencesPageHeight() {
        return this.preferencesPageHeight;
    }

    public String getPreferencesIconText() {
        return this.preferencesIconText;
    }

    public boolean getSvgFormatOnly() {
        return this.svgFormatOnly;
    }

    public boolean isTimestampSuppressed() {
        return this.timestampSuppressed;
    }

    public boolean isTitlebarSuppressed() {
        return this.titlebarSuppressed;
    }

    public boolean isUserPreferencesSuppressed() {
        return this.userPreferencesSuppressed;
    }

    public String getUserPreferencesUpdateVariableName() {
        return this.userPreferencesUpdateVariableName;
    }

    public String getUserPreferences() {
        return this.userPreferences;
    }

    public String getResourcesFolder() {
        return this.resourcesFolder;
    }

    public void setBrowserCookieName(String string) {
        if (string != null) {
            this.browserCookieName = string.trim();
        }
    }

    public void setConfigDocument(Document document) throws DataInputProcessingException {
        this.configDocument = document;
    }

    public void setDataDocument(Document document) throws DataInputProcessingException {
        this.dataDocument = document;
    }

    public void setGraphicHeight(String string) {
        try {
            this.graphicHeight = Short.parseShort(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setGraphicWidth(String string) {
        try {
            this.graphicWidth = Short.parseShort(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setGraphicTitle(String string) {
        if (string != null) {
            this.graphicTitle = string.trim();
        }
    }

    public void setLegendSuppressed(String string) {
        if (string != null) {
            this.legendSuppressed = Boolean.valueOf(string);
        }
    }

    public void setGraphicTimestampPrefix(String string) {
        if (string != null) {
            this.graphicTimestampPrefix = string.trim();
        }
    }

    public void setGraphicLegendTitle(String string) {
        if (string != null) {
            this.graphicLegendTitle = string.trim();
        }
    }

    public void setGraphicFont(String string) {
        if (string != null) {
            this.graphicFont = string + ", " + "Arial, sans-serif";
        }
    }

    public boolean setGraphicColorPaletteName(String string) {
        String string2;
        boolean bl = false;
        if (string != null && (bl = this.graphicColorPalette.containsKey(string2 = string.trim()))) {
            this.graphicColorPaletteName = string2;
        }
        return bl;
    }

    public void setOutlineSuppressed(String string) {
        if (string != null) {
            this.outlineSuppressed = Boolean.valueOf(string);
        }
    }

    private void setFormatter() {
        NumberFormat numberFormat = NumberFormat.getInstance(this.locale);
        if (numberFormat instanceof DecimalFormat) {
            this.numberFormatter = (DecimalFormat)numberFormat;
            this.numberFormatter.applyPattern("#,##0.##");
        }
        if ((numberFormat = NumberFormat.getInstance(this.locale)) instanceof DecimalFormat) {
            this.bigNumberFormatter = (DecimalFormat)numberFormat;
            this.bigNumberFormatter.applyPattern("0.##E0");
        }
        this.percentFormatter = NumberFormat.getPercentInstance(this.locale);
        this.dateFormatter = DateFormat.getDateTimeInstance(1, 1, this.locale);
    }

    public void setLocale(Locale locale) {
        this.locale = locale == null ? Locale.getDefault() : locale;
        this.setFormatter();
    }

    public void setPreferencesPage(String string) {
        if (string != null) {
            this.preferencesPage = string.trim();
        }
    }

    public void setPreferencesPageWidth(String string) {
        if (string != null) {
            this.preferencesPageWidth = string;
        }
    }

    public void setPreferencesPageHeight(String string) {
        if (string != null) {
            this.preferencesPageHeight = string;
        }
    }

    public void setPreferencesIconText(String string) {
        if (string != null) {
            this.preferencesIconText = string.trim();
        }
    }

    public void setResourcesFolder(String string) {
        if (string != null) {
            this.resourcesFolder = string.trim();
        }
    }

    public void setSvgFormatOnly(String string) {
        if (string != null) {
            this.svgFormatOnly = Boolean.valueOf(string);
        }
    }

    public void setTimestampSuppressed(String string) {
        if (string != null) {
            this.timestampSuppressed = Boolean.valueOf(string);
        }
    }

    public void setTitlebarSuppressed(String string) {
        if (string != null) {
            this.titlebarSuppressed = Boolean.valueOf(string);
        }
    }

    public void setUserPreferences(String string) {
        if (string != null) {
            this.userPreferences = string;
        }
    }

    public void setUserPreferencesSuppressed(String string) {
        if (string != null) {
            this.userPreferencesSuppressed = Boolean.valueOf(string);
        }
    }

    public void setUserPreferencesUpdateVariableName(String string) {
        if (string != null) {
            this.userPreferencesUpdateVariableName = string;
        }
    }

    private void createGraphicColorPalettes(HashMap hashMap) {
        this.graphicColorPalette = hashMap != null ? new HashMap(hashMap) : new HashMap();
        this.graphicColorPalette.put("ZZ1", IGraphicDocumentStyle.SEASIDE_PALETTE);
        this.graphicColorPalette.put("ZZ2", IGraphicDocumentStyle.SUMMER_PALETTE);
        this.graphicColorPalette.put("ZZ3", IGraphicDocumentStyle.EARTH_PALETTE);
        this.graphicColorPalette.put("ZZ4", IGraphicDocumentStyle.SPRING_PALETTE);
        this.graphicColorPalette.put("ZZ5", IGraphicDocumentStyle.HARVEST_PALETTE);
        this.graphicColorPalette.put("ZZ6", IGraphicDocumentStyle.PASTEL_PALETTE);
    }

    public String formatNumber(double d) {
        DecimalFormat decimalFormat = d > 100000.0 || d < -100000.0 ? this.bigNumberFormatter : this.numberFormatter;
        return decimalFormat.format(d);
    }

    public String formatPercentage(double d) {
        return this.percentFormatter.format(d);
    }

    public String formatDate(Date date) {
        return this.dateFormatter.format(date);
    }

    public static Date parseISO8601Date(String string) {
        if (string == null) {
            return null;
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        try {
            int n7 = string.length();
            if (n7 >= 4) {
                n = Integer.parseInt(string.substring(0, 4));
            }
            if (n7 >= 7) {
                n2 = Integer.parseInt(string.substring(5, 7)) - 1;
            }
            if (n7 >= 10) {
                n3 = Integer.parseInt(string.substring(8, 10));
            }
            if (n7 >= 13) {
                n4 = Integer.parseInt(string.substring(11, 13));
            }
            if (n7 >= 16) {
                n5 = Integer.parseInt(string.substring(14, 16));
            }
            if (n7 >= 19) {
                n6 = Integer.parseInt(string.substring(17, 19));
            }
            return new GregorianCalendar(n, n2, n3, n4, n5, n6).getTime();
        }
        catch (Exception exception) {
            return null;
        }
    }
}

