/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.sample.svg.generator;

import java.io.Serializable;
import java.util.Date;
import org.eclipse.hyades.ui.sample.svg.generator.DataInputProcessingException;
import org.eclipse.hyades.ui.sample.svg.generator.DataPoint;
import org.eclipse.hyades.ui.sample.svg.generator.DataRange;
import org.eclipse.hyades.ui.sample.svg.generator.DataSet;
import org.eclipse.hyades.ui.sample.svg.generator.GraphicAttributes;
import org.eclipse.hyades.ui.sample.svg.generator.GraphicDocumentProperties;
import org.eclipse.hyades.ui.sample.svg.generator.IDataInputProcessingExceptionCodes;
import org.eclipse.hyades.ui.sample.svg.generator.IGraphicDocumentStyle;
import org.eclipse.hyades.ui.sample.svg.generator.SVGXYChart;
import org.eclipse.hyades.ui.sample.svg.generator.SegmentMarker;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SVGStackBarChart
extends SVGXYChart
implements IGraphicDocumentStyle,
IDataInputProcessingExceptionCodes,
Serializable {
    public SVGStackBarChart() {
        this.graphicType = "stack";
    }

    public Document generateGraphicDocument(GraphicDocumentProperties graphicDocumentProperties) throws DataInputProcessingException {
        String[] stringArray;
        Object object;
        double d;
        double d2;
        double d3;
        GraphicAttributes graphicAttributes = this.createGraphicAttributes(graphicDocumentProperties);
        Document document = graphicAttributes.getDataDocument();
        String string = null;
        int n = 0;
        int n2 = 60;
        int n3 = n2 / 2;
        int n4 = 50;
        try {
            this.xAxis = this.dataRetriever.getDataRange(document, "S");
        }
        catch (DataInputProcessingException dataInputProcessingException) {
            dataInputProcessingException.setWidgetType(this.getGraphicType());
            throw dataInputProcessingException;
        }
        try {
            this.yAxis = this.dataRetriever.getDataRange(document, "W");
        }
        catch (DataInputProcessingException dataInputProcessingException) {
            dataInputProcessingException.setWidgetType(this.getGraphicType());
            throw dataInputProcessingException;
        }
        if (this.xAxis == null || this.yAxis == null) {
            throw new DataInputProcessingException("", 126, "dataRange", this.getGraphicType());
        }
        if (this.xAxis.getType() != 1 || this.yAxis.getType() != 0) {
            throw new DataInputProcessingException("", 129, "dataRange", this.getGraphicType());
        }
        this.xMarkers = this.xAxis.getSegmentMarkers();
        this.yMarkers = this.yAxis.getSegmentMarkers();
        if (this.yMarkers != null && this.yMarkers.length > 0) {
            string = this.yMarkers[this.yMarkers.length - 1].getValueString();
        }
        n = this.dataRetriever.getNumberOfDatasets(document);
        this.dataSets = new DataSet[n];
        int n5 = 0;
        while (n5 < n) {
            this.dataSets[n5] = this.dataRetriever.getDatasetWithPosition(document, Integer.toString(n5));
            ++n5;
        }
        this.legendFlyOverLabels = this.getLegendFlyOverLabels(this.dataSets);
        double d4 = this.getMaxLengthOfYmarker(this.yMarkers, graphicAttributes);
        if (d4 > (d3 = (double)(graphicAttributes.getGraphicWidth() / 4))) {
            d4 = d3;
        }
        if ((d2 = this.getMaxLengthOfLegendLabel(graphicAttributes, this.dataSets)) > (d = (double)(graphicAttributes.getGraphicWidth() / 3))) {
            d2 = d;
        }
        if (graphicAttributes.isLegendSuppressed()) {
            d2 = 0.0;
        }
        int n6 = (int)((double)graphicAttributes.getGraphicWidth() - (d2 + d4 + (double)n2));
        int n7 = this.getNumberOfAxisLabels(graphicAttributes, n6, this.xAxis);
        int n8 = (int)((double)graphicAttributes.getGraphicHeight() - (double)n4 * 2.5 - (double)(n7 * 10));
        Document document2 = this.createSvgDocument(document.getImplementation(), Short.toString(graphicAttributes.getGraphicWidth()), Short.toString(graphicAttributes.getGraphicHeight()));
        Element element = document2.getDocumentElement();
        this.registerEventHandler(element, "onload", "init(evt)");
        this.addDefinitions(document2, graphicAttributes, n);
        this.addJavaScriptFunctions(document2, graphicAttributes, n, n2, n4, n6, n8);
        if (!graphicAttributes.isOutlineSuppressed()) {
            this.addOutline(document2, graphicAttributes);
        }
        if (!graphicAttributes.isTimestampSuppressed()) {
            try {
                object = this.dataRetriever.getTimestamp(document);
                stringArray = GraphicAttributes.parseISO8601Date((String)object);
                this.addTimeStamp(document2, graphicAttributes, (String)(stringArray == null ? object : graphicAttributes.formatDate((Date)stringArray)));
            }
            catch (DataInputProcessingException dataInputProcessingException) {
                dataInputProcessingException.setWidgetType(this.graphicType);
                throw dataInputProcessingException;
            }
        }
        if (!graphicAttributes.isTitlebarSuppressed()) {
            this.addTitleBar(document2, graphicAttributes);
        } else {
            n4 = super.resetGridOffsetForCenter(graphicAttributes.getGraphicHeight(), n8, 3.0);
        }
        if (!graphicAttributes.isUserPreferencesSuppressed() && graphicAttributes.getSvgFormatOnly()) {
            this.addPreferenceIcon(document2, graphicAttributes);
        }
        n2 = n3 + (int)d4;
        this.evenlyDistributeSegmentMarkers(this.xAxis);
        this.addGrid(document2, element, n6, n8, n2, n4, this.xAxis, this.yAxis);
        this.addAxisLabels(document2, graphicAttributes, element, n6, n8, n2, n4, this.xAxis, this.yAxis);
        this.addTitles(document2, graphicAttributes, element, n6, n8, n2, n4, this.xAxis, this.yAxis, n7, string);
        object = document2.createElement("g");
        this.addDataSets(document2, graphicAttributes, element, n6, n8, n2, n4, this.xAxis, this.yAxis, this.dataSets);
        if (!graphicAttributes.isLegendSuppressed()) {
            try {
                stringArray = this.dataRetriever.getLegendLabels(document);
                this.addLegend(document2, graphicAttributes, (Element)object, stringArray, this.legendFlyOverLabels, (int)d4 + n6 + n3, n4);
            }
            catch (DataInputProcessingException dataInputProcessingException) {
                dataInputProcessingException.setWidgetType(this.graphicType);
                throw dataInputProcessingException;
            }
        }
        element.appendChild((Node)object);
        return document2;
    }

    private void addAllBarValues(Document document, GraphicAttributes graphicAttributes, Element element, int n, int n2, DataRange dataRange, DataRange dataRange2, double d, double[] dArray) {
        SegmentMarker[] segmentMarkerArray = dataRange.getSegmentMarkers();
        double d2 = dataRange2.getMaxValue();
        double d3 = dataRange2.getMinValue();
        int n3 = 0;
        while (n3 < segmentMarkerArray.length) {
            double d4 = dArray[n3];
            if (!(d4 < d3) && !(d4 > d2)) {
                double d5 = (double)n2 * (d2 - d4) / (d2 - d3);
                double d6 = segmentMarkerArray[n3].getPosition() * (double)n;
                String string = graphicAttributes.formatNumber(d4);
                double d7 = d4 >= 0.0 ? d5 - 5.0 : d5 + 12.0;
                this.addLabel(document, graphicAttributes, element, string, "dataValues, anchorAtMiddle", d6, d7, 0);
            }
            ++n3;
        }
    }

    private void addBarSet(Document document, GraphicAttributes graphicAttributes, Element element, Element element2, int n, double d, int n2, DataRange dataRange, DataRange dataRange2, double d2, double[] dArray, DataSet dataSet) throws DataInputProcessingException {
        SegmentMarker[] segmentMarkerArray = dataRange.getSegmentMarkers();
        double d3 = dataRange2.getMaxValue();
        double d4 = dataRange2.getMinValue();
        int n3 = 0;
        int n4 = 0;
        while (n4 < segmentMarkerArray.length) {
            DataPoint dataPoint = dataSet.findDataPoint(segmentMarkerArray[n4].getValue());
            if (dataPoint != null && dataPoint.getType() != 1) {
                double d5;
                double d6 = dataPoint.getValue2();
                double d7 = d6 + dArray[n4];
                double d8 = dArray[n4];
                dArray[n4] = d7;
                if (d8 < d4) {
                    d8 = d4;
                }
                if (d8 > d3) {
                    d8 = d3;
                }
                if (d7 < d4) {
                    d7 = d4;
                }
                if (d7 > d3) {
                    d7 = d3;
                }
                double d9 = (double)n2 * (d3 - d7) / (d3 - d4);
                double d10 = (double)n2 * (d3 - d8) / (d3 - d4);
                double d11 = segmentMarkerArray[n4].getPosition() * d - d2 / 2.0;
                double d12 = d9 < d10 ? d9 : d10;
                double d13 = d5 = d9 < d10 ? d10 - d9 : d9 - d10;
                if (!(d5 <= 0.0)) {
                    Element element3 = document.createElement("rect");
                    element3.setAttribute("x", Double.toString(d11));
                    element3.setAttribute("y", Double.toString(d12));
                    element3.setAttribute("width", Double.toString(d2));
                    element3.setAttribute("height", Double.toString(d5));
                    element.appendChild(element3);
                    String string = dataPoint.getDisplayLabel(graphicAttributes);
                    double d14 = d11 + d2 + 2.0;
                    double d15 = d12;
                    double d16 = 16.0 + (double)(string.length() - 1) * 6.0;
                    double d17 = 18.0;
                    this.addEachTextBox(document, graphicAttributes, element2, d14, d15, d16, d17, string, n, n3++);
                }
            }
            ++n4;
        }
    }

    private void addDataSets(Document document, GraphicAttributes graphicAttributes, Element element, int n, int n2, int n3, int n4, DataRange dataRange, DataRange dataRange2, DataSet[] dataSetArray) throws DataInputProcessingException {
        int n5 = dataRange.getSegmentMarkers().length;
        double d = n5 > 0 ? (double)(n / n5 / 2) : 0.0;
        double[] dArray = new double[n5];
        int n6 = 0;
        while (n6 < n5) {
            dArray[n6] = 0.0;
            ++n6;
        }
        Element element2 = document.createElement("g");
        String string = "dataValues anchorAtMiddle";
        element2.setAttribute("id", "exactValues");
        element2.setAttribute("transform", "translate(" + n3 + "," + n4 + ")");
        element2.setAttribute("visibility", "hidden");
        element2.setAttribute("onclick", "toggleVisibility(\"exactValues\")");
        element.appendChild(element2);
        int n7 = 0;
        while (n7 < dataSetArray.length) {
            Element element3 = document.createElement("g");
            element3.setAttribute("id", "dataColour" + n7);
            element3.setAttribute("class", "shape" + n7);
            element3.setAttribute("transform", "translate(" + n3 + "," + n4 + ")");
            element3.setAttribute("onclick", "toggleVisibility(\"exactValues\")");
            element.appendChild(element3);
            Element element4 = document.createElement("g");
            String string2 = "dataValues anchorAtMiddle";
            element4.setAttribute("id", "textbox" + n7);
            element2.appendChild(element4);
            this.addBarSet(document, graphicAttributes, element3, element4, n7, n, n2, dataRange, dataRange2, d, dArray, dataSetArray[n7]);
            ++n7;
        }
        this.addAllBarValues(document, graphicAttributes, element2, n, n2, dataRange, dataRange2, d, dArray);
    }

    private void addDefaultInternalStylesheet(Document document, GraphicAttributes graphicAttributes, Element element, int n) {
        StringBuffer stringBuffer = new StringBuffer(" .st1{fill-rule:nonzero;clip-rule:nonzero;stroke:#000000;stroke-miterlimit:4;} .outline{stroke-width:0.75pt; stroke:#666666; fill:#ffffff;} .keyline{stroke-width:0.75pt; stroke:#666666;} .graphTitle {font-weight:bold; font-style:normal; font-size:11pt; fill:#000000; stroke-width:0.75pt;} .labelsValues {font-weight:normal; font-style:normal; font-size:10pt; fill:#000000;} .dataValues {font-weight:normal; font-style:normal; font-size:8pt; fill:#000000;} .timeStamp {font-weight:normal; font-style:normal; font-size:8pt; fill:#000000; text-anchor:end; opacity:0.5} .legendTitle {font-weight:normal; font-style:normal; font-size:10pt; fill:#000000; text-anchor:start; opacity:0.6} .legendData {font-weight:normal; font-style:normal; font-size:9pt; text-anchor:start; fill:#000000;} .anchorAtEnd {text-anchor: end;} .anchorAtStart {text-anchor: start;} .anchorAtMiddle {text-anchor: middle;}");
        stringBuffer.append(" .grid{stroke-width:0.75pt; stroke:#000000;} .gridline{stroke-width:0.75pt; stroke:#cccccc;} .griddashline{stroke-width:0.75pt; stroke:#cccccc; stroke-dasharray:2; fill:none;} .axisLines{fill:none;} .axisTicks{fill:none;} .solidLine{fill:none;stroke:#CCCCCC;stroke-width:1;} .dashLine{fill:none;stroke:#CCCCCC;stroke-width:1;stroke-dasharray:2;} .catOutline{fill:none;} .catColor{fill:#003399;stroke:none;} .exactValuesBox{fill:#FFFFCC;stroke:#999999;stroke-width:1;} .xyTitleLabels {font-weight:normal; font-style:normal; font-size:10pt; fill:#000000; opacity:0.6}");
        String[] stringArray = (String[])graphicAttributes.getGraphicColorPalette().get(graphicAttributes.getGraphicColorPaletteName());
        int n2 = stringArray.length;
        boolean bl = !graphicAttributes.isLegendSuppressed();
        int n3 = 0;
        int n4 = 0;
        while (n3 < n) {
            n4 = (n3 + 1) % n2;
            n4 = n4 == 0 ? n2 - 1 : n4 - 1;
            stringBuffer.append(" .dataset" + n3 + "{stroke-width:0.75pt; stroke:" + stringArray[n4] + ";}");
            if (bl) {
                stringBuffer.append(" .shape" + n3 + "{stroke:none; fill:" + stringArray[n4] + ";}");
            }
            ++n3;
        }
        CDATASection cDATASection = document.createCDATASection(stringBuffer.toString());
        Element element2 = document.createElement("style");
        element2.setAttribute("id", "defaultStyleRules");
        element2.setAttribute("type", "text/css");
        element2.appendChild(cDATASection);
        element.appendChild(element2);
    }

    protected void addDefinitions(Document document, GraphicAttributes graphicAttributes, int n) {
        Element element = super.addDefinitions(document, graphicAttributes);
        this.addDefaultInternalStylesheet(document, graphicAttributes, element, n);
    }

    private void addExactValue(Document document, GraphicAttributes graphicAttributes, Element element, double d, double d2, String string) {
        this.addLabel(document, graphicAttributes, element, string, "dataValues, anchorAtMiddle", d, d2, 0);
    }

    private GraphicAttributes createGraphicAttributes(GraphicDocumentProperties graphicDocumentProperties) throws DataInputProcessingException {
        GraphicAttributes graphicAttributes = new GraphicAttributes();
        graphicAttributes.setGraphicWidth("450");
        graphicAttributes.setPreferencesPage("prefs_stackedbar.htm");
        graphicAttributes.setPreferencesPageWidth("430");
        graphicAttributes.setPreferencesPageHeight("435");
        graphicAttributes.setConfigDocument(graphicDocumentProperties.getConfigDocument());
        graphicAttributes.setDataDocument(graphicDocumentProperties.getDataDocument());
        this.getConfigAttributes(graphicAttributes);
        graphicAttributes.setAttributesFrom(graphicDocumentProperties);
        return graphicAttributes;
    }
}

