/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.http.internal.junit.editor;

import org.eclipse.core.resources.IFile;
import org.eclipse.hyades.models.common.facades.behavioral.ITestCase;
import org.eclipse.hyades.test.common.junit.HyadesTestUtil;
import org.eclipse.hyades.test.http.TestHttpPlugin;
import org.eclipse.hyades.test.http.internal.junit.editor.HttpHeaderViewer;
import org.eclipse.hyades.test.http.internal.util.HttpConstants;
import org.eclipse.hyades.test.http.internal.util.RequestHelper;
import org.eclipse.hyades.test.ui.internal.editor.extension.IWriteAccessChangeListener;
import org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.util.DetailSection;
import org.eclipse.hyades.test.ui.internal.editor.form.util.WidgetFactory;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.hyades.ui.internal.util.UIUtil;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class HttpTestCaseDetailPage
extends DetailSection.DetailPage
implements ModifyListener,
IWriteAccessChangeListener {
    private CCombo methodCombo;
    private StyledText httpVersionText;
    private StyledText hostText;
    private StyledText portText;
    private StyledText absolutePathText;
    private StyledText bodyText;
    private HttpHeaderViewer headerViewer;
    private RequestHelper requestHelper = new RequestHelper();

    public void dispose() {
        this.getEditorForm().getBaseEditorExtension().removeListener((IWriteAccessChangeListener)this);
        this.requestHelper.dispose();
        this.headerViewer.dispose();
    }

    public Control createControl(Composite composite, FormWidgetFactory formWidgetFactory) {
        this.getEditorForm().getBaseEditorExtension().addListener((IWriteAccessChangeListener)this);
        WidgetFactory widgetFactory = this.getEditorForm().getWidgetFactory();
        Composite composite2 = widgetFactory.createComposite(composite);
        composite2.setLayout((Layout)new GridLayout());
        widgetFactory.createLabel(composite2, TestHttpPlugin.getString("HTTP_Version_Label"));
        this.httpVersionText = widgetFactory.createStyledText(composite2, 65540);
        widgetFactory.createLabel(composite2, TestHttpPlugin.getString("RQ_METH_TEXT"));
        this.methodCombo = widgetFactory.createCCombo(composite2, 0x800000);
        this.methodCombo.setLayoutData((Object)GridDataUtil.createHorizontalFill());
        this.methodCombo.setItems(HttpConstants.SUPPORTED_REQUEST_METHODS);
        widgetFactory.createLabel(composite2, TestHttpPlugin.getString("HOST_TEXT"));
        this.hostText = widgetFactory.createStyledText(composite2, 65540);
        this.hostText.setLayoutData((Object)GridDataUtil.createHorizontalFill());
        widgetFactory.createLabel(composite2, TestHttpPlugin.getString("PORT_TEXT"));
        this.portText = widgetFactory.createStyledText(composite2, 65540);
        this.portText.setLayoutData((Object)GridDataUtil.createHorizontalFill());
        widgetFactory.createLabel(composite2, TestHttpPlugin.getString("ABS_PATH_TEXT"));
        this.absolutePathText = widgetFactory.createStyledText(composite2, 65540);
        this.absolutePathText.setLayoutData((Object)GridDataUtil.createHorizontalFill());
        widgetFactory.createLabel(composite2, TestHttpPlugin.getString("BODY_TEXT"));
        this.bodyText = widgetFactory.createStyledText(composite2, 66306);
        GridData gridData = GridDataUtil.createHorizontalFill();
        gridData.heightHint = 4 * this.hostText.getLineHeight();
        this.bodyText.setLayoutData((Object)gridData);
        this.headerViewer = new HttpHeaderViewer();
        this.headerViewer.createControl(composite2, widgetFactory);
        this.headerViewer.setReadOnly(this.isReadOnly());
        widgetFactory.paintBordersFor(composite2);
        return composite2;
    }

    public void setInput(Object object) {
        IStructuredSelection iStructuredSelection;
        this.requestHelper.dispose();
        this.methodCombo.removeModifyListener((ModifyListener)this);
        this.httpVersionText.removeVerifyKeyListener((VerifyKeyListener)this);
        this.httpVersionText.removeModifyListener((ModifyListener)this);
        this.hostText.removeVerifyKeyListener((VerifyKeyListener)this);
        this.hostText.removeModifyListener((ModifyListener)this);
        this.absolutePathText.removeVerifyKeyListener((VerifyKeyListener)this);
        this.absolutePathText.removeModifyListener((ModifyListener)this);
        this.bodyText.removeVerifyKeyListener((VerifyKeyListener)this);
        this.bodyText.removeModifyListener((ModifyListener)this);
        this.portText.removeVerifyKeyListener((VerifyKeyListener)this);
        this.portText.removeModifyListener((ModifyListener)this);
        this.httpVersionText.setText("");
        this.hostText.setText("");
        this.bodyText.setText("");
        this.portText.setText("");
        this.absolutePathText.setText("");
        this.methodCombo.setText("");
        if (object instanceof IStructuredSelection && (iStructuredSelection = (IStructuredSelection)object).size() == 1) {
            object = iStructuredSelection.getFirstElement();
        }
        if (object instanceof ITestCase) {
            this.methodCombo.setEnabled(!this.isReadOnly());
            this.httpVersionText.setEditable(false);
            this.hostText.setEditable(true);
            this.bodyText.setEditable(true);
            this.absolutePathText.setEditable(true);
            this.portText.setEditable(true);
            this.requestHelper.setTestCase((ITestCase)object);
            this.httpVersionText.setText("1.1");
            this.absolutePathText.setText(HyadesTestUtil.getNotNullString((Object)this.requestHelper.getAttribute(3)));
            this.bodyText.setText(HyadesTestUtil.getNotNullString((Object)this.requestHelper.getAttribute(4)));
            this.hostText.setText(HyadesTestUtil.getNotNullString((Object)this.requestHelper.getAttribute(1)));
            this.portText.setText(HyadesTestUtil.getNotNullString((Object)this.requestHelper.getAttribute(2)));
            this.methodCombo.setText(HyadesTestUtil.getNotNullString((Object)this.requestHelper.getAttribute(5)));
            this.headerViewer.setEnabled(true);
            this.headerViewer.setInput(this.requestHelper);
        } else {
            this.httpVersionText.setEditable(false);
            this.hostText.setEditable(false);
            this.bodyText.setEditable(false);
            this.absolutePathText.setEditable(false);
            this.methodCombo.setEnabled(false);
            this.portText.setEditable(false);
            this.headerViewer.setEnabled(false);
        }
        this.methodCombo.addModifyListener((ModifyListener)this);
        this.httpVersionText.addVerifyKeyListener((VerifyKeyListener)this);
        this.httpVersionText.addModifyListener((ModifyListener)this);
        this.hostText.addVerifyKeyListener((VerifyKeyListener)this);
        this.hostText.addModifyListener((ModifyListener)this);
        this.absolutePathText.addVerifyKeyListener((VerifyKeyListener)this);
        this.absolutePathText.addModifyListener((ModifyListener)this);
        this.bodyText.addVerifyKeyListener((VerifyKeyListener)this);
        this.bodyText.addModifyListener((ModifyListener)this);
        this.portText.addVerifyKeyListener((VerifyKeyListener)this);
        this.portText.addModifyListener((ModifyListener)this);
    }

    public Object getInput() {
        return this.requestHelper.getTestCase();
    }

    public void verifyKey(VerifyEvent verifyEvent) {
        super.verifyKey(verifyEvent);
        if (verifyEvent.widget == this.portText) {
            UIUtil.integerStyledTextVerifyKey((VerifyEvent)verifyEvent);
        }
    }

    public void modifyText(ModifyEvent modifyEvent) {
        if (modifyEvent.widget == this.absolutePathText) {
            this.requestHelper.setAttribute(3, this.absolutePathText.getText());
        } else if (modifyEvent.widget == this.bodyText) {
            this.requestHelper.setAttribute(4, this.bodyText.getText());
        } else if (modifyEvent.widget == this.hostText) {
            this.requestHelper.setAttribute(1, this.hostText.getText());
        } else if (modifyEvent.widget == this.portText) {
            this.requestHelper.setAttribute(2, this.portText.getText());
        } else if (modifyEvent.widget == this.methodCombo) {
            this.requestHelper.setAttribute(5, this.methodCombo.getText());
        }
        if (this.requestHelper.isDirty()) {
            this.getEditorForm().getBaseEditorExtension().markDirty();
        }
    }

    public void writeAccessChanged(IFile iFile, boolean bl) {
        this.methodCombo.setEnabled(!bl);
        this.headerViewer.setReadOnly(bl);
    }
}

