/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.model.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.hyades.test.ui.internal.model.ui.ChildrenSelectionAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;

public class RemoveChildrenAction
extends ChildrenSelectionAction {
    private boolean saveChanges;
    private boolean showErrorDialog;
    private boolean unloadNotSavedResource;

    public RemoveChildrenAction(boolean bl) {
        super(TestUIPlugin.getString("BTN_REMOVE"));
        this.saveChanges = bl;
        if (bl) {
            this.setText(TestUIPlugin.getString("LBL_DELETE"));
        }
        this.setToolTipText(this.getText());
        ISharedImages iSharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.setDisabledImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
        this.setImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_DELETE"));
        this.setHoverImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_DELETE_HOVER"));
    }

    protected boolean updateSelection(IStructuredSelection iStructuredSelection) {
        if (!super.updateSelection(iStructuredSelection)) {
            return false;
        }
        if (this.getStructuredViewer() == null || this.getChilren().size() != 1) {
            return true;
        }
        return this.getStructuredViewer().getInput() != this.getChilren().get(0);
    }

    public void setUnloadNotSavedResource(boolean bl) {
        this.unloadNotSavedResource = bl;
    }

    public boolean isUnloadNotSavedResource() {
        return this.unloadNotSavedResource;
    }

    public boolean isSaveChanges() {
        return this.saveChanges;
    }

    public void setShowErrorDialog(boolean bl) {
        this.showErrorDialog = bl;
    }

    public boolean isShowErrorDialog() {
        return this.showErrorDialog;
    }

    public void run() {
        this.setActionPerformed(false);
        Set set = this.breakFeatures(this.getStructuredSelection());
        if (set.isEmpty()) {
            return;
        }
        List list = this.saveResources(set);
        set.clear();
        if (list.isEmpty()) {
            return;
        }
        this.handleUnsavedResources(list);
        list.clear();
    }

    protected Set breakFeatures(IStructuredSelection iStructuredSelection) {
        HashSet<Resource> hashSet = new HashSet<Resource>();
        Iterator iterator = iStructuredSelection.iterator();
        while (iterator.hasNext()) {
            EObject eObject = (EObject)iterator.next();
            Resource[] resourceArray = EMFUtil.remove(eObject);
            if (resourceArray.length > 0) {
                this.setActionPerformed(true);
            }
            if (!this.isSaveChanges()) continue;
            hashSet.addAll(Arrays.asList(resourceArray));
        }
        this.adjustStructuredViewer();
        this.getChilren().clear();
        return hashSet;
    }

    protected void adjustStructuredViewer() {
    }

    protected List saveResources(Set set) {
        ArrayList<Resource> arrayList = new ArrayList<Resource>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Resource resource = (Resource)iterator.next();
            try {
                EMFUtil.save(resource);
            }
            catch (Exception exception) {
                TestUIPlugin.logError(exception);
                arrayList.add(resource);
            }
        }
        return arrayList;
    }

    protected void handleUnsavedResources(List list) {
        Resource resource;
        Object object;
        if (this.isShowErrorDialog()) {
            Object object2;
            object = new StringBuffer();
            resource = list.iterator();
            while (resource.hasNext()) {
                object2 = (Resource)resource.next();
                IFile iFile = EMFUtil.getWorkspaceFile(object2);
                if (iFile == null) continue;
                ((StringBuffer)object).append("\n").append(iFile.getFullPath().toString());
            }
            object2 = TestUIPlugin.getString("_ERROR_RESS_SAVE", ((StringBuffer)object).toString());
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)TestUIPlugin.getString("W_ERROR"), (String)object2);
        }
        if (this.isUnloadNotSavedResource()) {
            object = list.iterator();
            while (object.hasNext()) {
                resource = (Resource)object.next();
                resource.unload();
            }
        }
    }
}

