/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator.action;

import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.navigator.ExecutionNavigator;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.help.WorkbenchHelp;

class ExecutionFilterDialog
extends Dialog
implements Listener {
    private ExecutionNavigator executionExplorer;
    private Button okButton;
    private Button showRunningButton;
    private Button showFinishedButton;
    private IPreferenceStore store;

    public ExecutionFilterDialog(ExecutionNavigator executionNavigator) {
        super(executionNavigator.getSite().getShell());
        this.executionExplorer = executionNavigator;
        this.store = TestUIPlugin.getInstance().getPreferenceStore();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(TestUIPlugin.getString("EXEC_DLG_TITLE"));
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        this.createFilterOptions(composite2);
        this.setCurrentFilter();
        this.adjustOptions();
        WorkbenchHelp.setHelp((Control)composite2, (String)(TestUIPlugin.getID() + ".enav0005"));
        return composite2;
    }

    private Control createFilterOptions(Composite composite) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.horizontalSpacing = 10;
        gridLayout.verticalSpacing = 5;
        gridLayout.marginWidth = 10;
        gridLayout.marginHeight = 10;
        Group group = new Group(composite, 0);
        group.setText(TestUIPlugin.getString("EXEC_DLG_DESC"));
        group.setLayout((Layout)gridLayout);
        GridData gridData = GridDataUtil.createFill();
        gridData.widthHint = 300;
        group.setLayoutData((Object)gridData);
        this.showRunningButton = new Button((Composite)group, 32);
        this.showRunningButton.setText(TestUIPlugin.getString("EXEC_DLG_SHOW_RUN"));
        this.showRunningButton.addListener(13, (Listener)this);
        this.showFinishedButton = new Button((Composite)group, 32);
        this.showFinishedButton.setText(TestUIPlugin.getString("EXEC_DLG_SHOW_FINISHED"));
        this.showFinishedButton.addListener(13, (Listener)this);
        WorkbenchHelp.setHelp((Control)this.showRunningButton, (String)(TestUIPlugin.getID() + ".enav0006"));
        WorkbenchHelp.setHelp((Control)this.showFinishedButton, (String)(TestUIPlugin.getID() + ".enav0007"));
        return composite;
    }

    private void setCurrentFilter() {
        int n = this.store.getInt("execFilter");
        boolean bl = (n & 1) == 1;
        boolean bl2 = (n & 2) == 2;
        this.showRunningButton.setSelection(bl);
        this.showFinishedButton.setSelection(bl2);
    }

    protected int getShowRunningFinished() {
        int n = 0;
        if (this.showRunningButton.getSelection()) {
            n |= 1;
        }
        if (this.showFinishedButton.getSelection()) {
            n |= 2;
        }
        return n;
    }

    protected void okPressed() {
        int n = this.getShowRunningFinished();
        this.store.setValue("execFilter", n);
        this.executionExplorer.getTreeViewer().refresh();
        super.okPressed();
    }

    protected Button createButton(Composite composite, int n, String string, boolean bl) {
        Button button = super.createButton(composite, n, string, bl);
        if (n == 0) {
            this.okButton = button;
            this.okButton.setEnabled(false);
        }
        return button;
    }

    public void handleEvent(Event event) {
        if (event.type == 13) {
            this.adjustOptions();
        }
    }

    private boolean adjustOptions() {
        int n = this.getShowRunningFinished();
        if (this.okButton != null) {
            boolean bl = this.store.getInt("execFilter") != n;
            this.okButton.setEnabled(bl);
        }
        return false;
    }
}

