/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.wizard;

import java.io.InputStream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.wizard.ReportWizardPage;
import org.eclipse.hyades.ui.internal.util.UIUtil;
import org.eclipse.hyades.ui.internal.wizard.HyadesWizard;
import org.eclipse.hyades.ui.internal.wizard.LocationPage;
import org.eclipse.hyades.ui.report.IReportGenerator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;

public class ReportWizard
extends HyadesWizard {
    protected static final String SET_LAST_REPORT = "LAST_REPORT";
    protected static final String SET_LAST_SELECTION = "LAST_FOLDER_SELECTION";
    private ReportWizardPage reportPage;
    private LocationPage locationPage;

    public ReportWizard() {
        this.setWindowTitle(TestUIPlugin.getString("NEW_REPORT_TITLE"));
        IDialogSettings iDialogSettings = TestUIPlugin.getInstance().getDialogSettings();
        IDialogSettings iDialogSettings2 = iDialogSettings.getSection("ReportWizard");
        if (iDialogSettings2 == null) {
            iDialogSettings2 = iDialogSettings.addNewSection("ReportWizard");
        }
        this.setDialogSettings(iDialogSettings2);
    }

    protected void initPages() {
        this.reportPage = new ReportWizardPage("report", this.getSelection());
        this.reportPage.setTitle(TestUIPlugin.getString("WIZ_TST_REPP_PG_TTL"));
        this.reportPage.setDescription(TestUIPlugin.getString("WIZ_TST_REPP_PG_LOC_DSC"));
        this.locationPage = new LocationPage("location", this.adjustLocation());
        this.locationPage.setTitle(TestUIPlugin.getString("WIZ_TST_REP_PG_TTL"));
        this.locationPage.setDescription(TestUIPlugin.getString("WIZ_TST_REP_PG_LOC_DSC"));
        String string = this.getFileExtension();
        if (string != null) {
            this.locationPage.setFileExtension(string);
            this.locationPage.setFileName("*." + string);
        }
    }

    protected String getFileExtension() {
        return null;
    }

    protected IStructuredSelection adjustLocation() {
        IResource iResource;
        String string;
        IStructuredSelection iStructuredSelection = this.getSelection();
        if (this.getDialogSettings() != null && (string = this.getDialogSettings().get(SET_LAST_SELECTION)) != null && (iResource = ResourcesPlugin.getWorkspace().getRoot().findMember(string)) != null && iResource.exists()) {
            iStructuredSelection = new StructuredSelection((Object)iResource);
        }
        return iStructuredSelection;
    }

    public void addPages() {
        this.addPage((IWizardPage)this.reportPage);
        this.addPage((IWizardPage)this.locationPage);
    }

    public boolean performFinish() {
        IFile iFile = null;
        IPath iPath = this.locationPage.getContainerFullPath();
        IContainer iContainer = this.createContainer(iPath);
        String string = "report";
        IReportGenerator iReportGenerator = this.reportPage.getReportGenerator();
        try {
            if (iReportGenerator != null && iReportGenerator.getReportFileExtension((ISelection)this.getSelection()) != null) {
                string = iReportGenerator.getReportFileExtension((ISelection)this.getSelection());
            }
        }
        catch (Exception exception) {
            TestUIPlugin.logError(exception);
            String string2 = exception.getLocalizedMessage();
            if (string2 == null || string2.length() == 0) {
                string2 = exception.getMessage();
            }
            if (string2 == null || string2.length() == 0) {
                string2 = exception.getClass().getName();
            }
            MessageDialog.openError((Shell)this.getShell(), (String)TestUIPlugin.getString("W_ERROR"), (String)TestUIPlugin.getString("GENERATE_ERROR_", string2));
            return false;
        }
        iPath = new Path(this.locationPage.getFileName() + "." + string);
        iFile = iContainer.getFile(iPath);
        if (iFile == null) {
            return false;
        }
        if (iFile.exists() && !MessageDialog.openQuestion((Shell)this.getShell(), (String)TestUIPlugin.getString("W_QUESTION"), (String)TestUIPlugin.getString("FILE_EXISTS"))) {
            return false;
        }
        InputStream inputStream = null;
        try {
            if (iReportGenerator != null) {
                inputStream = iReportGenerator.generate(iFile, (ISelection)this.getSelection());
            }
        }
        catch (Exception exception) {
            TestUIPlugin.logError(exception);
            String string3 = exception.getLocalizedMessage();
            if (string3 == null || string3.length() == 0) {
                string3 = exception.getMessage();
            }
            if (string3 == null || string3.length() == 0) {
                string3 = exception.getClass().getName();
            }
            MessageDialog.openError((Shell)this.getShell(), (String)TestUIPlugin.getString("W_ERROR"), (String)TestUIPlugin.getString("GENERATE_ERROR_", string3));
            return false;
        }
        if (inputStream == null) {
            MessageDialog.openError((Shell)this.getShell(), (String)TestUIPlugin.getString("W_ERROR"), (String)TestUIPlugin.getString("REOPRT_NO_CONTENT_ERROR_"));
            return false;
        }
        try {
            if (iFile.exists()) {
                iFile.delete(true, true, null);
            }
            iFile.create(inputStream, true, null);
        }
        catch (CoreException coreException) {
            TestUIPlugin.logError(coreException);
            UIUtil.openSaveFileErrorDialog((Shell)this.getShell(), (String)iFile.getFullPath().toString(), (Throwable)coreException);
            return false;
        }
        IPreferenceStore iPreferenceStore = TestUIPlugin.getInstance().getPreferenceStore();
        iPreferenceStore.setValue("OpenReportEditor", this.reportPage.openEditor());
        if (this.reportPage.openEditor()) {
            UIUtil.openEditor((IFile)iFile, null, (boolean)false);
        }
        this.getDialogSettings().put(SET_LAST_REPORT, this.reportPage.getReportDescription().getName());
        this.getDialogSettings().put(SET_LAST_SELECTION, iContainer.getFullPath().toString());
        return true;
    }

    private IContainer createContainer(IPath iPath) {
        IFolder iFolder = null;
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        int n = iPath.segmentCount();
        int n2 = 0;
        while (n2 < n) {
            IFolder iFolder2;
            if (n2 == 0) {
                iFolder2 = iWorkspace.getRoot().getProject(iPath.uptoSegment(n2 + 1).toString());
                if (iFolder2 == null || !iFolder2.exists()) {
                    try {
                        iFolder2.create(null);
                    }
                    catch (Exception exception) {
                        TestUIPlugin.logError(exception);
                        exception.printStackTrace();
                    }
                }
                try {
                    iFolder2.open(null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                iFolder = iFolder2;
            } else {
                iFolder2 = iWorkspace.getRoot().getFolder(iPath.uptoSegment(n2 + 1));
                if (iFolder2 == null || !iFolder2.exists()) {
                    try {
                        iFolder2.create(false, true, null);
                    }
                    catch (Exception exception) {
                        TestUIPlugin.logError(exception);
                        exception.printStackTrace();
                    }
                }
                iFolder = iFolder2;
            }
            ++n2;
        }
        try {
            iFolder.getProject().refreshLocal(2, null);
        }
        catch (CoreException coreException) {
            TestUIPlugin.logError(coreException);
            coreException.printStackTrace();
        }
        return iFolder;
    }
}

