/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.wizard;

import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofileFactory;
import org.eclipse.hyades.models.common.testprofile.TPFBehavior;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.hyades.ui.internal.util.UIUtil;
import org.eclipse.hyades.ui.internal.wizard.HyadesNewWizard;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.PartInitException;

public class TestSuiteNewWizard
extends HyadesNewWizard {
    public TestSuiteNewWizard() {
        this.setWindowTitle(TestUIPlugin.getString("WIZ_TST_SUITE_TTL"));
        this.setDefaultPageImageDescriptor(TestUIImages.INSTANCE.getImageDescriptor("newtestsuite_wiz.gif"));
        IDialogSettings iDialogSettings = TestUIPlugin.getInstance().getDialogSettings();
        IDialogSettings iDialogSettings2 = iDialogSettings.getSection("TestSuiteNewWizard");
        if (iDialogSettings2 == null) {
            iDialogSettings2 = iDialogSettings.addNewSection("TestSuiteNewWizard");
        }
        this.setDialogSettings(iDialogSettings2);
    }

    protected String getType() {
        return "org.eclipse.hyades.testSuite.generic";
    }

    protected String getFileExtension() {
        return "testsuite";
    }

    public void addPages() {
        this.getLocationPage().setTitle(TestUIPlugin.getString("WIZ_TST_SUITE_GEN_PG_TTL"));
        this.getLocationPage().setDescription(TestUIPlugin.getString("WIZ_TST_SUITE_GEN_PG_LOC_DSC"));
        this.addPage((IWizardPage)this.getLocationPage());
        this.getAttributeWizardPage().setTitle(TestUIPlugin.getString("WIZ_TST_SUITE_GEN_PG_TTL"));
        this.getAttributeWizardPage().setDescription(TestUIPlugin.getString("WIZ_TST_SUITE_GEN_PG_ATT_DSC"));
        this.addPage((IWizardPage)this.getAttributeWizardPage());
    }

    protected boolean createObject(IFile iFile) throws Exception {
        Resource resource = this.createResource(iFile);
        resource.getContents().add(this.createEObject());
        EMFUtil.save(resource);
        return true;
    }

    protected EObject createEObject() {
        TPFTestSuite tPFTestSuite = Common_TestprofileFactory.eINSTANCE.createTPFTestSuite();
        tPFTestSuite.setType(this.getType());
        tPFTestSuite.setName(this.getAttributeWizardPage().getItemName());
        String string = this.getAttributeWizardPage().getItemDescription();
        if (string != null && string.trim().length() > 0) {
            tPFTestSuite.setDescription(string);
        }
        if (tPFTestSuite.getBehavior() == null) {
            TPFBehavior tPFBehavior = Common_TestprofileFactory.eINSTANCE.createTPFBehavior();
            tPFTestSuite.setBehavior(tPFBehavior);
        }
        return tPFTestSuite;
    }

    protected Resource createResource(IFile iFile) {
        URI uRI = URI.createPlatformResourceURI((String)iFile.getFullPath().toString());
        Resource.Factory factory = EMFUtil.getResourceFactory("testsuite");
        return factory.createResource(uRI);
    }

    protected void openEditor(IFile iFile) throws PartInitException {
        if (TestUIPlugin.getInstance().getPreferenceStore().getBoolean("openEditor")) {
            UIUtil.openEditor((IFile)iFile, (String)"org.eclipse.hyades.test.ui.editor.TestSuiteEditorPart", (boolean)false);
        }
    }
}

