/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.harness;

import java.net.UnknownHostException;
import java.util.HashMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.execution.core.ExecutionComponentStateChangeEvent;
import org.eclipse.hyades.execution.core.IDataProcessor;
import org.eclipse.hyades.execution.core.IExecutableObject;
import org.eclipse.hyades.execution.core.IExecutionComponent;
import org.eclipse.hyades.execution.core.IExecutionComponentFactory;
import org.eclipse.hyades.execution.core.IExecutionComponentStateChangeListener;
import org.eclipse.hyades.execution.core.IExecutionEnvironment;
import org.eclipse.hyades.execution.core.IExecutor;
import org.eclipse.hyades.execution.core.IRemoteHyadesComponent;
import org.eclipse.hyades.execution.core.ISession;
import org.eclipse.hyades.execution.core.UnknownDaemonException;
import org.eclipse.hyades.execution.harness.ExecutionHarnessPlugin;
import org.eclipse.hyades.execution.harness.IExecutableObjectAdapter;
import org.eclipse.hyades.execution.harness.IExecutionEnvironmentAdapter;
import org.eclipse.hyades.execution.harness.XMLExecutionDataProcessor;
import org.eclipse.hyades.execution.local.ExecutionComponentFactoryImpl;
import org.eclipse.hyades.execution.local.NodeImpl;
import org.eclipse.hyades.internal.execution.local.control.AgentControllerUnavailableException;
import org.eclipse.hyades.models.common.facades.behavioral.ITest;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.models.common.facades.behavioral.impl.HyadesFactory;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.models.hierarchy.util.StringUtil;

public class TestExecutionHarness {
    private Object agentLock = new Object();
    private boolean bAgentReady = false;
    private static HashMap testTypeMap = null;
    private static boolean bFactoryInitialized = false;

    protected void releaseAgentLock() {
        Object object = this.agentLock;
        synchronized (object) {
            this.bAgentReady = true;
            this.agentLock.notify();
        }
    }

    public void initializeRegisteredExecutionEnvironments(IExecutionComponentFactory iExecutionComponentFactory, boolean bl) throws ClassNotFoundException {
        if (!bl) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            IPluginRegistry iPluginRegistry = Platform.getPluginRegistry();
            IConfigurationElement[] iConfigurationElementArray = Platform.getPluginRegistry().getConfigurationElementsFor("org.eclipse.hyades.execution.harness.RegisteredExecutionComponentImpl");
            testTypeMap = new HashMap();
            int n = 0;
            while (n < iConfigurationElementArray.length) {
                object4 = iConfigurationElementArray[n].getAttribute("type");
                if (((String)object4).equalsIgnoreCase("ENVIRONMENT")) {
                    String string = iConfigurationElementArray[n].getAttribute("name");
                    iExecutionComponentFactory.addExecutionComponent(string, iConfigurationElementArray[n].getAttribute("implClass"));
                    iExecutionComponentFactory.addStub(string, iConfigurationElementArray[n].getAttribute("stubClass"));
                    iExecutionComponentFactory.addSkeleton(string, iConfigurationElementArray[n].getAttribute("skeletonClass"));
                    object3 = testTypeMap.get(object4);
                    if (object3 == null) {
                        object3 = new HashMap();
                        testTypeMap.put(object4, object3);
                    }
                    object2 = (HashMap)object3;
                    object = iConfigurationElementArray[n].getChildren("SupportedTestType");
                    int n2 = 0;
                    while (n2 < ((V)object).length) {
                        ((HashMap)object2).put(object[n2].getAttribute("name"), string);
                        ++n2;
                    }
                }
                ++n;
            }
            object4 = Platform.getPluginRegistry().getConfigurationElementsFor("org.eclipse.hyades.execution.harness.ExecutionEnvironmentAdapter");
            int n3 = 0;
            while (n3 < ((Object)object4).length) {
                object3 = object4[n3].getAttribute("class");
                object2 = "EXECUTION_ENVIRONMENT_ADAPTER";
                object = testTypeMap.get(object2);
                if (object == null) {
                    object = new HashMap();
                    testTypeMap.put(object2, object);
                }
                HashMap hashMap = (HashMap)object;
                IConfigurationElement[] iConfigurationElementArray2 = object4[n3].getChildren("SupportedTestType");
                int n4 = 0;
                while (n4 < iConfigurationElementArray2.length) {
                    hashMap.put(iConfigurationElementArray2[n4].getAttribute("name"), object3);
                    ++n4;
                }
                ++n3;
            }
        }
    }

    public void initializeRegisteredExecutionComponents(IExecutionComponentFactory iExecutionComponentFactory, boolean bl, boolean bl2) throws ClassNotFoundException {
        if (!bl) {
            int n;
            IConfigurationElement[] iConfigurationElementArray;
            Object object;
            Object object2;
            Object object3;
            Object object4;
            IPluginRegistry iPluginRegistry = Platform.getPluginRegistry();
            IConfigurationElement[] iConfigurationElementArray2 = Platform.getPluginRegistry().getConfigurationElementsFor("org.eclipse.hyades.execution.harness.RegisteredExecutionComponentImpl");
            testTypeMap = new HashMap();
            int n2 = 0;
            while (n2 < iConfigurationElementArray2.length) {
                object4 = iConfigurationElementArray2[n2].getAttribute("type");
                if (!bl2 || !((String)object4).equalsIgnoreCase("ENVIRONMENT")) {
                    String string = iConfigurationElementArray2[n2].getAttribute("name");
                    iExecutionComponentFactory.addExecutionComponent(string, iConfigurationElementArray2[n2].getAttribute("implClass"));
                    iExecutionComponentFactory.addStub(string, iConfigurationElementArray2[n2].getAttribute("stubClass"));
                    iExecutionComponentFactory.addSkeleton(string, iConfigurationElementArray2[n2].getAttribute("skeletonClass"));
                    object3 = testTypeMap.get(object4);
                    if (object3 == null) {
                        object3 = new HashMap();
                        testTypeMap.put(object4, object3);
                    }
                    object2 = (HashMap)object3;
                    object = iConfigurationElementArray2[n2].getChildren("SupportedTestType");
                    int n3 = 0;
                    while (n3 < ((V)object).length) {
                        ((HashMap)object2).put(object[n3].getAttribute("name"), string);
                        ++n3;
                    }
                }
                ++n2;
            }
            if (!bl2) {
                object4 = Platform.getPluginRegistry().getConfigurationElementsFor("org.eclipse.hyades.execution.harness.ExecutionEnvironmentAdapter");
                int n4 = 0;
                while (n4 < ((Object)object4).length) {
                    object3 = object4[n4].getAttribute("class");
                    object2 = "EXECUTION_ENVIRONMENT_ADAPTER";
                    object = testTypeMap.get(object2);
                    if (object == null) {
                        object = new HashMap();
                        testTypeMap.put(object2, object);
                    }
                    HashMap hashMap = (HashMap)object;
                    iConfigurationElementArray = object4[n4].getChildren("SupportedTestType");
                    n = 0;
                    while (n < iConfigurationElementArray.length) {
                        hashMap.put(iConfigurationElementArray[n].getAttribute("name"), object3);
                        ++n;
                    }
                    ++n4;
                }
            }
            object4 = Platform.getPluginRegistry().getConfigurationElementsFor("org.eclipse.hyades.execution.harness.ExecutableObjectAdapter");
            int n5 = 0;
            while (n5 < ((Object)object4).length) {
                object3 = object4[n5].getAttribute("class");
                object2 = "EXECUTABLE_OBJECT_ADAPTER";
                object = testTypeMap.get(object2);
                if (object == null) {
                    object = new HashMap();
                    testTypeMap.put(object2, object);
                }
                HashMap hashMap = (HashMap)object;
                iConfigurationElementArray = object4[n5].getChildren("SupportedTestType");
                n = 0;
                while (n < iConfigurationElementArray.length) {
                    hashMap.put(iConfigurationElementArray[n].getAttribute("name"), object3);
                    ++n;
                }
                ++n5;
            }
        }
    }

    public String getExecutionComponentForTestType(String string, String string2, boolean bl) throws ClassNotFoundException {
        HashMap hashMap;
        String string3;
        if (!bl && (string3 = testTypeMap.get(string)) != null && string3 instanceof HashMap && (string3 = (hashMap = (HashMap)((Object)string3)).get(string2)) != null && string3 instanceof String) {
            return string3;
        }
        string3 = ExecutionHarnessPlugin.getString("EXEC_NOT_FOUND_ERR_");
        string3 = StringUtil.change((String)string3, (String)"%1", (String)string);
        string3 = StringUtil.change((String)string3, (String)"%2", (String)string2);
        throw new ClassNotFoundException(string3);
    }

    public String launchTest(ITestSuite iTestSuite, ITest iTest, String string, String string2, String string3, String string4, boolean bl, boolean bl2) {
        ISession iSession;
        boolean bl3 = false;
        String string5 = "";
        string5 = iTest.getType();
        String string6 = string;
        try {
            NodeImpl nodeImpl = new NodeImpl(string6);
            iSession = nodeImpl.connect(string2, null);
        }
        catch (UnknownHostException unknownHostException) {
            return StringUtil.change((String)ExecutionHarnessPlugin.getString("TIMEOUT_NODE_ERROR_"), (String)"%1", (String)string6);
        }
        catch (AgentControllerUnavailableException agentControllerUnavailableException) {
            return StringUtil.change((String)ExecutionHarnessPlugin.getString("AGENT_UNAV_ERROR_"), (String)"%1", (String)string6);
        }
        catch (UnknownDaemonException unknownDaemonException) {
            return StringUtil.change((String)ExecutionHarnessPlugin.getString("AGENT_UNAV_ERROR_"), (String)"%1", (String)string6);
        }
        catch (Exception exception) {
            ExecutionHarnessPlugin.getDefault().logError(exception);
            return StringUtil.change((String)ExecutionHarnessPlugin.getString("RUN_FAILED_ERR_"), (String)"%1", (String)string6);
        }
        try {
            block26: {
                try {
                    String string7;
                    IExecutionComponentFactory iExecutionComponentFactory = ExecutionComponentFactoryImpl.getInstance((ISession)iSession);
                    if (!bFactoryInitialized) {
                        this.initializeRegisteredExecutionEnvironments(iExecutionComponentFactory, bl2);
                    }
                    String string8 = this.getExecutionComponentForTestType("ENVIRONMENT", string5, bl2);
                    IExecutionEnvironment iExecutionEnvironment = (IExecutionEnvironment)iExecutionComponentFactory.createExecutionComponentByType(string8);
                    iSession.addChild((IExecutionComponent)iExecutionEnvironment);
                    IExecutionEnvironmentAdapter iExecutionEnvironmentAdapter = null;
                    try {
                        string7 = this.getExecutionComponentForTestType("EXECUTION_ENVIRONMENT_ADAPTER", string5, bl2);
                        iExecutionEnvironmentAdapter = (IExecutionEnvironmentAdapter)Class.forName(string7).newInstance();
                    }
                    catch (Exception exception) {
                        ExecutionHarnessPlugin.getDefault().logError(exception);
                        String string9 = StringUtil.change((String)ExecutionHarnessPlugin.getString("EXEC_ENV_ERR_"), (String)"%1", (String)string5);
                        Object var30_30 = null;
                        iSession.release();
                        return string9;
                    }
                    if (iExecutionEnvironmentAdapter != null) {
                        iExecutionEnvironmentAdapter.setupExecutionEnvironment(iExecutionEnvironment, (TPFTestSuite)iTestSuite, (TPFTest)iTest);
                    }
                    if (!bFactoryInitialized) {
                        this.initializeRegisteredExecutionComponents(iExecutionComponentFactory, bl2, true);
                    }
                    string7 = this.getExecutionComponentForTestType("EXECUTOR", string5, bl2);
                    IExecutor iExecutor = (IExecutor)iExecutionComponentFactory.createExecutionComponentByType(string7);
                    iExecutionEnvironment.addChild((IExecutionComponent)iExecutor);
                    if (bl) {
                        // empty if block
                    }
                    String string10 = this.getExecutionComponentForTestType("AGENT", string5, bl2);
                    IRemoteHyadesComponent iRemoteHyadesComponent = (IRemoteHyadesComponent)iExecutionComponentFactory.createExecutionComponentByType(string10);
                    iExecutor.addChild((IExecutionComponent)iRemoteHyadesComponent);
                    iRemoteHyadesComponent.startMonitoring((IDataProcessor)new XMLExecutionDataProcessor(null, (TPFTestSuite)iTestSuite, string3, string4));
                    iRemoteHyadesComponent.addExecutionComponentStateChangeListener(new IExecutionComponentStateChangeListener(){

                        public void stateChanged(ExecutionComponentStateChangeEvent executionComponentStateChangeEvent) {
                            if (executionComponentStateChangeEvent.getState() == 2) {
                                TestExecutionHarness.this.releaseAgentLock();
                            }
                        }
                    });
                    String string11 = this.getExecutionComponentForTestType("EXECUTABLEOBJECT", string5, bl2);
                    IExecutableObject iExecutableObject = iExecutor.getCompatibleExecutableObject(string11);
                    if (iExecutableObject == null) break block26;
                    IExecutableObjectAdapter iExecutableObjectAdapter = null;
                    try {
                        String string12 = this.getExecutionComponentForTestType("EXECUTABLE_OBJECT_ADAPTER", string5, bl2);
                        iExecutableObjectAdapter = (IExecutableObjectAdapter)Class.forName(string12).newInstance();
                    }
                    catch (Exception exception) {
                        ExecutionHarnessPlugin.getDefault().logError(exception);
                        String string13 = StringUtil.change((String)ExecutionHarnessPlugin.getString("EXEC_ENV_ERR_"), (String)"%1", (String)string5);
                        Object var30_31 = null;
                        iSession.release();
                        return string13;
                    }
                    if (iExecutableObjectAdapter != null) {
                        iExecutableObjectAdapter.setupExecutableObject(iExecutableObject, (TPFTestSuite)iTestSuite, (TPFTest)iTest);
                    }
                    iExecutor.setExecutableObject(iExecutableObject);
                    int n = iExecutor.getState();
                    if (iRemoteHyadesComponent.getState() == 3) {
                        while (!this.bAgentReady) {
                            Object object = this.agentLock;
                            synchronized (object) {
                                try {
                                    this.agentLock.wait();
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                    iExecutor.launch();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    ExecutionHarnessPlugin.getDefault().logError(classNotFoundException);
                    String string14 = StringUtil.change((String)ExecutionHarnessPlugin.getString("CLASS_NOT_FOUND_ERR_"), (String)"%1", (String)classNotFoundException.getMessage());
                    Object var30_33 = null;
                    iSession.release();
                    return string14;
                }
                catch (Throwable throwable) {
                    ExecutionHarnessPlugin.getDefault().logError(throwable);
                    String string15 = throwable.getMessage();
                    Object var30_34 = null;
                    iSession.release();
                    return string15;
                }
            }
            Object var30_32 = null;
        }
        catch (Throwable throwable) {
            Object var30_35 = null;
            iSession.release();
            throw throwable;
        }
        iSession.release();
        return null;
    }

    public String launchTest(String string, String string2, String string3, String string4, String string5, String string6, boolean bl, boolean bl2) {
        Object object = null;
        ITestSuite iTestSuite = null;
        try {
            iTestSuite = HyadesFactory.INSTANCE.loadTestSuite(string);
        }
        catch (Exception exception) {
            ExecutionHarnessPlugin.getDefault().logError(exception);
            return StringUtil.change((String)ExecutionHarnessPlugin.getString("LOAD_SUITE_ERR_"), (String)"%1", (String)string);
        }
        object = string2 != null && string2.length() != 0 ? (ITest)HyadesFactory.INSTANCE.getObjectByID(iTestSuite, string2) : iTestSuite;
        return this.launchTest(iTestSuite, (ITest)object, string3, string4, string5, string6, bl, bl2);
    }
}

