/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.sample.svg.generator;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import org.eclipse.hyades.ui.sample.svg.generator.DataInputProcessingException;
import org.eclipse.hyades.ui.sample.svg.generator.DataPoint;
import org.eclipse.hyades.ui.sample.svg.generator.DataRange;
import org.eclipse.hyades.ui.sample.svg.generator.DataSet;
import org.eclipse.hyades.ui.sample.svg.generator.GraphicAttributes;
import org.eclipse.hyades.ui.sample.svg.generator.GraphicDocumentProperties;
import org.eclipse.hyades.ui.sample.svg.generator.IDataInputConstants;
import org.eclipse.hyades.ui.sample.svg.generator.IDataInputProcessingExceptionCodes;
import org.eclipse.hyades.ui.sample.svg.generator.IGraphicDocumentStyle;
import org.eclipse.hyades.ui.sample.svg.generator.MeterDataRetriever;
import org.eclipse.hyades.ui.sample.svg.generator.SVGDocumentGenerator;
import org.eclipse.hyades.ui.sample.svg.generator.SegmentMarker;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SVGMeter
extends SVGDocumentGenerator
implements IGraphicDocumentStyle,
IDataInputConstants,
IDataInputProcessingExceptionCodes,
Serializable {
    private final MeterDataRetriever dataRetriever;

    public SVGMeter() {
        this.graphicType = "meter";
        this.dataRetriever = new MeterDataRetriever();
    }

    public Document generateGraphicDocument(GraphicDocumentProperties graphicDocumentProperties) throws DataInputProcessingException {
        DataPoint[] dataPointArray;
        Object object;
        GraphicAttributes graphicAttributes = this.createGraphicAttributes(graphicDocumentProperties);
        Document document = graphicAttributes.getDataDocument();
        if (document == null) {
            int n = 114;
            String string = "";
            DataInputProcessingException dataInputProcessingException = new DataInputProcessingException(n, string);
            dataInputProcessingException.setWidgetType(this.graphicType);
            throw dataInputProcessingException;
        }
        DataRange dataRange = null;
        SegmentMarker[] segmentMarkerArray = null;
        DataSet dataSet = null;
        try {
            dataRange = this.dataRetriever.getDataRange(document, "");
        }
        catch (DataInputProcessingException dataInputProcessingException) {
            dataInputProcessingException.setWidgetType(this.graphicType);
            throw dataInputProcessingException;
        }
        if (dataRange == null) {
            throw new DataInputProcessingException("", 126, "dataRange", this.getGraphicType());
        }
        if (dataRange.getType() != 0) {
            throw new DataInputProcessingException("", 129, "dataRange", this.getGraphicType());
        }
        segmentMarkerArray = dataRange.getSegmentMarkers();
        dataSet = this.dataRetriever.getDatasetWithPosition(document, "0");
        Document document2 = this.createSvgDocument(document.getImplementation(), Short.toString(graphicAttributes.getGraphicWidth()), Short.toString(graphicAttributes.getGraphicHeight()));
        Element element = document2.getDocumentElement();
        this.registerEventHandler(element, "onload", "init(evt)");
        this.addDefinitions(document2, graphicAttributes);
        this.addJavaScriptFunctions(document2, graphicAttributes, 0, 0, 0, 0, 0);
        if (!graphicAttributes.isOutlineSuppressed()) {
            this.addOutline(document2, graphicAttributes);
        }
        if (!graphicAttributes.isTimestampSuppressed()) {
            try {
                object = this.dataRetriever.getTimestamp(document);
                dataPointArray = GraphicAttributes.parseISO8601Date((String)object);
                this.addTimeStamp(document2, graphicAttributes, (String)(dataPointArray == null ? object : graphicAttributes.formatDate((Date)dataPointArray)));
            }
            catch (DataInputProcessingException dataInputProcessingException) {
                dataInputProcessingException.setWidgetType(this.graphicType);
                throw dataInputProcessingException;
            }
        }
        if (!graphicAttributes.isTitlebarSuppressed()) {
            this.addTitleBar(document2, graphicAttributes);
        }
        if (!graphicAttributes.isUserPreferencesSuppressed() && graphicAttributes.getSvgFormatOnly()) {
            this.addPreferenceIcon(document2, graphicAttributes);
        }
        try {
            object = this.dataRetriever.getLabels(document);
            dataPointArray = dataSet.getDataPoints();
            DataPoint dataPoint = null;
            if (dataPointArray != null && dataPointArray.length > 0) {
                dataPoint = dataPointArray[0];
            }
            if (dataPoint.getType() != 1) {
                this.addDial(document2, graphicAttributes, (Hashtable)object, segmentMarkerArray, dataPoint);
            }
        }
        catch (DataInputProcessingException dataInputProcessingException) {
            dataInputProcessingException.setWidgetType(this.graphicType);
            throw dataInputProcessingException;
        }
        return document2;
    }

    private void addDefaultInternalStylesheet(Document document, Element element) {
        StringBuffer stringBuffer = new StringBuffer(" .st1{fill-rule:nonzero;clip-rule:nonzero;stroke:#000000;stroke-miterlimit:4;} .outline{stroke-width:0.75pt; stroke:#666666; fill:#ffffff;} .keyline{stroke-width:0.75pt; stroke:#666666;} .graphTitle {font-weight:bold; font-style:normal; font-size:11pt; fill:#000000; stroke-width:0.75pt;} .labelsValues {font-weight:normal; font-style:normal; font-size:10pt; fill:#000000;} .dataValues {font-weight:normal; font-style:normal; font-size:8pt; fill:#000000;} .timeStamp {font-weight:normal; font-style:normal; font-size:8pt; fill:#000000; text-anchor:end; opacity:0.5} .legendTitle {font-weight:normal; font-style:normal; font-size:10pt; fill:#000000; text-anchor:start; opacity:0.6} .legendData {font-weight:normal; font-style:normal; font-size:9pt; text-anchor:start; fill:#000000;} .anchorAtEnd {text-anchor: end;} .anchorAtStart {text-anchor: start;} .anchorAtMiddle {text-anchor: middle;}");
        stringBuffer.append(" ");
        stringBuffer.append(".minmaxRate {font-weight:normal; font-style:normal; font-size:8pt; fill:#000000;} .rateDef {font-weight:normal; font-style:normal; font-size:8pt; fill:#000000;opacity:0.5} .critDiv {font-weight:normal; font-style:normal; font-size:8pt; fill:#000000; opacity:0.5} .graphOutline{fill:none;} .ticks{fill:none;}  .speedometerBg{fill:#FFFFFF;} .innerRim{fill:#999999;} .outerRim{fill:#006666;} .needle{fill:#000000;stroke-width:1.5;stroke-linecap:round;} .outerCircle{fill:#000000;stroke:none;} .innerCircle{fill:#FFFFFF;stroke:none;} .center{fill-rule:nonzero;clip-rule:nonzero;stroke:#000000;stroke-miterlimit:4;} .safeRange{fill:#CCCCCC;stroke:none;} .semiCritical{fill:#FFFF99;stroke:none;} .critical{fill:#FF0000;stroke:none;} .actualRate{fill:#CCCCCC;stroke:#999999;} ");
        CDATASection cDATASection = document.createCDATASection(stringBuffer.toString());
        Element element2 = document.createElement("style");
        element2.setAttribute("id", "defaultStyleRules");
        element2.setAttribute("type", "text/css");
        element2.appendChild(cDATASection);
        element.appendChild(element2);
    }

    protected Element addDefinitions(Document document, GraphicAttributes graphicAttributes) {
        Element element = super.addDefinitions(document, graphicAttributes);
        this.addDefaultInternalStylesheet(document, element);
        Element element2 = document.createElement("g");
        element2.setAttribute("id", "tickline");
        Element element3 = document.createElement("polyline");
        element3.setAttribute("class", "grid");
        element3.setAttribute("points", "0 0 5 0");
        element2.appendChild(element3);
        element.appendChild(element2);
        return element;
    }

    private void addDial(Document document, GraphicAttributes graphicAttributes, Hashtable hashtable, SegmentMarker[] segmentMarkerArray, DataPoint dataPoint) throws DataInputProcessingException {
        double d;
        double d2;
        String string;
        String string2;
        String string3;
        ArrayList arrayList;
        double d3;
        double d4;
        String string4;
        Element element;
        Element element2 = document.getDocumentElement();
        short s = graphicAttributes.getGraphicWidth();
        short s2 = graphicAttributes.getGraphicHeight();
        double d5 = s / 2;
        double d6 = s2 / 2 + 5;
        short s3 = s2 >= s ? s : s2;
        Element element3 = document.createElement("circle");
        element3.setAttribute("class", "st1 outerRim");
        element3.setAttribute("cx", Double.toString(d5));
        element3.setAttribute("cy", Double.toString(d6));
        element3.setAttribute("r", Double.toString((double)s3 * 0.36));
        element2.appendChild(element3);
        element3 = document.createElement("circle");
        element3.setAttribute("class", "st1 innerRim");
        element3.setAttribute("cx", Double.toString(d5));
        element3.setAttribute("cy", Double.toString(d6));
        element3.setAttribute("r", Double.toString((double)s3 * 0.352));
        element2.appendChild(element3);
        element3 = document.createElement("circle");
        element3.setAttribute("class", "st1 speedometerBg");
        element3.setAttribute("cx", Double.toString(d5));
        element3.setAttribute("cy", Double.toString(d6));
        element3.setAttribute("r", Double.toString((double)s3 * 0.344));
        element3.setAttribute("fill", "#ffffff");
        element2.appendChild(element3);
        double d7 = (double)s3 * 0.262;
        double d8 = (double)s3 * 0.1;
        short s4 = 14;
        element3 = document.createElement("rect");
        element3.setAttribute("class", "st1 actualRate");
        element3.setAttribute("width", Double.toString(d7));
        element3.setAttribute("height", Short.toString(s4));
        element3.setAttribute("x", Double.toString(d5 - d7 / 2.0));
        element3.setAttribute("y", Double.toString(d6 + d8));
        element2.appendChild(element3);
        String string5 = (String)hashtable.get("actualRate");
        if (string5 != null) {
            element = document.createElement("g");
            element.setAttribute("id", "minmaxRate");
            element.setAttribute("class", "minmaxRate anchorAtMiddle");
            element2.appendChild(element);
            this.addLabel(document, graphicAttributes, element, string5, null, d5, d6 + d8 + (double)s4 - 3.0, 0);
        }
        if ((string4 = (String)hashtable.get("rateDefinition")) != null && !string4.equals("")) {
            element = document.createElement("g");
            element.setAttribute("id", "rateDefinition");
            element.setAttribute("class", "rateDef anchorAtMiddle");
            element2.appendChild(element);
            this.addLabel(document, graphicAttributes, element, string4, null, d5, d6 + 14.0, 0);
        }
        if (segmentMarkerArray.length < 2) {
            int n = 104;
            String string6 = "dataRange";
            DataInputProcessingException dataInputProcessingException = new DataInputProcessingException(n, string6);
            throw dataInputProcessingException;
        }
        if (segmentMarkerArray.length > 4) {
            int n = 103;
            String string7 = "dataRange";
            DataInputProcessingException dataInputProcessingException = new DataInputProcessingException(n, string7);
            throw dataInputProcessingException;
        }
        SegmentMarker segmentMarker = null;
        SegmentMarker segmentMarker2 = null;
        SegmentMarker segmentMarker3 = null;
        SegmentMarker segmentMarker4 = null;
        if (segmentMarkerArray.length == 4) {
            segmentMarker = segmentMarkerArray[0];
            segmentMarker3 = segmentMarkerArray[1];
            segmentMarker2 = segmentMarkerArray[2];
            segmentMarker4 = segmentMarkerArray[3];
        } else if (segmentMarkerArray.length == 3) {
            segmentMarker = segmentMarkerArray[0];
            segmentMarker3 = segmentMarkerArray[1];
            segmentMarker4 = segmentMarkerArray[2];
        } else {
            segmentMarker = segmentMarkerArray[0];
            segmentMarker4 = segmentMarkerArray[1];
        }
        double d9 = segmentMarker4.getValue() - segmentMarker.getValue();
        String string8 = this.getSegmentLabel(graphicAttributes, segmentMarker);
        String string9 = this.getSegmentLabel(graphicAttributes, segmentMarker3);
        String string10 = this.getSegmentLabel(graphicAttributes, segmentMarker2);
        String string11 = this.getSegmentLabel(graphicAttributes, segmentMarker4);
        double d10 = 0.0;
        double d11 = 0.0;
        double d12 = d9;
        double d13 = 0.01745329252;
        if (segmentMarker3 != null) {
            d10 = segmentMarker3.getValue() - segmentMarker.getValue();
            d11 = -segmentMarker3.getValue();
            if (segmentMarker2 != null) {
                d11 = segmentMarker2.getValue() - segmentMarker3.getValue();
                d12 = segmentMarker4.getValue() - segmentMarker2.getValue();
            }
        }
        double d14 = 0.0;
        double d15 = 0.0;
        double d16 = 0.0;
        if (d12 > 0.0) {
            d14 = d12 / d9 * 180.0 * d13;
        }
        if (d11 > 0.0) {
            d15 = d11 / d9 * 180.0 * d13;
        }
        if (d10 > 0.0) {
            d16 = d10 / d9 * 180.0 * d13;
        }
        double d17 = (double)s3 * 0.25;
        String string12 = "";
        String string13 = "translate(" + d5 + "," + d6 + ")";
        if (d14 > 0.0) {
            d4 = Math.cos(d14 - 1.0E-6) * d17;
            d3 = Math.sin(d14 - 1.0E-6) * d17;
            string12 = "M " + d17 + " 0 A " + d17 + " " + d17 + " 0 0 0 " + d4 + " -" + d3 + " L 0 0 Z";
            element3 = document.createElement("path");
            element3.setAttribute("class", "st1 safeRange");
            element3.setAttribute("transform", string13);
            element3.setAttribute("d", string12);
            element2.appendChild(element3);
        }
        if (d15 > 0.0) {
            d4 = Math.cos(d15) * d17;
            d3 = Math.sin(d15) * d17;
            string12 = "M " + d17 + " 0 A " + d17 + " " + d17 + " 0 0 0 " + d4 + " -" + d3 + " L 0 0 Z";
            element3 = document.createElement("path");
            element3.setAttribute("class", "st1 semiCritical");
            element3.setAttribute("transform", string13 + " rotate(-" + d14 / d13 + ")");
            element3.setAttribute("d", string12);
            element2.appendChild(element3);
        }
        if (d16 > 0.0) {
            d4 = Math.cos(d16) * d17;
            d3 = Math.sin(d16) * d17;
            string12 = "M " + d17 + " 0 A " + d17 + " " + d17 + " 0 0 0 " + d4 + " -" + d3 + " L 0 0 Z";
            element3 = document.createElement("path");
            element3.setAttribute("class", "st1 critical");
            element3.setAttribute("transform", string13 + " rotate(-" + (180.0 - d16 / d13) + ")");
            element3.setAttribute("d", string12);
            element2.appendChild(element3);
        }
        Element element4 = document.createElement("g");
        element4.setAttribute("id", "meterLabel");
        element2.appendChild(element4);
        d4 = d5 - d17 - 2.0;
        d3 = d6 + 2.0;
        this.addLabel(document, graphicAttributes, element4, string8, "minmaxRate anchorAtEnd", d4, d3, 0);
        d4 = d5 + d17 + 1.0;
        d3 = d6 + 2.0;
        this.addLabel(document, graphicAttributes, element4, string11, "minmaxRate anchorAtStart", d4, d3, 0);
        double d18 = segmentMarker4.getValue() - segmentMarker.getValue();
        if (segmentMarker3 != null) {
            arrayList = this.calculateMarkerPosition(segmentMarker3.getValue() - segmentMarker.getValue(), d18, d17);
            string3 = (String)arrayList.get(0);
            string2 = (String)arrayList.get(1);
            string = (String)arrayList.get(2);
            this.addTranslationLabel(document, element4, string3, string2, string9, string13, string);
        }
        if (segmentMarker2 != null) {
            arrayList = this.calculateMarkerPosition(segmentMarker2.getValue() - segmentMarker.getValue(), d18, d17);
            string3 = (String)arrayList.get(0);
            string2 = (String)arrayList.get(1);
            string = (String)arrayList.get(2);
            this.addTranslationLabel(document, element4, string3, string2, string10, string13, string);
        }
        double d19 = 9.0;
        string2 = "";
        int n = 0;
        while (n < 19) {
            d2 = d19 * Math.PI / 180.0;
            d = Math.cos(-1.0 * d2) * (d17 - 5.0);
            double d20 = Math.sin(-1.0 * d2) * (d17 - 5.0);
            string2 = "rotate(-" + d19 + "," + d + "," + d20 + ")";
            element3 = document.createElement("use");
            element3.setAttribute("xlink:href", "#tickline");
            element3.setAttribute("x", Double.toString(d));
            element3.setAttribute("y", Double.toString(d20));
            element3.setAttribute("transform", string13 + string2);
            element2.appendChild(element3);
            d19 += 9.0;
            ++n;
        }
        if (dataPoint != null && (d2 = dataPoint.getValue2()) >= segmentMarker.getValue() && d2 <= segmentMarker4.getValue()) {
            d = (d2 - segmentMarker.getValue()) / (segmentMarker4.getValue() - segmentMarker.getValue()) * 180.0 + 180.0;
            element3 = document.createElement("rect");
            element3.setAttribute("class", "st1 needle");
            element3.setAttribute("width", Double.toString(d17 - 6.0));
            element3.setAttribute("height", Double.toString(1.3));
            element3.setAttribute("x", Double.toString(d5));
            element3.setAttribute("y", Double.toString(d6));
            element3.setAttribute("transform", "rotate(" + d + "," + Double.toString(d5) + "," + Double.toString(d6) + ")");
            element2.appendChild(element3);
            element3 = document.createElement("circle");
            element3.setAttribute("class", "st1 outerCircle");
            element3.setAttribute("cx", Double.toString(d5));
            element3.setAttribute("cy", Double.toString(d6));
            element3.setAttribute("r", Double.toString(2.5));
            element2.appendChild(element3);
            element3 = document.createElement("circle");
            element3.setAttribute("class", "st1 innerCircle");
            element3.setAttribute("cx", Double.toString(d5));
            element3.setAttribute("cy", Double.toString(d6));
            element3.setAttribute("r", Double.toString(1.7));
            element2.appendChild(element3);
            element3 = document.createElement("circle");
            element3.setAttribute("class", "st1 center");
            element3.setAttribute("cx", Double.toString(d5));
            element3.setAttribute("cy", Double.toString(d6));
            element3.setAttribute("r", Double.toString(0.5));
            element2.appendChild(element3);
        }
    }

    private String getSegmentLabel(GraphicAttributes graphicAttributes, SegmentMarker segmentMarker) {
        if (segmentMarker != null) {
            String string = segmentMarker.getLabel();
            return string != null ? string : graphicAttributes.formatNumber(segmentMarker.getValue());
        }
        return "";
    }

    private void addTranslationLabel(Document document, Element element, String string, String string2, String string3, String string4, String string5) {
        Element element2 = document.createElement("text");
        element2.setAttribute("class", "critDiv " + string5);
        element2.setAttribute("x", string);
        element2.setAttribute("y", string2);
        element2.setAttribute("transform", string4);
        element2.appendChild(document.createTextNode(string3));
        element.appendChild(element2);
    }

    ArrayList calculateMarkerPosition(double d, double d2, double d3) {
        double d4 = (d2 - d) / d2 * 180.0;
        double d5 = d4 * Math.PI / 180.0;
        double d6 = Math.cos(-1.0 * d5) * (d3 + 3.0);
        double d7 = Math.sin(-1.0 * d5) * (d3 + 3.0);
        String string = "";
        if (d4 < 90.0) {
            string = "anchorAtStart";
        } else if (d4 == 90.0) {
            string = "anchorAtMiddle";
        } else if (d4 > 90.0) {
            string = "anchorAtEnd";
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(Double.toString(d6));
        arrayList.add(Double.toString(d7));
        arrayList.add(new String(string));
        return arrayList;
    }

    private void getConfigAttributes(GraphicAttributes graphicAttributes) throws DataInputProcessingException {
        Hashtable hashtable = this.dataRetriever.getConfigurationAttributes(graphicAttributes.getConfigDocument(), graphicAttributes.getDataDocument());
        if (hashtable == null) {
            return;
        }
        String string = (String)hashtable.get("width");
        String string2 = (String)hashtable.get("height");
        String string3 = (String)hashtable.get("title");
        String string4 = (String)hashtable.get("timestampPrefix");
        if (string != null) {
            graphicAttributes.setGraphicWidth(string);
        }
        if (string2 != null) {
            graphicAttributes.setGraphicHeight(string2);
        }
        if (string3 != null) {
            graphicAttributes.setGraphicTitle(string3);
        }
        if (string4 != null) {
            graphicAttributes.setGraphicTimestampPrefix(string4);
        }
    }

    private GraphicAttributes createGraphicAttributes(GraphicDocumentProperties graphicDocumentProperties) throws DataInputProcessingException {
        GraphicAttributes graphicAttributes = new GraphicAttributes();
        graphicAttributes.setGraphicWidth("325");
        graphicAttributes.setPreferencesPage("prefs_meter.htm");
        graphicAttributes.setPreferencesPageWidth("430");
        graphicAttributes.setPreferencesPageHeight("350");
        graphicAttributes.setConfigDocument(graphicDocumentProperties.getConfigDocument());
        graphicAttributes.setDataDocument(graphicDocumentProperties.getDataDocument());
        this.getConfigAttributes(graphicAttributes);
        graphicAttributes.setAttributesFrom(graphicDocumentProperties);
        return graphicAttributes;
    }
}

