/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.sample.svg.generator;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.hyades.ui.sample.svg.generator.DataInputProcessingException;
import org.eclipse.hyades.ui.sample.svg.generator.DataRange;
import org.eclipse.hyades.ui.sample.svg.generator.DataSet;
import org.eclipse.hyades.ui.sample.svg.generator.ECMAScriptGenerator;
import org.eclipse.hyades.ui.sample.svg.generator.GraphicAttributes;
import org.eclipse.hyades.ui.sample.svg.generator.IDataInputConstants;
import org.eclipse.hyades.ui.sample.svg.generator.SVGDocumentGenerator;
import org.eclipse.hyades.ui.sample.svg.generator.SegmentMarker;
import org.eclipse.hyades.ui.sample.svg.generator.XYChartDataRetriever;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class SVGXYChart
extends SVGDocumentGenerator
implements IDataInputConstants,
Serializable {
    protected final XYChartDataRetriever dataRetriever = new XYChartDataRetriever();
    protected final int axisLabelFontSize = 8;
    protected String[] legendFlyOverLabels = null;
    protected DataRange xAxis = null;
    protected DataRange yAxis = null;
    protected SegmentMarker[] xMarkers = null;
    protected SegmentMarker[] yMarkers = null;
    protected DataSet[] dataSets = null;

    SVGXYChart() {
    }

    protected void addJavaScriptFunctions(Document document, GraphicAttributes graphicAttributes, int n, int n2, int n3, int n4, int n5) {
        Element element = document.getDocumentElement();
        super.addJavaScriptFunctions(document, graphicAttributes, n, n2, n3, n4, n5);
        Element element2 = document.createElement("script");
        element2.setAttribute("type", "text/ecmascript");
        element.appendChild(element2);
        ECMAScriptGenerator eCMAScriptGenerator = new ECMAScriptGenerator();
        StringBuffer stringBuffer = new StringBuffer(eCMAScriptGenerator.generateXYChartHelperFunctions());
        CDATASection cDATASection = document.createCDATASection(stringBuffer.toString());
        element2.appendChild(cDATASection);
    }

    protected void addEachTextBox(Document document, GraphicAttributes graphicAttributes, Element element, double d, double d2, double d3, double d4, String string, int n, int n2) {
        String string2 = "dataValues anchorAtMiddle";
        Element element2 = document.createElement("rect");
        element2.setAttribute("x", Double.toString(d));
        element2.setAttribute("y", Double.toString(d2));
        element2.setAttribute("width", Double.toString(d3));
        element2.setAttribute("height", Double.toString(d4));
        element2.setAttribute("fill", "#FFFFCC");
        element2.setAttribute("stroke", "gray");
        element2.setAttribute("stroke-width", "1");
        element2.setAttribute("id", "textboxRect" + Integer.toString(n) + Integer.toString(n2));
        element.appendChild(element2);
        Element element3 = document.createElement("text");
        element3.setAttribute("id", "textboxText" + n + n2);
        element3.setAttribute("style", "text-anchor: middle");
        element3.setAttribute("class", string2);
        element3.appendChild(document.createTextNode(string));
        element.appendChild(element3);
    }

    private Element genNamedPolyLine(Document document, String string, String string2) {
        Element element = document.createElement("polyline");
        element.setAttribute("class", string);
        element.setAttribute("fill", "none");
        element.setAttribute("points", string2);
        return element;
    }

    private Element genNamedPolyLineGroup(Document document, String string, String string2, String string3) {
        Element element = document.createElement("g");
        element.setAttribute("id", string);
        element.appendChild(this.genNamedPolyLine(document, string2, string3));
        return element;
    }

    private Element gen2NamedPolyLineGroup(Document document, String string, String string2, String string3, String string4, String string5) {
        Element element = document.createElement("g");
        element.setAttribute("id", string);
        element.appendChild(this.genNamedPolyLine(document, string2, string3));
        element.appendChild(this.genNamedPolyLine(document, string4, string5));
        return element;
    }

    private Element genUseWithOffsets(Document document, String string, double d, double d2) {
        Element element = document.createElement("use");
        element.setAttribute("xlink:href", "#" + string);
        element.setAttribute("x", Double.toString(d));
        element.setAttribute("y", Double.toString(d2));
        return element;
    }

    protected void addGrid(Document document, Element element, int n, int n2, int n3, int n4, DataRange dataRange, DataRange dataRange2) {
        Object object;
        Element element2 = document.createElement("defs");
        element.appendChild(element2);
        element2.appendChild(this.genNamedPolyLineGroup(document, "solidgridline", "gridline", "0 0 " + n + " 0"));
        element2.appendChild(this.genNamedPolyLineGroup(document, "dashgridline", "griddashline", "0 0 " + n + " 0"));
        element2.appendChild(this.gen2NamedPolyLineGroup(document, "tickline", "grid", "0 0 5 0", "grid", n - 5 + " 0 " + n + " 0"));
        element2.appendChild(this.genNamedPolyLineGroup(document, "xtickline", "grid", "0 0 0 -5"));
        Element element3 = document.createElement("g");
        element.appendChild(element3);
        element3.setAttribute("transform", "translate(" + n3 + "," + n4 + ")");
        element3.appendChild(this.genNamedPolyLine(document, "grid", "0 0 0 " + n2 + " " + n + " " + n2 + " " + n + " 0"));
        boolean bl = dataRange.getType() == 1;
        double d = dataRange.getMinValue();
        double d2 = dataRange.getMaxValue();
        SegmentMarker[] segmentMarkerArray = dataRange.getSegmentMarkers();
        int n5 = 0;
        while (n5 < segmentMarkerArray.length) {
            block9: {
                double d3;
                block10: {
                    double d4;
                    block8: {
                        SegmentMarker segmentMarker = segmentMarkerArray[n5];
                        d3 = 0.0;
                        if (!bl) break block8;
                        d4 = segmentMarkerArray[n5].getPosition();
                        if (d4 < 0.0 || d4 > 1.0) break block9;
                        d3 = (double)n * d4;
                        break block10;
                    }
                    d4 = segmentMarkerArray[n5].getValue();
                    if (d4 < d || d4 > d2) break block9;
                    d3 = (double)n * (d4 - d) / (d2 - d);
                }
                element3.appendChild(this.genUseWithOffsets(document, "xtickline", d3, n2));
            }
            ++n5;
        }
        double d5 = dataRange2.getMinValue();
        double d6 = dataRange2.getMaxValue();
        SegmentMarker[] segmentMarkerArray2 = dataRange2.getSegmentMarkers();
        int n6 = 0;
        while (n6 < segmentMarkerArray2.length) {
            object = segmentMarkerArray2[n6];
            double d7 = segmentMarkerArray2[n6].getValue();
            if (!(d7 < d5) && !(d7 > d6)) {
                double d8 = (int)((double)n2 * (d6 - d7) / (d6 - d5));
                element3.appendChild(this.genUseWithOffsets(document, "tickline", 0.0, d8));
                element3.appendChild(this.genUseWithOffsets(document, "solidgridline", 0.0, d8));
            }
            ++n6;
        }
        object = this.calculateDashGridPositions(segmentMarkerArray2);
        int n7 = 0;
        while (n7 < ((double[])object).length) {
            double d9 = object[n7];
            if (!(d9 < d5) && !(d9 > d6)) {
                int n8 = (int)((double)n2 * (d6 - d9) / (d6 - d5));
                element3.appendChild(this.genUseWithOffsets(document, "dashgridline", 0.0, n8));
            }
            ++n7;
        }
    }

    protected double[] calculateDashGridPositions(SegmentMarker[] segmentMarkerArray) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        if (segmentMarkerArray.length <= 1) {
            return new double[0];
        }
        int n = segmentMarkerArray.length - 1;
        double[] dArray = new double[n];
        double d4 = segmentMarkerArray[0].getValue();
        int n2 = 0;
        while (n2 < n) {
            double d5 = segmentMarkerArray[n2 + 1].getValue();
            dArray[n2] = (d4 + d5) / 2.0;
            d4 = d5;
            ++n2;
        }
        return dArray;
    }

    protected void addTitles(Document document, GraphicAttributes graphicAttributes, Element element, int n, int n2, int n3, int n4, DataRange dataRange, DataRange dataRange2, int n5, String string) {
        String string2 = null;
        Element element2 = null;
        int n6 = n2 + 8 + 5;
        String string3 = dataRange.getLabel();
        if (string3 != null) {
            string2 = "xyTitleLabels anchorAtMiddle";
            element2 = document.createElement("g");
            element2.setAttribute("transform", "translate(" + n3 + "," + n4 + ")");
            element2.setAttribute("id", "labelsValues0");
            element2.setAttribute("class", string2);
            element.appendChild(element2);
            double d = n6 + (n5 + 1) * 12;
            double d2 = graphicAttributes.getGraphicHeight();
            if (d + 14.0 > d2) {
                this.addLabel(document, graphicAttributes, element2, string3, null, n / 2, d2 - 8.0, 0);
            } else {
                this.addLabel(document, graphicAttributes, element2, string3, null, n / 2, d, 0);
            }
        }
        if ((string3 = dataRange2.getLabel()) != null) {
            string2 = "xyTitleLabels anchorAtMiddle";
            element2 = document.createElement("g");
            element2.setAttribute("transform", "translate(30," + n4 + ")");
            element2.setAttribute("id", "labelsValues1");
            element2.setAttribute("class", string2);
            element.appendChild(element2);
            this.addLabel(document, graphicAttributes, element2, string3, null, 0.0, (double)n2 / 2.0, 270);
        }
    }

    protected void evenlyDistributeSegmentMarkers(DataRange dataRange) {
        if (dataRange == null) {
            return;
        }
        SegmentMarker[] segmentMarkerArray = dataRange.getSegmentMarkers();
        if (segmentMarkerArray == null) {
            return;
        }
        double d = 1.0 / (double)segmentMarkerArray.length;
        double d2 = d / 2.0;
        int n = 0;
        while (n < segmentMarkerArray.length) {
            segmentMarkerArray[n].setPosition(d2 + d * (double)n);
            ++n;
        }
    }

    protected void addAxisLabels(Document document, GraphicAttributes graphicAttributes, Element element, int n, int n2, int n3, int n4, DataRange dataRange, DataRange dataRange2) {
        String string = "dataValues anchorAtMiddle";
        String string2 = "dataValues anchorAtEnd";
        Element element2 = document.createElement("g");
        element.appendChild(element2);
        element2.setAttribute("transform", "translate(" + n3 + "," + n4 + ")");
        element2.setAttribute("id", "dataValues0");
        element2.setAttribute("class", string);
        int n5 = n2 + 8 + 5;
        double d = dataRange.getMinValue();
        double d2 = dataRange.getMaxValue();
        SegmentMarker[] segmentMarkerArray = dataRange.getSegmentMarkers();
        boolean bl = dataRange.getType() == 1;
        int n6 = 0;
        while (n6 < segmentMarkerArray.length) {
            block10: {
                double d3;
                block11: {
                    double d4;
                    block9: {
                        SegmentMarker segmentMarker = segmentMarkerArray[n6];
                        d3 = 0.0;
                        if (!bl) break block9;
                        d4 = segmentMarkerArray[n6].getPosition();
                        if (d4 < 0.0 || d4 > 1.0) break block10;
                        d3 = (double)n * d4;
                        break block11;
                    }
                    d4 = segmentMarkerArray[n6].getValue();
                    if (d4 < d || d4 > d2) break block10;
                    d3 = (double)n * (d4 - d) / (d2 - d);
                }
                String string3 = segmentMarkerArray[n6].getLabel();
                if (string3 == null) {
                    string3 = graphicAttributes.formatNumber(segmentMarkerArray[n6].getValue());
                }
                String[] stringArray = this.wrapXLabel(string3);
                double d5 = n5;
                int n7 = 0;
                while (n7 < stringArray.length) {
                    this.addLabel(document, graphicAttributes, element2, stringArray[n7], string, d3, d5, 0);
                    d5 += 12.0;
                    ++n7;
                }
            }
            ++n6;
        }
        element2 = document.createElement("g");
        element.appendChild(element2);
        element2.setAttribute("transform", "translate(" + n3 + "," + n4 + ")");
        element2.setAttribute("id", "dataValues1");
        element2.setAttribute("class", string2);
        double d6 = -5.0;
        double d7 = dataRange2.getMinValue();
        double d8 = dataRange2.getMaxValue();
        SegmentMarker[] segmentMarkerArray2 = dataRange2.getSegmentMarkers();
        double d9 = (double)n2 + 4.0;
        int n8 = 0;
        while (n8 < segmentMarkerArray2.length) {
            SegmentMarker segmentMarker = segmentMarkerArray2[n8];
            double d10 = segmentMarkerArray2[n8].getValue();
            if (!(d10 < d7) && !(d10 > d8)) {
                double d11 = (double)n2 * (d8 - d10) / (d8 - d7) + 4.0;
                String string4 = segmentMarkerArray2[n8].getLabel();
                if (string4 == null) {
                    string4 = graphicAttributes.formatNumber(segmentMarkerArray2[n8].getValue());
                }
                this.addLabel(document, graphicAttributes, element2, string4, string2, d6, d11, 0);
            }
            ++n8;
        }
    }

    protected int getNumberOfAxisLabels(GraphicAttributes graphicAttributes, int n, DataRange dataRange) {
        double d = dataRange.getMinValue();
        double d2 = dataRange.getMaxValue();
        SegmentMarker[] segmentMarkerArray = dataRange.getSegmentMarkers();
        int n2 = 0;
        boolean bl = dataRange.getType() == 1;
        int n3 = 0;
        while (n3 < segmentMarkerArray.length) {
            block7: {
                String[] stringArray;
                block8: {
                    double d3;
                    double d4;
                    block6: {
                        SegmentMarker segmentMarker = segmentMarkerArray[n3];
                        d4 = 0.0;
                        if (!bl) break block6;
                        d3 = segmentMarkerArray[n3].getPosition();
                        if (d3 < 0.0 || d3 > 1.0) break block7;
                        d4 = (double)n * d3;
                        break block8;
                    }
                    d3 = segmentMarkerArray[n3].getValue();
                    if (d3 < d || d3 > d2) break block7;
                    d4 = (double)n * (d3 - d) / (d2 - d);
                }
                String string = segmentMarkerArray[n3].getLabel();
                if (string == null) {
                    string = graphicAttributes.formatNumber(segmentMarkerArray[n3].getValue());
                }
                if ((stringArray = this.wrapXLabel(string)).length > n2) {
                    n2 = stringArray.length;
                }
            }
            ++n3;
        }
        return n2;
    }

    private String[] wrapXLabel(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreElements()) {
            arrayList.add(stringTokenizer.nextElement().toString());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    protected Vector calculateDashGridYPositions(String[] stringArray) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < stringArray.length) {
            d2 = Double.parseDouble(stringArray[n]);
            d3 = (d + d2) / 2.0;
            vector.add(Double.toString(d3));
            d = d2;
            ++n;
        }
        return vector;
    }

    protected void getConfigAttributes(GraphicAttributes graphicAttributes) throws DataInputProcessingException {
        Hashtable hashtable = this.dataRetriever.getConfigurationAttributes(graphicAttributes.getConfigDocument(), graphicAttributes.getDataDocument());
        if (hashtable == null) {
            return;
        }
        String string = (String)hashtable.get("width");
        String string2 = (String)hashtable.get("height");
        String string3 = (String)hashtable.get("title");
        String string4 = (String)hashtable.get("timestampPrefix");
        String string5 = (String)hashtable.get("legendTitle");
        if (string != null) {
            graphicAttributes.setGraphicWidth(string);
        }
        if (string2 != null) {
            graphicAttributes.setGraphicHeight(string2);
        }
        if (string3 != null) {
            graphicAttributes.setGraphicTitle(string3);
        }
        if (string4 != null) {
            graphicAttributes.setGraphicTimestampPrefix(string4);
        }
        if (string5 != null) {
            graphicAttributes.setGraphicLegendTitle(string5);
        }
    }

    protected int resetGridOffsetForCentering(short s, int n) {
        return (int)((double)(s - n) / 2.0);
    }

    protected int resetGridOffsetForCenter(short s, int n, double d) {
        return (int)((double)(s - n) / d);
    }

    protected double getMaxLengthOfYmarker(SegmentMarker[] segmentMarkerArray, GraphicAttributes graphicAttributes) {
        int n = 0;
        int n2 = 0;
        while (n2 < segmentMarkerArray.length) {
            int n3;
            String string = segmentMarkerArray[n2].getDisplayLabel(graphicAttributes);
            if (string != null && n < (n3 = string.length())) {
                n = n3;
            }
            ++n2;
        }
        return 16.0 + (double)n * 6.0;
    }
}

