/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.editor.form.base;

import org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.base.ModifiedTextCellEditor;
import org.eclipse.hyades.test.ui.internal.editor.form.base.TablePart;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;

public class EditableTablePart
extends TablePart {
    private boolean editable;

    public EditableTablePart(String[] stringArray) {
        super(stringArray);
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean bl) {
        this.editable = bl;
    }

    protected StructuredViewer createStructuredViewer(Composite composite, int n, FormWidgetFactory formWidgetFactory) {
        TableViewer tableViewer = (TableViewer)super.createStructuredViewer(composite, n, formWidgetFactory);
        if (this.editable) {
            Table table = tableViewer.getTable();
            CellEditor[] cellEditorArray = new CellEditor[]{new ModifiedTextCellEditor((Composite)table)};
            String[] stringArray = new String[]{"name"};
            tableViewer.setCellEditors(cellEditorArray);
            tableViewer.setCellModifier((ICellModifier)new NameModifier());
            tableViewer.setColumnProperties(stringArray);
            table.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.keyCode == 0x100000B) {
                        EditableTablePart.this.activateEditMode();
                    }
                }
            });
        }
        return tableViewer;
    }

    protected void activateEditMode() {
        TableViewer tableViewer = this.getTableViewer();
        IStructuredSelection iStructuredSelection = (IStructuredSelection)tableViewer.getSelection();
        if (iStructuredSelection.size() == 1 && !tableViewer.isCellEditorActive()) {
            tableViewer.editElement(iStructuredSelection.getFirstElement(), 0);
        }
    }

    protected void entryModified(Object object, String string) {
    }

    class NameModifier
    implements ICellModifier {
        NameModifier() {
        }

        public boolean canModify(Object object, String string) {
            return true;
        }

        public void modify(Object object, String string, Object object2) {
            EditableTablePart.this.entryModified(object, object2.toString());
        }

        public Object getValue(Object object, String string) {
            return object.toString();
        }
    }
}

