/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.model.ui;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.models.common.util.ExecutionUtil;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.hyades.ui.util.IDisposable;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class ExecutionContentProvider
implements ITreeContentProvider,
IDisposable {
    private ResourceSet resourceSet;
    private Map elementDescriptionByFileExtension;
    private boolean showEMFResource;
    private boolean showEnabledChildren = true;

    public ExecutionContentProvider(ResourceSet resourceSet) {
        this.resourceSet = resourceSet;
        this.elementDescriptionByFileExtension = new HashMap();
        this.showEMFResource = false;
    }

    public void dispose() {
        this.elementDescriptionByFileExtension.clear();
    }

    public void addElementDescription(ElementDescription elementDescription) {
        this.elementDescriptionByFileExtension.put(elementDescription.getFileExtension(), elementDescription);
    }

    public boolean isShowEMFResource() {
        return this.showEMFResource;
    }

    public void setShowEMFResource(boolean bl) {
        this.showEMFResource = bl;
    }

    public boolean isShowEnabledChildren() {
        return this.showEnabledChildren;
    }

    public void setShowEnabledChildren(boolean bl) {
        this.showEnabledChildren = bl;
    }

    public void inputChanged(Viewer viewer, Object object, Object object2) {
    }

    public Object getParent(Object object) {
        if (object instanceof IResource) {
            return ((IResource)object).getParent();
        }
        if (object instanceof Resource) {
            IFile iFile = EMFUtil.getWorkspaceFile((Resource)object);
            if (iFile != null) {
                return iFile.getParent();
            }
        } else {
            if (object instanceof TPFExecutionResult && ((TPFExecutionResult)object).eContainer() == null) {
                return ((TPFExecutionResult)object).getTest();
            }
            if (object instanceof EObject) {
                EObject eObject = (EObject)object;
                if (eObject.eContainer() != null) {
                    return eObject.eContainer();
                }
                if (this.isShowEMFResource()) {
                    return eObject.eResource();
                }
                IFile iFile = EMFUtil.getWorkspaceFile(eObject);
                if (iFile != null) {
                    return iFile.getParent();
                }
            }
        }
        return null;
    }

    public Object[] getElements(Object object) {
        if (object instanceof IWorkspaceRoot) {
            return ((IWorkspaceRoot)object).getProjects();
        }
        return this.getChildren(object);
    }

    public boolean hasChildren(Object object) {
        if (object instanceof IContainer) {
            IContainer iContainer = (IContainer)object;
            if (!iContainer.exists()) {
                return false;
            }
            IResource[] iResourceArray = null;
            try {
                iResourceArray = iContainer.members();
            }
            catch (CoreException coreException) {
                TestUIPlugin.logError(coreException);
                return false;
            }
            int n = 0;
            int n2 = iResourceArray.length;
            while (n < n2) {
                if (iResourceArray[n].getType() != 1) {
                    return true;
                }
                ElementDescription elementDescription = (ElementDescription)this.elementDescriptionByFileExtension.get(iResourceArray[n].getFileExtension());
                if (elementDescription != null) {
                    EObject[] eObjectArray = EMFUtil.load(this.resourceSet, (IFile)iResourceArray[n]);
                    Iterator iterator = elementDescription.getEClassifiers().iterator();
                    while (iterator.hasNext()) {
                        if (EcoreUtil.getObjectByType(Arrays.asList(eObjectArray), (EClassifier)((EClassifier)iterator.next())) == null) continue;
                        return true;
                    }
                }
                ++n;
            }
        } else {
            if (object instanceof Resource) {
                return !((Resource)object).getContents().isEmpty();
            }
            if (object instanceof TPFTest) {
                return ExecutionUtil.findExecutionResults((TPFTest)((TPFTest)object)).size() > 0;
            }
        }
        return false;
    }

    public Object[] getChildren(Object object) {
        if (object instanceof IContainer) {
            UniqueEList uniqueEList = new UniqueEList();
            IResource[] iResourceArray = null;
            try {
                iResourceArray = ((IContainer)object).members();
            }
            catch (CoreException coreException) {
                TestUIPlugin.logError(coreException);
                return new Object[0];
            }
            int n = 0;
            int n2 = iResourceArray.length;
            while (n < n2) {
                if (iResourceArray[n].getType() != 1) {
                    uniqueEList.add(iResourceArray[n]);
                } else {
                    ElementDescription elementDescription = (ElementDescription)this.elementDescriptionByFileExtension.get(iResourceArray[n].getFileExtension());
                    if (elementDescription != null) {
                        EObject[] eObjectArray = EMFUtil.load(this.resourceSet, (IFile)iResourceArray[n]);
                        Iterator iterator = elementDescription.getEClassifiers().iterator();
                        while (iterator.hasNext()) {
                            Collection collection = EcoreUtil.getObjectsByType(Arrays.asList(eObjectArray), (EClassifier)((EClassifier)iterator.next()));
                            if (this.isShowEMFResource()) {
                                Iterator iterator2 = collection.iterator();
                                while (iterator2.hasNext()) {
                                    uniqueEList.add(((EObject)iterator2.next()).eResource());
                                }
                                continue;
                            }
                            uniqueEList.addAll(collection);
                        }
                    }
                }
                ++n;
            }
            return uniqueEList.toArray();
        }
        if (object instanceof Resource) {
            return ((Resource)object).getContents().toArray();
        }
        if (object instanceof TPFTest) {
            return ExecutionUtil.findExecutionResults((TPFTest)((TPFTest)object)).toArray();
        }
        return new Object[0];
    }

    public static class ElementDescription {
        private String fileExtension;
        private List eClassifiers;

        public ElementDescription(String string) {
            this.fileExtension = string;
        }

        public String getFileExtension() {
            return this.fileExtension;
        }

        public List getEClassifiers() {
            if (this.eClassifiers == null) {
                this.eClassifiers = new UniqueEList();
            }
            return this.eClassifiers;
        }
    }
}

