/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.hyades.models.common.common.CMNNamedElement;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.hyades.test.ui.internal.model.ResourceUtil;
import org.eclipse.hyades.test.ui.internal.model.ui.ExecutionContentProvider;
import org.eclipse.hyades.test.ui.internal.navigator.ExecutionNavigatorFrameSource;
import org.eclipse.hyades.test.ui.internal.navigator.ExecutionResourceChangeUpdater;
import org.eclipse.hyades.test.ui.internal.navigator.action.ExecutionNavigatorActionGroup;
import org.eclipse.hyades.ui.internal.logicalfolder.LogicalFolder;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.hyades.ui.internal.navigator.NavigatorViewerSorter;
import org.eclipse.hyades.ui.internal.navigator.TreeNavigator;
import org.eclipse.hyades.ui.internal.navigator.TreeNavigatorFrameSource;
import org.eclipse.hyades.ui.internal.navigator.action.NavigatorActionGroup;
import org.eclipse.hyades.ui.internal.provider.IResourceChangeUpdater;
import org.eclipse.hyades.ui.internal.provider.ResourceChangeUpdaterProvider;
import org.eclipse.hyades.ui.internal.provider.WorkbenchAdapterLabelProvider;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ExecutionNavigator
extends TreeNavigator {
    public static final String ID = "org.eclipse.hyades.test.ui.ExecutionNavigator";
    public static final int FILTER_SHOW_RUNNING = 1;
    public static final int FILTER_SHOW_FINISHED = 2;
    public static final int FILTER_SHOW_ALL = 3;
    private static Map execNavigatorByWorkbenchWindow;
    private ArrayList executionResults = new ArrayList();
    protected static final String SET_SHOW_FOLDERS = "SHOW_FOLDERS";
    protected static final String SET_SHOW_EOBJECT_CHILDREN = "SHOW_EOBJECT_CHILDREN";
    protected static final String SET_SORTER_CRITERIA = "SORTER_CRITERIA";
    protected static final int CP_FOLDER = 0;
    protected static final int CP_LOGICAL = 1;
    private List rootLogicalFolders;
    private boolean showingFolders = true;
    private boolean showingEObjectChildren = false;
    private ResourceChangeUpdaterProvider resourceChangeUpdaterProvider;
    private ResourceSet resourceSet;
    private ExecutionContentProvider modelContentProvider;
    static /* synthetic */ Class class$org$eclipse$core$resources$IFile;
    static /* synthetic */ Class class$org$eclipse$hyades$test$ui$adapter$TestWorkbenchAdapter;

    private static void addExecNavigator(ExecutionNavigator executionNavigator) {
        if (execNavigatorByWorkbenchWindow == null) {
            execNavigatorByWorkbenchWindow = new HashMap();
        }
        execNavigatorByWorkbenchWindow.put(executionNavigator.getSite().getWorkbenchWindow(), executionNavigator);
    }

    private static void removeExecNavigator(ExecutionNavigator executionNavigator) {
        if (execNavigatorByWorkbenchWindow != null) {
            execNavigatorByWorkbenchWindow.remove(executionNavigator.getSite().getWorkbenchWindow());
            if (execNavigatorByWorkbenchWindow.isEmpty()) {
                execNavigatorByWorkbenchWindow = null;
            }
        }
    }

    public static ExecutionNavigator getExecNavigator(IWorkbenchWindow iWorkbenchWindow) {
        if (iWorkbenchWindow != null && execNavigatorByWorkbenchWindow != null) {
            return (ExecutionNavigator)((Object)execNavigatorByWorkbenchWindow.get(iWorkbenchWindow));
        }
        return null;
    }

    public ExecutionNavigator() {
        this.initializeResourceSet();
    }

    public void dispose() {
        if (this.executionResults != null) {
            this.executionResults.clear();
        }
        this.executionResults = null;
        if (this.rootLogicalFolders != null) {
            this.rootLogicalFolders.clear();
        }
        ExecutionNavigator.removeExecNavigator(this);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.resourceChangeUpdaterProvider);
        this.resourceChangeUpdaterProvider.getResourceChangeUpdater().dispose();
        this.resourceChangeUpdaterProvider.dispose();
        this.resourceChangeUpdaterProvider = null;
        this.modelContentProvider.dispose();
        this.modelContentProvider = null;
        EMFUtil.removeAdapters((Iterator)this.resourceSet.getAllContents());
        this.resourceSet.getResources().clear();
        this.resourceSet.eAdapters().clear();
        this.resourceSet = null;
        super.dispose();
    }

    public String getStoreSection() {
        return "ExecutionNavigator";
    }

    protected void initializeResourceSet() {
        this.resourceSet = new ResourceSetImpl();
        this.modelContentProvider = new ExecutionContentProvider(this.getResourceSet());
        ExecutionContentProvider.ElementDescription elementDescription = new ExecutionContentProvider.ElementDescription("testsuite");
        elementDescription.getEClassifiers().add(Common_TestprofilePackage.eINSTANCE.getTPFTestSuite());
        this.modelContentProvider.addElementDescription(elementDescription);
    }

    protected void initSettings() {
        this.setShowingFolders(true);
        this.setShowingEObjectChildren(true);
    }

    public ResourceSet getResourceSet() {
        return this.resourceSet;
    }

    public void init(IViewSite iViewSite, IMemento iMemento) throws PartInitException {
        super.init(iViewSite, iMemento);
        ExecutionNavigator.addExecNavigator(this);
    }

    public IFile getFile(Object object) {
        IFile iFile;
        if (object instanceof IFile) {
            return (IFile)object;
        }
        if (object instanceof Resource) {
            return EMFUtil.getWorkspaceFile((Resource)object);
        }
        if (object instanceof EObject) {
            EObject eObject = (EObject)object;
            if (eObject.eContainer() != null) {
                return null;
            }
            Resource resource = eObject.eResource();
            if (resource == null) {
                return null;
            }
            if (this.getResourceSet().getResource(resource.getURI(), false) == null) {
                return null;
            }
            return EMFUtil.getWorkspaceFile(resource);
        }
        if (object instanceof IAdaptable && (iFile = (IFile)((IAdaptable)object).getAdapter(class$org$eclipse$core$resources$IFile == null ? (class$org$eclipse$core$resources$IFile = ExecutionNavigator.class$("org.eclipse.core.resources.IFile")) : class$org$eclipse$core$resources$IFile)) != null) {
            return iFile;
        }
        return null;
    }

    public void setMonitoringResourceChange(boolean bl) {
        if (this.resourceChangeUpdaterProvider != null) {
            this.resourceChangeUpdaterProvider.getResourceChangeUpdater().setActive(bl);
        }
    }

    public boolean isMonitoringResourceChange() {
        if (this.resourceChangeUpdaterProvider != null) {
            this.resourceChangeUpdaterProvider.getResourceChangeUpdater().isActive();
        }
        return false;
    }

    protected void loadSettings() {
        super.loadSettings();
        this.setShowingFolders(this.getSettings().getBoolean(SET_SHOW_FOLDERS));
        this.setShowingEObjectChildren(this.getSettings().getBoolean(SET_SHOW_EOBJECT_CHILDREN));
    }

    protected void adjustTreeViewer(TreeViewer treeViewer) {
        int n = 1;
        try {
            n = this.getSettings().getInt(SET_SORTER_CRITERIA);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        NavigatorViewerSorter navigatorViewerSorter = new NavigatorViewerSorter((INavigator)this, n){

            protected String getValue(Viewer viewer, Object object) {
                String string = super.getValue(viewer, object);
                if (object instanceof EObject) {
                    EObject eObject = (EObject)object;
                    if (eObject.eContainer() != null) {
                        return "";
                    }
                    if (this.getCriteria() == 2) {
                        if (eObject instanceof TPFTest) {
                            String string2 = ((TPFTest)eObject).getType();
                            string = string2 != null ? string2 + string : "zZz" + string2;
                        }
                        string = eObject.eClass().getName() + string;
                    }
                }
                return string;
            }
        };
        treeViewer.setSorter((ViewerSorter)navigatorViewerSorter);
        ViewerFilter viewerFilter = new ViewerFilter(){

            public boolean select(Viewer viewer, Object object, Object object2) {
                if (!ExecutionNavigator.this.isShowingEObjectChildren()) {
                    return !(object instanceof EObject);
                }
                return true;
            }
        };
        treeViewer.addFilter(viewerFilter);
        this.resourceChangeUpdaterProvider = new ResourceChangeUpdaterProvider.UIUpdaterProvider();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.resourceChangeUpdaterProvider, 1);
        ExecutionResourceChangeUpdater executionResourceChangeUpdater = new ExecutionResourceChangeUpdater(this);
        this.resourceChangeUpdaterProvider.setResourceChangeUpdater((IResourceChangeUpdater)executionResourceChangeUpdater);
        treeViewer.setContentProvider((IContentProvider)this.modelContentProvider);
        ILabelDecorator iLabelDecorator = PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator();
        treeViewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)new WorkbenchAdapterLabelProvider(class$org$eclipse$hyades$test$ui$adapter$TestWorkbenchAdapter == null ? (class$org$eclipse$hyades$test$ui$adapter$TestWorkbenchAdapter = ExecutionNavigator.class$("org.eclipse.hyades.test.ui.adapter.TestWorkbenchAdapter")) : class$org$eclipse$hyades$test$ui$adapter$TestWorkbenchAdapter), iLabelDecorator));
    }

    protected boolean editorActivated(IEditorPart iEditorPart) {
        if (this.getViewer() == null) {
            return false;
        }
        IEditorInput iEditorInput = iEditorPart.getEditorInput();
        if (iEditorInput instanceof IFileEditorInput) {
            IFileEditorInput iFileEditorInput = (IFileEditorInput)iEditorInput;
            IFile iFile = iFileEditorInput.getFile();
            Resource resource = EMFUtil.getResource(this.getResourceSet(), iFile);
            if (resource != null && !resource.getContents().isEmpty()) {
                Object object;
                IStructuredSelection iStructuredSelection = this.getStructuredSelection();
                if (iStructuredSelection.size() == 1 && (object = iStructuredSelection.getFirstElement()) instanceof EObject && ((EObject)object).eResource() == resource) {
                    return true;
                }
                this.selectReveal((ISelection)new StructuredSelection(resource.getContents().get(0)));
                return true;
            }
        }
        return false;
    }

    protected void linkToEditor(IStructuredSelection iStructuredSelection) {
        IWorkbenchPage iWorkbenchPage;
        IEditorPart iEditorPart;
        IFile iFile = this.getFile(iStructuredSelection.getFirstElement());
        if (iFile != null && (iEditorPart = (iWorkbenchPage = this.getSite().getPage()).findEditor((IEditorInput)new FileEditorInput(iFile))) != null) {
            iWorkbenchPage.bringToTop((IWorkbenchPart)iEditorPart);
            return;
        }
    }

    public AbstractUIPlugin getPlugin() {
        return TestUIPlugin.getInstance();
    }

    protected Object createViewerInput() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    protected void createActions() {
        this.setActionGroup(new ExecutionNavigatorActionGroup(this));
    }

    public boolean isShowingFolders() {
        return this.showingFolders;
    }

    public void setShowingFolders(boolean bl) {
        this.showingFolders = bl;
        this.getSettings().put(SET_SHOW_FOLDERS, this.showingFolders);
        if (this.getViewer() == null) {
            return;
        }
        this.getViewer().refresh();
    }

    public boolean isShowingEObjectChildren() {
        return this.showingEObjectChildren;
    }

    public void setShowingEObjectChildren(boolean bl) {
        this.showingEObjectChildren = bl;
        this.modelContentProvider.setShowEnabledChildren(bl);
        this.getSettings().put(SET_SHOW_EOBJECT_CHILDREN, this.showingEObjectChildren);
        if (this.getViewer() == null) {
            return;
        }
        this.getViewer().refresh();
        this.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this.getViewer(), (ISelection)StructuredSelection.EMPTY));
    }

    protected String getStatusLineMessage(IStructuredSelection iStructuredSelection) {
        if (iStructuredSelection.size() == 1) {
            Object object = iStructuredSelection.getFirstElement();
            if (object instanceof IResource) {
                return ((IResource)object).getFullPath().toString();
            }
            if (object instanceof LogicalFolder) {
                LogicalFolder logicalFolder = (LogicalFolder)object;
                if (logicalFolder.getChildren().size() == 0) {
                    return logicalFolder.getName();
                }
                return TestUIPlugin.getString("STS_LNE_LOG_FLD", new String[]{logicalFolder.getName(), Integer.toString(logicalFolder.getChildren().size())});
            }
            if (object instanceof CMNNamedElement) {
                CMNNamedElement cMNNamedElement = (CMNNamedElement)object;
                String string = ((ILabelProvider)this.getViewer().getLabelProvider()).getText((Object)cMNNamedElement);
                IFile iFile = EMFUtil.getWorkspaceFile((EObject)cMNNamedElement);
                String string2 = "";
                if (iFile != null) {
                    string2 = iFile.getFullPath().toString();
                }
                return TestUIPlugin.getString("STS_LNE_FILE_ELEM", new String[]{string, string2});
            }
            if (object instanceof Resource) {
                Resource resource = (Resource)object;
                String string = ((ILabelProvider)this.getViewer().getLabelProvider()).getText((Object)resource);
                IFile iFile = EMFUtil.getWorkspaceFile(resource);
                String string3 = "";
                if (iFile != null) {
                    string3 = iFile.getFullPath().toString();
                }
                return TestUIPlugin.getString("STS_LNE_FILE_ELEM", new String[]{string, string3});
            }
        }
        return super.getStatusLineMessage(iStructuredSelection);
    }

    public void doubleClick(DoubleClickEvent doubleClickEvent) {
        if (doubleClickEvent.getViewer() == this.getTreeViewer()) {
            IStructuredSelection iStructuredSelection = (IStructuredSelection)doubleClickEvent.getSelection();
            Object object = iStructuredSelection.getFirstElement();
            if (object instanceof EObject || object instanceof Resource) {
                return;
            }
            TreeViewer treeViewer = this.getTreeViewer();
            if (treeViewer.isExpandable(object)) {
                treeViewer.setExpandedState(object, !treeViewer.getExpandedState(object));
            }
        }
    }

    protected IStructuredSelection convertToViewer(ISelection iSelection) {
        IStructuredSelection iStructuredSelection = super.convertToViewer(iSelection);
        if (iStructuredSelection.isEmpty()) {
            return iStructuredSelection;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(iStructuredSelection.size());
        Iterator iterator = iStructuredSelection.iterator();
        while (iterator.hasNext()) {
            EObject eObject;
            Object e = iterator.next();
            if (e instanceof IFile) {
                eObject = EMFUtil.getEObjects(this.getResourceSet(), (IFile)e);
                int n = 0;
                int n2 = ((EObject[])eObject).length;
                while (n < n2) {
                    if (eObject[n] instanceof CMNNamedElement) {
                        arrayList.add(eObject[n]);
                    }
                    ++n;
                }
                continue;
            }
            if (e instanceof EObject) {
                eObject = EMFUtil.getEObject(this.resourceSet, (EObject)e, false);
                if (eObject == null || eObject.eContainer() != null && !this.isShowingEObjectChildren()) continue;
                arrayList.add(eObject);
                continue;
            }
            arrayList.add(e);
        }
        return new StructuredSelection(arrayList);
    }

    public void handleChange(int n) {
        if (NavigatorViewerSorter.SORTER_TYPE == n) {
            this.getSettings().put(SET_SORTER_CRITERIA, ((NavigatorViewerSorter)this.getViewer().getSorter()).getCriteria());
            NavigatorActionGroup navigatorActionGroup = this.getActionGroup();
            if (navigatorActionGroup != null) {
                navigatorActionGroup.updateActionBars();
            }
        }
        super.handleChange(n);
    }

    public Object getInitialViewerInput() {
        return super.getInitialViewerInput();
    }

    protected TreeNavigatorFrameSource createFrameSource() {
        return new ExecutionNavigatorFrameSource(this);
    }

    public LogicalFolder getRootLogicalFolder(String string) {
        if (this.rootLogicalFolders != null && string != null) {
            Iterator iterator = this.rootLogicalFolders.iterator();
            while (iterator.hasNext()) {
                LogicalFolder logicalFolder = (LogicalFolder)iterator.next();
                if (!string.equals(logicalFolder.getName())) continue;
                return logicalFolder;
            }
        }
        return null;
    }

    protected List loadElements(IMemento iMemento) {
        Object[] objectArray = super.loadElements(iMemento).toArray();
        ArrayList<Object> arrayList = new ArrayList<Object>(objectArray.length);
        int n = 0;
        int n2 = objectArray.length;
        while (n < n2) {
            LogicalFolder logicalFolder;
            if (objectArray[n] instanceof LogicalFolder) {
                logicalFolder = (LogicalFolder)objectArray[n];
                Object object = logicalFolder.getParent();
                if (object == null) {
                    if ((logicalFolder = this.getRootLogicalFolder(logicalFolder.getName())) != null) {
                        arrayList.add(logicalFolder);
                    }
                } else if (object instanceof EObject) {
                    EObject eObject = EMFUtil.getEObject(this.getResourceSet(), (EObject)object, true);
                    if (eObject != null) {
                        LogicalFolder logicalFolder2 = new LogicalFolder((Object)eObject, logicalFolder.getName());
                        logicalFolder2.setData(logicalFolder.getData());
                        logicalFolder2.setDescription(logicalFolder.getDescription());
                        arrayList.add(logicalFolder2);
                    }
                } else {
                    arrayList.add(logicalFolder);
                }
            } else if (objectArray[n] instanceof EObject) {
                logicalFolder = EMFUtil.getEObject(this.getResourceSet(), (EObject)objectArray[n], true);
                if (logicalFolder != null) {
                    arrayList.add(logicalFolder);
                }
            } else if (objectArray[n] instanceof ResourceUtil.ResourceAdaptable) {
                logicalFolder = ((ResourceUtil.ResourceAdaptable)objectArray[n]).getResource();
                if (logicalFolder != null && (logicalFolder = this.getResourceSet().getResource(logicalFolder.getURI(), true)) != null) {
                    arrayList.add(logicalFolder);
                }
            } else {
                arrayList.add(objectArray[n]);
            }
            ++n;
        }
        return arrayList;
    }

    protected String getHelpContextId() {
        return TestUIPlugin.getID() + ".enav0001";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

