/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.manual.runner.ui.panel;

import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventObject;
import javax.swing.JPanel;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import org.eclipse.hyades.test.manual.runner.ui.util.EditorItem;
import org.eclipse.hyades.test.manual.runner.ui.util.IRefreshable;

public abstract class BasePanel
extends JPanel
implements IRefreshable,
ActionListener,
CaretListener {
    private Object currentData;
    private boolean internalChange = false;

    public BasePanel(LayoutManager layoutManager, boolean bl) {
        super(layoutManager, bl);
        this.internalInitialize();
        this.createControl();
    }

    public BasePanel(LayoutManager layoutManager) {
        super(layoutManager);
        this.internalInitialize();
        this.createControl();
    }

    public BasePanel(boolean bl) {
        super(bl);
        this.internalInitialize();
        this.createControl();
    }

    public BasePanel() {
        this.internalInitialize();
        this.createControl();
    }

    private void internalInitialize() {
        try {
            this.initialize();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void initialize() {
    }

    protected abstract void createControl();

    public void refreshContent(Object object) {
        if (object == null || !(object instanceof EditorItem)) {
            this.invalidData();
            this.setEditable(false);
            return;
        }
        EditorItem editorItem = (EditorItem)object;
        if (EditorItem.REFRESH_STATE.equals(object = editorItem.getData())) {
            this.setEditable(editorItem.isEditable());
            return;
        }
        if (EditorItem.REFRESH.equals(object)) {
            this.refreshPanel(true);
            return;
        }
        if (object == null || !this.isValidData(object)) {
            this.invalidData();
            this.setEditable(false);
            return;
        }
        boolean bl = object.equals(this.currentData);
        this.setCurrentData(object);
        this.setEditable(editorItem.isEditable());
        this.refreshPanel(bl);
    }

    protected void setCurrentData(Object object) {
        this.currentData = object;
    }

    protected Object getCurrentData() {
        return this.currentData;
    }

    protected abstract boolean isValidData(Object var1);

    protected abstract void refreshPanel(boolean var1);

    protected abstract void invalidData();

    protected abstract void setEditable(boolean var1);

    public final void actionPerformed(ActionEvent actionEvent) {
        this.updateObject(actionEvent);
    }

    public void caretUpdate(CaretEvent caretEvent) {
        this.updateObject(caretEvent);
    }

    public final void updateObject(EventObject eventObject) {
        this.internalChange = true;
        try {
            this.updateCurrentData(eventObject);
            Object var3_2 = null;
            this.internalChange = false;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.internalChange = false;
            throw throwable;
        }
    }

    protected void updateCurrentData(EventObject eventObject) {
    }
}

