/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.editor.form.base;

import java.util.Hashtable;
import org.eclipse.hyades.test.ui.internal.editor.form.base.HyperlinkAction;
import org.eclipse.hyades.test.ui.internal.editor.form.base.HyperlinkSettings;
import org.eclipse.hyades.test.ui.internal.editor.form.base.IHyperlinkSegment;
import org.eclipse.hyades.test.ui.internal.editor.form.base.Locator;
import org.eclipse.hyades.test.ui.internal.editor.form.base.TextSegment;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class HyperlinkSegment
extends TextSegment
implements IHyperlinkSegment {
    private String actionId;
    private String arg;
    private HyperlinkSettings settings;

    public HyperlinkSegment(String string, HyperlinkSettings hyperlinkSettings, String string2) {
        super(string, string2);
        this.settings = hyperlinkSettings;
        this.underline = hyperlinkSettings.getHyperlinkUnderlineMode() == 3;
    }

    public HyperlinkAction getAction(Hashtable hashtable) {
        if (this.actionId == null) {
            return null;
        }
        Object v = hashtable.get(this.actionId);
        if (v == null) {
            return null;
        }
        if (v instanceof HyperlinkAction) {
            return (HyperlinkAction)v;
        }
        return null;
    }

    public String getObjectId() {
        return this.actionId;
    }

    void setActionId(String string) {
        this.actionId = string;
    }

    public void paint(GC gC, int n, Locator locator, Hashtable hashtable, boolean bl) {
        this.setColor(this.settings.getForeground());
        super.paint(gC, n, locator, hashtable, bl);
    }

    public void repaint(GC gC, boolean bl) {
        FontMetrics fontMetrics = gC.getFontMetrics();
        int n = fontMetrics.getHeight();
        int n2 = fontMetrics.getDescent();
        boolean bl2 = this.settings.getHyperlinkUnderlineMode() == 2;
        int n3 = 0;
        while (n3 < this.areaRectangles.size()) {
            TextSegment.AreaRectangle areaRectangle = (TextSegment.AreaRectangle)this.areaRectangles.get(n3);
            Rectangle rectangle = areaRectangle.rect;
            String string = areaRectangle.getText();
            Point point = gC.textExtent(string);
            int n4 = rectangle.x + 1;
            gC.drawString(string, n4, rectangle.y, true);
            if (this.underline || bl || bl2) {
                int n5 = rectangle.y + n - n2 + 1;
                Color color = null;
                if (bl2 && !bl) {
                    color = gC.getForeground();
                    gC.setForeground(gC.getBackground());
                }
                gC.drawLine(n4, n5, n4 + point.x, n5);
                if (color != null) {
                    gC.setForeground(color);
                }
            }
            ++n3;
        }
    }

    public String getArg() {
        return this.arg;
    }

    public void setArg(String string) {
        this.arg = string;
    }
}

