/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.editor.form.base;

import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TypedListener;

public abstract class SelectableControl
extends Canvas {
    protected boolean hasFocus;

    public SelectableControl(Composite composite, int n) {
        super(composite, n);
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                SelectableControl.this.paint(paintEvent);
            }
        });
        this.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent mouseEvent) {
                SelectableControl.this.notifyListeners(13);
            }
        });
        this.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.character == '\r') {
                    SelectableControl.this.notifyListeners(13);
                }
            }
        });
        this.addListener(31, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail != 4) {
                    event.doit = true;
                }
            }
        });
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                if (!SelectableControl.this.hasFocus) {
                    SelectableControl.this.hasFocus = true;
                    SelectableControl.this.redraw();
                }
            }

            public void focusLost(FocusEvent focusEvent) {
                if (SelectableControl.this.hasFocus) {
                    SelectableControl.this.hasFocus = false;
                    SelectableControl.this.redraw();
                }
            }
        });
    }

    protected void paint(PaintEvent paintEvent) {
        GC gC = paintEvent.gc;
        Point point = this.getSize();
        gC.setFont(this.getFont());
        this.paint(gC);
        if (this.hasFocus) {
            gC.setForeground(this.getForeground());
            gC.drawFocus(0, 0, point.x, point.y);
        }
    }

    protected abstract void paint(GC var1);

    protected void notifyListeners(int n) {
        Event event = new Event();
        event.type = n;
        event.widget = this;
        this.notifyListeners(n, event);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            return;
        }
        TypedListener typedListener = new TypedListener((SWTEventListener)selectionListener);
        this.addListener(13, (Listener)typedListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            return;
        }
        this.removeListener(13, (SWTEventListener)selectionListener);
    }
}

