/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator.action;

import java.util.Iterator;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.adapter.TestWorkbenchAdapter;
import org.eclipse.hyades.ui.internal.logicalfolder.LogicalFolder;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.hyades.ui.internal.navigator.TreeNavigator;
import org.eclipse.hyades.ui.internal.navigator.action.NavigatorActionGroup;
import org.eclipse.hyades.ui.internal.navigator.action.NewObjectAction;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.actions.NewWizardMenu;
import org.eclipse.ui.views.navigator.ResourceNavigatorMessages;

public class NewActionGroup
extends NavigatorActionGroup {
    private NewObjectAction newTestSuiteAction;
    private NewObjectAction newDeploymentAction;
    private NewObjectAction newHyadesObjectAction;

    public NewActionGroup(TreeNavigator treeNavigator) {
        super((INavigator)treeNavigator);
    }

    protected void createActions() {
        this.newTestSuiteAction = new NewObjectAction(this.getNavigator().getSite().getWorkbenchWindow());
        this.newTestSuiteAction.setText(TestUIPlugin.getString("LBL_TST_SUITE"));
        this.newTestSuiteAction.setToolTipText(this.newTestSuiteAction.getText());
        this.newTestSuiteAction.setWizardTitle(TestUIPlugin.getString("WIZ_TST_SUITE_TTL"));
        this.newTestSuiteAction.setWizardCategory("org.eclipse.hyades.test.ui.wizards.new/testSuite");
        this.newDeploymentAction = new NewObjectAction(this.getNavigator().getSite().getWorkbenchWindow());
        this.newDeploymentAction.setText(TestUIPlugin.getString("LBL_DEPLOYMENT"));
        this.newDeploymentAction.setToolTipText(this.newDeploymentAction.getText());
        this.newDeploymentAction.setWizardTitle(TestUIPlugin.getString("WIZ_DEPLOY_TTL"));
        this.newDeploymentAction.setWizardCategory("org.eclipse.hyades.test.ui.wizards.new/testElements");
        this.newHyadesObjectAction = new NewObjectAction(this.getNavigator().getSite().getWorkbenchWindow());
        this.newHyadesObjectAction.setText(TestUIPlugin.getString("WIZ_TST_OBJ_ACT"));
        this.newHyadesObjectAction.setWizardTitle(TestUIPlugin.getString("WIZ_TST_OBJ_TTL"));
        this.newHyadesObjectAction.setWizardCategory("org.eclipse.hyades.test.ui.wizards.new");
        this.newHyadesObjectAction.setToolTipText(this.newHyadesObjectAction.getText());
    }

    public void fillContextMenu(IMenuManager iMenuManager) {
        LogicalFolder logicalFolder;
        Object object;
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.getContext().getSelection();
        if (this.getNavigator().isShowingFolders()) {
            if (!this.hasLogicalFolder(iStructuredSelection)) {
                MenuManager menuManager = new MenuManager(ResourceNavigatorMessages.getString((String)"ResourceNavigator.new"));
                iMenuManager.add((IContributionItem)menuManager);
                new NewWizardMenu((IMenuManager)menuManager, this.getNavigator().getSite().getWorkbenchWindow(), false);
                menuManager.insert(0, (IContributionItem)new ActionContributionItem((IAction)this.newHyadesObjectAction));
                menuManager.insert(1, (IContributionItem)new Separator());
            }
        } else if (iStructuredSelection.size() == 1 && (object = iStructuredSelection.getFirstElement()) instanceof LogicalFolder && (logicalFolder = (LogicalFolder)object).getParent() == null) {
            MenuManager menuManager = new MenuManager(ResourceNavigatorMessages.getString((String)"ResourceNavigator.new"));
            iMenuManager.add((IContributionItem)menuManager);
            String string = logicalFolder.getName();
            if (TestWorkbenchAdapter.TEST_SUITE_LOGICAL_FOLDER_NAME.equals(string)) {
                menuManager.add((IAction)this.newTestSuiteAction);
            } else if (TestWorkbenchAdapter.DEPLOYMENT_LOGICAL_FOLDER_NAME.equals(string)) {
                menuManager.add((IAction)this.newDeploymentAction);
            }
        }
    }

    protected boolean hasLogicalFolder(IStructuredSelection iStructuredSelection) {
        Iterator iterator = iStructuredSelection.iterator();
        while (iterator.hasNext()) {
            if (!(iterator.next() instanceof LogicalFolder)) continue;
            return true;
        }
        return false;
    }
}

