/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.test.util;

import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.hyades.ui.internal.util.StringUtil;

public class StringUtilTest
extends TestCase {
    static /* synthetic */ Class class$org$eclipse$hyades$ui$test$util$StringUtilTest;

    public StringUtilTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite("Hyades UI String Util");
        testSuite.addTestSuite(class$org$eclipse$hyades$ui$test$util$StringUtilTest == null ? (class$org$eclipse$hyades$ui$test$util$StringUtilTest = StringUtilTest.class$("org.eclipse.hyades.ui.test.util.StringUtilTest")) : class$org$eclipse$hyades$ui$test$util$StringUtilTest);
        return testSuite;
    }

    public void testDecode() throws UnsupportedEncodingException {
        String string = "UTF-8";
        String string2 = "\u4e13a\u00e1\u00e0\u00e2\u00e4\u00e3\u4e13\u00e7\u4e13";
        byte[] byArray = string2.getBytes(string);
        Assert.assertEquals((String)string2, (String)StringUtil.decode((String)string, (byte[])byArray));
        string = "ISO-8859-1";
        string2 = "a\u00e1\u00e0\u00e2\u00e4\u00e3\u00e7";
        byArray = string2.getBytes(string);
        Assert.assertEquals((String)string2, (String)StringUtil.decode((String)string, (byte[])byArray));
        string = "Test";
        Assert.assertNull((Object)StringUtil.decode((String)string, (byte[])byArray));
    }

    public void testEncode() throws UnsupportedEncodingException {
        String string = "UTF-8";
        String string2 = "\u4e13a\u00e1\u00e0\u00e2\u00e4\u00e3\u4e13\u00e7\u4e13";
        Assert.assertTrue((boolean)Arrays.equals(string2.getBytes(string), StringUtil.encode((String)string, (String)string2)));
        string = "US-ASCII";
        Assert.assertTrue((boolean)Arrays.equals(string2.getBytes(string), StringUtil.encode((String)string, (String)string2)));
        string = "Test";
        Assert.assertNull((Object)StringUtil.encode((String)string, (String)string2));
    }

    public void testIndexOf() {
        String string = "TesT";
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = -1;
        while (n <= string.length() + 1) {
            Assert.assertEquals((String)("fromIndex: " + n), (int)stringBuffer.toString().indexOf(string, n), (int)StringUtil.indexOf((StringBuffer)stringBuffer, (String)string, (int)n));
            ++n;
        }
        string = "T";
        stringBuffer = new StringBuffer(string).append("a").append(string);
        int n2 = -1;
        while (n2 <= string.length() + 1) {
            Assert.assertEquals((String)("fromIndex: " + n2), (int)stringBuffer.toString().indexOf(string, n2), (int)StringUtil.indexOf((StringBuffer)stringBuffer, (String)string, (int)n2));
            ++n2;
        }
        string = "aa";
        stringBuffer = new StringBuffer("a");
        int n3 = -1;
        while (n3 <= string.length() + 1) {
            Assert.assertEquals((String)("fromIndex: " + n3), (int)stringBuffer.toString().indexOf(string, n3), (int)StringUtil.indexOf((StringBuffer)stringBuffer, (String)string, (int)n3));
            ++n3;
        }
        string = "aa";
        stringBuffer = new StringBuffer("aabbaaaaaccaaaaaadaaaa");
        int n4 = -1;
        while (n4 <= string.length() + 1) {
            Assert.assertEquals((String)("fromIndex: " + n4), (int)stringBuffer.toString().indexOf(string, n4), (int)StringUtil.indexOf((StringBuffer)stringBuffer, (String)string, (int)n4));
            ++n4;
        }
    }

    public void testReplace() {
        String string = "Test";
        String string2 = "es";
        String string3 = "##";
        Assert.assertEquals((String)"T##t", (String)StringUtil.replace((String)string, (String)string2, (String)string3));
        string = "Test1111111Test11111111Test111111";
        string2 = "11111";
        string3 = "a";
        Assert.assertEquals((String)"Testa11Testa111Testa1", (String)StringUtil.replace((String)string, (String)string2, (String)string3));
        string = "Testesst";
        string2 = "s";
        string3 = "";
        Assert.assertEquals((String)"Tetet", (String)StringUtil.replace((String)string, (String)string2, (String)string3));
        string = "Testesst";
        string2 = "s";
        string3 = null;
        Assert.assertEquals((String)"Tetet", (String)StringUtil.replace((String)string, (String)string2, (String)string3));
        string = "Testest";
        string2 = "est";
        string3 = "";
        Assert.assertEquals((String)"T", (String)StringUtil.replace((String)string, (String)string2, (String)string3));
        string = "Testest";
        string2 = "";
        string3 = "TT";
        Assert.assertEquals((String)"Testest", (String)StringUtil.replace((String)string, (String)string2, (String)string3));
        string = "TesT";
        string2 = "T";
        string3 = "TOT";
        Assert.assertEquals((String)"TOTesTOT", (String)StringUtil.replace((String)string, (String)string2, (String)string3));
        string = "TesT";
        string2 = "T";
        string3 = "U";
        Assert.assertEquals((String)"UesU", (String)StringUtil.replace((String)string, (String)string2, (String)string3));
        string = "Test";
        string2 = "es";
        string3 = "es#Testt#es";
        Assert.assertEquals((String)"Tes#Testt#est", (String)StringUtil.replace((String)string, (String)string2, (String)string3));
        string = "Testest";
        string2 = "Testest";
        string3 = "test";
        Assert.assertEquals((String)"test", (String)StringUtil.replace((String)string, (String)string2, (String)string3));
        string = "Testest";
        string2 = "Testest";
        string3 = "testtesttest";
        Assert.assertEquals((String)"testtesttest", (String)StringUtil.replace((String)string, (String)string2, (String)string3));
        string = "Testest";
        string2 = "123";
        string3 = "456";
        Assert.assertEquals((String)"Testest", (String)StringUtil.replace((String)string, (String)string2, (String)string3));
    }

    public void testTokenizer() {
        String string = "1a2ab3abc4abc";
        String string2 = "a";
        boolean bl = true;
        Object[] objectArray = new String[]{"1", "a", "2", "a", "b3", "a", "bc4", "a", "bc"};
        Assert.assertTrue((boolean)Arrays.equals(objectArray, StringUtil.tokenizer((String)string, (String)string2, (boolean)bl)));
        bl = false;
        objectArray = new String[]{"1", "2", "b3", "bc4", "bc"};
        Assert.assertTrue((boolean)Arrays.equals(objectArray, StringUtil.tokenizer((String)string, (String)string2, (boolean)bl)));
        string2 = "ab";
        bl = true;
        objectArray = new String[]{"1a2", "ab", "3", "ab", "c4", "ab", "c"};
        Assert.assertTrue((boolean)Arrays.equals(objectArray, StringUtil.tokenizer((String)string, (String)string2, (boolean)bl)));
        bl = false;
        objectArray = new String[]{"1a2", "3", "c4", "c"};
        Assert.assertTrue((boolean)Arrays.equals(objectArray, StringUtil.tokenizer((String)string, (String)string2, (boolean)bl)));
        string2 = "abc";
        bl = true;
        objectArray = new String[]{"1a2ab3", "abc", "4", "abc"};
        Assert.assertTrue((boolean)Arrays.equals(objectArray, StringUtil.tokenizer((String)string, (String)string2, (boolean)bl)));
        bl = false;
        objectArray = new String[]{"1a2ab3", "4"};
        Assert.assertTrue((boolean)Arrays.equals(objectArray, StringUtil.tokenizer((String)string, (String)string2, (boolean)bl)));
        string2 = "1a2";
        bl = true;
        objectArray = new String[]{"1a2", "ab3abc4abc"};
        Assert.assertTrue((boolean)Arrays.equals(objectArray, StringUtil.tokenizer((String)string, (String)string2, (boolean)bl)));
        bl = false;
        objectArray = new String[]{"ab3abc4abc"};
        Assert.assertTrue((boolean)Arrays.equals(objectArray, StringUtil.tokenizer((String)string, (String)string2, (boolean)bl)));
        string2 = "1x";
        bl = true;
        objectArray = new String[]{"1a2ab3abc4abc"};
        Assert.assertTrue((boolean)Arrays.equals(objectArray, StringUtil.tokenizer((String)string, (String)string2, (boolean)bl)));
        bl = false;
        objectArray = new String[]{"1a2ab3abc4abc"};
        Assert.assertTrue((boolean)Arrays.equals(objectArray, StringUtil.tokenizer((String)string, (String)string2, (boolean)bl)));
    }

    public void testIsDigits() {
        String string = "0123456789";
        Assert.assertTrue((boolean)StringUtil.isDigits((String)string));
        string = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
        Assert.assertFalse((boolean)StringUtil.isDigits((String)string));
        string = "0a1b2c3d4e5f6g7h8i9j";
        Assert.assertFalse((boolean)StringUtil.isDigits((String)string));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

