/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.harness;

import java.io.FileNotFoundException;
import java.net.UnknownHostException;
import java.util.HashMap;
import org.eclipse.core.internal.plugins.ConfigurationElement;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.execution.core.ExecutionComponentStateChangeEvent;
import org.eclipse.hyades.execution.core.IDataProcessor;
import org.eclipse.hyades.execution.core.IEclipseExecutionComponentFactory;
import org.eclipse.hyades.execution.core.IExecutableObject;
import org.eclipse.hyades.execution.core.IExecutionComponent;
import org.eclipse.hyades.execution.core.IExecutionComponentFactory;
import org.eclipse.hyades.execution.core.IExecutionComponentStateChangeListener;
import org.eclipse.hyades.execution.core.IExecutionEnvironment;
import org.eclipse.hyades.execution.core.IExecutor;
import org.eclipse.hyades.execution.core.INode;
import org.eclipse.hyades.execution.core.IRemoteHyadesComponent;
import org.eclipse.hyades.execution.core.ISession;
import org.eclipse.hyades.execution.core.UnknownDaemonException;
import org.eclipse.hyades.execution.harness.ExecutionHarnessPlugin;
import org.eclipse.hyades.execution.harness.IExecutableObjectAdapter;
import org.eclipse.hyades.execution.harness.IExecutionEnvironmentAdapter;
import org.eclipse.hyades.execution.harness.XMLExecutionDataProcessor;
import org.eclipse.hyades.execution.harness.util.ISystemUtility;
import org.eclipse.hyades.execution.harness.util.StandaloneExecutionUtilities;
import org.eclipse.hyades.execution.harness.util.StandaloneSystemUtility;
import org.eclipse.hyades.execution.local.EclipseExecutionComponentFactoryImpl;
import org.eclipse.hyades.execution.local.ExecutionComponentFactoryImpl;
import org.eclipse.hyades.execution.local.NodeImpl;
import org.eclipse.hyades.internal.execution.local.control.AgentControllerUnavailableException;
import org.eclipse.hyades.loaders.util.RegistryReader;
import org.eclipse.hyades.models.common.facades.behavioral.ITest;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.models.common.facades.behavioral.impl.FacadeResourceFactoryImpl;
import org.eclipse.hyades.models.common.facades.behavioral.impl.HyadesFactory;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.models.common.testprofile.impl.Common_TestprofilePackageImpl;
import org.eclipse.hyades.models.hierarchy.util.StringUtil;

public class TestExecutionHarness {
    private Object agentLock = new Object();
    private boolean bAgentReady = false;
    private static HashMap testTypeMap = null;
    private static boolean bFactoryInitialized = false;
    private static boolean bStandalone = false;
    private IExecutionComponentFactory factory;
    private ISession session;
    private INode node;
    private IExecutionEnvironment exeEnvironment;
    private IExecutableObject executableObject;
    private IExecutor executor;
    private IRemoteHyadesComponent agent;
    private String[] standaloneConfigurationFiles;
    private ISystemUtility systemUtility;

    public static void main(String[] stringArray) {
        TestExecutionHarness testExecutionHarness = new TestExecutionHarness("C:\\Hyades\\_0916_0831_workspace");
        System.out.println(testExecutionHarness.launchTest("C:\\Program Files\\eclipse 2.1\\eclipse\\runtime-workspace\\test\\src\\first.testsuite", null, "localhost", "10002", "c:\\temp", "executionresult.execution", true, true));
    }

    public TestExecutionHarness() {
        try {
            Class<?> clazz = Class.forName("org.eclipse.core.boot.BootLoader");
            bStandalone = false;
            this.systemUtility = ExecutionHarnessPlugin.getDefault();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalArgumentException("Standalone execution requires that a configuration file directory is passed to the TestExecutionHarness constructor!");
        }
    }

    public TestExecutionHarness(String string) {
        try {
            Class<?> clazz = Class.forName("org.eclipse.core.boot.BootLoader");
            bStandalone = false;
            this.systemUtility = ExecutionHarnessPlugin.getDefault();
        }
        catch (ClassNotFoundException classNotFoundException) {
            bStandalone = true;
            String[] stringArray = StandaloneExecutionUtilities.getConfigFilesFromConfigDir(string);
            this.setStandaloneConfigurationFiles(stringArray);
            String string2 = StandaloneExecutionUtilities.getHarnessDir(string);
            this.systemUtility = new StandaloneSystemUtility(string2);
            RegistryReader.standaloneConfiguration = new RegistryReader.StandaloneConfiguration();
            RegistryReader.standaloneConfiguration.setEclipseFolder(string);
            this.init();
        }
    }

    private void init() {
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("testsuite", new FacadeResourceFactoryImpl());
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("deploy", new FacadeResourceFactoryImpl());
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("execution", new FacadeResourceFactoryImpl());
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("xmi", new FacadeResourceFactoryImpl());
        Common_TestprofilePackageImpl.init();
    }

    protected void releaseAgentLock() {
        Object object = this.agentLock;
        synchronized (object) {
            this.bAgentReady = true;
            this.agentLock.notify();
        }
    }

    protected void initializeRegisteredExecutionComponents(IExecutionComponentFactory iExecutionComponentFactory, boolean bl) throws ClassNotFoundException, FileNotFoundException {
        testTypeMap = new HashMap();
        if (!bl) {
            IEclipseExecutionComponentFactory iEclipseExecutionComponentFactory = (IEclipseExecutionComponentFactory)iExecutionComponentFactory;
            IPluginRegistry iPluginRegistry = Platform.getPluginRegistry();
            IConfigurationElement[] iConfigurationElementArray = Platform.getPluginRegistry().getConfigurationElementsFor("org.eclipse.hyades.execution.harness.RegisteredExecutionComponentImpl");
            int n = 0;
            while (n < iConfigurationElementArray.length) {
                String string = iConfigurationElementArray[n].getAttribute("type");
                String string2 = iConfigurationElementArray[n].getAttribute("name");
                iEclipseExecutionComponentFactory.addExecutionComponent(iConfigurationElementArray[n]);
                Object object = testTypeMap.get(string);
                if (object == null) {
                    object = new HashMap();
                    testTypeMap.put(string, object);
                }
                HashMap hashMap = (HashMap)object;
                IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElementArray[n].getChildren("SupportedTestType");
                int n2 = 0;
                while (n2 < iConfigurationElementArray2.length) {
                    hashMap.put(iConfigurationElementArray2[n2].getAttribute("name"), string2);
                    ++n2;
                }
                ++n;
            }
            this.mapAdapterClasses("org.eclipse.hyades.execution.harness.ExecutionEnvironmentAdapter", "EXECUTION_ENVIRONMENT_ADAPTER", bl);
            this.mapAdapterClasses("org.eclipse.hyades.execution.harness.ExecutableObjectAdapter", "EXECUTABLE_OBJECT_ADAPTER", bl);
        } else {
            StandaloneExecutionUtilities.initializeRegisteredExecutionComponents(this.standaloneConfigurationFiles, testTypeMap, iExecutionComponentFactory);
        }
    }

    private void mapAdapterClasses(String string, String string2, boolean bl) {
        if (!bl) {
            IConfigurationElement[] iConfigurationElementArray = Platform.getPluginRegistry().getConfigurationElementsFor(string);
            int n = 0;
            while (n < iConfigurationElementArray.length) {
                String string3 = iConfigurationElementArray[n].getAttribute("class");
                Object object = testTypeMap.get(string2);
                if (object == null) {
                    object = new HashMap();
                    testTypeMap.put(string2, object);
                }
                HashMap hashMap = (HashMap)object;
                IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElementArray[n].getChildren("SupportedTestType");
                int n2 = 0;
                while (n2 < iConfigurationElementArray2.length) {
                    hashMap.put(iConfigurationElementArray2[n2].getAttribute("name"), iConfigurationElementArray[n]);
                    ++n2;
                }
                ++n;
            }
        }
    }

    protected String getExecutionComponentForTestType(String string, String string2, boolean bl) throws ClassNotFoundException {
        Object object;
        Object v = testTypeMap.get(string);
        if (v != null && v instanceof HashMap && (v = ((HashMap)(object = (HashMap)v)).get(string2)) != null && v instanceof String) {
            return (String)v;
        }
        object = this.systemUtility.getString("EXEC_NOT_FOUND_ERR_");
        object = StringUtil.change((String)object, (String)"%1", (String)string);
        object = StringUtil.change((String)object, (String)"%2", (String)string2);
        throw new ClassNotFoundException((String)object);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized String launchTest(ITestSuite iTestSuite, ITest iTest, String string, String string2, String string3, String string4, boolean bl, boolean bl2) {
        block11: {
            String string5;
            block12: {
                String string6;
                block10: {
                    this.factory = null;
                    this.session = null;
                    this.exeEnvironment = null;
                    this.executableObject = null;
                    this.executor = null;
                    this.agent = null;
                    this.node = null;
                    String string7 = iTest.getType();
                    String string8 = string;
                    StringBuffer stringBuffer = new StringBuffer();
                    this.session = this.sessionConnect(string2, this.session, string8, stringBuffer);
                    if (this.session == null) {
                        return stringBuffer.toString();
                    }
                    try {
                        try {
                            this.factory = bl2 ? ExecutionComponentFactoryImpl.getInstance((ISession)this.session) : EclipseExecutionComponentFactoryImpl.getInstance((ISession)this.session);
                            if (!bFactoryInitialized) {
                                this.initializeRegisteredExecutionComponents(this.factory, bl2);
                            }
                            String string9 = this.getExecutionComponentForTestType("ENVIRONMENT", string7, bl2);
                            this.exeEnvironment = (IExecutionEnvironment)this.factory.createExecutionComponentByType(string9);
                            this.session.addChild((IExecutionComponent)this.exeEnvironment);
                            if (!this.adaptExecutionEnvironment(iTestSuite, iTest, bl2, string7, stringBuffer)) {
                                string6 = stringBuffer.toString();
                                Object var19_17 = null;
                                break block10;
                            }
                            String string10 = this.getExecutionComponentForTestType("EXECUTOR", string7, bl2);
                            this.executor = (IExecutor)this.factory.createExecutionComponentByType(string10);
                            this.exeEnvironment.addChild((IExecutionComponent)this.executor);
                            String string11 = this.getExecutionComponentForTestType("AGENT", string7, bl2);
                            this.agent = (IRemoteHyadesComponent)this.factory.createExecutionComponentByType(string11);
                            this.executor.addChild((IExecutionComponent)this.agent);
                            this.agent.startMonitoring((IDataProcessor)new XMLExecutionDataProcessor(null, (TPFTestSuite)iTestSuite, string3, string4));
                            this.agent.addExecutionComponentStateChangeListener(new IExecutionComponentStateChangeListener(){

                                public void stateChanged(ExecutionComponentStateChangeEvent executionComponentStateChangeEvent) {
                                    if (executionComponentStateChangeEvent.getState() == 2) {
                                        TestExecutionHarness.this.releaseAgentLock();
                                    }
                                }
                            });
                            String string12 = this.getExecutionComponentForTestType("EXECUTABLEOBJECT", string7, bl2);
                            this.executableObject = this.executor.getCompatibleExecutableObject(string12);
                            if (this.executableObject == null) break block11;
                            if (!this.adaptExecutableObject(iTestSuite, iTest, bl2, string7, stringBuffer)) {
                                string5 = stringBuffer.toString();
                                break block12;
                            }
                            this.executor.setExecutableObject(this.executableObject);
                            this.waitForActiveAgent();
                            this.executor.launch();
                            break block11;
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            this.systemUtility.logError(classNotFoundException);
                            String string13 = StringUtil.change((String)this.systemUtility.getString("CLASS_NOT_FOUND_ERR_"), (String)"%1", (String)classNotFoundException.getMessage());
                            Object var19_20 = null;
                            this.session.release();
                            return string13;
                        }
                        catch (Throwable throwable) {
                            this.systemUtility.logError(throwable);
                            String string14 = throwable.getMessage();
                            Object var19_21 = null;
                            this.session.release();
                            return string14;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var19_22 = null;
                        this.session.release();
                        throw throwable;
                    }
                }
                this.session.release();
                return string6;
            }
            Object var19_18 = null;
            this.session.release();
            return string5;
        }
        Object var19_19 = null;
        this.session.release();
        return null;
    }

    private void waitForActiveAgent() {
        int n = this.executor.getState();
        if (this.agent.getState() == 3) {
            while (!this.bAgentReady) {
                Object object = this.agentLock;
                synchronized (object) {
                    try {
                        this.agentLock.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private Object getAdapterInstance(String string, String string2, boolean bl) throws ClassNotFoundException {
        Object object;
        Object v = testTypeMap.get(string);
        if (v != null && v instanceof HashMap) {
            object = (HashMap)v;
            v = ((HashMap)object).get(string2);
            try {
                if (bl) {
                    if (v != null && v instanceof String) {
                        return Class.forName((String)v).newInstance();
                    }
                } else if (v != null && v instanceof ConfigurationElement) {
                    return ((ConfigurationElement)v).createExecutableExtension("class");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        object = this.systemUtility.getString("EXEC_NOT_FOUND_ERR_");
        object = StringUtil.change((String)object, (String)"%1", (String)string);
        object = StringUtil.change((String)object, (String)"%2", (String)string2);
        throw new ClassNotFoundException((String)object);
    }

    private boolean adaptExecutableObject(ITestSuite iTestSuite, ITest iTest, boolean bl, String string, StringBuffer stringBuffer) {
        IExecutableObjectAdapter iExecutableObjectAdapter = null;
        try {
            iExecutableObjectAdapter = (IExecutableObjectAdapter)this.getAdapterInstance("EXECUTABLE_OBJECT_ADAPTER", string, bl);
        }
        catch (Exception exception) {
            this.systemUtility.logError(exception);
            stringBuffer.append(StringUtil.change((String)this.systemUtility.getString("EXEC_ENV_ERR_"), (String)"%1", (String)string));
            return false;
        }
        if (iExecutableObjectAdapter != null) {
            iExecutableObjectAdapter.setupExecutableObject(this.executableObject, (TPFTestSuite)iTestSuite, (TPFTest)iTest);
        }
        return true;
    }

    private boolean adaptExecutionEnvironment(ITestSuite iTestSuite, ITest iTest, boolean bl, String string, StringBuffer stringBuffer) {
        IExecutionEnvironmentAdapter iExecutionEnvironmentAdapter = null;
        try {
            iExecutionEnvironmentAdapter = (IExecutionEnvironmentAdapter)this.getAdapterInstance("EXECUTION_ENVIRONMENT_ADAPTER", string, bl);
        }
        catch (Exception exception) {
            this.systemUtility.logError(exception);
            stringBuffer.append(StringUtil.change((String)this.systemUtility.getString("EXEC_ENV_ERR_"), (String)"%1", (String)string));
            return false;
        }
        if (iExecutionEnvironmentAdapter != null) {
            iExecutionEnvironmentAdapter.setupExecutionEnvironment(this.exeEnvironment, (TPFTestSuite)iTestSuite, (TPFTest)iTest);
        }
        return true;
    }

    private ISession sessionConnect(String string, ISession iSession, String string2, StringBuffer stringBuffer) {
        stringBuffer.setLength(0);
        try {
            NodeImpl nodeImpl = new NodeImpl(string2);
            iSession = nodeImpl.connect(string, null);
        }
        catch (UnknownHostException unknownHostException) {
            stringBuffer.append(StringUtil.change((String)this.systemUtility.getString("TIMEOUT_NODE_ERROR_"), (String)"%1", (String)string2));
        }
        catch (AgentControllerUnavailableException agentControllerUnavailableException) {
            stringBuffer.append(StringUtil.change((String)this.systemUtility.getString("AGENT_UNAV_ERROR_"), (String)"%1", (String)string2));
        }
        catch (UnknownDaemonException unknownDaemonException) {
            stringBuffer.append(StringUtil.change((String)this.systemUtility.getString("AGENT_UNAV_ERROR_"), (String)"%1", (String)string2));
        }
        catch (Exception exception) {
            this.systemUtility.logError(exception);
            stringBuffer.append(StringUtil.change((String)this.systemUtility.getString("RUN_FAILED_ERR_"), (String)"%1", (String)string2));
        }
        return iSession;
    }

    public String launchTest(String string, String string2, String string3, String string4, String string5, String string6, boolean bl, boolean bl2) {
        Object object = null;
        ITestSuite iTestSuite = null;
        try {
            iTestSuite = HyadesFactory.INSTANCE.loadTestSuite(string);
        }
        catch (Exception exception) {
            this.systemUtility.logError(exception);
            return StringUtil.change((String)this.systemUtility.getString("LOAD_SUITE_ERR_"), (String)"%1", (String)string);
        }
        object = string2 != null && string2.length() != 0 ? (ITest)HyadesFactory.INSTANCE.getObjectByID(iTestSuite, string2) : iTestSuite;
        return this.launchTest(iTestSuite, (ITest)object, string3, string4, string5, string6, bl, bl2);
    }

    private String[] getStandaloneConfigurationFiles() {
        return this.standaloneConfigurationFiles;
    }

    private void setStandaloneConfigurationFiles(String[] stringArray) {
        this.standaloneConfigurationFiles = stringArray;
    }
}

