/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.harness.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.hyades.execution.core.IExecutionComponentFactory;
import org.eclipse.hyades.execution.harness.util.XMLUtil;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class StandaloneExecutionUtilities {
    public static void initializeRegisteredExecutionComponents(String[] stringArray, HashMap hashMap, IExecutionComponentFactory iExecutionComponentFactory) throws ClassNotFoundException, FileNotFoundException {
        int n = 0;
        while (n < stringArray.length) {
            StandaloneExecutionUtilities.parseConfigFile(stringArray[n], hashMap, iExecutionComponentFactory);
            ++n;
        }
    }

    private static void parseConfigFile(String string, HashMap hashMap, IExecutionComponentFactory iExecutionComponentFactory) throws ClassNotFoundException, FileNotFoundException {
        FileInputStream fileInputStream = new FileInputStream(string);
        Element element = XMLUtil.loadDom(fileInputStream, "plugin");
        NodeList nodeList = XMLUtil.getChildrenByName(element, "extension");
        if (nodeList != null) {
            int n = 0;
            while (n < nodeList.getLength()) {
                Element element2;
                if (nodeList.item(n) instanceof Element && (element2 = (Element)nodeList.item(n)) != null) {
                    int n2;
                    NodeList nodeList2;
                    if (element2.getAttribute("point").equals("org.eclipse.hyades.execution.harness.RegisteredExecutionComponentImpl")) {
                        nodeList2 = XMLUtil.getChildrenByName(element2, "RegisteredExecutionComponentImpl");
                        n2 = 0;
                        while (n2 < nodeList2.getLength()) {
                            if (nodeList2.item(n2) instanceof Element) {
                                StandaloneExecutionUtilities.parseRegisteredExecutionComponents((Element)nodeList2.item(n2), hashMap, iExecutionComponentFactory);
                            }
                            ++n2;
                        }
                    }
                    if (element2.getAttribute("point").equals("org.eclipse.hyades.execution.harness.ExecutionEnvironmentAdapter")) {
                        nodeList2 = XMLUtil.getChildrenByName(element2, "ExecutionEnvironmentAdapter");
                        n2 = 0;
                        while (n2 < nodeList2.getLength()) {
                            if (nodeList2.item(n2) instanceof Element) {
                                StandaloneExecutionUtilities.parseAdapters((Element)nodeList2.item(n2), hashMap, iExecutionComponentFactory, "EXECUTION_ENVIRONMENT_ADAPTER");
                            }
                            ++n2;
                        }
                    }
                    if (element2.getAttribute("point").equals("org.eclipse.hyades.execution.harness.ExecutableObjectAdapter")) {
                        nodeList2 = XMLUtil.getChildrenByName(element2, "ExecutableObjectAdapter");
                        n2 = 0;
                        while (n2 < nodeList2.getLength()) {
                            if (nodeList2.item(n2) instanceof Element) {
                                StandaloneExecutionUtilities.parseAdapters((Element)nodeList2.item(n2), hashMap, iExecutionComponentFactory, "EXECUTABLE_OBJECT_ADAPTER");
                            }
                            ++n2;
                        }
                    }
                }
                ++n;
            }
        }
    }

    private static void parseRegisteredExecutionComponents(Element element, HashMap hashMap, IExecutionComponentFactory iExecutionComponentFactory) throws ClassNotFoundException {
        String string = element.getAttribute("type");
        String string2 = element.getAttribute("name");
        iExecutionComponentFactory.addExecutionComponent(string2, element.getAttribute("implClass"));
        iExecutionComponentFactory.addStub(string2, element.getAttribute("stubClass"));
        iExecutionComponentFactory.addSkeleton(string2, element.getAttribute("skeletonClass"));
        Object object = hashMap.get(string);
        if (object == null) {
            object = new HashMap();
            hashMap.put(string, object);
        }
        HashMap hashMap2 = (HashMap)object;
        NodeList nodeList = XMLUtil.getChildrenByName(element, "SupportedTestType");
        int n = 0;
        while (n < nodeList.getLength()) {
            if (nodeList.item(n) instanceof Element) {
                Element element2 = (Element)nodeList.item(n);
                hashMap2.put(element2.getAttribute("name"), string2);
            }
            ++n;
        }
    }

    private static void parseAdapters(Element element, HashMap hashMap, IExecutionComponentFactory iExecutionComponentFactory, String string) throws ClassNotFoundException {
        String string2 = element.getAttribute("class");
        Object object = hashMap.get(string);
        if (object == null) {
            object = new HashMap();
            hashMap.put(string, object);
        }
        HashMap hashMap2 = (HashMap)object;
        NodeList nodeList = XMLUtil.getChildrenByName(element, "SupportedTestType");
        int n = 0;
        while (n < nodeList.getLength()) {
            if (nodeList.item(n) instanceof Element) {
                Element element2 = (Element)nodeList.item(n);
                hashMap2.put(element2.getAttribute("name"), string2);
            }
            ++n;
        }
    }

    public static String[] getConfigFilesFromConfigDir(String string) {
        File file = new File(string);
        if (!file.isDirectory()) {
            return null;
        }
        string = file.getAbsolutePath();
        file = new File(string = string + File.separator + "plugins");
        if (!file.isDirectory()) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = file.list();
        int n = 0;
        while (n < stringArray.length) {
            String string2 = string + File.separator + stringArray[n];
            File file2 = new File(string2);
            if (file2.isDirectory() && (file2 = new File(string2 = string2 + File.separator + "plugin.xml")).exists()) {
                arrayList.add(string2);
            }
            ++n;
        }
        return arrayList.toArray(new String[0]);
    }

    public static String getHarnessDir(String string) {
        File file = new File(string);
        if (!file.isDirectory()) {
            return null;
        }
        string = file.getAbsolutePath();
        String string2 = string + File.separator + "plugins" + File.separator + "org.eclipse.hyades.execution.harness";
        File file2 = new File(string2);
        if (file2.isDirectory()) {
            return string2;
        }
        return null;
    }
}

