package httpRecorder.proxy;

/*
 * Disclaimer:
 * The following source code is sample code created by IBM Corporation. 
 * This sample code is not part of any standard IBM product and is provided 
 * to you solely for the purpose of assisting you in the development of your 
 * applications. The code is provided 'AS IS', without warranty or condition 
 * of any kind. IBM shall not be liable for any damages arising out of your 
 * use of the sample code, even if IBM has been advised of the possibility of 
 * such damages.
 */

/**
 * HTTP request and response header.
 */

public class HttpHeader
{
	public static final String VALUE_TOKEN = ": ";
		 
	private String name;
	private String value;
	
	private HttpElement element;
	
	public HttpHeader(String line)
	{
		int index = line.indexOf(VALUE_TOKEN);
		if(index >= 0)
		{
			name = line.substring(0, index);
			
			if(index < line.length())
				value = line.substring(index+VALUE_TOKEN.length());
		}
	}
	
	public String getName()
	{
		return name;
	}
	
	public String getValue()
	{
		return value;
	}	
	
	void setElement(HttpElement element)
	{
		this.element = element;
	}
	
	public HttpElement getElement()
	{
		return element;
	}
	
	public String toString()
	{
		return name + ((value != null)?(VALUE_TOKEN + value):"");
	}
}
