/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.dialog;

import java.util.Vector;
import org.eclipse.hyades.models.common.datapool.DPLDatapool;
import org.eclipse.hyades.models.common.datapool.DPLEquivalenceClass;
import org.eclipse.hyades.models.common.datapool.DPLRecord;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class DataPoolRowDialog
extends Dialog {
    private static final String TAG_EQUIVALENCE_CLASSES = "equivalenceClasses";
    private static final String TAG_EQUIVALENCE_CLASS = "equivalenceClass";
    private static final String TAG_RECORD = "record";
    private static final int HEIGHT = 40;
    private static final int WIDTH = 380;
    private Shell shell = null;
    private DPLDatapool datapool = null;
    private String title = null;
    private boolean insertionMode = false;
    private Table table = null;
    private TableItem previousTableItem = null;
    private TableItem selectedTableItem = null;
    private Combo equivalenceClassCombo = null;
    private Combo recordIndexCombo = null;
    private int insertionEquivalenceClassIndex = -1;
    private int insertionRecordIndex = -1;
    private TableItem insertionTableItem = null;
    private SelectionListener equivalenceClassListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            DPLEquivalenceClass dPLEquivalenceClass = null;
            Combo combo = (Combo)selectionEvent.widget;
            DataPoolRowDialog.this.insertionEquivalenceClassIndex = combo.getSelectionIndex();
            DPLEquivalenceClass[] dPLEquivalenceClassArray = (DPLEquivalenceClass[])combo.getData(DataPoolRowDialog.TAG_EQUIVALENCE_CLASSES);
            dPLEquivalenceClass = dPLEquivalenceClassArray[DataPoolRowDialog.this.insertionEquivalenceClassIndex];
            String[] stringArray = DataPoolRowDialog.this.getRecordIndexLabels(dPLEquivalenceClass);
            DataPoolRowDialog.this.recordIndexCombo.setItems(stringArray);
            DataPoolRowDialog.this.recordIndexCombo.select(0);
            if (dPLEquivalenceClass != null) {
                String string = DataPoolRowDialog.this.recordIndexCombo.getText();
                Integer n = new Integer(string);
                DataPoolRowDialog.this.insertionRecordIndex = n;
            } else {
                DataPoolRowDialog.this.insertionRecordIndex = -1;
            }
            DataPoolRowDialog.this.recordIndexCombo.setData(DataPoolRowDialog.TAG_EQUIVALENCE_CLASS, (Object)dPLEquivalenceClass);
            DataPoolRowDialog.this.enableOK();
        }
    };
    private SelectionListener recordIndexListener = new SelectionAdapter(){

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void widgetSelected(SelectionEvent selectionEvent) {
            Combo combo = (Combo)selectionEvent.widget;
            String string = combo.getText();
            try {
                try {
                    Integer n = new Integer(string);
                    DataPoolRowDialog.this.insertionRecordIndex = n;
                }
                catch (NumberFormatException numberFormatException) {
                    DataPoolRowDialog.this.insertionRecordIndex = -1;
                    Object var6_7 = null;
                    DataPoolRowDialog.this.enableOK();
                    return;
                }
                Object var6_6 = null;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                DataPoolRowDialog.this.enableOK();
                throw throwable;
            }
            DataPoolRowDialog.this.enableOK();
        }
    };

    public DataPoolRowDialog(Shell shell, DPLDatapool dPLDatapool, Table table, TableItem tableItem, TableItem tableItem2, String string) {
        super(shell);
        this.shell = shell;
        this.datapool = dPLDatapool;
        this.title = string;
        this.table = table;
        this.selectedTableItem = tableItem;
        this.previousTableItem = tableItem2;
        if (string.equals(TestUIPlugin.getString("DATA_ROW_DLG_TITLE_INS"))) {
            this.insertionMode = true;
        }
    }

    protected Control createContents(Composite composite) {
        Control control = super.createContents(composite);
        this.enableOK();
        return control;
    }

    protected Control createDialogArea(Composite composite) {
        this.getShell().setText(this.title);
        Composite composite2 = (Composite)super.createDialogArea(composite);
        GridData gridData = GridDataUtil.createFill();
        gridData.heightHint = 40;
        gridData.widthHint = 380;
        composite2.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 0);
        if (this.insertionMode) {
            label.setText(TestUIPlugin.getString("DATA_ROW_DLG_INS"));
        } else {
            label.setText(TestUIPlugin.getString("DATA_ROW_DLG_MOVE"));
        }
        this.equivalenceClassCombo = new Combo(composite2, 12);
        DPLEquivalenceClass[] dPLEquivalenceClassArray = this.getEquivalenceClasses(null);
        String[] stringArray = this.getEquivalenceClassLabels(dPLEquivalenceClassArray);
        this.equivalenceClassCombo.setItems(stringArray);
        this.equivalenceClassCombo.setData(TAG_EQUIVALENCE_CLASSES, (Object)dPLEquivalenceClassArray);
        gridData = new GridData(256);
        gridData.horizontalSpan = 1;
        gridData.widthHint = 150;
        this.equivalenceClassCombo.setLayoutData((Object)gridData);
        this.equivalenceClassCombo.addSelectionListener(this.equivalenceClassListener);
        Label label2 = new Label(composite2, 0);
        label2.setText(TestUIPlugin.getString("DATA_ROW_DLG_INDEX"));
        DPLEquivalenceClass dPLEquivalenceClass = null;
        DPLRecord dPLRecord = null;
        DPLEquivalenceClass dPLEquivalenceClass2 = null;
        DPLRecord dPLRecord2 = null;
        if (this.selectedTableItem != null) {
            dPLEquivalenceClass = (DPLEquivalenceClass)this.selectedTableItem.getData(TAG_EQUIVALENCE_CLASS);
            dPLRecord = (DPLRecord)this.selectedTableItem.getData(TAG_RECORD);
        }
        if (this.previousTableItem != null) {
            dPLEquivalenceClass2 = (DPLEquivalenceClass)this.previousTableItem.getData(TAG_EQUIVALENCE_CLASS);
            dPLRecord2 = (DPLRecord)this.previousTableItem.getData(TAG_RECORD);
        }
        String[] stringArray2 = null;
        stringArray2 = this.insertionMode ? this.getRecordIndexLabels(dPLEquivalenceClass2) : this.getRecordIndexLabels(dPLEquivalenceClass);
        this.recordIndexCombo = new Combo(composite2, 12);
        if (stringArray2 != null) {
            this.recordIndexCombo.setItems(stringArray2);
        }
        this.recordIndexCombo.setData(TAG_EQUIVALENCE_CLASS, (Object)dPLEquivalenceClass2);
        gridData = new GridData(256);
        gridData.horizontalSpan = 1;
        gridData.widthHint = 55;
        this.recordIndexCombo.setLayoutData((Object)gridData);
        this.recordIndexCombo.addSelectionListener(this.recordIndexListener);
        if (!(this.insertionMode || dPLEquivalenceClass2 != null && dPLEquivalenceClass2.equals(dPLEquivalenceClass))) {
            int n = this.datapool.getEquivalenceClasses().indexOf(dPLEquivalenceClass);
            if (n != -1) {
                this.equivalenceClassCombo.select(n);
                this.insertionEquivalenceClassIndex = n;
            }
            this.recordIndexCombo.select(this.recordIndexCombo.getItemCount() - 1);
            this.insertionRecordIndex = -1;
        } else {
            int n = this.datapool.getEquivalenceClasses().indexOf(dPLEquivalenceClass2);
            int n2 = dPLEquivalenceClass2.getRecord().indexOf(dPLRecord2);
            if (n2 != -1) {
                this.recordIndexCombo.select(n2);
                this.insertionRecordIndex = n2;
            }
            if (n != -1) {
                this.equivalenceClassCombo.select(n);
                this.insertionEquivalenceClassIndex = n;
            }
        }
        return composite2;
    }

    private boolean enableOK() {
        this.getButton(0).setEnabled(true);
        return true;
    }

    private DPLEquivalenceClass[] getEquivalenceClasses(String string) {
        Object object;
        int n = this.datapool.getEquivalenceClasses().size();
        Vector<DPLEquivalenceClass> vector = new Vector<DPLEquivalenceClass>();
        int n2 = 0;
        while (n2 < n) {
            DPLEquivalenceClass dPLEquivalenceClass = (DPLEquivalenceClass)this.datapool.getEquivalenceClasses().get(n2);
            object = dPLEquivalenceClass.getId();
            if (!((String)object).equals(string)) {
                vector.add(dPLEquivalenceClass);
            }
            ++n2;
        }
        int n3 = vector.size();
        object = new DPLEquivalenceClass[n3];
        vector.toArray((T[])object);
        return object;
    }

    private String[] getEquivalenceClassLabels(DPLEquivalenceClass[] dPLEquivalenceClassArray) {
        if (dPLEquivalenceClassArray == null) {
            return null;
        }
        int n = dPLEquivalenceClassArray.length;
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            DPLEquivalenceClass dPLEquivalenceClass = dPLEquivalenceClassArray[n2];
            stringArray[n2] = dPLEquivalenceClass.getName();
            ++n2;
        }
        return stringArray;
    }

    private String[] getRecordIndexLabels(DPLEquivalenceClass dPLEquivalenceClass) {
        int n = 0;
        if (dPLEquivalenceClass != null) {
            n = dPLEquivalenceClass.getRecord().size();
        }
        String[] stringArray = new String[n + 1];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = String.valueOf(n2);
            ++n2;
        }
        stringArray[n] = TestUIPlugin.getString("DATA_ROW_DLG_HEAD_INDEX_VAR");
        return stringArray;
    }

    private int findEquivalenceClassIndexInCombo(DPLEquivalenceClass[] dPLEquivalenceClassArray, DPLEquivalenceClass dPLEquivalenceClass) {
        if (dPLEquivalenceClassArray == null || dPLEquivalenceClass == null) {
            return -1;
        }
        int n = 0;
        while (n < dPLEquivalenceClassArray.length) {
            if (dPLEquivalenceClassArray[n].equals(dPLEquivalenceClass)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int getInsertionEquivalenceClassIndex() {
        return this.insertionEquivalenceClassIndex;
    }

    public int getInsertionRecordIndex() {
        return this.insertionRecordIndex;
    }
}

