/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.editor.form.base;

import java.io.InputStream;
import java.util.Hashtable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.editor.form.base.AbstractSectionForm;
import org.eclipse.hyades.test.ui.internal.editor.form.base.FormEngineLayout;
import org.eclipse.hyades.test.ui.internal.editor.form.base.HyperlinkAction;
import org.eclipse.hyades.test.ui.internal.editor.form.base.HyperlinkSettings;
import org.eclipse.hyades.test.ui.internal.editor.form.base.IHyperlinkSegment;
import org.eclipse.hyades.test.ui.internal.editor.form.base.IParagraph;
import org.eclipse.hyades.test.ui.internal.editor.form.base.ITextSegment;
import org.eclipse.hyades.test.ui.internal.editor.form.base.Locator;
import org.eclipse.hyades.test.ui.internal.editor.form.base.TextModel;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class FormEngine
extends Canvas {
    public static final String URL_HANDLER_ID = "urlHandler";
    boolean hasFocus;
    boolean paragraphsSeparated = true;
    TextModel model;
    Hashtable objectTable = new Hashtable();
    public int marginWidth = 0;
    public int marginHeight = 1;
    IHyperlinkSegment entered;
    boolean mouseDown = false;
    Point dragOrigin;
    private Action openAction;
    private Action copyShortcutAction;

    public boolean getFocus() {
        return this.hasFocus;
    }

    public int getParagraphSpacing(int n) {
        return n / 2;
    }

    public void setParagraphsSeparated(boolean bl) {
        this.paragraphsSeparated = bl;
    }

    public FormEngine(Composite composite, int n) {
        super(composite, n);
        this.setLayout(new FormEngineLayout());
        this.model = new TextModel();
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                FormEngine.this.model.dispose();
            }
        });
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                FormEngine.this.paint(paintEvent);
            }
        });
        this.addListener(1, new Listener(){

            public void handleEvent(Event event) {
                if (event.character == '\r') {
                    FormEngine.this.activateSelectedLink();
                    return;
                }
            }
        });
        this.addListener(31, new Listener(){

            public void handleEvent(Event event) {
                switch (event.detail) {
                    case 32: 
                    case 64: 
                    case 256: 
                    case 512: {
                        event.doit = false;
                        return;
                    }
                }
                if (!FormEngine.this.model.hasFocusSegments()) {
                    event.doit = true;
                    return;
                }
                if (event.detail == 16) {
                    event.doit = FormEngine.this.advance(true);
                } else if (event.detail == 8) {
                    event.doit = FormEngine.this.advance(false);
                } else if (event.detail != 4) {
                    event.doit = true;
                }
            }
        });
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                if (!FormEngine.this.hasFocus) {
                    FormEngine.this.hasFocus = true;
                    FormEngine.this.handleFocusChange();
                }
            }

            public void focusLost(FocusEvent focusEvent) {
                if (FormEngine.this.hasFocus) {
                    FormEngine.this.hasFocus = false;
                    FormEngine.this.handleFocusChange();
                }
            }
        });
        this.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent mouseEvent) {
            }

            public void mouseDown(MouseEvent mouseEvent) {
                FormEngine.this.handleMouseClick(mouseEvent, true);
            }

            public void mouseUp(MouseEvent mouseEvent) {
                FormEngine.this.handleMouseClick(mouseEvent, false);
            }
        });
        this.addMouseTrackListener(new MouseTrackListener(){

            public void mouseEnter(MouseEvent mouseEvent) {
                FormEngine.this.handleMouseMove(mouseEvent);
            }

            public void mouseExit(MouseEvent mouseEvent) {
                if (FormEngine.this.entered != null) {
                    FormEngine.this.exitLink(FormEngine.this.entered);
                    FormEngine.this.paintLinkHover(FormEngine.this.entered, false);
                    FormEngine.this.entered = null;
                    FormEngine.this.setCursor(null);
                }
            }

            public void mouseHover(MouseEvent mouseEvent) {
                FormEngine.this.handleMouseHover(mouseEvent);
            }
        });
        this.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent mouseEvent) {
                FormEngine.this.handleMouseMove(mouseEvent);
            }
        });
        this.initAccessible();
        this.makeActions();
    }

    private void makeActions() {
        this.openAction = new Action(){

            public void run() {
                FormEngine.this.activateSelectedLink();
            }
        };
        this.openAction.setText(TestUIPlugin.getString("FormEgine.linkPopup.open"));
        this.copyShortcutAction = new Action(){

            public void run() {
                FormEngine.this.copyShortcut(FormEngine.this.getSelectedLink());
            }
        };
        this.copyShortcutAction.setText(TestUIPlugin.getString("FormEgine.linkPopup.copyShortcut"));
    }

    protected String getAcessibleText() {
        return this.model.getAccessibleText();
    }

    private void initAccessible() {
        Accessible accessible = this.getAccessible();
        accessible.addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent accessibleEvent) {
                accessibleEvent.result = FormEngine.this.getAcessibleText();
            }

            public void getHelp(AccessibleEvent accessibleEvent) {
                accessibleEvent.result = FormEngine.this.getToolTipText();
            }
        });
        accessible.addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getChildAtPoint(AccessibleControlEvent accessibleControlEvent) {
                Point point = FormEngine.this.toControl(new Point(accessibleControlEvent.x, accessibleControlEvent.y));
                accessibleControlEvent.childID = FormEngine.this.getBounds().contains(point) ? -1 : -2;
            }

            public void getLocation(AccessibleControlEvent accessibleControlEvent) {
                Rectangle rectangle = FormEngine.this.getBounds();
                Point point = FormEngine.this.toDisplay(new Point(rectangle.x, rectangle.y));
                accessibleControlEvent.x = point.x;
                accessibleControlEvent.y = point.y;
                accessibleControlEvent.width = rectangle.width;
                accessibleControlEvent.height = rectangle.height;
            }

            public void getChildCount(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.detail = 0;
            }

            public void getRole(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.detail = 42;
            }

            public void getState(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.detail = 64;
            }
        });
    }

    protected void handleMouseClick(MouseEvent mouseEvent, boolean bl) {
        if (bl) {
            IHyperlinkSegment iHyperlinkSegment = this.model.findHyperlinkAt(mouseEvent.x, mouseEvent.y);
            if (iHyperlinkSegment != null) {
                IHyperlinkSegment iHyperlinkSegment2 = this.model.getSelectedLink();
                this.model.selectLink(iHyperlinkSegment);
                this.enterLink(iHyperlinkSegment);
                this.paintFocusTransfer(iHyperlinkSegment2, iHyperlinkSegment);
            }
            this.mouseDown = true;
            this.dragOrigin = new Point(mouseEvent.x, mouseEvent.y);
        } else {
            IHyperlinkSegment iHyperlinkSegment;
            if (mouseEvent.button == 1 && (iHyperlinkSegment = this.model.findHyperlinkAt(mouseEvent.x, mouseEvent.y)) != null) {
                this.activateLink(iHyperlinkSegment);
            }
            this.mouseDown = false;
        }
    }

    protected void handleMouseHover(MouseEvent mouseEvent) {
    }

    protected void handleMouseMove(MouseEvent mouseEvent) {
        if (this.mouseDown) {
            this.handleDrag(mouseEvent);
            return;
        }
        ITextSegment iTextSegment = this.model.findSegmentAt(mouseEvent.x, mouseEvent.y);
        if (iTextSegment == null) {
            if (this.entered != null) {
                this.exitLink(this.entered);
                this.paintLinkHover(this.entered, false);
                this.entered = null;
            }
            this.setCursor(null);
        } else if (iTextSegment instanceof IHyperlinkSegment) {
            IHyperlinkSegment iHyperlinkSegment = (IHyperlinkSegment)iTextSegment;
            if (this.entered == null) {
                this.entered = iHyperlinkSegment;
                this.enterLink(iHyperlinkSegment);
                this.paintLinkHover(this.entered, true);
                this.setCursor(this.model.getHyperlinkSettings().getHyperlinkCursor());
            }
        } else {
            if (this.entered != null) {
                this.exitLink(this.entered);
                this.paintLinkHover(this.entered, false);
                this.entered = null;
            }
            this.setCursor(this.model.getHyperlinkSettings().getTextCursor());
        }
    }

    private void handleDrag(MouseEvent mouseEvent) {
    }

    public HyperlinkSettings getHyperlinkSettings() {
        return this.model.getHyperlinkSettings();
    }

    public void setHyperlinkSettings(HyperlinkSettings hyperlinkSettings) {
        this.model.setHyperlinkSettings(hyperlinkSettings);
    }

    protected boolean advance(boolean bl) {
        IHyperlinkSegment iHyperlinkSegment = this.model.getSelectedLink();
        if (iHyperlinkSegment != null) {
            this.exitLink(iHyperlinkSegment);
        }
        boolean bl2 = this.model.traverseLinks(bl);
        IHyperlinkSegment iHyperlinkSegment2 = this.model.getSelectedLink();
        if (bl2) {
            this.enterLink(iHyperlinkSegment2);
        }
        this.paintFocusTransfer(iHyperlinkSegment, iHyperlinkSegment2);
        if (iHyperlinkSegment2 != null) {
            this.ensureVisible(iHyperlinkSegment2);
        }
        return !bl2;
    }

    public IHyperlinkSegment getSelectedLink() {
        return this.model.getSelectedLink();
    }

    protected void handleFocusChange() {
        if (this.hasFocus) {
            this.model.traverseLinks(true);
            this.enterLink(this.model.getSelectedLink());
            this.paintFocusTransfer(null, this.model.getSelectedLink());
        } else {
            this.paintFocusTransfer(this.model.getSelectedLink(), null);
            this.model.selectLink(null);
        }
    }

    private void enterLink(IHyperlinkSegment iHyperlinkSegment) {
        if (iHyperlinkSegment == null) {
            return;
        }
        HyperlinkAction hyperlinkAction = iHyperlinkSegment.getAction(this.objectTable);
        if (hyperlinkAction != null) {
            hyperlinkAction.linkEntered(iHyperlinkSegment);
        }
    }

    protected void exitLink(IHyperlinkSegment iHyperlinkSegment) {
        if (iHyperlinkSegment == null) {
            return;
        }
        HyperlinkAction hyperlinkAction = iHyperlinkSegment.getAction(this.objectTable);
        if (hyperlinkAction != null) {
            hyperlinkAction.linkExited(iHyperlinkSegment);
        }
    }

    protected void paintLinkHover(IHyperlinkSegment iHyperlinkSegment, boolean bl) {
        GC gC = new GC((Drawable)this);
        HyperlinkSettings hyperlinkSettings = this.getHyperlinkSettings();
        gC.setForeground(bl ? hyperlinkSettings.getActiveForeground() : hyperlinkSettings.getForeground());
        gC.setBackground(this.getBackground());
        gC.setFont(this.getFont());
        boolean bl2 = iHyperlinkSegment == this.getSelectedLink();
        iHyperlinkSegment.repaint(gC, bl);
        if (bl2) {
            iHyperlinkSegment.paintFocus(gC, this.getBackground(), this.getForeground(), false);
            iHyperlinkSegment.paintFocus(gC, this.getBackground(), this.getForeground(), true);
        }
        gC.dispose();
    }

    protected void activateSelectedLink() {
        IHyperlinkSegment iHyperlinkSegment = this.model.getSelectedLink();
        if (iHyperlinkSegment != null) {
            this.activateLink(iHyperlinkSegment);
        }
    }

    private void activateLink(IHyperlinkSegment iHyperlinkSegment) {
        this.setCursor(this.model.getHyperlinkSettings().getBusyCursor());
        HyperlinkAction hyperlinkAction = iHyperlinkSegment.getAction(this.objectTable);
        if (hyperlinkAction != null) {
            hyperlinkAction.linkActivated(iHyperlinkSegment);
        }
        if (!this.isDisposed()) {
            this.setCursor(this.model.getHyperlinkSettings().getHyperlinkCursor());
        }
    }

    protected void paint(PaintEvent paintEvent) {
        int n = this.getClientArea().width;
        IParagraph[] iParagraphArray = this.model.getParagraphs();
        GC gC = paintEvent.gc;
        gC.setFont(this.getFont());
        gC.setForeground(this.getForeground());
        gC.setBackground(this.getBackground());
        Locator locator = new Locator();
        locator.marginWidth = this.marginWidth;
        locator.marginHeight = this.marginHeight;
        locator.x = this.marginWidth;
        locator.y = this.marginHeight;
        FontMetrics fontMetrics = gC.getFontMetrics();
        int n2 = fontMetrics.getHeight();
        IHyperlinkSegment iHyperlinkSegment = this.model.getSelectedLink();
        int n3 = 0;
        while (n3 < iParagraphArray.length) {
            IParagraph iParagraph = iParagraphArray[n3];
            if (n3 > 0 && this.paragraphsSeparated && iParagraph.getAddVerticalSpace()) {
                locator.y += this.getParagraphSpacing(n2);
            }
            locator.indent = iParagraph.getIndent();
            locator.resetCaret();
            locator.rowHeight = 0;
            iParagraph.paint(gC, n, locator, n2, this.objectTable, iHyperlinkSegment);
            ++n3;
        }
    }

    public void registerTextObject(String string, Object object) {
        this.objectTable.put(string, object);
    }

    public void load(String string, boolean bl, boolean bl2) {
        try {
            if (bl) {
                this.model.parseTaggedText(string, bl2);
            } else {
                this.model.parseRegularText(string, bl2);
            }
        }
        catch (CoreException coreException) {
            TestUIPlugin.logError(coreException);
        }
    }

    public void load(InputStream inputStream, boolean bl) {
        try {
            this.model.parseInputStream(inputStream, bl);
        }
        catch (CoreException coreException) {
            TestUIPlugin.logError(coreException);
        }
    }

    public boolean setFocus() {
        return super.setFocus();
    }

    private void paintFocusTransfer(IHyperlinkSegment iHyperlinkSegment, IHyperlinkSegment iHyperlinkSegment2) {
        GC gC = new GC((Drawable)this);
        Color color = this.getBackground();
        Color color2 = this.getForeground();
        gC.setFont(this.getFont());
        if (iHyperlinkSegment != null) {
            gC.setBackground(color);
            gC.setForeground(color2);
            iHyperlinkSegment.paintFocus(gC, color, color2, false);
        }
        if (iHyperlinkSegment2 != null) {
            gC.setBackground(color);
            gC.setForeground(color2);
            iHyperlinkSegment2.paintFocus(gC, color, color2, true);
        }
        gC.dispose();
    }

    public int getMarginWidth() {
        return this.marginWidth;
    }

    public void setMarginWidth(int n) {
        this.marginWidth = n;
    }

    public int getMarginHeight() {
        return this.marginHeight;
    }

    public void setMarginHeight(int n) {
        this.marginHeight = n;
    }

    public void contextMenuAboutToShow(IMenuManager iMenuManager) {
        IHyperlinkSegment iHyperlinkSegment = this.getSelectedLink();
        if (iHyperlinkSegment != null) {
            this.contributeLinkActions(iMenuManager, iHyperlinkSegment);
        }
    }

    private void contributeLinkActions(IMenuManager iMenuManager, IHyperlinkSegment iHyperlinkSegment) {
        iMenuManager.add((IAction)this.openAction);
        iMenuManager.add((IAction)this.copyShortcutAction);
        iMenuManager.add((IContributionItem)new Separator());
    }

    protected void copyShortcut(IHyperlinkSegment iHyperlinkSegment) {
        String string = iHyperlinkSegment.getText();
        Clipboard clipboard = new Clipboard(this.getDisplay());
        clipboard.setContents(new Object[]{string}, new Transfer[]{TextTransfer.getInstance()});
    }

    private void ensureVisible(IHyperlinkSegment iHyperlinkSegment) {
        Rectangle rectangle = iHyperlinkSegment.getBounds();
        ScrolledComposite scrolledComposite = this.getScrolledComposite();
        if (scrolledComposite == null) {
            return;
        }
        Point point = AbstractSectionForm.getControlLocation(scrolledComposite, (Control)this);
        point.x += rectangle.x;
        point.y += rectangle.y;
        AbstractSectionForm.ensureVisible(scrolledComposite, point, new Point(rectangle.width, rectangle.height));
    }

    ScrolledComposite getScrolledComposite() {
        Composite composite = this.getParent();
        while (composite != null) {
            if (composite instanceof ScrolledComposite) {
                return (ScrolledComposite)composite;
            }
            composite = composite.getParent();
        }
        return null;
    }
}

