/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator.action;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.model.ui.RemoveChildrenAction;
import org.eclipse.hyades.test.ui.internal.navigator.TestNavigator;
import org.eclipse.hyades.test.ui.internal.navigator.action.GenerateAction;
import org.eclipse.hyades.test.ui.internal.navigator.action.NewActionGroup;
import org.eclipse.hyades.test.ui.internal.navigator.action.OpenEditorAction;
import org.eclipse.hyades.test.ui.internal.navigator.action.OpenReportAction;
import org.eclipse.hyades.test.ui.internal.navigator.action.RunAction;
import org.eclipse.hyades.test.ui.internal.navigator.action.ToggleEObjectChildrenAction;
import org.eclipse.hyades.test.ui.internal.navigator.action.ToggleFolderAction;
import org.eclipse.hyades.ui.internal.action.CollapseAllAction;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.hyades.ui.internal.navigator.ITreeNavigator;
import org.eclipse.hyades.ui.internal.navigator.action.FrameListActionGroup;
import org.eclipse.hyades.ui.internal.navigator.action.NavigatorActionGroup;
import org.eclipse.hyades.ui.internal.navigator.action.NavigatorSorterActionGroup;
import org.eclipse.hyades.ui.internal.navigator.action.ToggleLinkingAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.AddBookmarkAction;
import org.eclipse.ui.actions.AddTaskAction;
import org.eclipse.ui.actions.DeleteResourceAction;
import org.eclipse.ui.actions.WorkingSetFilterActionGroup;
import org.eclipse.ui.dialogs.PropertyDialogAction;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.views.framelist.TreeFrame;
import org.eclipse.ui.views.navigator.ResourceNavigatorMessages;

public class TestNavigatorActionGroup
extends NavigatorActionGroup {
    protected OpenEditorAction openAction;
    protected AddBookmarkAction addBookmarkAction;
    protected AddTaskAction addTaskAction;
    protected PropertyDialogAction propertyDialogAction;
    protected CollapseAllAction collapseAllAction;
    protected ToggleLinkingAction toggleLinkingAction;
    protected ToggleFolderAction toggleFolderAction;
    protected ToggleEObjectChildrenAction toggleEObjectChildren;
    protected OpenReportAction openReportAction;
    protected GenerateAction generateAction;
    protected RunAction runAction;
    protected DeleteResourceAction deleteResourceAction;
    protected RemoveChildrenAction deleteChildEObject;
    protected NavigatorSorterActionGroup sorterActionGroup;
    protected NewActionGroup newActionGroup;
    protected WorkingSetFilterActionGroup workingSetFilterActionGroup;
    protected FrameListActionGroup frameListActionGroup;

    public TestNavigatorActionGroup(TestNavigator testNavigator) {
        super((INavigator)testNavigator);
    }

    public void dispose() {
        this.newActionGroup.dispose();
        this.workingSetFilterActionGroup.dispose();
        this.sorterActionGroup.dispose();
        this.frameListActionGroup.dispose();
        this.generateAction.dispose();
        this.runAction.dispose();
        super.dispose();
    }

    public void setContext(ActionContext actionContext) {
        super.setContext(actionContext);
        this.sorterActionGroup.setContext(actionContext);
        this.newActionGroup.setContext(actionContext);
        this.workingSetFilterActionGroup.setContext(actionContext);
        this.frameListActionGroup.setContext(actionContext);
    }

    protected void createActions() {
        Shell shell = this.getNavigator().getSite().getShell();
        this.openAction = new OpenEditorAction((TestNavigator)this.getNavigator(), TestUIPlugin.getString("ACT_OPEN"));
        this.addBookmarkAction = new AddBookmarkAction(shell);
        this.addTaskAction = new AddTaskAction(shell);
        this.propertyDialogAction = new PropertyDialogAction(shell, (ISelectionProvider)this.getNavigator().getViewer());
        this.collapseAllAction = new CollapseAllAction(((ITreeNavigator)this.getNavigator()).getTreeViewer());
        this.collapseAllAction.useDefaultDecorators();
        this.toggleLinkingAction = new ToggleLinkingAction(this.getNavigator(), ResourceNavigatorMessages.getString((String)"ToggleLinkingAction.text"));
        this.toggleLinkingAction.setToolTipText(ResourceNavigatorMessages.getString((String)"ToggleLinkingAction.toolTip"));
        this.toggleLinkingAction.setImageDescriptor(this.getImageDescriptor("elcl16/synced.gif"));
        this.toggleLinkingAction.setHoverImageDescriptor(this.getImageDescriptor("clcl16/synced.gif"));
        this.toggleFolderAction = new ToggleFolderAction((TestNavigator)this.getNavigator(), TestUIPlugin.getString("ACT_SHOW_FLD_TXT"));
        this.toggleFolderAction.setToolTipText(TestUIPlugin.getString("ACT_SHOW_FLD_DSC"));
        TestUIImages.INSTANCE.setImageDescriptors((IAction)this.toggleFolderAction, "showfolders_co.gif");
        this.toggleEObjectChildren = new ToggleEObjectChildrenAction((TestNavigator)this.getNavigator(), TestUIPlugin.getString("ACT_SHOW_EOBJ_CH_TXT"));
        this.toggleEObjectChildren.setToolTipText(TestUIPlugin.getString("ACT_SHOW_EOBJ_CH_DSC"));
        TestUIImages.INSTANCE.setImageDescriptors((IAction)this.toggleEObjectChildren, "showchild_co.gif");
        ISharedImages iSharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.deleteResourceAction = new DeleteResourceAction(shell);
        this.deleteResourceAction.setDisabledImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
        this.deleteResourceAction.setImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_DELETE"));
        this.deleteResourceAction.setHoverImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_DELETE_HOVER"));
        this.deleteChildEObject = new RemoveChildrenAction(true){

            protected List saveResources(Set set) {
                TestNavigator testNavigator = (TestNavigator)TestNavigatorActionGroup.this.getNavigator();
                testNavigator.getTreeViewer().remove(this.getStructuredSelection().toArray());
                testNavigator.setMonitoringResourceChange(false);
                try {
                    List list = super.saveResources(set);
                    Object var5_4 = null;
                    testNavigator.setMonitoringResourceChange(true);
                    return list;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    testNavigator.setMonitoringResourceChange(true);
                    throw throwable;
                }
            }
        };
        this.deleteChildEObject.setStructuredViewer(((TestNavigator)this.getNavigator()).getViewer());
        this.deleteChildEObject.setShowErrorDialog(true);
        this.openReportAction = new OpenReportAction();
        this.generateAction = new GenerateAction();
        this.runAction = new RunAction();
    }

    protected void createActionGroups() {
        this.sorterActionGroup = new NavigatorSorterActionGroup(this.getNavigator());
        this.newActionGroup = new NewActionGroup((TestNavigator)this.getNavigator());
        IPropertyChangeListener iPropertyChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getProperty();
                if ("changeWorkingSet".equals(string)) {
                    INavigator iNavigator = TestNavigatorActionGroup.this.getNavigator();
                    Object object = propertyChangeEvent.getNewValue();
                    if (object instanceof IWorkingSet) {
                        ((TestNavigator)iNavigator).setWorkingSet((IWorkingSet)object);
                    } else if (object == null) {
                        ((TestNavigator)iNavigator).setWorkingSet(null);
                    }
                }
            }
        };
        this.workingSetFilterActionGroup = new WorkingSetFilterActionGroup(this.getNavigator().getViewer().getControl().getShell(), iPropertyChangeListener);
        this.workingSetFilterActionGroup.setWorkingSet(((TestNavigator)this.getNavigator()).getWorkingSet());
        this.frameListActionGroup = new FrameListActionGroup((ITreeNavigator)((TestNavigator)this.getNavigator()));
    }

    public void fillContextMenu(IMenuManager iMenuManager) {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.getContext().getSelection();
        IStructuredSelection iStructuredSelection2 = this.getResourceSelection(iStructuredSelection);
        this.newActionGroup.fillContextMenu(iMenuManager);
        this.frameListActionGroup.fillContextMenu(iMenuManager);
        this.openAction.selectionChanged(iStructuredSelection);
        if (this.openAction.isApplicableForSelection()) {
            iMenuManager.add((IAction)this.openAction);
            iMenuManager.add((IContributionItem)new Separator());
        }
        this.generateAction.selectionChanged(iStructuredSelection);
        if (this.generateAction.isApplicableForSelection()) {
            iMenuManager.add((IAction)this.generateAction);
        }
        this.runAction.selectionChanged(iStructuredSelection);
        if (this.runAction.isApplicableForSelection()) {
            iMenuManager.add((IAction)this.runAction);
        }
        this.deleteResourceAction.setEnabled(false);
        if (iStructuredSelection2.size() == iStructuredSelection.size()) {
            iMenuManager.add((IContributionItem)new Separator());
            this.deleteResourceAction.selectionChanged(iStructuredSelection2);
            iMenuManager.add((IAction)this.deleteResourceAction);
            iMenuManager.add((IContributionItem)new Separator());
            this.addBookmarkAction.selectionChanged(iStructuredSelection2);
            if (this.addBookmarkAction.isEnabled()) {
                iMenuManager.add((IAction)this.addBookmarkAction);
            }
        }
        if (!this.deleteResourceAction.isEnabled()) {
            iMenuManager.add((IContributionItem)new Separator());
            this.deleteChildEObject.selectionChanged(iStructuredSelection);
            if (this.deleteChildEObject.isEnabled()) {
                iMenuManager.add((IAction)this.deleteChildEObject);
            }
        }
        this.openReportAction.selectionChanged(iStructuredSelection);
        if (this.openReportAction.isApplicableForSelection()) {
            iMenuManager.add((IAction)this.openReportAction);
        }
        if (iStructuredSelection.size() == 1) {
            iMenuManager.add((IContributionItem)new Separator());
            this.propertyDialogAction.selectionChanged(iStructuredSelection);
            if (this.propertyDialogAction.isApplicableForSelection()) {
                iMenuManager.add((IAction)this.propertyDialogAction);
            }
        }
    }

    public void fillActionBars(IActionBars iActionBars) {
        iActionBars.setGlobalActionHandler("properties", (IAction)this.propertyDialogAction);
        iActionBars.setGlobalActionHandler("bookmark", (IAction)this.addBookmarkAction);
        iActionBars.setGlobalActionHandler("addTask", (IAction)this.addTaskAction);
        iActionBars.setGlobalActionHandler("delete", (IAction)this.deleteResourceAction);
        this.frameListActionGroup.fillActionBars(iActionBars);
        this.newActionGroup.fillActionBars(iActionBars);
        this.workingSetFilterActionGroup.fillActionBars(iActionBars);
        this.sorterActionGroup.fillActionBars(iActionBars);
        IMenuManager iMenuManager = iActionBars.getMenuManager();
        iMenuManager.add((IAction)this.toggleLinkingAction);
        iMenuManager.add((IAction)this.toggleEObjectChildren);
        IToolBarManager iToolBarManager = iActionBars.getToolBarManager();
        iToolBarManager.add((IContributionItem)new Separator());
        iToolBarManager.add((IAction)this.collapseAllAction);
        iToolBarManager.add((IAction)this.toggleLinkingAction);
    }

    public void updateActionBars() {
        TestNavigator testNavigator = (TestNavigator)this.getNavigator();
        Object object = ((TreeFrame)testNavigator.getFrameList().getCurrentFrame()).getInput();
        this.toggleFolderAction.setEnabled(object == null || testNavigator.getInitialViewerInput() == object);
        this.toggleEObjectChildren.setEnabled(object == null || !(object instanceof EObject));
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.getContext().getSelection();
        IStructuredSelection iStructuredSelection2 = this.getResourceSelection(iStructuredSelection);
        this.propertyDialogAction.setEnabled(iStructuredSelection.size() == 1);
        this.addBookmarkAction.selectionChanged(iStructuredSelection2);
        this.deleteResourceAction.selectionChanged(iStructuredSelection2);
        this.addTaskAction.selectionChanged(iStructuredSelection);
        this.frameListActionGroup.updateActionBars();
        this.sorterActionGroup.updateActionBars();
        this.newActionGroup.updateActionBars();
        this.workingSetFilterActionGroup.updateActionBars();
    }

    public void runDefaultAction(IStructuredSelection iStructuredSelection) {
        this.openAction.selectionChanged(iStructuredSelection);
        this.openAction.run();
    }

    public void handleKeyPressed(KeyEvent keyEvent) {
        if (keyEvent.character == '\u007f' && keyEvent.stateMask == 0 && this.deleteResourceAction.isEnabled()) {
            this.deleteResourceAction.run();
        }
        super.handleKeyPressed(keyEvent);
    }

    protected IStructuredSelection getResourceSelection(IStructuredSelection iStructuredSelection) {
        TestNavigator testNavigator = (TestNavigator)this.getNavigator();
        ArrayList arrayList = new ArrayList();
        Iterator iterator = iStructuredSelection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof IResource && ((IResource)e).getType() != 1) {
                arrayList.add(e);
                continue;
            }
            IFile iFile = testNavigator.getFile(e);
            if (iFile == null) continue;
            arrayList.add(iFile);
        }
        return new StructuredSelection(arrayList);
    }

    protected ImageDescriptor getImageDescriptor(String string) {
        String string2 = "icons/full/";
        try {
            AbstractUIPlugin abstractUIPlugin = (AbstractUIPlugin)Platform.getPlugin((String)"org.eclipse.ui");
            URL uRL = abstractUIPlugin.getDescriptor().getInstallURL();
            URL uRL2 = new URL(uRL, string2 + string);
            return ImageDescriptor.createFromURL((URL)uRL2);
        }
        catch (MalformedURLException malformedURLException) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }
}

