/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.wizard;

import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.models.common.datapool.Common_DatapoolFactory;
import org.eclipse.hyades.models.common.datapool.DPLDatapool;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.hyades.ui.internal.util.UIUtil;
import org.eclipse.hyades.ui.internal.wizard.HyadesNewWizard;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.PartInitException;

public class DatapoolNewWizard
extends HyadesNewWizard {
    public DatapoolNewWizard() {
        this.setWindowTitle(TestUIPlugin.getString("WIZ_DATAPOOL_TTL"));
        this.setDefaultPageImageDescriptor(TestUIImages.INSTANCE.getImageDescriptor("newtestsuite_wiz.gif"));
        IDialogSettings iDialogSettings = TestUIPlugin.getInstance().getDialogSettings();
        IDialogSettings iDialogSettings2 = iDialogSettings.getSection("DataPoolNewWizard");
        if (iDialogSettings2 == null) {
            iDialogSettings2 = iDialogSettings.addNewSection("DataPoolNewWizard");
        }
        this.setDialogSettings(iDialogSettings2);
    }

    protected String getType() {
        return "org.eclipse.hyades.datapool.generic";
    }

    protected String getFileExtension() {
        return "datapool";
    }

    public void addPages() {
        this.getLocationPage().setTitle(TestUIPlugin.getString("WIZ_DATAPOOL_GEN_PG_TTL"));
        this.getLocationPage().setDescription(TestUIPlugin.getString("WIZ_DATAPOOL_GEN_PG_LOC_DSC"));
        this.addPage((IWizardPage)this.getLocationPage());
        this.getAttributeWizardPage().setTitle(TestUIPlugin.getString("WIZ_DATAPOOL_GEN_PG_TTL"));
        this.getAttributeWizardPage().setDescription(TestUIPlugin.getString("WIZ_DATAPOOL_GEN_PG_ATT_DSC"));
        this.addPage((IWizardPage)this.getAttributeWizardPage());
    }

    protected boolean createObject(IFile iFile) throws Exception {
        Resource resource = this.createResource(iFile);
        resource.getContents().add(this.createEObject());
        EMFUtil.save(resource);
        return true;
    }

    protected EObject createEObject() {
        DPLDatapool dPLDatapool = Common_DatapoolFactory.eINSTANCE.createDPLDatapool();
        dPLDatapool.setName(this.getAttributeWizardPage().getItemName());
        String string = this.getAttributeWizardPage().getItemDescription();
        if (string != null && string.trim().length() > 0) {
            dPLDatapool.setDescription(string);
        }
        return dPLDatapool;
    }

    protected Resource createResource(IFile iFile) {
        URI uRI = URI.createPlatformResourceURI((String)iFile.getFullPath().toString());
        Resource.Factory factory = EMFUtil.getResourceFactory("datapool");
        return factory.createResource(uRI);
    }

    protected void openEditor(IFile iFile) throws PartInitException {
        if (TestUIPlugin.getInstance().getPreferenceStore().getBoolean("openEditor")) {
            UIUtil.openEditor((IFile)iFile, (String)"org.eclipse.hyades.test.ui.editor.DatapoolEditorPart", (boolean)false);
        }
    }
}

