/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.execution.recorder;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.hyades.internal.execution.recorder.Recorder;

public class RecorderFactory {
    private static RecorderFactory instance = null;
    private HashMap recorderMap = new HashMap();
    private String[] recorderIDs = null;

    public static RecorderFactory getInstance() {
        if (instance == null) {
            instance = new RecorderFactory();
        }
        return instance;
    }

    protected void addRecorder(Recorder recorder) {
        this.recorderMap.put(recorder.getId(), recorder);
    }

    private RecorderFactory() {
    }

    public String[] getRecorderIDs() {
        if (this.recorderIDs == null) {
            Object[] objectArray = this.recorderMap.keySet().toArray();
            this.recorderIDs = new String[objectArray.length];
            int n = 0;
            while (n < objectArray.length) {
                this.recorderIDs[n] = (String)objectArray[n];
                ++n;
            }
        }
        return this.recorderIDs;
    }

    public Recorder getRecorderWithID(String string) {
        return (Recorder)this.recorderMap.get(string);
    }

    public Recorder getActiveRecorder() {
        Collection collection = this.recorderMap.values();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Recorder recorder = (Recorder)iterator.next();
            if (!recorder.isActive()) continue;
            return recorder;
        }
        return null;
    }
}

