/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.execution.recorder.local;

import java.io.IOException;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.Enumeration;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.hyades.execution.core.DaemonConnectException;
import org.eclipse.hyades.execution.core.IControlMessage;
import org.eclipse.hyades.execution.core.IDataProcessor;
import org.eclipse.hyades.execution.core.IExecutableObject;
import org.eclipse.hyades.execution.core.IExecutionComponent;
import org.eclipse.hyades.execution.core.IExecutionComponentFactory;
import org.eclipse.hyades.execution.core.IExecutionEnvironment;
import org.eclipse.hyades.execution.core.IRemoteHyadesComponent;
import org.eclipse.hyades.execution.core.ISession;
import org.eclipse.hyades.execution.core.UnknownDaemonException;
import org.eclipse.hyades.execution.local.ExecutionComponentFactoryImpl;
import org.eclipse.hyades.execution.local.JavaProcessExecutableObjectStub;
import org.eclipse.hyades.execution.local.JavaProcessExecutorStub;
import org.eclipse.hyades.execution.local.NodeImpl;
import org.eclipse.hyades.execution.local.SessionStub;
import org.eclipse.hyades.execution.recorder.RecorderPlugin;
import org.eclipse.hyades.internal.execution.local.common.CommandElement;
import org.eclipse.hyades.internal.execution.local.common.CustomCommand;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.AgentListener;
import org.eclipse.hyades.internal.execution.local.control.InactiveAgentException;
import org.eclipse.hyades.internal.execution.local.control.InactiveProcessException;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.internal.execution.local.control.NotConnectedException;
import org.eclipse.hyades.internal.execution.local.control.Process;
import org.eclipse.hyades.internal.execution.recorder.Recorder;
import org.eclipse.hyades.internal.execution.recorder.local.RecorderDataProcessorHelper;
import org.eclipse.hyades.internal.execution.recorder.local.appadapters.RecorderAppAdapterFactory;
import org.eclipse.hyades.internal.execution.recorder.ui.views.RecorderControlView;
import org.eclipse.hyades.internal.execution.testgen.TestGenerator;
import org.eclipse.hyades.internal.execution.testgen.TestGeneratorFactory;
import org.eclipse.hyades.internal.execution.testgen.TestgenException;
import org.eclipse.swt.widgets.Display;

public class RecorderClient {
    private JavaProcessExecutorStub executor;
    private IExecutionEnvironment exeEnvironment = null;
    private IExecutionComponentFactory factory = null;
    private ISession session = null;
    private IRemoteHyadesComponent remoteHyadesComponent = null;
    private IExecutableObject executableObject = null;
    private Recorder theRecorder;
    private Agent controlAgent = null;
    private RecorderDataProcessorHelper dataProcessorHelper;
    private Display display = Display.getCurrent();

    public void run(final Recorder recorder) throws IllegalAccessException, InstantiationException, IOException {
        new Thread(){

            public void run() {
                try {
                    RecorderClient.this.theRecorder = recorder;
                    RecorderClient.this.sendStatusMessageToControlView(RecorderPlugin.getResourceString("RecorderClient.RECORDING_STARTED_STATUS_MESSAGE"));
                    RecorderClient.this.session = RecorderClient.this.createSession();
                    RecorderClient.this.factory = ExecutionComponentFactoryImpl.getInstance((ISession)RecorderClient.this.session);
                    RecorderClient.this.sendStatusMessageToControlView(RecorderPlugin.getResourceString("RecorderClient.SETTING_UP_JAVA_ENVIRONMENT_STATUS_MESSAGE"));
                    RecorderClient.this.exeEnvironment = RecorderClient.this.setupJavaEnvironment();
                    RecorderClient.this.session.addChild((IExecutionComponent)RecorderClient.this.exeEnvironment);
                    RecorderClient.this.sendStatusMessageToControlView(RecorderPlugin.getResourceString("RecorderClient.CONFIGURING_EXECUTOR_STATUS_MESSAGE"));
                    RecorderClient.this.executor = RecorderClient.this.setupExecutor();
                    RecorderClient.this.sendStatusMessageToControlView(RecorderPlugin.getResourceString("RecorderClient.CONFIGURING_CONTROL_CHANNEL_COMMUNICATION_STATUS_MESSAGE"));
                    RecorderClient.this.remoteHyadesComponent = RecorderClient.this.setupAgent();
                    RecorderClient.this.dataProcessorHelper = new RecorderDataProcessorHelper(RecorderClient.this.theRecorder.getDataProcessor());
                    RecorderClient.this.remoteHyadesComponent.startMonitoring((IDataProcessor)RecorderClient.this.dataProcessorHelper);
                    RecorderClient.this.sendStatusMessageToControlView(RecorderPlugin.getResourceString("RecorderClient.SENDING_EXECUTABLE_OBJECT_STATUS_MESSAGE"));
                    RecorderClient.this.executableObject = RecorderClient.this.setupHarnessAgentExecutableObject();
                    RecorderClient.this.sendStatusMessageToControlView(RecorderPlugin.getResourceString("RecorderClient.SENDING_EXECUTOR_STATUS_MESSAGE"));
                    RecorderClient.this.exeEnvironment.addChild((IExecutionComponent)RecorderClient.this.executor);
                    RecorderClient.this.sendStatusMessageToControlView(RecorderPlugin.getResourceString("RecorderClient.INITIALIZING_DATA_PROCESSOR_STATUS_MESSAGE"));
                    RecorderClient.this.theRecorder.getDataProcessor().initialize();
                    RecorderClient.this.executor.setExecutableObject(RecorderClient.this.executableObject);
                    RecorderClient.this.executor.addChild((IExecutionComponent)RecorderClient.this.remoteHyadesComponent);
                    RecorderClient.this.sendStatusMessageToControlView(RecorderPlugin.getResourceString("RecorderClient.LAUNCHING_EXECUTOR_STATUS_MESSAGE"));
                    RecorderClient.this.executor.launch();
                    RecorderClient.this.sendStatusMessageToControlView(RecorderPlugin.getResourceString("RecorderClient.EXECUTOR_LAUNCH_SUCCESSFUL_STATUS_MESSAGE"));
                    RecorderClient.this.startRecording();
                    new FinishCleanupAndGenTestThread().start();
                }
                catch (Exception exception) {
                    RecorderPlugin.reportExceptionToUser(exception, RecorderPlugin.getResourceString("RecorderClient.START_RECORDING_ABORTED"), exception.getClass().getName(), RecorderPlugin.getResourceString("RecorderClient.RECORDER_ERROR"));
                    RecorderClient.this.sendStatusMessageToControlView(RecorderPlugin.getResourceString("RecorderClient.START_RECORDING_ABORTED_DUE_TO_EXCEPTION_STATUS_MESSAGE") + exception.getClass().getName());
                    if (RecorderClient.this.session != null) {
                        RecorderClient.this.session.release();
                    }
                    RecorderClient.this.theRecorder.setActive(false);
                }
            }
        }.start();
    }

    private void sendStatusMessageToControlView(String string) {
        RecorderControlView recorderControlView = RecorderControlView.getInstance();
        recorderControlView.addMessage(string);
    }

    private void startRecording() throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        String string = null;
        String string2 = "-1";
        String string3 = "Init " + this.theRecorder.getConfigParams();
        this.sendStatusMessageToControlView(RecorderPlugin.getResourceString("RecorderClient.SENDING_COMMAND_STATUS_MESSAGE") + string3);
        this.sendMessage(string3);
        string3 = "StartRecording";
        this.sendStatusMessageToControlView(RecorderPlugin.getResourceString("RecorderClient.SENDING_COMMAND_STATUS_MESSAGE") + string3);
        this.sendMessage(string3);
        String string4 = this.theRecorder.getApplicationAdapterID();
        if (!string4.equalsIgnoreCase("-1")) {
            string = RecorderAppAdapterFactory.getInstance().getAgentClasspath(this.theRecorder.getApplicationAdapterID());
            string2 = RecorderAppAdapterFactory.getInstance().getClient(this.theRecorder.getApplicationAdapterID()).getInitString();
        }
        if (string != null && string != "-1") {
            string3 = "StartApp " + string + ";" + string2;
            this.sendStatusMessageToControlView(RecorderPlugin.getResourceString("RecorderClient.SENDING_COMMAND_STATUS_MESSAGE") + string3);
            this.sendMessage(string3);
        }
    }

    public void stopRecording() {
        this.sendMessage("StopApp");
        this.sendMessage("Stop");
    }

    private void sendMessage(String string) {
        if (this.controlAgent == null) {
            this.initControlAgent();
        }
        CustomCommand customCommand = new CustomCommand();
        customCommand.setData(string);
        try {
            this.controlAgent.invokeCustomCommand(customCommand);
        }
        catch (InactiveAgentException inactiveAgentException) {
            inactiveAgentException.printStackTrace();
        }
    }

    private void initControlAgent() {
        String string = this.executor.getPid();
        int n = 100;
        try {
            boolean bl = false;
            Node node = ((SessionStub)this.executor.getSessionContext()).getAgent().getProcess().getNode();
            while (!bl && n > 0) {
                Enumeration enumeration = node.listProcesses();
                while (enumeration.hasMoreElements()) {
                    Process process = (Process)enumeration.nextElement();
                    if (process.getProcessId().equals(string)) {
                        bl = true;
                        Process process2 = process;
                        synchronized (process2) {
                            Enumeration enumeration2 = process.getAgentsByType("tester");
                            while (enumeration2.hasMoreElements()) {
                                this.controlAgent = (Agent)enumeration2.nextElement();
                                try {
                                    this.controlAgent.addAgentListener((AgentListener)new RecorderAgentListener());
                                    this.controlAgent.attach();
                                    break;
                                }
                                catch (InactiveAgentException inactiveAgentException) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                    --n;
                }
            }
        }
        catch (InactiveProcessException inactiveProcessException) {
        }
        catch (NotConnectedException notConnectedException) {
            // empty catch block
        }
    }

    private IExecutableObject setupHarnessAgentExecutableObject() throws ClassNotFoundException {
        this.factory.addExecutionComponent("JAVA_EXECUTABLE", "org.eclipse.hyades.execution.core.impl.JavaProcessExecutableObjectImpl");
        this.factory.addStub("JAVA_EXECUTABLE", "org.eclipse.hyades.execution.local.JavaProcessExecutableObjectStub");
        this.factory.addSkeleton("JAVA_EXECUTABLE", "org.eclipse.hyades.execution.remote.JavaProcessExecutableObjectSkeleton");
        IExecutableObject iExecutableObject = this.executor.getCompatibleExecutableObject("JAVA_EXECUTABLE");
        this.theRecorder.getExecutableObjectAdapter().setupExecutableObject((JavaProcessExecutableObjectStub)iExecutableObject);
        return iExecutableObject;
    }

    private IRemoteHyadesComponent setupAgent() throws ClassNotFoundException {
        this.factory.addExecutionComponent("AGENT", "org.eclipse.hyades.execution.core.impl.JavaTaskRemoteHyadesComponentImpl");
        this.factory.addStub("AGENT", "org.eclipse.hyades.execution.local.JavaTaskRemoteHyadesComponentStub");
        this.factory.addSkeleton("AGENT", "org.eclipse.hyades.execution.remote.JavaTaskRemoteHyadesComponentSkeleton");
        return (IRemoteHyadesComponent)this.factory.createExecutionComponentByType("AGENT");
    }

    private JavaProcessExecutorStub setupExecutor() throws ClassNotFoundException {
        this.factory.addExecutionComponent("EXECUTOR", "org.eclipse.hyades.execution.core.impl.ProcessExecutorImpl");
        this.factory.addStub("EXECUTOR", "org.eclipse.hyades.execution.local.JavaProcessExecutorStub");
        this.factory.addSkeleton("EXECUTOR", "org.eclipse.hyades.execution.remote.JavaProcessExecutorSkeleton");
        return (JavaProcessExecutorStub)this.factory.createExecutionComponentByType("EXECUTOR");
    }

    private ISession createSession() throws UnknownHostException, UnknownDaemonException, DaemonConnectException {
        String string = RecorderPlugin.getDefault().getRAServerHost();
        String string2 = RecorderPlugin.getDefault().getRAServerPort();
        this.sendStatusMessageToControlView(RecorderPlugin.getResourceString("RecorderClient.CONNECTING_TO_RASERVER_STATUS_MESSAGE") + string + RecorderPlugin.getResourceString("RecorderClient.PORT_LABEL") + string2);
        NodeImpl nodeImpl = new NodeImpl(string);
        ISession iSession = null;
        iSession = nodeImpl.connect(string2, null);
        return iSession;
    }

    private IExecutionEnvironment setupJavaEnvironment() throws ClassNotFoundException, IOException {
        IExecutionEnvironment iExecutionEnvironment = null;
        this.factory.addExecutionComponent("ENVIRONMENT", "org.eclipse.hyades.execution.core.impl.ExecutionEnvironmentImpl");
        this.factory.addStub("ENVIRONMENT", "org.eclipse.hyades.execution.local.ExecutionEnvironmentStub");
        this.factory.addSkeleton("ENVIRONMENT", "org.eclipse.hyades.execution.remote.ExecutionEnvironmentSkeleton");
        iExecutionEnvironment = (IExecutionEnvironment)this.factory.createExecutionComponentByType("ENVIRONMENT");
        this.theRecorder.getAgentEnvironmentAdapter().setupExecutionEnvironment(iExecutionEnvironment);
        return iExecutionEnvironment;
    }

    private class ControlMessage
    implements IControlMessage {
        private String messageData;

        public ControlMessage(String string) {
            this.messageData = string;
        }

        public String getMessageData() {
            return this.messageData;
        }

        public void setMessageData(String string) {
            this.messageData = string;
        }
    }

    private class RecorderAgentListener
    implements AgentListener {
        private RecorderAgentListener() {
        }

        public void agentActive(Agent agent) {
        }

        public void agentInactive(Agent agent) {
        }

        public void error(Agent agent, String string, String string2) {
        }

        public void handleCommand(Agent agent, CommandElement commandElement) {
            if (commandElement instanceof CustomCommand) {
                String string = ((CustomCommand)commandElement).getData();
                System.out.println("recieving message: " + string);
            }
        }
    }

    private class FinishCleanupAndGenTestThread
    extends Thread {
        public FinishCleanupAndGenTestThread() {
            this.setName("Recording completion listener");
        }

        public void run() {
            while (!RecorderClient.this.dataProcessorHelper.isRecordingComplete()) {
                this.delay(200);
            }
            RecorderClient.this.theRecorder.setActive(false);
            RecorderControlView.getInstance().addMessage(RecorderPlugin.getResourceString("RecorderClient.RECORDING_COMPLETE_MESSAGE"));
            if (!RecorderClient.this.theRecorder.getScriptgenID().equalsIgnoreCase("-1")) {
                RecorderClient.this.display.asyncExec(new Runnable(){

                    public void run() {
                        String string = RecorderClient.this.theRecorder.getScriptgenID();
                        IConfigurationElement iConfigurationElement = null;
                        String string2 = RecorderClient.this.theRecorder.getRecordingPath();
                        RecorderControlView.getInstance().addMessage(RecorderPlugin.getResourceString("RecorderClient.Test_generation_started_with_generator___4") + string);
                        iConfigurationElement = TestGeneratorFactory.getInstance().getGeneratorConfigElement(string);
                        try {
                            TestGenerator testGenerator = (TestGenerator)iConfigurationElement.createExecutableExtension("class");
                            String string3 = null;
                            if (!string2.endsWith(".rec")) {
                                Object[] objectArray = new String[]{string2, ".rec"};
                                String string4 = RecorderPlugin.getResourceString("RecorderClient.RECORDING_PATH_NOT_CORRECT_FORMAT_STRING");
                                RecorderClient.this.sendStatusMessageToControlView(MessageFormat.format(string4, objectArray));
                                return;
                            }
                            string3 = string2.substring(0, string2.length() - 3);
                            IFile iFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(string3 + "recmodel"));
                            if (iFile.exists()) {
                                RecorderControlView.getInstance().addMessage(RecorderPlugin.getResourceString("RecorderClient.TEST_TO_BE_GENERATED") + RecorderClient.this.theRecorder.getTestPath());
                                testGenerator.initialize(iFile, RecorderClient.this.theRecorder.getTestPath());
                                testGenerator.runTestGen();
                                RecorderControlView.getInstance().addMessage(RecorderPlugin.getResourceString("RecorderClient.TEST_GENERATION_COMPLETE"));
                            } else {
                                RecorderControlView.getInstance().addMessage(RecorderPlugin.getResourceString("RecorderClient.UNABLE_TO_GENERATE_NO_TRACE_FILE"));
                            }
                        }
                        catch (CoreException coreException) {
                            coreException.printStackTrace();
                        }
                        catch (TestgenException testgenException) {
                            testgenException.printStackTrace();
                        }
                    }
                });
            }
            RecorderClient.this.session.release();
        }

        private void delay(int n) {
            try {
                Thread.sleep(n);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }
}

