/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.execution.recorder.utilities;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.hyades.models.trace.TRCSourceInfo;
import org.eclipse.hyades.models.trace.TraceFactory;

public class RecorderFileUtil {
    public static IFile createTraceFile(String string) throws CoreException {
        String string2 = string;
        byte[] byArray = new byte[1];
        IFile iFile = null;
        try {
            if (!string2.endsWith(".rec")) {
                string2 = string2 + ".rec";
            }
            if ((iFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(string2))).exists()) {
                iFile.delete(true, true, null);
            }
            iFile.create((InputStream)new ByteArrayInputStream(new byte[0]), true, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
        }
        return iFile;
    }

    public static IFile createTraceModel(String string, String string2) {
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        hashMap.put("DECLARE_XML", Boolean.TRUE);
        hashMap.put("SKIP_ESCAPE", Boolean.FALSE);
        TRCSourceInfo tRCSourceInfo = TraceFactory.eINSTANCE.createTRCSourceInfo();
        if (string.endsWith(".rec")) {
            string = string + "model";
        } else if (!string.endsWith(".recmodel")) {
            string = string + ".recmodel";
        }
        URI uRI = URI.createPlatformResourceURI((String)string);
        tRCSourceInfo.setLocation(string2);
        ResourceSetImpl resourceSetImpl = new ResourceSetImpl();
        Resource resource = resourceSetImpl.createResource(uRI);
        resource.getContents().add(tRCSourceInfo);
        try {
            resource.save(hashMap);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(string));
    }

    public static EObject[] loadResource(IFile iFile) {
        ResourceSetImpl resourceSetImpl = new ResourceSetImpl();
        Resource resource = resourceSetImpl.getResource(URI.createPlatformResourceURI((String)iFile.getFullPath().toString()), true);
        if (resource == null) {
            System.out.println("Failed to get the resource");
            return null;
        }
        EObject[] eObjectArray = resource.getContents().toArray(new EObject[resource.getContents().size()]);
        return eObjectArray;
    }

    public static IFile getTraceFile(IFile iFile) {
        EObject[] eObjectArray = RecorderFileUtil.loadResource(iFile);
        TRCSourceInfo tRCSourceInfo = (TRCSourceInfo)eObjectArray[0];
        String string = tRCSourceInfo.getLocation();
        System.out.println("Trace file: " + string);
        IFile iFile2 = (IFile)ResourcesPlugin.getWorkspace().getRoot().findMember(string);
        return iFile2;
    }
}

