/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.execution.testgen.ui.wizards;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.core.internal.resources.File;
import org.eclipse.core.internal.resources.Folder;
import org.eclipse.core.internal.resources.Project;
import org.eclipse.core.internal.resources.WorkspaceRoot;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.hyades.execution.testgen.TestgenPlugin;
import org.eclipse.hyades.internal.execution.testgen.ui.TestgenUIUtility;
import org.eclipse.hyades.internal.execution.testgen.ui.wizards.ITestGenWizardPage;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.dialogs.ResourceSorter;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public abstract class FileLocationSelectionWizardpage
extends WizardPage
implements ITestGenWizardPage {
    private IStructuredSelection selection;
    private TreeViewer tree;
    private File selectedFile;
    private IContainer selectedContainer;
    private IProject selectedProject;
    private Object previousSelection = null;
    private Text selectedFileName;
    static /* synthetic */ Class class$org$eclipse$hyades$internal$execution$testgen$ui$wizards$FileLocationSelectionWizardpage;
    static /* synthetic */ Class class$org$eclipse$core$resources$IContainer;
    static /* synthetic */ Class class$org$eclipse$core$internal$resources$File;

    public abstract String getFileExtension();

    public abstract String getFileNameLabel();

    public abstract String getTitle();

    public abstract String getDescription();

    public FileLocationSelectionWizardpage() {
        super((class$org$eclipse$hyades$internal$execution$testgen$ui$wizards$FileLocationSelectionWizardpage == null ? (class$org$eclipse$hyades$internal$execution$testgen$ui$wizards$FileLocationSelectionWizardpage = FileLocationSelectionWizardpage.class$("org.eclipse.hyades.internal.execution.testgen.ui.wizards.FileLocationSelectionWizardpage")) : class$org$eclipse$hyades$internal$execution$testgen$ui$wizards$FileLocationSelectionWizardpage).getName());
    }

    public void saveSettings() {
        String string = this.getValidFileName();
        TestgenPlugin.getDefault().getPreferenceStore().setValue(this.getClass().getName(), string);
    }

    private String getValidFileName() {
        String string = this.selectedContainer.getFullPath().toString() + "/" + this.selectedFileName.getText();
        if (!string.endsWith("." + this.getFileExtension())) {
            string = string + "." + this.getFileExtension();
        }
        return string;
    }

    public void createControl(Composite composite) {
        this.setTitle(this.getTitle());
        this.setDescription(this.getDescription());
        try {
            Font font = composite.getFont();
            Composite composite2 = new Composite(composite, 0);
            TestgenUIUtility.assignGridLayout(composite2, 1);
            TestgenUIUtility.layoutControlInGrid((Control)composite2, 1, 256);
            this.setControl((Control)composite2);
            WorkbenchHelp.setHelp((Control)composite2, (String)this.getContextHelpID());
            this.tree = TestgenUIUtility.createTreeViewer(composite2, font);
            this.tree.setContentProvider((IContentProvider)new WorkbenchContentProvider());
            this.tree.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)new WorkbenchLabelProvider(), WorkbenchPlugin.getDefault().getWorkbench().getDecoratorManager().getLabelDecorator()));
            this.tree.setInput((Object)WorkbenchPlugin.getPluginWorkspace().getRoot());
            this.tree.setSorter((ViewerSorter)new ResourceSorter(1));
            this.tree.addFilter((ViewerFilter)new TreeFilter());
            ArrayList arrayList = new ArrayList();
            String string = this.getPreviouslySelectedObject(arrayList);
            if (string != null && arrayList.size() > 0 && (class$org$eclipse$core$resources$IContainer == null ? (class$org$eclipse$core$resources$IContainer = FileLocationSelectionWizardpage.class$("org.eclipse.core.resources.IContainer")) : class$org$eclipse$core$resources$IContainer).isInstance(arrayList.get(0))) {
                this.selectedContainer = (IContainer)arrayList.get(0);
            } else if (string != null && arrayList.size() > 0 && (class$org$eclipse$core$internal$resources$File == null ? (class$org$eclipse$core$internal$resources$File = FileLocationSelectionWizardpage.class$("org.eclipse.core.internal.resources.File")) : class$org$eclipse$core$internal$resources$File).isInstance(arrayList.get(0))) {
                this.selectedFile = (File)arrayList.get(0);
                this.selectedContainer = this.selectedFile.getParent();
            }
            if (string != null) {
                this.tree.setSelection((ISelection)new StructuredSelection(arrayList));
            }
            this.tree.addSelectionChangedListener((ISelectionChangedListener)new TreeSelectionChangedListener());
            TestgenUIUtility.layoutControlInGrid(this.tree.getControl(), 1, 1808);
            Canvas canvas = new Canvas(composite2, 0);
            TestgenUIUtility.layoutControlInGrid((Control)canvas, 1, 256);
            TestgenUIUtility.assignGridLayout((Composite)canvas, 2);
            Label label = TestgenUIUtility.createLabel((Composite)canvas, this.getFileNameLabel(), null);
            this.selectedFileName = TestgenUIUtility.createEditControl((Composite)canvas, "", null);
            if (string != null) {
                this.selectedFileName.setText(string);
            }
            this.selectedFileName.addKeyListener(new KeyListener(){

                public void keyPressed(KeyEvent keyEvent) {
                }

                public void keyReleased(KeyEvent keyEvent) {
                    if (FileLocationSelectionWizardpage.this.selectedFileName.getText() != "") {
                        FileLocationSelectionWizardpage.this.setPageComplete(true);
                    }
                }
            });
            TestgenUIUtility.layoutControlInGrid((Control)label, 1, 128);
            TestgenUIUtility.layoutControlInGrid((Control)this.selectedFileName, 1, 768);
            this.setPageComplete(true);
        }
        catch (TestgenUIUtility.TestGenUIException testGenUIException) {
            testGenUIException.printStackTrace();
        }
    }

    private String getPreviouslySelectedObject(ArrayList arrayList) {
        String string = null;
        String string2 = null;
        string = TestgenPlugin.getDefault().getPreferenceStore().getString(this.getClass().getName());
        if (string == "") {
            return null;
        }
        WorkspaceRoot workspaceRoot = (WorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot();
        StringTokenizer stringTokenizer = new StringTokenizer(string = string.substring(1, string.length()), "/");
        string2 = stringTokenizer.nextToken();
        if (string2 == null) {
            return null;
        }
        Project project = (Project)workspaceRoot.getProject(string2);
        if (!project.exists()) {
            return null;
        }
        File file = null;
        Folder folder = null;
        Folder folder2 = null;
        String string3 = null;
        while (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
            if (folder == null) {
                folder = (Folder)project.getFolder(string3);
                if (folder.exists() || !(file = (File)project.getFile(string3)).exists()) continue;
                arrayList.add(file);
                return string3;
            }
            folder2 = (Folder)folder.getFolder(string3);
            if (folder2.exists()) {
                folder = folder2;
                continue;
            }
            file = (File)folder.getFile(string3);
            break;
        }
        if (file.exists()) {
            arrayList.add(file);
        } else if (folder.exists()) {
            arrayList.add(folder);
        } else {
            arrayList.add(project);
        }
        return string3;
    }

    public boolean isPageComplete() {
        boolean bl;
        boolean bl2 = bl = this.selectedFile != null || this.selectedFileName.getText() != "";
        return bl && this.selectedContainer != null;
    }

    public String getSelectedFilePath() {
        return this.getValidFileName();
    }

    public abstract String getContextHelpID();

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class TreeFilter
    extends ViewerFilter {
        static /* synthetic */ Class class$org$eclipse$core$internal$resources$File;

        TreeFilter() {
        }

        public boolean select(Viewer viewer, Object object, Object object2) {
            if ((class$org$eclipse$core$internal$resources$File == null ? (class$org$eclipse$core$internal$resources$File = TreeFilter.class$("org.eclipse.core.internal.resources.File")) : class$org$eclipse$core$internal$resources$File).isInstance(object2)) {
                File file = (File)object2;
                return file.getFileExtension().compareToIgnoreCase(FileLocationSelectionWizardpage.this.getFileExtension()) == 0;
            }
            return true;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    class TreeSelectionChangedListener
    implements ISelectionChangedListener {
        static /* synthetic */ Class class$org$eclipse$core$internal$resources$File;
        static /* synthetic */ Class class$org$eclipse$core$resources$IFolder;
        static /* synthetic */ Class class$org$eclipse$core$resources$IContainer;

        TreeSelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
            IStructuredSelection iStructuredSelection = (IStructuredSelection)selectionChangedEvent.getSelection();
            Object object = iStructuredSelection.getFirstElement();
            if (iStructuredSelection.size() > 1) {
                FileLocationSelectionWizardpage.this.tree.setSelection((ISelection)new StructuredSelection(object));
            }
            if ((class$org$eclipse$core$internal$resources$File == null ? (class$org$eclipse$core$internal$resources$File = TreeSelectionChangedListener.class$("org.eclipse.core.internal.resources.File")) : class$org$eclipse$core$internal$resources$File).isInstance(object)) {
                FileLocationSelectionWizardpage.this.selectedFile = (File)object;
                IContainer iContainer = FileLocationSelectionWizardpage.this.selectedFile.getParent();
                if ((class$org$eclipse$core$resources$IFolder == null ? (class$org$eclipse$core$resources$IFolder = TreeSelectionChangedListener.class$("org.eclipse.core.resources.IFolder")) : class$org$eclipse$core$resources$IFolder).isInstance(iContainer)) {
                    FileLocationSelectionWizardpage.this.selectedContainer = iContainer;
                    FileLocationSelectionWizardpage.this.selectedFileName.setText(FileLocationSelectionWizardpage.this.selectedFile.getName());
                    FileLocationSelectionWizardpage.this.setPageComplete(true);
                }
            } else if ((class$org$eclipse$core$resources$IContainer == null ? (class$org$eclipse$core$resources$IContainer = TreeSelectionChangedListener.class$("org.eclipse.core.resources.IContainer")) : class$org$eclipse$core$resources$IContainer).isInstance(object)) {
                FileLocationSelectionWizardpage.this.selectedContainer = (IContainer)object;
                FileLocationSelectionWizardpage.this.selectedFile = null;
                FileLocationSelectionWizardpage.this.setPageComplete(true);
            }
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }
}

