/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.execution.recorder;

import org.eclipse.hyades.internal.execution.recorder.RecorderException;
import org.eclipse.hyades.internal.execution.recorder.RecorderFactory;
import org.eclipse.hyades.internal.execution.recorder.local.IRecorderDataProcessor;
import org.eclipse.hyades.internal.execution.recorder.local.RecorderClient;
import org.eclipse.hyades.internal.execution.recorder.remote.RecorderEnvironmentAdapter;
import org.eclipse.hyades.internal.execution.recorder.remote.RecorderExecutableObjectAdapter;

public class Recorder {
    protected String id = null;
    protected RecorderEnvironmentAdapter environmentAdapter = null;
    protected IRecorderDataProcessor dataProcessor = null;
    private String configParams = null;
    private RecorderExecutableObjectAdapter executableObjectAdapter = null;
    private String applicationAdapterID = null;
    private String scriptGeneratorID = null;
    private String recordingPath = null;
    private String testPath = null;
    private RecorderClient client = null;
    private boolean active = false;

    public Recorder(String string, IRecorderDataProcessor iRecorderDataProcessor, RecorderEnvironmentAdapter recorderEnvironmentAdapter, RecorderExecutableObjectAdapter recorderExecutableObjectAdapter) throws RecorderException {
        if (RecorderFactory.getInstance().getRecorderWithID(string) != null) {
            throw new RecorderException("recorder with ID \"" + string + "\" already exists");
        }
        this.id = string;
        this.dataProcessor = iRecorderDataProcessor;
        this.environmentAdapter = recorderEnvironmentAdapter;
        this.executableObjectAdapter = recorderExecutableObjectAdapter;
        RecorderFactory.getInstance().addRecorder(this);
    }

    public RecorderEnvironmentAdapter getAgentEnvironmentAdapter() {
        return this.environmentAdapter;
    }

    public IRecorderDataProcessor getDataProcessor() {
        return this.dataProcessor;
    }

    public String getId() {
        return this.id;
    }

    public void Record() throws RecorderException {
        try {
            this.setActive(true);
            this.client = new RecorderClient();
            this.client.run(this);
        }
        catch (Exception exception) {
            throw new RecorderException(exception.getMessage());
        }
    }

    public String getConfigParams() {
        return this.configParams;
    }

    public void setConfigParams(String string) {
        this.configParams = string;
    }

    public RecorderExecutableObjectAdapter getExecutableObjectAdapter() {
        return this.executableObjectAdapter;
    }

    public String getApplicationAdapterID() {
        return this.applicationAdapterID;
    }

    public void setApplicationAdapterID(String string) {
        this.applicationAdapterID = string;
    }

    public String getRecordingPath() {
        return this.recordingPath;
    }

    public String getScriptgenID() {
        return this.scriptGeneratorID;
    }

    public void setScriptgenID(String string) {
        this.scriptGeneratorID = string;
    }

    public void setRecordingPath(String string) {
        this.recordingPath = string;
    }

    public String getTestPath() {
        return this.testPath;
    }

    public void setTestPath(String string) {
        this.testPath = string;
    }

    public void stopRecorder() {
        this.client.stopRecording();
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean bl) {
        this.active = bl;
    }
}

