/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.http.internal.reports.hitrate;

import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.hyades.test.http.internal.reports.HTTPReportGenerator;
import org.eclipse.hyades.test.http.internal.reports.ReportGraph;
import org.eclipse.hyades.test.http.internal.reports.ReportGraphConfiguration;
import org.eclipse.hyades.test.http.internal.reports.hitrate.HitRateReport;
import org.eclipse.jface.viewers.ISelection;

public class HitRateReportGenerator
extends HTTPReportGenerator {
    public InputStream generate(IFile iFile, ISelection iSelection) throws Exception {
        this.initResultSelection();
        if (this.result == null) {
            throw new Exception("problem resolving selected results");
        }
        HitRateReport hitRateReport = new HitRateReport(this.result);
        hitRateReport.generate();
        ReportGraphConfiguration reportGraphConfiguration = this.setupConfiguration();
        ReportGraph reportGraph = new ReportGraph(hitRateReport.getList(), reportGraphConfiguration);
        IPath iPath = iFile.getFullPath();
        iPath.removeFileExtension().addFileExtension("svg");
        return reportGraph.generate(iPath);
    }

    private ReportGraphConfiguration setupConfiguration() {
        ReportGraphConfiguration reportGraphConfiguration = new ReportGraphConfiguration();
        reportGraphConfiguration.setTitle("Page Hit Rate");
        reportGraphConfiguration.setXTitle("Page");
        reportGraphConfiguration.setYTitle("Hits/second");
        reportGraphConfiguration.setLegendTitle("Legend");
        reportGraphConfiguration.setTimeStampPrefix("");
        reportGraphConfiguration.setMinWidth(800);
        reportGraphConfiguration.setHeight(500);
        return reportGraphConfiguration;
    }
}

