/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.dialog;

import java.util.Vector;
import org.eclipse.hyades.models.common.datapool.DPLDatapool;
import org.eclipse.hyades.models.common.datapool.DPLEquivalenceClass;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

public class DataPoolRowGroupDialog
extends Dialog
implements KeyListener,
SelectionListener {
    private static final String TAG_EQUIVALENCE_CLASSES = "equivalenceClasses";
    private static final int HEIGHT = 60;
    private static final int WIDTH = 300;
    private Shell shell = null;
    private DPLDatapool datapool = null;
    private String title = null;
    private boolean insertionMode = false;
    private Table table = null;
    private DPLEquivalenceClass selectedEquivalenceClass = null;
    private DPLEquivalenceClass previousEquivalenceClass = null;
    private Text nameField = null;
    private Color nameFieldForeground = null;
    private Combo equivalenceClassCombo = null;
    private String name = null;
    private int insertionIndex = -1;

    public DataPoolRowGroupDialog(Shell shell, DPLDatapool dPLDatapool, Table table, DPLEquivalenceClass dPLEquivalenceClass, DPLEquivalenceClass dPLEquivalenceClass2, String string) {
        super(shell);
        this.shell = shell;
        this.datapool = dPLDatapool;
        this.title = string;
        this.table = table;
        this.previousEquivalenceClass = dPLEquivalenceClass2;
        this.selectedEquivalenceClass = dPLEquivalenceClass;
        if (string.equals(TestUIPlugin.getString("DATA_ROW_GRP_DLG_TITLE_INS"))) {
            this.insertionMode = true;
        }
    }

    protected Control createContents(Composite composite) {
        Control control = super.createContents(composite);
        this.enableOK();
        return control;
    }

    protected Control createDialogArea(Composite composite) {
        this.getShell().setText(this.title);
        Composite composite2 = (Composite)super.createDialogArea(composite);
        GridData gridData = GridDataUtil.createFill();
        gridData.heightHint = 60;
        gridData.widthHint = 300;
        composite2.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 0);
        label.setText(TestUIPlugin.getString("DATA_ROW_GRP_DLG_NAME"));
        this.nameField = new Text(composite2, 2052);
        gridData = new GridData(256);
        gridData.horizontalSpan = 1;
        this.nameField.setLayoutData((Object)gridData);
        this.nameField.addKeyListener((KeyListener)this);
        if (this.selectedEquivalenceClass != null) {
            this.name = this.selectedEquivalenceClass.getName();
            this.nameField.setText(this.name);
            this.nameField.setSelection(this.name.length() + 1);
        }
        Label label2 = new Label(composite2, 0);
        if (this.insertionMode) {
            label2.setText(TestUIPlugin.getString("DATA_ROW_GRP_DLG_INS"));
        } else {
            label2.setText(TestUIPlugin.getString("DATA_ROW_GRP_DLG_MOVE"));
        }
        this.equivalenceClassCombo = new Combo(composite2, 12);
        DPLEquivalenceClass[] dPLEquivalenceClassArray = null;
        dPLEquivalenceClassArray = this.getEquivalenceClasses(null);
        String[] stringArray = this.getEquivalenceClassLabels(dPLEquivalenceClassArray);
        this.equivalenceClassCombo.setItems(stringArray);
        this.equivalenceClassCombo.setData(TAG_EQUIVALENCE_CLASSES, (Object)dPLEquivalenceClassArray);
        gridData = new GridData(256);
        gridData.horizontalSpan = 1;
        gridData.widthHint = 150;
        this.equivalenceClassCombo.setLayoutData((Object)gridData);
        this.equivalenceClassCombo.addSelectionListener((SelectionListener)this);
        if (this.previousEquivalenceClass != null) {
            int n = this.datapool.getEquivalenceClasses().indexOf(this.previousEquivalenceClass);
            if (n != -1) {
                this.equivalenceClassCombo.select(n);
                this.insertionIndex = n;
            }
        } else {
            this.equivalenceClassCombo.select(this.equivalenceClassCombo.getItemCount() - 1);
            this.insertionIndex = -1;
        }
        return composite2;
    }

    private boolean enableOK() {
        if (this.nameField != null && this.nameField.getText().length() > 0) {
            if (this.isNameUnique(this.nameField.getText())) {
                this.nameField.setForeground(this.nameFieldForeground);
                this.getButton(0).setEnabled(true);
                return true;
            }
            Display display = Display.getDefault();
            Color color = display.getSystemColor(3);
            this.nameField.setForeground(color);
        }
        this.getButton(0).setEnabled(false);
        return false;
    }

    private DPLEquivalenceClass[] getEquivalenceClasses(String string) {
        Object object;
        int n = this.datapool.getEquivalenceClasses().size();
        Vector<DPLEquivalenceClass> vector = new Vector<DPLEquivalenceClass>();
        int n2 = 0;
        while (n2 < n) {
            DPLEquivalenceClass dPLEquivalenceClass = (DPLEquivalenceClass)this.datapool.getEquivalenceClasses().get(n2);
            object = dPLEquivalenceClass.getId();
            if (!((String)object).equals(string)) {
                vector.add(dPLEquivalenceClass);
            }
            ++n2;
        }
        int n3 = vector.size();
        object = new DPLEquivalenceClass[n3];
        vector.toArray((T[])object);
        return object;
    }

    private String[] getEquivalenceClassLabels(DPLEquivalenceClass[] dPLEquivalenceClassArray) {
        int n = 0;
        if (dPLEquivalenceClassArray != null) {
            n = dPLEquivalenceClassArray.length;
        }
        String[] stringArray = new String[n + 1];
        int n2 = 0;
        while (n2 < n) {
            DPLEquivalenceClass dPLEquivalenceClass = dPLEquivalenceClassArray[n2];
            stringArray[n2] = dPLEquivalenceClass.getName();
            ++n2;
        }
        stringArray[n] = TestUIPlugin.getString("DATA_ROW_GRP_DLG_HEAD_VAR");
        return stringArray;
    }

    private String[] getRecordIndexLabels(DPLEquivalenceClass dPLEquivalenceClass) {
        if (dPLEquivalenceClass == null) {
            return null;
        }
        int n = dPLEquivalenceClass.getRecord().size();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = String.valueOf(n2);
            ++n2;
        }
        return stringArray;
    }

    private int findEquivalenceClassIndexInCombo(DPLEquivalenceClass[] dPLEquivalenceClassArray, DPLEquivalenceClass dPLEquivalenceClass) {
        if (dPLEquivalenceClassArray == null || dPLEquivalenceClass == null) {
            return -1;
        }
        int n = 0;
        while (n < dPLEquivalenceClassArray.length) {
            if (dPLEquivalenceClassArray[n].equals(dPLEquivalenceClass)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private boolean isNameUnique(String string) {
        if (this.datapool == null) {
            return true;
        }
        int n = 0;
        while (n < this.datapool.getEquivalenceClasses().size()) {
            DPLEquivalenceClass dPLEquivalenceClass = (DPLEquivalenceClass)this.datapool.getEquivalenceClasses().get(n);
            if (!dPLEquivalenceClass.equals(this.selectedEquivalenceClass) && string.equals(dPLEquivalenceClass.getName())) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public String getName() {
        return this.name;
    }

    public int getInsertionIndex() {
        return this.insertionIndex;
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        DPLEquivalenceClass dPLEquivalenceClass = null;
        Combo combo = (Combo)selectionEvent.widget;
        if (combo.getSelectionIndex() != combo.getItemCount() - 1) {
            int n = combo.getSelectionIndex();
            DPLEquivalenceClass[] dPLEquivalenceClassArray = (DPLEquivalenceClass[])combo.getData(TAG_EQUIVALENCE_CLASSES);
            dPLEquivalenceClass = dPLEquivalenceClassArray[n];
            this.insertionIndex = this.datapool.getEquivalenceClasses().indexOf(dPLEquivalenceClass);
        } else {
            this.insertionIndex = -1;
        }
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (this.nameField != null) {
            this.name = this.nameField.getText();
        }
        this.enableOK();
    }

    public void keyReleased(KeyEvent keyEvent) {
    }
}

