/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.editor.extension;

import org.eclipse.hyades.models.common.configuration.CFGLocation;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.editor.extension.BaseEditorExtension;
import org.eclipse.hyades.test.ui.internal.editor.form.DeploymentForm;
import org.eclipse.hyades.test.ui.internal.editor.form.LocationForm;
import org.eclipse.hyades.test.ui.internal.editor.form.util.WidgetFactory;
import org.eclipse.hyades.ui.editor.IHyadesEditorPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class DeploymentEditorExtension
extends BaseEditorExtension {
    private static final int PAGE_OVERVIEW = 0;
    private static final int PAGE_LOCATIONS = 1;
    public static final String EXTENSION_ID = "org.eclipse.hyades.test.ui.editor.extension.Deployment";
    private DeploymentForm deploymentForm;
    private LocationForm locationsForm;

    public void dispose() {
        this.deploymentForm.getWidgetFactory().dispose();
        this.deploymentForm.dispose();
        this.locationsForm.dispose();
        super.dispose();
    }

    public TPFDeployment getDeployment() {
        return (TPFDeployment)this.getHyadesEditorPart().getEditorObject();
    }

    public void createPages() {
        IHyadesEditorPart iHyadesEditorPart = this.getHyadesEditorPart();
        WidgetFactory widgetFactory = new WidgetFactory();
        this.deploymentForm = new DeploymentForm(this, widgetFactory);
        this.deploymentForm.setLocationPageIndex(1);
        iHyadesEditorPart.addPage(this.deploymentForm.createControl());
        iHyadesEditorPart.setPageText(0, TestUIPlugin.getString("W_OVERVIEW"));
        this.locationsForm = new LocationForm(this, widgetFactory);
        iHyadesEditorPart.addPage(this.locationsForm.createControl());
        iHyadesEditorPart.setPageText(1, TestUIPlugin.getString("W_LOCS"));
        this.deploymentForm.updateTitle();
    }

    public void refreshContent(Object object) {
        this.deploymentForm.load();
        this.deploymentForm.updateTitle();
        this.locationsForm.load();
    }

    public IStructuredSelection getSelection() {
        switch (this.getHyadesEditorPart().getActivePage()) {
            case 0: {
                return new StructuredSelection((Object)this.getDeployment());
            }
            case 1: {
                return (IStructuredSelection)this.locationsForm.getSelection();
            }
        }
        return StructuredSelection.EMPTY;
    }

    public boolean pageActivated(int n) {
        switch (n) {
            case 0: {
                return this.deploymentForm.activated();
            }
            case 1: {
                return this.locationsForm.activated();
            }
        }
        return false;
    }

    public void setSelection(IStructuredSelection iStructuredSelection) {
        Object object;
        if (iStructuredSelection.size() == 1 && (object = iStructuredSelection.getFirstElement()) != this.getDeployment() && object instanceof CFGLocation) {
            this.getHyadesEditorPart().setActivePage(1);
            this.locationsForm.selectReveal((ISelection)iStructuredSelection);
        }
    }
}

