/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.editor.form.base;

import org.eclipse.hyades.test.ui.internal.editor.form.base.FormSection;
import org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.base.IForm;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.JFacePreferences;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public abstract class AbstractForm
implements IForm,
IPropertyChangeListener {
    protected FormWidgetFactory factory = new FormWidgetFactory();
    protected Color headingBackground;
    protected Color headingForeground;
    protected boolean headingVisible = true;
    protected Image headingImage;
    protected String headingText;
    protected Font titleFont = JFaceResources.getHeaderFont();
    private IPropertyChangeListener hyperlinkColorListener;

    public AbstractForm() {
        JFaceResources.getFontRegistry().addListener((IPropertyChangeListener)this);
        IPreferenceStore iPreferenceStore = JFacePreferences.getPreferenceStore();
        this.hyperlinkColorListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getProperty().equals("HYPERLINK_COLOR") || propertyChangeEvent.getProperty().equals("ACTIVE_HYPERLINK_COLOR")) {
                    AbstractForm.this.updateHyperlinkColors();
                }
            }
        };
        iPreferenceStore.addPropertyChangeListener(this.hyperlinkColorListener);
    }

    protected void updateHyperlinkColors() {
        this.factory.updateHyperlinkColors();
    }

    public void commitChanges(boolean bl) {
    }

    public abstract Control createControl(Composite var1);

    public void dispose() {
        this.factory.dispose();
        JFaceResources.getFontRegistry().removeListener((IPropertyChangeListener)this);
        IPreferenceStore iPreferenceStore = JFacePreferences.getPreferenceStore();
        iPreferenceStore.removePropertyChangeListener((IPropertyChangeListener)this);
        iPreferenceStore.removePropertyChangeListener(this.hyperlinkColorListener);
    }

    public boolean doGlobalAction(String string) {
        return false;
    }

    public void expandTo(Object object) {
    }

    public abstract Control getControl();

    public FormWidgetFactory getFactory() {
        return this.factory;
    }

    public Color getHeadingBackground() {
        return this.headingBackground;
    }

    public Color getHeadingForeground() {
        return this.headingForeground;
    }

    public Image getHeadingImage() {
        return this.headingImage;
    }

    public String getHeadingText() {
        if (this.headingText == null) {
            return "";
        }
        return this.headingText;
    }

    public void initialize(Object object) {
    }

    public boolean isHeadingVisible() {
        return this.headingVisible;
    }

    public void registerSection(FormSection formSection) {
    }

    public void setFocus() {
    }

    public void setHeadingBackground(Color color) {
        this.headingBackground = color;
    }

    public void setHeadingForeground(Color color) {
        this.headingForeground = color;
    }

    public void setHeadingImage(Image image) {
        this.headingImage = image;
    }

    public void setHeadingVisible(boolean bl) {
        this.headingVisible = bl;
    }

    public void setHeadingText(String string) {
        this.headingText = string;
    }

    public void update() {
    }

    protected boolean canPerformDirectly(String string, Control control) {
        if (control instanceof Text) {
            Text text = (Text)control;
            if (string.equals("cut")) {
                text.cut();
                return true;
            }
            if (string.equals("copy")) {
                text.copy();
                return true;
            }
            if (string.equals("paste")) {
                text.paste();
                return true;
            }
            if (string.equals("selectAll")) {
                text.selectAll();
                return true;
            }
            if (string.equals("delete")) {
                int n = text.getSelectionCount();
                if (n == 0) {
                    int n2 = text.getCaretPosition();
                    text.setSelection(n2, n2 + 1);
                }
                text.insert("");
                return true;
            }
        }
        return false;
    }

    public abstract void propertyChange(PropertyChangeEvent var1);
}

