/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.editor.form.base;

import org.eclipse.hyades.models.common.datapool.Common_DatapoolFactory;
import org.eclipse.hyades.models.common.datapool.DPLCell;
import org.eclipse.hyades.models.common.datapool.DPLDatapool;
import org.eclipse.hyades.models.common.datapool.DPLEquivalenceClass;
import org.eclipse.hyades.models.common.datapool.DPLRecord;
import org.eclipse.hyades.models.common.datapool.DPLVariable;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.action.DeleteColumnAction;
import org.eclipse.hyades.test.ui.internal.action.DeleteRowAction;
import org.eclipse.hyades.test.ui.internal.action.DeleteRowGroupAction;
import org.eclipse.hyades.test.ui.internal.action.EditColumnAction;
import org.eclipse.hyades.test.ui.internal.action.EditRowAction;
import org.eclipse.hyades.test.ui.internal.action.EditRowGroupAction;
import org.eclipse.hyades.test.ui.internal.action.InsertColumnAction;
import org.eclipse.hyades.test.ui.internal.action.InsertRowAction;
import org.eclipse.hyades.test.ui.internal.action.InsertRowGroupAction;
import org.eclipse.hyades.test.ui.internal.dialog.DataPoolColumnDialog;
import org.eclipse.hyades.test.ui.internal.dialog.DataPoolRowDialog;
import org.eclipse.hyades.test.ui.internal.dialog.DataPoolRowGroupDialog;
import org.eclipse.hyades.test.ui.internal.editor.extension.DatapoolEditorExtension;
import org.eclipse.hyades.test.ui.internal.editor.form.base.DatapoolTableUtil;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.ControlEditor;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.TableCursor;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPartSite;

public class DatapoolTable
implements IMenuListener,
SelectionListener {
    private static final String START_LITERAL = "<Literal>";
    private static final String END_LITERAL = "</Literal>";
    private static final String TAG_DATA = "data";
    private static final String TAG_RECORD = "record";
    private static final String TAG_VARIABLE = "variable";
    private static final String TAG_VARIABLE_INDEX = "variableIndex";
    private static final String TAG_EQUIVALENCE_CLASS = "equivalenceClass";
    private static final int MAX_TABLE_WIDTH = 60000;
    private static final int MAX_TABLE_HEIGHT = 120000;
    private DPLDatapool datapool = null;
    private Table table = null;
    private DatapoolTableUtil tableUtil = null;
    private TableViewer viewer = null;
    private Composite parent = null;
    private Menu contextMenu = null;
    private TableCursor cursor = null;
    private ControlEditor controlEditor = null;
    private DatapoolEditorExtension extension = null;
    private Text textEditor = null;
    private FocusListener focusListener;
    private ICellEditorListener cellEditorListener;
    private SelectionListener headerListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            if (DatapoolTable.this.extension.getHyadesEditorPart().isReadOnly()) {
                return;
            }
            if (DatapoolTable.this.textEditor != null && !DatapoolTable.this.textEditor.isDisposed()) {
                DatapoolTable.this.textEditor.dispose();
            }
            TableColumn tableColumn = (TableColumn)selectionEvent.widget;
            DatapoolTable.this.editColumnAux(tableColumn);
        }
    };
    private ControlListener resizeListener = new ControlAdapter(){

        public void controlMoved(ControlEvent controlEvent) {
        }

        public void controlResized(ControlEvent controlEvent) {
            DatapoolTable.this.resetScrollBarSize(true);
        }
    };
    private ControlListener resizeColumnListener = new ControlAdapter(){

        public void controlMoved(ControlEvent controlEvent) {
        }

        public void controlResized(ControlEvent controlEvent) {
            if (DatapoolTable.this.cursor != null && !DatapoolTable.this.cursor.isDisposed()) {
                DatapoolTable.this.cursor.setSelection(DatapoolTable.this.table.getSelectionIndex(), DatapoolTable.this.cursor.getColumn());
            }
            DatapoolTable.this.resetScrollBarSize(false);
        }
    };
    private InsertRowAction insertRowAction = null;
    private DeleteRowAction deleteRowAction = null;
    private EditRowAction editRowAction = null;
    private InsertColumnAction insertColumnAction = null;
    private DeleteColumnAction deleteColumnAction = null;
    private EditColumnAction editColumnAction = null;
    private InsertRowGroupAction insertRowGroupAction = null;
    private DeleteRowGroupAction deleteRowGroupAction = null;
    private EditRowGroupAction editRowGroupAction = null;

    public DatapoolTable(Composite composite, DatapoolEditorExtension datapoolEditorExtension, DPLDatapool dPLDatapool) {
        if (composite == null || dPLDatapool == null || datapoolEditorExtension == null) {
            return;
        }
        this.datapool = dPLDatapool;
        this.parent = composite;
        this.setWaitCursor();
        this.extension = datapoolEditorExtension;
        this.createTable(composite);
        this.tableUtil = new DatapoolTableUtil(this.table);
        MenuManager menuManager = new MenuManager("#DatapoolEditor");
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener((IMenuListener)this);
        this.contextMenu = menuManager.createContextMenu((Control)this.table);
        this.table.setMenu(this.contextMenu);
        this.table.addSelectionListener((SelectionListener)this);
        IWorkbenchPartSite iWorkbenchPartSite = this.extension.getHyadesEditorPart().getEditorPart().getSite();
        iWorkbenchPartSite.setSelectionProvider((ISelectionProvider)this.viewer);
        this.makeActions();
        try {
            composite.getParent().getParent().addControlListener(this.resizeListener);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.unsetWaitCursor();
    }

    private void createTable(Composite composite) {
        this.table = new Table(composite, 67584);
        this.viewer = new TableViewer(this.table);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        gridData.widthHint = 60000;
        gridData.heightHint = 120000;
        this.table.setLayoutData((Object)gridData);
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnPixelData(100, false));
        this.table.setLayout((Layout)tableLayout);
        if (this.isWithoutColumns()) {
            this.makeHeaderColumn();
        } else {
            this.makeColumns();
        }
        if (!this.isWithoutRows()) {
            this.makeRows();
        }
        this.createCursor();
        this.table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.keyCode == 262144 && (keyEvent.stateMask & 0x20000) != 0) {
                    return;
                }
                if (keyEvent.keyCode == 131072 && (keyEvent.stateMask & 0x40000) != 0) {
                    return;
                }
                if (keyEvent.keyCode != 262144 && (keyEvent.stateMask & 0x40000) != 0) {
                    return;
                }
                if (keyEvent.keyCode != 131072 && (keyEvent.stateMask & 0x20000) != 0) {
                    return;
                }
                if (DatapoolTable.this.table.getItemCount() != 0) {
                    TableItem[] tableItemArray = DatapoolTable.this.table.getSelection();
                    TableItem tableItem = tableItemArray.length == 0 ? DatapoolTable.this.table.getItem(DatapoolTable.this.table.getTopIndex()) : tableItemArray[0];
                    DatapoolTable.this.table.showItem(tableItem);
                    DatapoolTable.this.cursor.setSelection(tableItem, 0);
                    DatapoolTable.this.cursor.setVisible(true);
                    DatapoolTable.this.cursor.setFocus();
                }
            }
        });
    }

    private void createCursor() {
        if (this.datapool.getEquivalenceClasses().size() == 0) {
            return;
        }
        this.cursor = new TableCursor(this.table, 0);
        this.controlEditor = new ControlEditor((Composite)this.cursor);
        this.controlEditor.grabHorizontal = true;
        this.controlEditor.grabVertical = true;
        this.cursor.setMenu(this.contextMenu);
        this.cursor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (DatapoolTable.this.extension.getHyadesEditorPart().isReadOnly()) {
                    return;
                }
                if (DatapoolTable.this.textEditor != null && !DatapoolTable.this.textEditor.isDisposed()) {
                    DatapoolTable.this.textEditor.dispose();
                }
                DatapoolTable.this.table.setSelection(new TableItem[]{DatapoolTable.this.cursor.getRow()});
                DatapoolTable.this.setScrollBars();
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                if (DatapoolTable.this.extension.getHyadesEditorPart().isReadOnly()) {
                    return;
                }
                DatapoolTable.this.textEditor = new Text((Composite)DatapoolTable.this.cursor, 0);
                TableItem tableItem = DatapoolTable.this.cursor.getRow();
                int n = DatapoolTable.this.cursor.getColumn();
                if (n == 0) {
                    DatapoolTable.this.editRowAux(DatapoolTable.this.cursor.getRow());
                    return;
                }
                DatapoolTable.this.textEditor.setText(tableItem.getText(n));
                DatapoolTable.this.textEditor.addKeyListener((KeyListener)new TableCellKeyAdaptor(DatapoolTable.this.textEditor, tableItem, n));
                DatapoolTable.this.controlEditor.setEditor((Control)DatapoolTable.this.textEditor);
                DatapoolTable.this.textEditor.setFocus();
            }
        });
        this.cursor.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                int n;
                if (DatapoolTable.this.extension.getHyadesEditorPart().isReadOnly()) {
                    return;
                }
                if (keyEvent.keyCode == 0x1000009 && (keyEvent.stateMask & 0x40000) != 0) {
                    int n2 = DatapoolTable.this.cursor.getColumn();
                    if (n2 == 0) {
                        DatapoolTable.this.insertRowGroup();
                    }
                    if (n2 > 0) {
                        DatapoolTable.this.insertColumn();
                    }
                    return;
                }
                if (keyEvent.keyCode == 127 && (keyEvent.stateMask & 0x40000) != 0) {
                    int n3 = DatapoolTable.this.cursor.getColumn();
                    if (n3 == 0) {
                        DatapoolTable.this.deleteRowGroup();
                    }
                    if (n3 > 0) {
                        DatapoolTable.this.deleteColumn();
                    }
                    return;
                }
                if (keyEvent.keyCode == 27 || keyEvent.keyCode == 13 || keyEvent.keyCode == 65536 || keyEvent.keyCode == 0x1000006 || keyEvent.keyCode == 0x1000005 || keyEvent.keyCode == 0x1000007 || keyEvent.keyCode == 0x1000008 || keyEvent.keyCode == 262144 || keyEvent.keyCode == 131072 || (keyEvent.stateMask & 0x40000) != 0 || (keyEvent.stateMask & 0x10000) != 0 || keyEvent.keyCode >= 0x100000A && keyEvent.keyCode <= 0x1000015) {
                    return;
                }
                if (keyEvent.keyCode == 0x1000009) {
                    n = DatapoolTable.this.cursor.getColumn();
                    if (n == 0) {
                        DatapoolTable.this.insertRow();
                    }
                    if (n <= 0) {
                        return;
                    }
                }
                if (keyEvent.keyCode == 127) {
                    n = DatapoolTable.this.cursor.getColumn();
                    if (n == 0) {
                        DatapoolTable.this.deleteRow();
                    }
                    if (n > 0) {
                        DatapoolTable.this.clearCell();
                    }
                    return;
                }
                if (keyEvent.keyCode == 0x1000002 || keyEvent.keyCode == 0x1000001 || keyEvent.keyCode == 0x1000003 || keyEvent.keyCode == 0x1000004) {
                    int n4;
                    if (DatapoolTable.this.textEditor != null && !DatapoolTable.this.textEditor.isDisposed()) {
                        DatapoolTable.this.textEditor.dispose();
                    }
                    n = DatapoolTable.this.cursor.getColumn();
                    int n5 = DatapoolTable.this.table.getSelectionIndex();
                    if (keyEvent.keyCode == 0x1000004 && n > (n4 = DatapoolTable.this.tableUtil.getColumnCount()) - 1) {
                        DatapoolTable.this.cursor.setSelection(n5, n - 1);
                    }
                    return;
                }
                n = keyEvent.character;
                DatapoolTable.this.textEditor = new Text((Composite)DatapoolTable.this.cursor, 0);
                TableItem tableItem = DatapoolTable.this.cursor.getRow();
                int n6 = DatapoolTable.this.cursor.getColumn();
                if (n6 == 0) {
                    DatapoolTable.this.editRowAux(DatapoolTable.this.cursor.getRow());
                    return;
                }
                if (keyEvent.keyCode == 8) {
                    DatapoolTable.this.textEditor.setText(new String());
                } else {
                    DatapoolTable.this.textEditor.setText(tableItem.getText(n6) + String.valueOf((char)n));
                }
                DatapoolTable.this.textEditor.setSelection(DatapoolTable.this.textEditor.getText().length() + 1);
                DatapoolTable.this.textEditor.addKeyListener((KeyListener)new TableCellKeyAdaptor(DatapoolTable.this.textEditor, tableItem, n6));
                DatapoolTable.this.controlEditor.setEditor((Control)DatapoolTable.this.textEditor);
                DatapoolTable.this.textEditor.setFocus();
            }
        });
        this.cursor.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent mouseEvent) {
                if (DatapoolTable.this.extension.getHyadesEditorPart().isReadOnly()) {
                    return;
                }
                DatapoolTable.this.textEditor = new Text((Composite)DatapoolTable.this.cursor, 0);
                TableItem tableItem = DatapoolTable.this.cursor.getRow();
                int n = DatapoolTable.this.cursor.getColumn();
                if (n == 0) {
                    DatapoolTable.this.editRowAux(tableItem);
                    return;
                }
                DatapoolTable.this.textEditor.setText(tableItem.getText(n));
                DatapoolTable.this.textEditor.setSelection(DatapoolTable.this.textEditor.getText().length() + 1);
                DatapoolTable.this.textEditor.addKeyListener((KeyListener)new TableCellKeyAdaptor(DatapoolTable.this.textEditor, tableItem, n));
                DatapoolTable.this.controlEditor.setEditor((Control)DatapoolTable.this.textEditor);
                DatapoolTable.this.textEditor.setFocus();
            }

            public void mouseDown(MouseEvent mouseEvent) {
                if (mouseEvent.button == 3) {
                    DatapoolTable.this.contextMenu.setEnabled(true);
                    DatapoolTable.this.contextMenu.setVisible(true);
                }
                if (mouseEvent.button != 1) {
                    return;
                }
                if (DatapoolTable.this.textEditor != null && !DatapoolTable.this.textEditor.isDisposed()) {
                    DatapoolTable.this.textEditor.dispose();
                }
            }

            public void mouseUp(MouseEvent mouseEvent) {
            }
        });
        if (this.table.getItemCount() > 0) {
            this.table.select(0);
            this.cursor.setSelection(0, 0);
        }
    }

    private void setWaitCursor() {
        if (this.parent == null) {
            return;
        }
        Display display = this.parent.getShell().getDisplay();
        Cursor cursor = new Cursor((Device)display, 1);
        this.setDisplayCursor(cursor);
    }

    private void unsetWaitCursor() {
        this.setDisplayCursor(null);
    }

    private void setDisplayCursor(Cursor cursor) {
        if (this.parent == null) {
            return;
        }
        Display display = this.parent.getShell().getDisplay();
        Shell[] shellArray = display.getShells();
        int n = 0;
        while (n < shellArray.length) {
            shellArray[n].setCursor(cursor);
            ++n;
        }
    }

    private void applyEditingValue(String string) {
        if (this.cursor != null && this.cursor.getColumn() > 0) {
            TableItem tableItem = this.cursor.getRow();
            int n = this.cursor.getColumn();
            if (tableItem == null || tableItem.isDisposed()) {
                return;
            }
            DPLCell[] dPLCellArray = (DPLCell[])tableItem.getData(TAG_DATA);
            DPLCell dPLCell = dPLCellArray[this.cursor.getColumn() - 1];
            if (dPLCell == null) {
                if (string.length() == 0) {
                    if (this.textEditor != null && !this.textEditor.isDisposed()) {
                        this.textEditor.dispose();
                    }
                    return;
                }
                dPLCell = Common_DatapoolFactory.eINSTANCE.createDPLCell();
                dPLCell.setRecord((DPLRecord)tableItem.getData(TAG_RECORD));
                TableColumn tableColumn = this.table.getColumn(n);
                dPLCell.setVariable((DPLVariable)tableColumn.getData(TAG_VARIABLE));
                dPLCellArray[this.cursor.getColumn() - 1] = dPLCell;
            } else if (this.wrapAsLiterl(string).equals(dPLCell.getValue())) {
                if (this.textEditor != null && !this.textEditor.isDisposed()) {
                    this.textEditor.dispose();
                }
                return;
            }
            dPLCell.setValue(this.wrapAsLiterl(string));
            tableItem.setText(this.cursor.getColumn(), string);
            this.cursor.setSelection(this.table.getSelectionIndex(), this.cursor.getColumn());
            this.extension.markDirty();
            if (this.textEditor != null && !this.textEditor.isDisposed()) {
                this.textEditor.dispose();
            }
        }
    }

    private void makeColumns() {
        this.makeHeaderColumn();
        int n = 0;
        while (n < this.datapool.getVariables().size()) {
            TableColumn tableColumn = new TableColumn(this.table, 0, n + 1);
            DPLVariable dPLVariable = (DPLVariable)this.datapool.getVariables().get(n);
            tableColumn.setResizable(true);
            tableColumn.setText(dPLVariable.getName() + TestUIPlugin.getString("DATA_EDT_DIVIDER") + dPLVariable.getType());
            tableColumn.setData(TAG_VARIABLE, (Object)dPLVariable);
            tableColumn.setData(TAG_VARIABLE_INDEX, (Object)new Integer(n));
            tableColumn.setWidth(100);
            tableColumn.addSelectionListener(this.headerListener);
            tableColumn.addControlListener(this.resizeColumnListener);
            ++n;
        }
    }

    private void makeHeaderColumn() {
        TableColumn tableColumn = new TableColumn(this.table, 0, 0);
        tableColumn.setResizable(true);
        tableColumn.setWidth(100);
        tableColumn.setData(TAG_VARIABLE, null);
        tableColumn.addControlListener(this.resizeColumnListener);
    }

    private void makeRows() {
        int n = 0;
        while (n < this.datapool.getEquivalenceClasses().size()) {
            DPLEquivalenceClass dPLEquivalenceClass = (DPLEquivalenceClass)this.datapool.getEquivalenceClasses().get(n);
            int n2 = 0;
            while (n2 < dPLEquivalenceClass.getRecord().size()) {
                DPLCell dPLCell;
                DPLRecord dPLRecord = (DPLRecord)dPLEquivalenceClass.getRecord().get(n2);
                int n3 = dPLRecord.getCells().size();
                String[] stringArray = new String[this.datapool.getVariables().size() + 1];
                DPLCell[] dPLCellArray = new DPLCell[this.datapool.getVariables().size()];
                stringArray[0] = dPLEquivalenceClass.getName() + TestUIPlugin.getString("DATA_EDT_DIVIDER") + String.valueOf(n2);
                int n4 = 0;
                while (n4 < n3) {
                    dPLCell = (DPLCell)dPLRecord.getCells().get(n4);
                    DPLVariable dPLVariable = dPLCell.getVariable();
                    int n5 = this.findColumnIndex(dPLVariable.getId());
                    stringArray[n5] = this.unwrapLiteral(dPLCell.getValue());
                    dPLCellArray[n5 - 1] = dPLCell;
                    ++n4;
                }
                dPLCell = new TableItem(this.table, 0);
                dPLCell.setText(stringArray);
                dPLCell.setData(TAG_DATA, (Object)dPLCellArray);
                dPLCell.setData(TAG_RECORD, (Object)dPLRecord);
                dPLCell.setData(TAG_EQUIVALENCE_CLASS, (Object)dPLEquivalenceClass);
                ++n2;
            }
            ++n;
        }
    }

    private boolean isWithoutRows() {
        if (this.datapool.getEquivalenceClasses().size() > 0) {
            if (this.datapool.getEquivalenceClasses().size() == 1) {
                DPLEquivalenceClass dPLEquivalenceClass = (DPLEquivalenceClass)this.datapool.getEquivalenceClasses().get(0);
                return dPLEquivalenceClass.getRecord().size() == 0;
            }
            return false;
        }
        return true;
    }

    private boolean isWithoutColumns() {
        return this.datapool.getVariables().size() == 0;
    }

    private int findColumnIndex(String string) {
        int n = 0;
        while (n < this.table.getColumnCount()) {
            TableColumn tableColumn = this.table.getColumn(n);
            DPLVariable dPLVariable = (DPLVariable)tableColumn.getData(TAG_VARIABLE);
            if (dPLVariable != null && string.equals(dPLVariable.getId())) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private void setScrollBars() {
        Point point = this.cursor.getLocation();
        Composite composite = this.parent.getParent().getParent();
        if (composite != null && composite instanceof ScrolledComposite) {
            int n = composite.getBounds().height;
            int n2 = composite.getBounds().width;
            int n3 = point.x - n2 + this.cursor.getBounds().width + 30;
            int n4 = point.y - n + this.cursor.getBounds().height + 53;
            ((ScrolledComposite)composite).setOrigin(n3, n4);
        }
    }

    private void resizeScrollBars() {
        try {
            Composite composite = this.parent.getParent().getParent();
            int n = composite.getHorizontalBar().getMaximum();
            int n2 = composite.getVerticalBar().getMaximum();
            int n3 = composite.getBounds().height;
            int n4 = composite.getBounds().width;
            int n5 = this.table.getBounds().width;
            int n6 = this.table.getBounds().height;
            int n7 = 0;
            int n8 = 68;
            int n9 = 0;
            while (n9 < this.table.getColumnCount()) {
                n7 += this.table.getColumn(n9).getWidth();
                ++n9;
            }
            int n10 = 0;
            while (n10 < this.table.getItemCount()) {
                TableItem tableItem = this.table.getItem(n10);
                n8 += tableItem.getBounds((int)0).height + 1;
                ++n10;
            }
            if (n7 < n4) {
                composite.getHorizontalBar().setVisible(false);
            } else {
                composite.getHorizontalBar().setVisible(true);
                if (n < 119) {
                    composite.getHorizontalBar().setMaximum(n7 - n4 + 44);
                } else {
                    composite.getHorizontalBar().setMaximum(n7 + 12);
                }
            }
            if (n8 < n3) {
                composite.getVerticalBar().setVisible(false);
            } else {
                composite.getVerticalBar().setVisible(true);
                if (n2 < 119) {
                    composite.getVerticalBar().setMaximum(n8 - n3 + 58);
                } else {
                    composite.getVerticalBar().setMaximum(n8 - 12);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void resetScrollBarSize(boolean bl) {
        try {
            Composite composite = this.table.getParent().getParent().getParent();
            int n = composite.getHorizontalBar().getMaximum();
            int n2 = composite.getVerticalBar().getMaximum();
            int n3 = composite.getBounds().height;
            int n4 = composite.getBounds().width;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            while (n7 < this.table.getColumnCount()) {
                n5 += this.table.getColumn(n7).getWidth();
                ++n7;
            }
            int n8 = 0;
            while (n8 < this.table.getItemCount()) {
                TableItem tableItem = this.table.getItem(n8);
                n6 += tableItem.getBounds((int)0).height + 1;
                ++n8;
            }
            if (n5 + 14 < n4) {
                n5 = 0;
            }
            if (n6 < n3) {
                n6 = 0;
            }
            if (bl) {
                composite.getHorizontalBar().setMaximum(n + n5 - 60000 - 26);
                composite.getVerticalBar().setMaximum(n2 + n6 - 120000 - 4);
            } else {
                if (n < 119) {
                    composite.getHorizontalBar().setMaximum(n5 - n4 + 44);
                } else {
                    composite.getHorizontalBar().setMaximum(n5 + 12);
                }
                if (n2 < 119) {
                    composite.getVerticalBar().setMaximum(n6 - n3 + 58);
                } else {
                    composite.getVerticalBar().setMaximum(n6 - 12);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        int n;
        int n2 = this.table.getSelectionIndex();
        if (this.cursor != null && !this.cursor.isDisposed() && (n = this.cursor.getColumn()) >= 0) {
            this.cursor.setSelection(n2, n);
        }
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    private void makeActions() {
        TableViewer tableViewer = this.viewer;
        this.insertRowAction = new InsertRowAction((ISelectionProvider)tableViewer, this);
        this.deleteRowAction = new DeleteRowAction((ISelectionProvider)tableViewer, this);
        this.editRowAction = new EditRowAction((ISelectionProvider)tableViewer, this);
        this.insertColumnAction = new InsertColumnAction((ISelectionProvider)tableViewer, this);
        this.deleteColumnAction = new DeleteColumnAction((ISelectionProvider)tableViewer, this);
        this.editColumnAction = new EditColumnAction((ISelectionProvider)tableViewer, this);
        this.insertRowGroupAction = new InsertRowGroupAction((ISelectionProvider)tableViewer, this);
        this.deleteRowGroupAction = new DeleteRowGroupAction((ISelectionProvider)tableViewer, this);
        this.editRowGroupAction = new EditRowGroupAction((ISelectionProvider)tableViewer, this);
    }

    public void menuAboutToShow(IMenuManager iMenuManager) {
        MenuManager menuManager = (MenuManager)iMenuManager;
        menuManager.add((IAction)this.insertRowGroupAction);
        menuManager.add((IAction)this.deleteRowGroupAction);
        menuManager.add((IAction)this.editRowGroupAction);
        menuManager.add((IAction)this.insertRowAction);
        menuManager.add((IAction)this.deleteRowAction);
        menuManager.add((IAction)this.editRowAction);
        menuManager.add((IAction)this.insertColumnAction);
        menuManager.add((IAction)this.deleteColumnAction);
        menuManager.add((IAction)this.editColumnAction);
        int n = 0;
        if (this.cursor != null && !this.cursor.isDisposed()) {
            n = this.cursor.getColumn() == 0 ? 0 : 1;
        }
        if (this.table.getSelectionIndex() == -1) {
            n = 2;
        }
        if (this.datapool.getEquivalenceClasses().size() == 0) {
            n = 3;
        }
        if (this.datapool.getEquivalenceClasses().size() == 0 && this.datapool.getVariables().size() == 0) {
            n = 4;
        }
        if (this.extension.getHyadesEditorPart().isReadOnly()) {
            n = 5;
        }
        switch (n) {
            case 0: {
                this.insertRowAction.aboutToShow(true);
                this.deleteRowAction.aboutToShow(true);
                this.editRowAction.aboutToShow(true);
                this.insertRowGroupAction.aboutToShow(true);
                this.deleteRowGroupAction.aboutToShow(true);
                this.editRowGroupAction.aboutToShow(true);
                this.insertColumnAction.aboutToShow(true);
                this.deleteColumnAction.aboutToShow(false);
                this.editColumnAction.aboutToShow(true);
                break;
            }
            case 1: {
                this.insertRowAction.aboutToShow(true);
                this.deleteRowAction.aboutToShow(true);
                this.editRowAction.aboutToShow(true);
                this.insertRowGroupAction.aboutToShow(true);
                this.deleteRowGroupAction.aboutToShow(true);
                this.editRowGroupAction.aboutToShow(true);
                this.insertColumnAction.aboutToShow(true);
                this.deleteColumnAction.aboutToShow(true);
                this.editColumnAction.aboutToShow(true);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                this.insertRowAction.aboutToShow(false);
                this.deleteRowAction.aboutToShow(false);
                this.editRowAction.aboutToShow(false);
                this.insertRowGroupAction.aboutToShow(true);
                this.deleteRowGroupAction.aboutToShow(false);
                this.editRowGroupAction.aboutToShow(false);
                this.insertColumnAction.aboutToShow(true);
                this.deleteColumnAction.aboutToShow(false);
                this.editColumnAction.aboutToShow(false);
                break;
            }
            case 5: {
                this.insertRowAction.aboutToShow(false);
                this.deleteRowAction.aboutToShow(false);
                this.editRowAction.aboutToShow(false);
                this.insertRowGroupAction.aboutToShow(false);
                this.deleteRowGroupAction.aboutToShow(false);
                this.editRowGroupAction.aboutToShow(false);
                this.insertColumnAction.aboutToShow(false);
                this.deleteColumnAction.aboutToShow(false);
                this.editColumnAction.aboutToShow(false);
                break;
            }
            default: {
                this.insertRowAction.aboutToShow(true);
                this.deleteRowAction.aboutToShow(true);
                this.editRowAction.aboutToShow(true);
                this.insertRowGroupAction.aboutToShow(true);
                this.deleteRowGroupAction.aboutToShow(true);
                this.editRowGroupAction.aboutToShow(true);
                this.insertColumnAction.aboutToShow(true);
                this.deleteColumnAction.aboutToShow(true);
                this.editColumnAction.aboutToShow(true);
            }
        }
    }

    public void insertRowGroup() {
        DataPoolRowGroupDialog dataPoolRowGroupDialog;
        TableItem tableItem = null;
        if (this.cursor != null && !this.cursor.isDisposed()) {
            tableItem = this.cursor.getRow();
        }
        DPLEquivalenceClass dPLEquivalenceClass = null;
        if (tableItem != null) {
            dPLEquivalenceClass = (DPLEquivalenceClass)tableItem.getData(TAG_EQUIVALENCE_CLASS);
        }
        if ((dataPoolRowGroupDialog = new DataPoolRowGroupDialog(Display.getCurrent().getActiveShell(), this.datapool, this.table, null, dPLEquivalenceClass, TestUIPlugin.getString("DATA_ROW_GRP_DLG_TITLE_INS"))).open() == 0) {
            this.setWaitCursor();
            String string = dataPoolRowGroupDialog.getName();
            if (string != null && string.length() != 0) {
                DPLEquivalenceClass dPLEquivalenceClass2 = Common_DatapoolFactory.eINSTANCE.createDPLEquivalenceClass();
                dPLEquivalenceClass2.setName(string);
                DPLRecord dPLRecord = Common_DatapoolFactory.eINSTANCE.createDPLRecord();
                dPLRecord.setEquivalenceClass(dPLEquivalenceClass2);
                int n = dataPoolRowGroupDialog.getInsertionIndex();
                this.datapool.getEquivalenceClasses().add(n + 1, dPLEquivalenceClass2);
                dPLEquivalenceClass2.setDatapool(this.datapool);
                this.equivalenceClassAdded(this.datapool, n);
            }
            this.unsetWaitCursor();
        }
    }

    public void deleteRowGroup() {
        TableItem tableItem = null;
        if (this.cursor == null || this.cursor.isDisposed()) {
            return;
        }
        tableItem = this.cursor.getRow();
        this.setWaitCursor();
        DPLEquivalenceClass dPLEquivalenceClass = (DPLEquivalenceClass)tableItem.getData(TAG_EQUIVALENCE_CLASS);
        int n = this.datapool.getEquivalenceClasses().indexOf(dPLEquivalenceClass);
        this.datapool.getEquivalenceClasses().remove(dPLEquivalenceClass);
        this.equivalenceClassRemoved(this.datapool, n);
        this.unsetWaitCursor();
    }

    public void editRowGroup() {
        TableItem tableItem = null;
        if (this.cursor == null || this.cursor.isDisposed()) {
            return;
        }
        tableItem = this.cursor.getRow();
        this.editRowGroupAux(tableItem);
    }

    private void editRowGroupAux(TableItem tableItem) {
        DataPoolRowGroupDialog dataPoolRowGroupDialog;
        DPLEquivalenceClass dPLEquivalenceClass = null;
        if (tableItem != null) {
            dPLEquivalenceClass = (DPLEquivalenceClass)tableItem.getData(TAG_EQUIVALENCE_CLASS);
        }
        int n = -1;
        if (dPLEquivalenceClass != null) {
            n = this.datapool.getEquivalenceClasses().indexOf(dPLEquivalenceClass);
        }
        DPLEquivalenceClass dPLEquivalenceClass2 = null;
        if (n != -1 && n != 0) {
            dPLEquivalenceClass2 = (DPLEquivalenceClass)this.datapool.getEquivalenceClasses().get(n - 1);
        }
        if ((dataPoolRowGroupDialog = new DataPoolRowGroupDialog(Display.getCurrent().getActiveShell(), this.datapool, this.table, dPLEquivalenceClass, dPLEquivalenceClass2, TestUIPlugin.getString("DATA_ROW_GRP_DLG_TITLE_EDIT"))).open() == 0) {
            int n2;
            this.setWaitCursor();
            String string = dataPoolRowGroupDialog.getName();
            if (!dPLEquivalenceClass.getName().equals(string)) {
                dPLEquivalenceClass.setName(string);
                this.equivalenceClassChanged(this.datapool, n);
            }
            if ((n2 = dataPoolRowGroupDialog.getInsertionIndex()) == n - 1) {
                this.unsetWaitCursor();
                return;
            }
            this.equivalenceClassMoved(this.datapool, n, n2);
            if (n2 < n) {
                this.datapool.getEquivalenceClasses().move(n2 + 1, n);
            } else {
                this.datapool.getEquivalenceClasses().move(n2, n);
            }
            this.unsetWaitCursor();
        }
    }

    public void insertRow() {
        TableItem tableItem = null;
        if (this.cursor == null || this.cursor.isDisposed()) {
            return;
        }
        tableItem = this.cursor.getRow();
        DataPoolRowDialog dataPoolRowDialog = new DataPoolRowDialog(Display.getCurrent().getActiveShell(), this.datapool, this.table, null, tableItem, TestUIPlugin.getString("DATA_ROW_DLG_TITLE_INS"));
        if (dataPoolRowDialog.open() == 0) {
            this.setWaitCursor();
            int n = dataPoolRowDialog.getInsertionEquivalenceClassIndex();
            int n2 = dataPoolRowDialog.getInsertionRecordIndex();
            if (n != -1 && n2 != -1) {
                DPLEquivalenceClass dPLEquivalenceClass = (DPLEquivalenceClass)this.datapool.getEquivalenceClasses().get(n);
                DPLRecord dPLRecord = Common_DatapoolFactory.eINSTANCE.createDPLRecord();
                dPLEquivalenceClass.getRecord().add(n2 + 1, dPLRecord);
                dPLRecord.setEquivalenceClass(dPLEquivalenceClass);
                this.recordAdded(this.datapool, n, n2);
            } else {
                DPLEquivalenceClass dPLEquivalenceClass = (DPLEquivalenceClass)this.datapool.getEquivalenceClasses().get(n);
                DPLRecord dPLRecord = Common_DatapoolFactory.eINSTANCE.createDPLRecord();
                dPLEquivalenceClass.getRecord().add(0, dPLRecord);
                dPLRecord.setEquivalenceClass(dPLEquivalenceClass);
                this.recordAdded(this.datapool, n, n2);
            }
            this.unsetWaitCursor();
        }
    }

    public void deleteRow() {
        TableItem tableItem = null;
        if (this.cursor == null || this.cursor.isDisposed()) {
            return;
        }
        tableItem = this.cursor.getRow();
        this.setWaitCursor();
        DPLEquivalenceClass dPLEquivalenceClass = (DPLEquivalenceClass)tableItem.getData(TAG_EQUIVALENCE_CLASS);
        DPLRecord dPLRecord = (DPLRecord)tableItem.getData(TAG_RECORD);
        int n = this.datapool.getEquivalenceClasses().indexOf(dPLEquivalenceClass);
        int n2 = dPLEquivalenceClass.getRecord().indexOf(dPLRecord);
        dPLEquivalenceClass.getRecord().remove(dPLRecord);
        if (dPLEquivalenceClass.getRecord().size() == 0) {
            this.datapool.getEquivalenceClasses().remove(dPLEquivalenceClass);
            this.equivalenceClassRemoved(this.datapool, n);
        } else {
            this.recordRemoved(this.datapool, n, n2);
        }
        this.unsetWaitCursor();
    }

    public void editRow() {
        TableItem tableItem = null;
        if (this.cursor == null || this.cursor.isDisposed()) {
            return;
        }
        tableItem = this.cursor.getRow();
        this.editRowAux(tableItem);
    }

    private void editRowAux(TableItem tableItem) {
        DataPoolRowDialog dataPoolRowDialog;
        int n = this.table.getSelectionIndex();
        TableItem tableItem2 = null;
        if (n != 0) {
            tableItem2 = this.table.getItem(n - 1);
        }
        if ((dataPoolRowDialog = new DataPoolRowDialog(Display.getCurrent().getActiveShell(), this.datapool, this.table, tableItem, tableItem2, TestUIPlugin.getString("DATA_ROW_DLG_TITLE_EDIT"))).open() == 0) {
            this.setWaitCursor();
            DPLEquivalenceClass dPLEquivalenceClass = (DPLEquivalenceClass)tableItem.getData(TAG_EQUIVALENCE_CLASS);
            int n2 = this.datapool.getEquivalenceClasses().indexOf(dPLEquivalenceClass);
            DPLRecord dPLRecord = (DPLRecord)tableItem.getData(TAG_RECORD);
            int n3 = dPLEquivalenceClass.getRecord().indexOf(dPLRecord);
            int n4 = dataPoolRowDialog.getInsertionEquivalenceClassIndex();
            int n5 = dataPoolRowDialog.getInsertionRecordIndex();
            if (n2 == n4) {
                if (n3 != n5 + 1) {
                    if (n5 > n3) {
                        this.recordMoved(this.datapool, n2, n3, n5);
                        dPLEquivalenceClass.getRecord().move(n5, n3);
                    } else {
                        this.recordMoved(this.datapool, n2, n3, n5 + 1);
                        dPLEquivalenceClass.getRecord().move(n5 + 1, n3);
                    }
                }
            } else if (n4 != -1 && n5 != -1) {
                DPLEquivalenceClass dPLEquivalenceClass2 = (DPLEquivalenceClass)this.datapool.getEquivalenceClasses().get(n4);
                dPLEquivalenceClass2.getRecord().add(n5 + 1, dPLRecord);
                if (n2 > n4) {
                    this.recordAdded(this.datapool, n4, n5);
                    this.recordRemoved(this.datapool, n2, n3);
                } else {
                    this.recordRemoved(this.datapool, n2, n3);
                    this.recordAdded(this.datapool, n4, n5);
                }
                if (dPLEquivalenceClass.getRecord().size() == 0) {
                    this.datapool.getEquivalenceClasses().remove(dPLEquivalenceClass);
                }
            } else {
                DPLEquivalenceClass dPLEquivalenceClass3 = (DPLEquivalenceClass)this.datapool.getEquivalenceClasses().get(n4);
                dPLEquivalenceClass3.getRecord().add(0, dPLRecord);
                if (n2 > n4) {
                    this.recordAdded(this.datapool, n4, n5);
                    this.recordRemoved(this.datapool, n2, n3);
                } else {
                    this.recordRemoved(this.datapool, n2, n3);
                    this.recordAdded(this.datapool, n4, n5);
                }
                if (dPLEquivalenceClass.getRecord().size() == 0) {
                    this.datapool.getEquivalenceClasses().remove(dPLEquivalenceClass);
                }
            }
            this.unsetWaitCursor();
        }
    }

    public void insertColumn() {
        DataPoolColumnDialog dataPoolColumnDialog;
        int n = -1;
        if (this.cursor != null && !this.cursor.isDisposed()) {
            n = this.cursor.getColumn();
        }
        TableColumn tableColumn = null;
        if (n > 0) {
            tableColumn = this.table.getColumn(n);
        }
        DPLVariable dPLVariable = null;
        if (tableColumn != null) {
            dPLVariable = (DPLVariable)tableColumn.getData(TAG_VARIABLE);
        }
        if ((dataPoolColumnDialog = new DataPoolColumnDialog(Display.getCurrent().getActiveShell(), this.datapool, null, dPLVariable, TestUIPlugin.getString("DATA_COL_DLG_TITLE_INS"))).open() == 0) {
            this.setWaitCursor();
            DPLVariable dPLVariable2 = Common_DatapoolFactory.eINSTANCE.createDPLVariable();
            dPLVariable2.setName(dataPoolColumnDialog.getName());
            dPLVariable2.setType(dataPoolColumnDialog.getType());
            int n2 = this.findColumnIndex(dataPoolColumnDialog.getInsertionVariableID());
            if (n2 == -1) {
                n2 = 0;
            }
            this.datapool.getVariables().add(n2, dPLVariable2);
            dPLVariable2.setDatapool(this.datapool);
            this.variableAdded(this.datapool, n2);
            this.unsetWaitCursor();
        }
    }

    public void deleteColumn() {
        if (this.cursor == null || this.cursor.isDisposed()) {
            return;
        }
        int n = this.cursor.getColumn();
        int n2 = this.table.getSelectionIndex();
        if (n < 1) {
            return;
        }
        this.setWaitCursor();
        TableColumn tableColumn = this.table.getColumn(n);
        DPLVariable dPLVariable = (DPLVariable)tableColumn.getData(TAG_VARIABLE);
        this.datapool.getVariables().remove(dPLVariable);
        TableItem[] tableItemArray = this.table.getItems();
        int n3 = 0;
        while (n3 < tableItemArray.length) {
            DPLCell[] dPLCellArray = (DPLCell[])tableItemArray[n3].getData(TAG_DATA);
            int n4 = 0;
            while (n4 < dPLCellArray.length) {
                if (n4 == n - 1) {
                    DPLRecord dPLRecord = (DPLRecord)tableItemArray[n3].getData(TAG_RECORD);
                    dPLRecord.getCells().remove(dPLCellArray[n4]);
                }
                ++n4;
            }
            ++n3;
        }
        this.variableRemoved(this.datapool, n);
        this.unsetWaitCursor();
    }

    public void editColumn() {
        int n = this.cursor.getColumn();
        TableColumn tableColumn = this.table.getColumn(n);
        this.editColumnAux(tableColumn);
    }

    private void editColumnAux(TableColumn tableColumn) {
        int n = this.table.indexOf(tableColumn);
        TableColumn tableColumn2 = null;
        if (n != 0) {
            tableColumn2 = this.table.getColumn(n - 1);
        }
        DPLVariable dPLVariable = null;
        if (tableColumn2 != null) {
            dPLVariable = (DPLVariable)tableColumn2.getData(TAG_VARIABLE);
        }
        DPLVariable dPLVariable2 = (DPLVariable)tableColumn.getData(TAG_VARIABLE);
        DataPoolColumnDialog dataPoolColumnDialog = new DataPoolColumnDialog(Display.getCurrent().getActiveShell(), this.datapool, dPLVariable2, dPLVariable, TestUIPlugin.getString("DATA_COL_DLG_TITLE_EDIT"));
        if (dataPoolColumnDialog.open() == 0) {
            this.setWaitCursor();
            String string = dataPoolColumnDialog.getName();
            String string2 = dataPoolColumnDialog.getType();
            String string3 = dataPoolColumnDialog.getInsertionVariableID();
            String string4 = new String();
            if (dPLVariable != null) {
                string4 = dPLVariable.getId();
            }
            if (string.equals(dPLVariable2.getName()) && string2.equals(dPLVariable2.getType()) && string3.equals(string4)) {
                this.unsetWaitCursor();
                return;
            }
            dPLVariable2.setName(dataPoolColumnDialog.getName());
            dPLVariable2.setType(dataPoolColumnDialog.getType());
            Integer n2 = (Integer)tableColumn.getData(TAG_VARIABLE_INDEX);
            this.variableChanged(this.datapool, n2);
            int n3 = this.findColumnIndex(dataPoolColumnDialog.getInsertionVariableID());
            if (n3 == n - 1) {
                this.unsetWaitCursor();
                return;
            }
            if (n3 == -1) {
                this.datapool.getVariables().move(0, n - 1);
            } else if (n3 > n) {
                this.datapool.getVariables().move(n3 - 1, n - 1);
            } else {
                this.datapool.getVariables().move(n3, n - 1);
            }
            if (n3 > n) {
                this.variableMoved(this.datapool, n, n3);
            } else {
                if (n3 == -1) {
                    n3 = 0;
                }
                this.variableMoved(this.datapool, n, n3 + 1);
            }
            this.unsetWaitCursor();
        }
    }

    public void clearCell() {
        this.applyEditingValue(new String());
    }

    private String wrapAsLiterl(String string) {
        if (string != null) {
            return START_LITERAL + string + END_LITERAL;
        }
        return "<Literal></Literal>";
    }

    private String unwrapLiteral(String string) {
        if ((string = string.trim()).startsWith(START_LITERAL) && string.endsWith(END_LITERAL)) {
            string = string.substring(START_LITERAL.length(), string.length());
            int n = string.lastIndexOf(END_LITERAL);
            string = string.substring(0, n);
            return string;
        }
        return new String();
    }

    public void variableAdded(DPLDatapool dPLDatapool, int n) {
        int n2;
        TableColumn tableColumn = new TableColumn(this.table, 0, n + 1);
        DPLVariable dPLVariable = (DPLVariable)dPLDatapool.getVariables().get(n);
        tableColumn.setResizable(true);
        tableColumn.setText(dPLVariable.getName() + TestUIPlugin.getString("DATA_EDT_DIVIDER") + dPLVariable.getType());
        tableColumn.setData(TAG_VARIABLE, (Object)dPLVariable);
        tableColumn.setData(TAG_VARIABLE_INDEX, (Object)new Integer(n));
        tableColumn.addSelectionListener(this.headerListener);
        tableColumn.setWidth(100);
        tableColumn.addSelectionListener(this.headerListener);
        tableColumn.addControlListener(this.resizeColumnListener);
        this.tableUtil.insertColumn(tableColumn, n);
        if (this.cursor != null && !this.cursor.isDisposed() && (n2 = this.table.getSelectionIndex()) >= 0) {
            this.table.setSelection(n2);
            this.cursor.setSelection(n2, n + 1);
            this.resizeScrollBars();
            this.setScrollBars();
        }
        this.extension.markDirty();
    }

    public void variableRemoved(DPLDatapool dPLDatapool, int n) {
        this.tableUtil.deleteColumn(n);
        if (this.cursor != null && !this.cursor.isDisposed()) {
            if (n > 0) {
                int n2 = this.table.getSelectionIndex();
                if (n2 >= 0) {
                    this.table.select(n2);
                    this.cursor.setSelection(n2, n - 1);
                    this.resizeScrollBars();
                    this.setScrollBars();
                }
            } else {
                this.table.deselectAll();
            }
        }
        this.extension.markDirty();
    }

    public void variableMoved(DPLDatapool dPLDatapool, int n, int n2) {
        int n3;
        this.tableUtil.moveColumn(n, n2);
        if (this.cursor != null && !this.cursor.isDisposed() && n2 > 0 && (n3 = this.table.getSelectionIndex()) >= 0) {
            this.table.select(n3);
            this.cursor.setSelection(n3, n2);
            this.setScrollBars();
        }
        this.extension.markDirty();
    }

    public void variableChanged(DPLDatapool dPLDatapool, int n) {
        DPLVariable dPLVariable = (DPLVariable)dPLDatapool.getVariables().get(n);
        int n2 = this.findColumnIndex(dPLVariable.getId());
        TableColumn tableColumn = this.table.getColumn(n2);
        tableColumn.setText(dPLVariable.getName() + TestUIPlugin.getString("DATA_EDT_DIVIDER") + dPLVariable.getType());
        tableColumn.setData(TAG_VARIABLE, (Object)dPLVariable);
        tableColumn.setData(TAG_VARIABLE_INDEX, (Object)new Integer(n));
        this.extension.markDirty();
    }

    public void equivalenceClassChanged(DPLDatapool dPLDatapool, int n) {
        DPLEquivalenceClass dPLEquivalenceClass = (DPLEquivalenceClass)dPLDatapool.getEquivalenceClasses().get(n);
        int n2 = 0;
        while (n2 < dPLEquivalenceClass.getRecord().size()) {
            int n3 = this.findRowIndex(n, n2);
            TableItem tableItem = this.table.getItem(n3);
            tableItem.setText(0, dPLEquivalenceClass.getName() + TestUIPlugin.getString("DATA_EDT_DIVIDER") + String.valueOf(n2));
            this.extension.markDirty();
            ++n2;
        }
    }

    public void equivalenceClassAdded(DPLDatapool dPLDatapool, int n) {
        DPLEquivalenceClass dPLEquivalenceClass = (DPLEquivalenceClass)dPLDatapool.getEquivalenceClasses().get(n + 1);
        DPLEquivalenceClass dPLEquivalenceClass2 = null;
        int n2 = 0;
        if (n >= 0) {
            dPLEquivalenceClass2 = (DPLEquivalenceClass)dPLDatapool.getEquivalenceClasses().get(n);
            n2 = this.findRowIndex(n, dPLEquivalenceClass2.getRecord().size() - 1) + 1;
        }
        int n3 = 0;
        while (n3 < dPLEquivalenceClass.getRecord().size()) {
            DPLCell dPLCell;
            DPLRecord dPLRecord = (DPLRecord)dPLEquivalenceClass.getRecord().get(n3);
            String[] stringArray = new String[this.table.getColumnCount()];
            DPLCell[] dPLCellArray = new DPLCell[this.table.getColumnCount() - 1];
            stringArray[0] = dPLEquivalenceClass.getName() + TestUIPlugin.getString("DATA_EDT_DIVIDER") + String.valueOf(n3);
            int n4 = 0;
            while (n4 < dPLRecord.getCells().size()) {
                dPLCell = (DPLCell)dPLRecord.getCells().get(n4);
                DPLVariable dPLVariable = dPLCell.getVariable();
                int n5 = this.findColumnIndex(dPLVariable.getId());
                stringArray[n5] = this.unwrapLiteral(dPLCell.getValue());
                dPLCellArray[n5 - 1] = dPLCell;
                ++n4;
            }
            dPLCell = new TableItem(this.table, 0, n2 + n3);
            dPLCell.setText(stringArray);
            dPLCell.setData(TAG_DATA, (Object)dPLCellArray);
            dPLCell.setData(TAG_RECORD, (Object)dPLRecord);
            dPLCell.setData(TAG_EQUIVALENCE_CLASS, (Object)dPLEquivalenceClass);
            ++n3;
        }
        if (this.table.getItemCount() == 1) {
            this.createCursor();
        }
        if (this.cursor != null && !this.cursor.isDisposed() && this.table != null) {
            this.table.setSelection(n2);
            this.cursor.setSelection(n2, 0);
            this.resizeScrollBars();
            this.setScrollBars();
        }
        this.extension.markDirty();
    }

    public void equivalenceClassRemoved(DPLDatapool dPLDatapool, int n) {
        int n2 = this.findRowIndex(n, 0);
        TableItem tableItem = this.table.getItem(n2);
        DPLEquivalenceClass dPLEquivalenceClass = (DPLEquivalenceClass)tableItem.getData(TAG_EQUIVALENCE_CLASS);
        boolean bl = true;
        while (bl) {
            this.table.remove(n2);
            if (n2 < this.table.getItemCount()) {
                tableItem = this.table.getItem(n2);
                DPLEquivalenceClass dPLEquivalenceClass2 = (DPLEquivalenceClass)tableItem.getData(TAG_EQUIVALENCE_CLASS);
                if (dPLEquivalenceClass2.equals(dPLEquivalenceClass)) continue;
                bl = false;
                continue;
            }
            bl = false;
        }
        this.extension.markDirty();
        if (this.cursor != null && !this.cursor.isDisposed() && this.table != null) {
            int n3 = this.table.getItemCount();
            if (n3 == 0) {
                this.table.deselectAll();
                this.cursor.dispose();
                return;
            }
            if (n3 > n2) {
                this.table.setSelection(n2);
                this.cursor.setSelection(n2, 0);
                this.resizeScrollBars();
                this.setScrollBars();
                return;
            }
            if (n3 > n2 - 1) {
                this.table.setSelection(n2 - 1);
                this.cursor.setSelection(n2 - 1, 0);
                this.resizeScrollBars();
                this.setScrollBars();
            }
        }
    }

    public void equivalenceClassMoved(DPLDatapool dPLDatapool, int n, int n2) {
        int n3;
        DPLEquivalenceClass dPLEquivalenceClass;
        if (n == n2) {
            return;
        }
        int n4 = 0;
        if (n2 != -1) {
            dPLEquivalenceClass = (DPLEquivalenceClass)dPLDatapool.getEquivalenceClasses().get(n2);
            n3 = dPLEquivalenceClass.getRecord().size();
            if (n < n2) {
                --n3;
            }
            n4 = this.findRowIndex(n2, n3);
        }
        dPLEquivalenceClass = (DPLEquivalenceClass)dPLDatapool.getEquivalenceClasses().get(n);
        n3 = dPLEquivalenceClass.getRecord().size();
        int n5 = this.findRowIndex(n, 0);
        int n6 = 0;
        while (n6 < dPLEquivalenceClass.getRecord().size()) {
            if (n > n2) {
                this.tableUtil.moveRow(n5 + n3 - 1, n4);
            } else {
                this.tableUtil.moveRow(n5, n4);
            }
            ++n6;
        }
        if (this.cursor != null && !this.cursor.isDisposed() && this.table != null) {
            this.table.setSelection(n4);
            this.cursor.setSelection(n4, 0);
            this.setScrollBars();
        }
        this.extension.markDirty();
    }

    public void recordAdded(DPLDatapool dPLDatapool, int n, int n2) {
        DPLVariable dPLVariable;
        DPLEquivalenceClass dPLEquivalenceClass = (DPLEquivalenceClass)dPLDatapool.getEquivalenceClasses().get(n);
        DPLRecord dPLRecord = (DPLRecord)dPLEquivalenceClass.getRecord().get(n2 + 1);
        String[] stringArray = new String[this.table.getColumnCount()];
        DPLCell[] dPLCellArray = new DPLCell[this.table.getColumnCount() - 1];
        stringArray[0] = dPLEquivalenceClass.getName() + TestUIPlugin.getString("DATA_EDT_DIVIDER") + String.valueOf(n2 + 1);
        int n3 = 0;
        while (n3 < dPLRecord.getCells().size()) {
            DPLCell dPLCell = (DPLCell)dPLRecord.getCells().get(n3);
            dPLVariable = dPLCell.getVariable();
            int n4 = this.findColumnIndex(dPLVariable.getId());
            stringArray[n4] = this.unwrapLiteral(dPLCell.getValue());
            dPLCellArray[n4 - 1] = dPLCell;
            ++n3;
        }
        int n5 = this.findRowIndex(n, n2 + 1);
        dPLVariable = new TableItem(this.table, 0, n5);
        dPLVariable.setText(stringArray);
        dPLVariable.setData(TAG_DATA, (Object)dPLCellArray);
        dPLVariable.setData(TAG_RECORD, (Object)dPLRecord);
        dPLVariable.setData(TAG_EQUIVALENCE_CLASS, (Object)dPLEquivalenceClass);
        this.repopulateRowLabels(n);
        if (this.cursor != null && !this.cursor.isDisposed() && this.table != null) {
            this.table.setSelection(n5);
            this.cursor.setSelection(n5, 0);
            this.resizeScrollBars();
            this.setScrollBars();
        }
        this.extension.markDirty();
    }

    public void recordRemoved(DPLDatapool dPLDatapool, int n, int n2) {
        int n3 = this.findRowIndex(n, n2);
        this.table.remove(n3);
        this.repopulateRowLabels(n);
        this.extension.markDirty();
        if (this.cursor != null && !this.cursor.isDisposed() && this.table != null) {
            int n4 = this.table.getItemCount();
            if (n4 == 0) {
                this.table.deselectAll();
                this.cursor.dispose();
                return;
            }
            if (n4 > n3) {
                this.table.setSelection(n3);
                this.cursor.setSelection(n3, 0);
                this.resizeScrollBars();
                this.setScrollBars();
                return;
            }
            if (n4 > n3 - 1) {
                this.table.setSelection(n3 - 1);
                this.cursor.setSelection(n3 - 1, 0);
                this.resizeScrollBars();
                this.setScrollBars();
            }
        }
    }

    public void recordMoved(DPLDatapool dPLDatapool, int n, int n2, int n3) {
        int n4 = this.findRowIndex(n, n2);
        int n5 = this.findRowIndex(n, n3);
        this.tableUtil.moveRow(n4, n5);
        this.repopulateRowLabels(n);
        this.extension.markDirty();
    }

    public void cellChanged(DPLDatapool dPLDatapool, int n, int n2, int n3) {
        DPLEquivalenceClass dPLEquivalenceClass = (DPLEquivalenceClass)dPLDatapool.getEquivalenceClasses().get(n);
        DPLRecord dPLRecord = (DPLRecord)dPLEquivalenceClass.getRecord().get(n2);
        DPLVariable dPLVariable = (DPLVariable)dPLDatapool.getVariables().get(n3);
        DPLCell dPLCell = null;
        int n4 = 0;
        while (n4 < dPLRecord.getCells().size()) {
            dPLCell = (DPLCell)dPLRecord.getCells().get(n4);
            if (dPLCell.getVariable().equals(dPLVariable)) break;
            dPLCell = null;
            ++n4;
        }
        if (dPLCell != null) {
            String string = this.unwrapLiteral(dPLCell.getValue());
            int n5 = this.findRowIndex(n, n2);
            TableItem tableItem = this.table.getItem(n5);
            tableItem.setText(n + 1, string);
            this.cursor.setSelection(n5, n + 1);
            this.extension.markDirty();
        }
        this.extension.markDirty();
    }

    public void datapoolReordered(DPLDatapool dPLDatapool) {
        this.extension.markDirty();
    }

    private int findRowIndex(int n, int n2) {
        int n3 = n2;
        int n4 = 0;
        while (n4 < n) {
            DPLEquivalenceClass dPLEquivalenceClass = (DPLEquivalenceClass)this.datapool.getEquivalenceClasses().get(n4);
            n3 += dPLEquivalenceClass.getRecord().size();
            ++n4;
        }
        return n3;
    }

    private void repopulateRowLabels(int n) {
        DPLEquivalenceClass dPLEquivalenceClass = (DPLEquivalenceClass)this.datapool.getEquivalenceClasses().get(n);
        String string = dPLEquivalenceClass.getName();
        int n2 = this.findRowIndex(n, 0);
        int n3 = 0;
        while (n3 < dPLEquivalenceClass.getRecord().size()) {
            if (this.table.getItemCount() > n2 + 1) {
                TableItem tableItem = this.table.getItem(n2 + n3);
                tableItem.setText(0, string + TestUIPlugin.getString("DATA_EDT_DIVIDER") + String.valueOf(n3));
            }
            ++n3;
        }
    }

    class TableCellKeyAdaptor
    implements KeyListener {
        private Text text = null;
        private TableItem row = null;
        private int rowIndex = -1;
        private int column = -1;

        public TableCellKeyAdaptor(Text text, TableItem tableItem, int n) {
            this.text = text;
            this.row = tableItem;
            this.column = n;
            if (tableItem != null) {
                this.rowIndex = DatapoolTable.this.table.indexOf(tableItem);
            }
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (DatapoolTable.this.extension.getHyadesEditorPart().isReadOnly()) {
                return;
            }
            if (keyEvent.character == '\r' || keyEvent.keyCode == 0x1000002 || keyEvent.keyCode == 0x1000001 || keyEvent.keyCode == 0x1000003 || keyEvent.keyCode == 0x1000004) {
                this.row.setText(this.column, this.text.getText());
                DatapoolTable.this.applyEditingValue(this.text.getText());
            }
            if (DatapoolTable.this.cursor != null && !DatapoolTable.this.cursor.isDisposed()) {
                if (keyEvent.keyCode == 0x1000002 && this.rowIndex + 1 < DatapoolTable.this.table.getItemCount()) {
                    DatapoolTable.this.cursor.setSelection(this.rowIndex + 1, this.column);
                    DatapoolTable.this.table.setSelection(this.rowIndex + 1);
                    DatapoolTable.this.setScrollBars();
                }
                if (keyEvent.keyCode == 0x1000001 && this.rowIndex > 0) {
                    DatapoolTable.this.cursor.setSelection(this.rowIndex - 1, this.column);
                    DatapoolTable.this.table.setSelection(this.rowIndex - 1);
                    DatapoolTable.this.setScrollBars();
                }
                if (keyEvent.keyCode == 0x1000004 && this.column + 1 < DatapoolTable.this.table.getColumnCount()) {
                    DatapoolTable.this.cursor.setSelection(this.rowIndex, this.column + 1);
                    DatapoolTable.this.setScrollBars();
                }
                if (keyEvent.keyCode == 0x1000003 && this.column > 0) {
                    DatapoolTable.this.cursor.setSelection(this.rowIndex, this.column - 1);
                    DatapoolTable.this.setScrollBars();
                }
            }
            if (keyEvent.character == '\u001b') {
                this.text.dispose();
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
        }
    }
}

